/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OrderDeliveryWindowConfig
extends MasterDataInsert<OrderDeliveryWindowComplete> {
    private static final long serialVersionUID = 1L;

    public OrderDeliveryWindowConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new OrderDeliveryWindowConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Order Delivery Windows";
    }

    @Override
    public OrderDeliveryWindowComplete getNewObject() {
        OrderDeliveryWindowComplete a = new OrderDeliveryWindowComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends OrderDeliveryWindowComplete> getMasterDataClass() {
        return OrderDeliveryWindowComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean valueSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(OrderDeliveryWindowComplete_.value).getValue() == null) {
                valueSet = false;
            }
            if (n.getChildNamed(OrderDeliveryWindowComplete_.description).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(OrderDeliveryWindowComplete_.description).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Description " + n.getChildNamed(OrderDeliveryWindowComplete_.description).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(OrderDeliveryWindowComplete_.description).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descrptions are set"));
        }
        if (!valueSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Values are set"));
        }
        return a;
    }

    private class OrderDeliveryWindowConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> description;
        private TitledItem<TextField> value;

        public OrderDeliveryWindowConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.description = new TitledItem<TextField>(new TextField(null), "Description", TitledItem.TitledItemOrientation.NORTH);
            this.value = new TitledItem<TextField>(new TextField(), "Value", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.description);
            this.add(this.value);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.description.getFocusComponents();
            a.addAll(this.value.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.description.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.description.setVisibleContainer(pane);
            this.value.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.description.kill();
            this.value.kill();
            this.description = null;
            this.value = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.description.setEnabled(b);
            this.value.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.description.getElement().setNode(node.getChildNamed(OrderDeliveryWindowComplete_.description));
            this.value.getElement().setNode(node.getChildNamed(OrderDeliveryWindowComplete_.value));
            this.setEnabled(true);
            OrderDeliveryWindowConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return OrderDeliveryWindowComplete_.description;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                OrderDeliveryWindowConfigPanel.this.description.setLocation(OrderDeliveryWindowConfig.this.masterDataTable.getCellPadding(), OrderDeliveryWindowConfig.this.masterDataTable.getCellPadding());
                OrderDeliveryWindowConfigPanel.this.description.setSize(200, (int)OrderDeliveryWindowConfigPanel.this.description.getPreferredSize().getHeight());
                OrderDeliveryWindowConfigPanel.this.value.setLocation(OrderDeliveryWindowConfig.this.masterDataTable.getCellPadding(), OrderDeliveryWindowConfigPanel.this.description.getY() + OrderDeliveryWindowConfigPanel.this.description.getHeight() + OrderDeliveryWindowConfig.this.masterDataTable.getCellPadding());
                OrderDeliveryWindowConfigPanel.this.value.setSize(200, (int)OrderDeliveryWindowConfigPanel.this.value.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

