/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DateDurationPanel;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete_;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.DateUnitE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PaxFigureTypeConfig
extends MasterDataInsert<PaxFigureTypeComplete> {
    private static final long serialVersionUID = 1L;

    public PaxFigureTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new PaxFigureConfigPanel();
    }

    @Override
    public String getInsertName() {
        return Words.PAX_FIGURE_TYPE;
    }

    @Override
    public PaxFigureTypeComplete getNewObject() {
        PaxFigureTypeComplete a = new PaxFigureTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    protected ThreadSafeExecutable createLoadRunnable() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(PaxFigureTypeConfig.this.getMasterDataClass(), true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return PaxFigureTypeConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Class<? extends PaxFigureTypeComplete> getMasterDataClass() {
        return PaxFigureTypeComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(PaxFigureTypeComplete_.code).getValue() == null) {
                codeSet = false;
            } else if (codes.contains(n.getChildNamed(PaxFigureTypeComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(PaxFigureTypeComplete_.code).getValue() + " is not unique."));
            } else {
                codes.add((String)n.getChildNamed(PaxFigureTypeComplete_.code).getValue());
            }
            if (n.getChildNamed(PaxFigureTypeComplete_.name).getValue() != null) continue;
            codeSet = false;
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Names are set"));
        }
        return a;
    }

    private class PaxFigureConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;
        private TitledItem<TextField> priority;
        private TitledItem<CheckBox> finalPax;
        private TitledItem<CheckBox> predefine;
        private TitledItem<DateDurationPanel> dateDuration;

        public PaxFigureConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.priority = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.PRIORITY, TitledItem.TitledItemOrientation.NORTH);
            this.dateDuration = new TitledItem<DateDurationPanel>(new DateDurationPanel(), Words.TIME_FRAME, TitledItem.TitledItemOrientation.NORTH);
            this.finalPax = new TitledItem<CheckBox>(new CheckBox(), Words.FINAL, TitledItem.TitledItemOrientation.EAST);
            this.predefine = new TitledItem<CheckBox>(new CheckBox(), Words.PREDEFINED, TitledItem.TitledItemOrientation.EAST);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.name);
            this.add(this.priority);
            this.add(this.dateDuration);
            this.add(this.finalPax);
            this.add(this.predefine);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.code);
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.priority);
            CheckedListAdder.addToList(a, this.dateDuration);
            CheckedListAdder.addToList(a, this.finalPax);
            CheckedListAdder.addToList(a, this.predefine);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
            this.priority.setVisibleContainer(pane);
            this.dateDuration.setVisibleContainer(pane);
            this.finalPax.setVisibleContainer(pane);
            this.predefine.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.name.kill();
            this.priority.kill();
            this.dateDuration.kill();
            this.finalPax.kill();
            this.predefine.kill();
            this.code = null;
            this.name = null;
            this.priority = null;
            this.dateDuration = null;
            this.finalPax = null;
            this.predefine = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.name.setEnabled(b);
            this.priority.setEnabled(b);
            this.dateDuration.setEnabled(b);
            this.finalPax.setEnabled(b);
            this.predefine.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(PaxFigureTypeComplete_.code));
            this.name.getElement().setNode(node.getChildNamed(PaxFigureTypeComplete_.name));
            this.priority.getElement().setNode(node.getChildNamed(PaxFigureTypeComplete_.priority));
            this.finalPax.getElement().setNode(node.getChildNamed(PaxFigureTypeComplete_.finalPax));
            this.predefine.getElement().setNode(node.getChildNamed(PaxFigureTypeComplete_.predefined));
            if (node.getChildNamed(PaxFigureTypeComplete_.duration).getValue() == null) {
                DateDurationComplete d = new DateDurationComplete();
                d.setDuration(Double.valueOf(0.0));
                d.setClientOId(Long.valueOf(ADTO.getNextId()));
                d.setUnit(DateUnitE.DAY);
                node.getChildNamed(PaxFigureTypeComplete_.duration).setValue((Object)d, 0L);
            }
            this.dateDuration.getElement().setNode(node.getChildNamed(PaxFigureTypeComplete_.duration));
            this.setEnabled(true);
            PaxFigureTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return PaxFigureTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                PaxFigureConfigPanel.this.code.setLocation(PaxFigureTypeConfig.this.masterDataTable.getCellPadding(), PaxFigureTypeConfig.this.masterDataTable.getCellPadding());
                PaxFigureConfigPanel.this.code.setSize(200, (int)PaxFigureConfigPanel.this.code.getPreferredSize().getHeight());
                PaxFigureConfigPanel.this.name.setLocation(PaxFigureTypeConfig.this.masterDataTable.getCellPadding(), PaxFigureConfigPanel.this.code.getY() + PaxFigureConfigPanel.this.code.getHeight() + PaxFigureTypeConfig.this.masterDataTable.getCellPadding());
                PaxFigureConfigPanel.this.name.setSize(200, (int)PaxFigureConfigPanel.this.name.getPreferredSize().getHeight());
                PaxFigureConfigPanel.this.priority.setLocation(PaxFigureTypeConfig.this.masterDataTable.getCellPadding(), PaxFigureConfigPanel.this.name.getY() + PaxFigureConfigPanel.this.name.getHeight() + PaxFigureTypeConfig.this.masterDataTable.getCellPadding());
                PaxFigureConfigPanel.this.priority.setSize(PaxFigureConfigPanel.this.priority.getPreferredSize());
                PaxFigureConfigPanel.this.dateDuration.setLocation(PaxFigureTypeConfig.this.masterDataTable.getCellPadding(), PaxFigureConfigPanel.this.priority.getY() + PaxFigureConfigPanel.this.priority.getHeight() + PaxFigureTypeConfig.this.masterDataTable.getCellPadding());
                PaxFigureConfigPanel.this.dateDuration.setSize(PaxFigureConfigPanel.this.dateDuration.getPreferredSize());
                PaxFigureConfigPanel.this.finalPax.setLocation(PaxFigureTypeConfig.this.masterDataTable.getCellPadding(), PaxFigureConfigPanel.this.dateDuration.getY() + PaxFigureConfigPanel.this.dateDuration.getHeight() + PaxFigureTypeConfig.this.masterDataTable.getCellPadding());
                PaxFigureConfigPanel.this.finalPax.setSize(PaxFigureConfigPanel.this.finalPax.getPreferredSize());
                PaxFigureConfigPanel.this.predefine.setLocation(PaxFigureTypeConfig.this.masterDataTable.getCellPadding(), PaxFigureConfigPanel.this.finalPax.getY() + PaxFigureConfigPanel.this.finalPax.getHeight() + PaxFigureTypeConfig.this.masterDataTable.getCellPadding());
                PaxFigureConfigPanel.this.predefine.setSize(PaxFigureConfigPanel.this.predefine.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

