/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxMealTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxMealTypeComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PaxMealTypeConfig
extends MasterDataInsert<PaxMealTypeComplete> {
    private static final long serialVersionUID = 1L;

    public PaxMealTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new ProductTypeConfigPanel();
    }

    @Override
    public PaxMealTypeComplete getNewObject() {
        PaxMealTypeComplete a = new PaxMealTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<PaxMealTypeComplete> getMasterDataClass() {
        return PaxMealTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.PAX_MEAL_TYPE;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(PaxMealTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(PaxMealTypeComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.CODE_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(PaxMealTypeComplete_.code).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(PaxMealTypeComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CODE_IS_SET));
        }
        return a;
    }

    private class ProductTypeConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<CheckBox> isCrew;

        public ProductTypeConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.isCrew = new TitledItem<CheckBox>(new CheckBox(null), Words.IS_CREW, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.isCrew);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            a.addAll(this.isCrew.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.isCrew.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.isCrew.kill();
            this.code = null;
            this.description = null;
            this.isCrew = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.isCrew.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(PaxMealTypeComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(PaxMealTypeComplete_.description));
            this.isCrew.getElement().setNode(node.getChildNamed(PaxMealTypeComplete_.isCrew));
            this.setEnabled(true);
            PaxMealTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return ProductTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ProductTypeConfigPanel.this.code.setLocation(PaxMealTypeConfig.this.masterDataTable.getCellPadding(), PaxMealTypeConfig.this.masterDataTable.getCellPadding());
                ProductTypeConfigPanel.this.code.setSize(200, (int)ProductTypeConfigPanel.this.code.getPreferredSize().getHeight());
                ProductTypeConfigPanel.this.description.setLocation(PaxMealTypeConfig.this.masterDataTable.getCellPadding(), ProductTypeConfigPanel.this.code.getY() + ProductTypeConfigPanel.this.code.getHeight() + PaxMealTypeConfig.this.masterDataTable.getCellPadding());
                ProductTypeConfigPanel.this.description.setSize(200, (int)ProductTypeConfigPanel.this.description.getPreferredSize().getHeight());
                ProductTypeConfigPanel.this.isCrew.setLocation(PaxMealTypeConfig.this.masterDataTable.getCellPadding(), ProductTypeConfigPanel.this.description.getY() + ProductTypeConfigPanel.this.description.getHeight() + PaxMealTypeConfig.this.masterDataTable.getCellPadding());
                ProductTypeConfigPanel.this.isCrew.setSize(200, (int)ProductTypeConfigPanel.this.isCrew.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

