/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.TimeUnitEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AircraftTypeComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PreparationGroupConfig
extends MasterDataInsert<PreparationGroupComplete> {
    private static final long serialVersionUID = 1L;

    public PreparationGroupConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new PreparationGroupConfigPanel();
    }

    @Override
    public PreparationGroupComplete getNewObject() {
        PreparationGroupComplete a = new PreparationGroupComplete();
        a.setCode("");
        a.setDescription("");
        a.setName("");
        a.setDuration(new TimeDurationComplete());
        a.getDuration().setClientOId(Long.valueOf(ADTO.getNextId()));
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<PreparationGroupComplete> getMasterDataClass() {
        return PreparationGroupComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.PREPARATION_GROUP;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(AircraftTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(DtoFieldConstants.CODE).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.CODE_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(DtoFieldConstants.CODE).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(DtoFieldConstants.CODE).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CODE_IS_SET));
        }
        return a;
    }

    private class PreparationGroupConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;
        private TitledItem<TextField> description;
        private NumberTextField durationValue;
        private ComboBox durationUnit;

        public PreparationGroupConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.durationValue = new NumberTextField(null, TextFieldType.DOUBLE);
            this.durationUnit = new ComboBox(null, null, ConverterRegistry.getConverter(TimeUnitEConverter.class));
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.name);
            this.add(this.durationValue);
            this.add(this.durationUnit);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.code);
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.description);
            CheckedListAdder.addToList(a, this.durationValue);
            CheckedListAdder.addToList(a, this.durationUnit);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.durationValue.setVisibleContainer(pane);
            this.durationUnit.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.name.kill();
            this.durationValue.kill();
            this.durationUnit.kill();
            this.code = null;
            this.description = null;
            this.name = null;
            this.durationUnit = null;
            this.durationValue = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.name.setEnabled(b);
            this.durationUnit.setEnabled(b);
            this.durationValue.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(DtoFieldConstants.CODE));
            this.name.getElement().setNode(node.getChildNamed(DtoFieldConstants.NAME));
            this.description.getElement().setNode(node.getChildNamed(DtoFieldConstants.DESCRIPTION));
            this.durationValue.setNode(node.getChildNamed(new DtoField[]{DtoFieldConstants.DURATION, TimeDurationComplete_.duration}));
            this.durationUnit.setNode(node.getChildNamed(new DtoField[]{DtoFieldConstants.DURATION, TimeDurationComplete_.unit}));
            this.durationUnit.setPossibleValues(StaticEnumServiceManager.getAllTimeDurations());
            this.setEnabled(true);
            PreparationGroupConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return DtoFieldConstants.CODE;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                PreparationGroupConfigPanel.this.code.setLocation(PreparationGroupConfig.this.masterDataTable.getCellPadding(), PreparationGroupConfig.this.masterDataTable.getCellPadding());
                PreparationGroupConfigPanel.this.code.setSize(200, (int)PreparationGroupConfigPanel.this.code.getPreferredSize().getHeight());
                PreparationGroupConfigPanel.this.name.setLocation(PreparationGroupConfig.this.masterDataTable.getCellPadding(), PreparationGroupConfigPanel.this.code.getY() + PreparationGroupConfigPanel.this.code.getHeight() + PreparationGroupConfig.this.masterDataTable.getCellPadding());
                PreparationGroupConfigPanel.this.name.setSize(200, (int)PreparationGroupConfigPanel.this.name.getPreferredSize().getHeight());
                PreparationGroupConfigPanel.this.description.setLocation(PreparationGroupConfig.this.masterDataTable.getCellPadding(), PreparationGroupConfigPanel.this.name.getY() + PreparationGroupConfigPanel.this.name.getHeight() + PreparationGroupConfig.this.masterDataTable.getCellPadding());
                PreparationGroupConfigPanel.this.description.setSize(200, (int)PreparationGroupConfigPanel.this.description.getPreferredSize().getHeight());
                PreparationGroupConfigPanel.this.durationValue.setLocation(PreparationGroupConfig.this.masterDataTable.getCellPadding(), PreparationGroupConfigPanel.this.description.getY() + PreparationGroupConfigPanel.this.description.getHeight() + PreparationGroupConfig.this.masterDataTable.getCellPadding());
                PreparationGroupConfigPanel.this.durationValue.setSize(200, (int)PreparationGroupConfigPanel.this.durationValue.getPreferredSize().getHeight());
                PreparationGroupConfigPanel.this.durationUnit.setLocation(PreparationGroupConfigPanel.this.durationValue.getX() + PreparationGroupConfigPanel.this.durationValue.getWidth() + 10, PreparationGroupConfigPanel.this.durationValue.getY());
                PreparationGroupConfigPanel.this.durationUnit.setSize(200, (int)PreparationGroupConfigPanel.this.durationUnit.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

