/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductCommissionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductCommissionComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ProductCommissionConfig
extends MasterDataInsert<ProductCommissionComplete> {
    private static final long serialVersionUID = 1L;

    public ProductCommissionConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public ProductCommissionComplete getNewObject() {
        ProductCommissionComplete z = new ProductCommissionComplete();
        z.setClientOId(Long.valueOf(ADTO.getNextId()));
        return z;
    }

    @Override
    public Class<? extends ProductCommissionComplete> getMasterDataClass() {
        return ProductCommissionComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Product Commission";
    }

    @Override
    public DetailsPanel getDetails() {
        return new ProductCommissionConfigPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        boolean rateSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(ProductCommissionComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(ProductCommissionComplete_.rate).getValue() == null) {
                rateSet = false;
            }
            if (n.getChildNamed(ProductCommissionComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(ProductCommissionComplete_.code).getValue())) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(ProductCommissionComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(ProductCommissionComplete_.code).getValue());
        }
        if (!codeSet) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!descriptionSet) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descriptions are set"));
        }
        if (!rateSet) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Rates are set"));
        }
        return validationObjects;
    }

    class ProductCommissionConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> description;
        private TitledItem<TextField> rate;
        private TitledItem<TextField> code;

        public ProductCommissionConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.description = new TitledItem<TextField>(new TextField(), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.rate = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.RATE_PERCENT, TitledItem.TitledItemOrientation.NORTH);
            this.code = new TitledItem<TextField>(new TextField(), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.description);
            this.add(this.rate);
            this.add(this.code);
        }

        @Override
        public DtoField getAttributeName() {
            return ProductCommissionComplete_.description;
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.description.getElement().setNode(n.getChildNamed(ProductCommissionComplete_.description));
            this.rate.getElement().setNode(n.getChildNamed(ProductCommissionComplete_.rate));
            this.code.getElement().setNode(n.getChildNamed(ProductCommissionComplete_.code));
            this.setEnabled(true);
            ProductCommissionConfig.this.setEnabled(true);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.description);
            CheckedListAdder.addToList(focusList, this.code);
            CheckedListAdder.addToList(focusList, this.rate);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.description.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.description.setVisibleContainer(pane);
            this.code.setVisibleContainer(pane);
            this.rate.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.description.kill();
            this.code.kill();
            this.rate.kill();
            this.description = null;
            this.code = null;
            this.rate = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = false;
            if (this.isNodeSet()) {
                b = isEnabled;
            }
            super.setEnabled(b);
            this.description.setEnabled(b);
            this.rate.setEnabled(b);
            this.code.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ProductCommissionConfigPanel.this.description.setLocation(ProductCommissionConfig.this.masterDataTable.getCellPadding(), ProductCommissionConfig.this.masterDataTable.getCellPadding());
                ProductCommissionConfigPanel.this.description.setSize(200, (int)ProductCommissionConfigPanel.this.description.getPreferredSize().getHeight());
                ProductCommissionConfigPanel.this.code.setLocation(ProductCommissionConfig.this.masterDataTable.getCellPadding(), ProductCommissionConfigPanel.this.description.getY() + ProductCommissionConfigPanel.this.description.getHeight() + ProductCommissionConfig.this.masterDataTable.getCellPadding());
                ProductCommissionConfigPanel.this.code.setSize(100, (int)ProductCommissionConfigPanel.this.code.getPreferredSize().getHeight());
                ProductCommissionConfigPanel.this.rate.setLocation(ProductCommissionConfig.this.masterDataTable.getCellPadding(), ProductCommissionConfigPanel.this.code.getY() + ProductCommissionConfigPanel.this.code.getHeight() + ProductCommissionConfig.this.masterDataTable.getCellPadding());
                ProductCommissionConfigPanel.this.rate.setSize(100, (int)ProductCommissionConfigPanel.this.rate.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

