/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.RecipeCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.CategoryConfig;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RecipeCategoryConfig
extends CategoryConfig<RecipeCategoryComplete> {
    private static final long serialVersionUID = 1L;

    public RecipeCategoryConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public int getMaxDepth() {
        return ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getRecipeCategoryDepth();
    }

    @Override
    public String getInsertName() {
        return "Recipe Categories";
    }

    private void ensureParentReference(RecipeCategoryComplete parent) {
        for (RecipeCategoryComplete child : parent.getSubCategories()) {
            child.setParent(parent);
            this.ensureParentReference(child);
        }
    }

    private Set<RecipeCategoryComplete> getCategoriesToDeleteRecursive(RecipeCategoryComplete categoryComplete) {
        HashSet<RecipeCategoryComplete> cats = new HashSet<RecipeCategoryComplete>();
        if (Boolean.TRUE.equals(categoryComplete.getIsDeleted()) && categoryComplete.getParent() != null && categoryComplete.getDeleteUser() == null && categoryComplete.getId() != null) {
            cats.add(categoryComplete);
        }
        for (RecipeCategoryComplete articleCategoryComplete : categoryComplete.getSubCategories()) {
            cats.addAll(this.getCategoriesToDeleteRecursive(articleCategoryComplete));
        }
        return cats;
    }

    private Set<RecipeCategoryComplete> getCategoriesToRestoreRecursive(RecipeCategoryComplete categoryComplete) {
        HashSet<RecipeCategoryComplete> cats = new HashSet<RecipeCategoryComplete>();
        if (Boolean.FALSE.equals(categoryComplete.getIsDeleted()) && categoryComplete.getParent() != null && categoryComplete.getDeleteUser() != null && categoryComplete.getId() != null) {
            cats.add(categoryComplete);
        }
        for (RecipeCategoryComplete articleCategoryComplete : categoryComplete.getSubCategories()) {
            cats.addAll(this.getCategoriesToRestoreRecursive(articleCategoryComplete));
        }
        return cats;
    }

    @Override
    public Node saveDataImpl(Node<?> node) throws ClientServerCallException {
        Iterator it = node.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.commitThis(RecipeCategoryComplete.class);
            RecipeCategoryComplete cat = (RecipeCategoryComplete)n.getValue(RecipeCategoryComplete.class);
            this.ensureParentReference(cat);
            Set<RecipeCategoryComplete> innerDelete = this.getCategoriesToDeleteRecursive(cat);
            Set<RecipeCategoryComplete> innerRestore = this.getCategoriesToRestoreRecursive(cat);
            for (RecipeCategoryComplete articleCategoryComplete : innerDelete) {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)articleCategoryComplete);
            }
            for (RecipeCategoryComplete articleCategoryComplete : innerRestore) {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)articleCategoryComplete);
            }
            cat = cat.getId() == null ? (RecipeCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).create((AMasterDataComplete)cat).getValue() : (cat.getIsDeleted() != false && cat.getDeleteUser() == null ? (RecipeCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)cat).getValue() : (cat.getIsDeleted() == false && cat.getDeleteUser() != null ? (RecipeCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)cat).getValue() : (RecipeCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).update((AMasterDataComplete)cat).getValue()));
            n.setValue((Object)cat, 0L);
            n.updateNode();
        }
        return node;
    }

    @Override
    public Converter getTopTitleConverter() {
        return ConverterRegistry.getConverter(RecipeCategoryConverter.class);
    }

    @Override
    public Node loadDataImpl(Node<?> node) throws ClientServerCallException {
        return INodeCreator.getDefaultImpl().createNodes(((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperRecipeCategoriesWithDeleted().getList(), false);
    }

    @Override
    public RecipeCategoryComplete createNewCategory() {
        RecipeCategoryComplete c = new RecipeCategoryComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setDisplay(Boolean.valueOf(true));
        return c;
    }
}

