/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationSettingsComplete;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsChangeNotificationConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<SystemSettingsComplete> node;
    private TextLabel liveScreen;
    private TitledItem<CheckBox> autoChangeNotificationCreation;
    private TitledItem<NumberTextField> maxHoursBeforeFlight;
    private TitledItem<NumberTextField> updateInterval;
    private TitledItem<NumberTextField> autoFadeOutSeconds;
    private TitledItem<NumberTextField> animationInterval;
    private TitledItem<NumberTextField> animationDelay;

    public SettingsChangeNotificationConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.autoChangeNotificationCreation = new TitledItem<CheckBox>(new CheckBox(), Words.AUTO_CHANGE_NOTIFICATION_ACTIVE, TitledItem.TitledItemOrientation.EAST);
        this.autoChangeNotificationCreation.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.maxHoursBeforeFlight = new TitledItem<NumberTextField>(new NumberTextField(new Node(), TextFieldType.INT), Words.MAX_HOURS_BEFORE_FLIGHT, TitledItem.TitledItemOrientation.NORTH);
        this.liveScreen = new TextLabel("Live Screen Settings");
        this.updateInterval = new TitledItem<NumberTextField>(new NumberTextField(new Node(), TextFieldType.INT), Words.UPDATE_INTERVAL_IN_S, TitledItem.TitledItemOrientation.NORTH);
        this.autoFadeOutSeconds = new TitledItem<NumberTextField>(new NumberTextField(new Node(), TextFieldType.INT), Words.AUTO_FADE_DELAY, TitledItem.TitledItemOrientation.NORTH);
        this.animationInterval = new TitledItem<NumberTextField>(new NumberTextField(new Node(), TextFieldType.INT), Words.SCROLL_INTERVAL, TitledItem.TitledItemOrientation.NORTH);
        this.animationDelay = new TitledItem<NumberTextField>(new NumberTextField(new Node(), TextFieldType.INT), Words.SCROLL_DELAY, TitledItem.TitledItemOrientation.NORTH);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.autoChangeNotificationCreation);
        this.scrollPane.getViewPort().add(this.maxHoursBeforeFlight);
        this.scrollPane.getViewPort().add(this.liveScreen);
        this.scrollPane.getViewPort().add(this.updateInterval);
        this.scrollPane.getViewPort().add(this.autoFadeOutSeconds);
        this.scrollPane.getViewPort().add(this.animationInterval);
        this.scrollPane.getViewPort().add(this.animationDelay);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return Words.SETTINGS;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.autoChangeNotificationCreation.kill();
            this.maxHoursBeforeFlight.kill();
            this.liveScreen.kill();
            this.updateInterval.kill();
            this.autoFadeOutSeconds.kill();
            this.animationInterval.kill();
            this.animationDelay.kill();
        }
        this.autoChangeNotificationCreation = null;
        this.maxHoursBeforeFlight = null;
        this.liveScreen = null;
        this.updateInterval = null;
        this.autoFadeOutSeconds = null;
        this.animationInterval = null;
        this.animationDelay = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            boolean checked = this.autoChangeNotificationCreation.getElement().isChecked() && isEnabled;
            this.autoChangeNotificationCreation.setEnabled(isEnabled);
            this.maxHoursBeforeFlight.setEnabled(checked);
            this.liveScreen.setEnabled(checked);
            this.updateInterval.setEnabled(checked);
            this.autoFadeOutSeconds.setEnabled(checked);
            this.animationInterval.setEnabled(checked);
            this.animationDelay.setEnabled(checked);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.autoChangeNotificationCreation);
            CheckedListAdder.addToList(focusList, this.maxHoursBeforeFlight);
            CheckedListAdder.addToList(focusList, this.updateInterval);
            CheckedListAdder.addToList(focusList, this.autoFadeOutSeconds);
            CheckedListAdder.addToList(focusList, this.animationInterval);
            CheckedListAdder.addToList(focusList, this.animationDelay);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.autoChangeNotificationCreation.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsChangeNotificationConfig.this.node.commitThis(SystemSettingsComplete.class);
                SystemSettingsComplete s = (SystemSettingsComplete)SettingsChangeNotificationConfig.this.node.getValue(SystemSettingsComplete.class);
                s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSystemSettings(s).getValue();
                SettingsChangeNotificationConfig.this.node.removeExistingValues();
                SettingsChangeNotificationConfig.this.node.setValue((Object)s, 0L);
                SettingsChangeNotificationConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsChangeNotificationConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsChangeNotificationConfig.this.changeLoadingState("Load 1/1 Modules");
                return ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsChangeNotificationConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<SystemSettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        SystemSettingsComplete systemSettings = (SystemSettingsComplete)node.getValue();
        if (systemSettings.getChangeNotificationSettings() == null) {
            ChangeNotificationSettingsComplete changeNotificationSettings = new ChangeNotificationSettingsComplete();
            changeNotificationSettings.setClientOId(Long.valueOf(ADTO.getNextId()));
            systemSettings.setChangeNotificationSettings(changeNotificationSettings);
            node.updateNode();
        }
        this.autoChangeNotificationCreation.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.changeNotificationSettings, ChangeNotificationSettingsComplete_.active}));
        this.maxHoursBeforeFlight.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.changeNotificationSettings, ChangeNotificationSettingsComplete_.maxHoursBeforeFlight}));
        this.updateInterval.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.changeNotificationSettings, ChangeNotificationSettingsComplete_.updateInterval}));
        this.autoFadeOutSeconds.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.changeNotificationSettings, ChangeNotificationSettingsComplete_.autoFadeOutSeconds}));
        this.animationInterval.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.changeNotificationSettings, ChangeNotificationSettingsComplete_.animationInterval}));
        this.animationDelay.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.changeNotificationSettings, ChangeNotificationSettingsComplete_.animationDelay}));
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsChangeNotificationConfig.this.layoutAnimation(parent);
            if (SettingsChangeNotificationConfig.this.isInserted) {
                SettingsChangeNotificationConfig.this.scrollPane.setLocation(1, 1);
                SettingsChangeNotificationConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsChangeNotificationConfig.this.isInserted) {
                h = (int)((double)h + (SettingsChangeNotificationConfig.this.autoChangeNotificationCreation.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsChangeNotificationConfig.this.liveScreen.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsChangeNotificationConfig.this.updateInterval.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsChangeNotificationConfig.this.autoFadeOutSeconds.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsChangeNotificationConfig.this.animationInterval.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsChangeNotificationConfig.this.animationDelay.getPreferredSize().getHeight() + (double)border));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int border = 10;
            w /= 2;
            if (SettingsChangeNotificationConfig.this.isInserted) {
                SettingsChangeNotificationConfig.this.autoChangeNotificationCreation.setLocation(border, border * 2);
                SettingsChangeNotificationConfig.this.autoChangeNotificationCreation.setSize(SettingsChangeNotificationConfig.this.autoChangeNotificationCreation.getPreferredSize());
                SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.setLocation(SettingsChangeNotificationConfig.this.autoChangeNotificationCreation.getX(), SettingsChangeNotificationConfig.this.autoChangeNotificationCreation.getY() + SettingsChangeNotificationConfig.this.autoChangeNotificationCreation.getHeight() + border);
                SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.setSize(SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getPreferredSize());
                SettingsChangeNotificationConfig.this.liveScreen.setLocation(SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getX(), SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getY() + SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getHeight() + 2 * border);
                SettingsChangeNotificationConfig.this.liveScreen.setSize(SettingsChangeNotificationConfig.this.liveScreen.getPreferredSize());
                SettingsChangeNotificationConfig.this.updateInterval.setLocation(SettingsChangeNotificationConfig.this.liveScreen.getX(), SettingsChangeNotificationConfig.this.liveScreen.getY() + SettingsChangeNotificationConfig.this.liveScreen.getHeight() + border);
                SettingsChangeNotificationConfig.this.updateInterval.setSize(SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getWidth(), (int)SettingsChangeNotificationConfig.this.updateInterval.getPreferredSize().getHeight());
                SettingsChangeNotificationConfig.this.autoFadeOutSeconds.setLocation(SettingsChangeNotificationConfig.this.updateInterval.getX(), SettingsChangeNotificationConfig.this.updateInterval.getY() + SettingsChangeNotificationConfig.this.updateInterval.getHeight() + border);
                SettingsChangeNotificationConfig.this.autoFadeOutSeconds.setSize(SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getWidth(), (int)SettingsChangeNotificationConfig.this.autoFadeOutSeconds.getPreferredSize().getHeight());
                SettingsChangeNotificationConfig.this.animationInterval.setLocation(SettingsChangeNotificationConfig.this.autoFadeOutSeconds.getX(), SettingsChangeNotificationConfig.this.autoFadeOutSeconds.getY() + SettingsChangeNotificationConfig.this.autoFadeOutSeconds.getHeight() + border);
                SettingsChangeNotificationConfig.this.animationInterval.setSize(SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getWidth(), (int)SettingsChangeNotificationConfig.this.animationInterval.getPreferredSize().getHeight());
                SettingsChangeNotificationConfig.this.animationDelay.setLocation(SettingsChangeNotificationConfig.this.animationInterval.getX(), SettingsChangeNotificationConfig.this.animationInterval.getY() + SettingsChangeNotificationConfig.this.animationInterval.getHeight() + border);
                SettingsChangeNotificationConfig.this.animationDelay.setSize(SettingsChangeNotificationConfig.this.maxHoursBeforeFlight.getWidth(), (int)SettingsChangeNotificationConfig.this.animationDelay.getPreferredSize().getHeight());
            }
        }
    }
}

