/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.dutyfree.DutyFreeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.store.dutyfree.DutyFreeSettingsComplete_;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsDutyFreeConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<DutyFreeSettingsComplete> node;
    private TitledItem<StorePositionSearchBox> outgoingStore;
    private TitledItem<StorePositionSearchBox> wasteStore;
    private TitledItem<SearchTextField2<StoreLight>> dutyFreeStore;
    private TitledItem<TextField> defaultPrefix;
    private TitledItem<CheckBox> scanTrolleyBarcode;

    public SettingsDutyFreeConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.outgoingStore = new TitledItem<StorePositionSearchBox>(new StorePositionSearchBox(), "DF Outgoing Store", TitledItem.TitledItemOrientation.NORTH);
        this.wasteStore = new TitledItem<StorePositionSearchBox>(new StorePositionSearchBox(), "DF Waste Store", TitledItem.TitledItemOrientation.NORTH);
        this.defaultPrefix = new TitledItem<TextField>(new TextField(), "Default Movement Group Prefix", TitledItem.TitledItemOrientation.NORTH);
        this.dutyFreeStore = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, null), "Duty Free Store", TitledItem.TitledItemOrientation.NORTH);
        this.scanTrolleyBarcode = new TitledItem<CheckBox>(new CheckBox(), "Scan fix Trolley Barcode", TitledItem.TitledItemOrientation.EAST);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.outgoingStore);
        this.scrollPane.getViewPort().add(this.wasteStore);
        this.scrollPane.getViewPort().add(this.defaultPrefix);
        this.scrollPane.getViewPort().add(this.dutyFreeStore);
        this.scrollPane.getViewPort().add(this.scanTrolleyBarcode);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Duty Free Settings";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.outgoingStore.kill();
            this.wasteStore.kill();
            this.defaultPrefix.kill();
            this.dutyFreeStore.kill();
            this.scanTrolleyBarcode.kill();
        }
        this.outgoingStore = null;
        this.wasteStore = null;
        this.defaultPrefix = null;
        this.dutyFreeStore = null;
        this.scanTrolleyBarcode = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.outgoingStore.setEnabled(isEnabled);
        this.wasteStore.setEnabled(isEnabled);
        this.defaultPrefix.setEnabled(isEnabled);
        this.outgoingStore.setEnabled(isEnabled);
        this.dutyFreeStore.setEnabled(isEnabled);
        this.scanTrolleyBarcode.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.outgoingStore);
            CheckedListAdder.addToList(focusList, this.wasteStore);
            CheckedListAdder.addToList(focusList, this.defaultPrefix);
            CheckedListAdder.addToList(focusList, this.outgoingStore);
            CheckedListAdder.addToList(focusList, this.dutyFreeStore);
            CheckedListAdder.addToList(focusList, this.scanTrolleyBarcode);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.outgoingStore.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsDutyFreeConfig.this.node.commitThis(DutyFreeSettingsComplete.class);
                DutyFreeSettingsComplete s = (DutyFreeSettingsComplete)SettingsDutyFreeConfig.this.node.getValue(DutyFreeSettingsComplete.class);
                s = (DutyFreeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)s).getValue();
                SettingsDutyFreeConfig.this.node.removeExistingValues();
                SettingsDutyFreeConfig.this.node.setValue((Object)s, 0L);
                SettingsDutyFreeConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsDutyFreeConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsDutyFreeConfig.this.changeLoadingState("Load 1/1 Modules");
                DutyFreeSettingsComplete dutyFreeSettings = (DutyFreeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getDutyFreeSettings().getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)dutyFreeSettings, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsDutyFreeConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<DutyFreeSettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.outgoingStore.getElement().setNode((Node<StorePositionLight>)node.getChildNamed(DutyFreeSettingsComplete_.outGoingStore));
        this.wasteStore.getElement().setNode((Node<StorePositionLight>)node.getChildNamed(DutyFreeSettingsComplete_.wasteStore));
        this.defaultPrefix.getElement().setNode(node.getChildNamed(DutyFreeSettingsComplete_.defaultGroupPrefix));
        this.dutyFreeStore.getElement().setNode(node.getChildNamed(DutyFreeSettingsComplete_.dutyFreeStore));
        this.scanTrolleyBarcode.getElement().setNode(node.getChildNamed(DutyFreeSettingsComplete_.useTrolleyBarcode));
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsDutyFreeConfig.this.layoutAnimation(parent);
            if (SettingsDutyFreeConfig.this.isInserted) {
                SettingsDutyFreeConfig.this.scrollPane.setLocation(1, 1);
                SettingsDutyFreeConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsDutyFreeConfig.this.isInserted) {
                h = (int)((double)h + (SettingsDutyFreeConfig.this.outgoingStore.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsDutyFreeConfig.this.wasteStore.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsDutyFreeConfig.this.dutyFreeStore.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsDutyFreeConfig.this.defaultPrefix.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsDutyFreeConfig.this.scanTrolleyBarcode.getPreferredSize().getHeight() + (double)border));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SettingsDutyFreeConfig.this.isInserted) {
                SettingsDutyFreeConfig.this.outgoingStore.setLocation(border, border * 2);
                SettingsDutyFreeConfig.this.outgoingStore.setSize(400, (int)SettingsDutyFreeConfig.this.outgoingStore.getPreferredSize().getHeight());
                SettingsDutyFreeConfig.this.wasteStore.setLocation(SettingsDutyFreeConfig.this.outgoingStore.getX(), SettingsDutyFreeConfig.this.outgoingStore.getY() + SettingsDutyFreeConfig.this.outgoingStore.getHeight() + border);
                SettingsDutyFreeConfig.this.wasteStore.setSize(400, (int)SettingsDutyFreeConfig.this.wasteStore.getPreferredSize().getHeight());
                SettingsDutyFreeConfig.this.dutyFreeStore.setLocation(SettingsDutyFreeConfig.this.outgoingStore.getX(), SettingsDutyFreeConfig.this.wasteStore.getY() + SettingsDutyFreeConfig.this.wasteStore.getHeight() + border);
                SettingsDutyFreeConfig.this.dutyFreeStore.setSize(400, (int)SettingsDutyFreeConfig.this.wasteStore.getPreferredSize().getHeight());
                SettingsDutyFreeConfig.this.defaultPrefix.setLocation(SettingsDutyFreeConfig.this.outgoingStore.getX(), SettingsDutyFreeConfig.this.dutyFreeStore.getY() + SettingsDutyFreeConfig.this.dutyFreeStore.getHeight() + border);
                SettingsDutyFreeConfig.this.defaultPrefix.setSize(SettingsDutyFreeConfig.this.defaultPrefix.getPreferredSize());
                SettingsDutyFreeConfig.this.scanTrolleyBarcode.setLocation(SettingsDutyFreeConfig.this.outgoingStore.getX(), SettingsDutyFreeConfig.this.defaultPrefix.getY() + SettingsDutyFreeConfig.this.defaultPrefix.getHeight() + border);
                SettingsDutyFreeConfig.this.scanTrolleyBarcode.setSize(SettingsDutyFreeConfig.this.scanTrolleyBarcode.getPreferredSize());
            }
        }
    }
}

