/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.label.AllergenInfoSheetSettingsComplete;
import ch.icit.pegasus.server.core.dtos.label.AllergenInfoSheetSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsFlightCatalogConfig
extends DefaultDataInsert {
    private static final long serialVersionUID = 1L;
    private Node<SystemSettingsComplete> node;
    private ScrollableBackground scrollPane;
    private TitledItem<ScrollableTextArea> allergenDisclaimer;
    private TitledItem<CheckBox> showProductsInFlightCatalog;
    private TitledItem<TextField> defaultNoAllegenSymbol;
    private TitledItem<TextField> defaultNotApprovedText;
    private InfoButton defaultNotApprovedInfo;
    private TitledItem<CheckBox> showDraftOnGroupedSheet;
    private TitledItem<CheckBox> showDraftOnDetailedSheet;
    private TitledItem<CheckBox> useProductAllergenDeclaration;
    private TitledItem<CheckBox> showAllergenTraces;
    private TitledItem<NumberTextField> allergenCodeDescriptionPrintCount;
    private TextLabel articleCategoriesTable;

    public SettingsFlightCatalogConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.allergenCodeDescriptionPrintCount = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.ALLERGEN_CODE_DESCRIPTION_SHEET_PRINT_COUNT, TitledItem.TitledItemOrientation.NORTH);
        this.allergenDisclaimer = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(), Words.ALLERGEN_DISCLAIMER, TitledItem.TitledItemOrientation.NORTH);
        this.allergenDisclaimer.setIgnorePrefHeight(true);
        this.allergenDisclaimer.getElement().setMaxStringLength(Integer.MAX_VALUE);
        this.showProductsInFlightCatalog = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_IMAGE, TitledItem.TitledItemOrientation.EAST);
        this.defaultNoAllegenSymbol = new TitledItem<TextField>(new TextField(), Words.DEFAULT_NO_ALLEGEN_SYMBOL, TitledItem.TitledItemOrientation.NORTH);
        this.defaultNotApprovedText = new TitledItem<TextField>(new TextField(), Words.NOT_APPROVED_TEXT, TitledItem.TitledItemOrientation.NORTH);
        this.showAllergenTraces = new TitledItem<CheckBox>(new CheckBox(), "Show Traces", TitledItem.TitledItemOrientation.EAST);
        this.defaultNotApprovedInfo = new InfoButton();
        this.defaultNotApprovedInfo.installStringViewer(ArticleToolkit.getAllergenNotApprovedTextDescription());
        this.articleCategoriesTable = new TextLabel(Words.RELEVANT_CATEGORY_DEFINED_IN_MASTER_DATA);
        this.showDraftOnDetailedSheet = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_DRAFT_ON_DETAILED_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.showDraftOnGroupedSheet = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_DRAFT_ON_GROUPED_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.useProductAllergenDeclaration = new TitledItem<CheckBox>(new CheckBox(), Words.USE_PRODUCT_ALLERGEN_DECLARATION, TitledItem.TitledItemOrientation.EAST);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.allergenDisclaimer);
        this.scrollPane.getViewPort().add(this.showProductsInFlightCatalog);
        this.scrollPane.getViewPort().add(this.articleCategoriesTable);
        this.scrollPane.getViewPort().add(this.defaultNoAllegenSymbol);
        this.scrollPane.getViewPort().add(this.defaultNotApprovedText);
        this.scrollPane.getViewPort().add(this.defaultNotApprovedInfo);
        this.scrollPane.getViewPort().add(this.showDraftOnDetailedSheet);
        this.scrollPane.getViewPort().add(this.showDraftOnGroupedSheet);
        this.scrollPane.getViewPort().add(this.allergenCodeDescriptionPrintCount);
        this.scrollPane.getViewPort().add(this.useProductAllergenDeclaration);
        this.scrollPane.getViewPort().add(this.showAllergenTraces);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Flight Catalog Settings";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.allergenDisclaimer.kill();
            this.showProductsInFlightCatalog.kill();
            this.articleCategoriesTable.kill();
            this.defaultNoAllegenSymbol.kill();
            this.defaultNotApprovedText.kill();
            this.defaultNotApprovedInfo.kill();
            this.showDraftOnDetailedSheet.kill();
            this.showDraftOnGroupedSheet.kill();
            this.allergenCodeDescriptionPrintCount.kill();
            this.useProductAllergenDeclaration.kill();
            this.showAllergenTraces.kill();
        }
        this.allergenDisclaimer = null;
        this.showProductsInFlightCatalog = null;
        this.articleCategoriesTable = null;
        this.defaultNoAllegenSymbol = null;
        this.defaultNotApprovedText = null;
        this.defaultNotApprovedInfo = null;
        this.showDraftOnDetailedSheet = null;
        this.showDraftOnGroupedSheet = null;
        this.allergenCodeDescriptionPrintCount = null;
        this.useProductAllergenDeclaration = null;
        this.showAllergenTraces = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.allergenDisclaimer.setEnabled(isEnabled);
            this.showProductsInFlightCatalog.setEnabled(isEnabled);
            this.articleCategoriesTable.setEnabled(isEnabled);
            this.defaultNoAllegenSymbol.setEnabled(isEnabled);
            this.defaultNotApprovedText.setEnabled(isEnabled);
            this.defaultNotApprovedInfo.setEnabled(isEnabled);
            this.showDraftOnDetailedSheet.setEnabled(isEnabled);
            this.showDraftOnGroupedSheet.setEnabled(isEnabled);
            this.allergenCodeDescriptionPrintCount.setEnabled(isEnabled);
            this.useProductAllergenDeclaration.setEnabled(isEnabled);
            this.showAllergenTraces.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.allergenDisclaimer);
            CheckedListAdder.addToList(a, this.showProductsInFlightCatalog);
            CheckedListAdder.addToList(a, this.showDraftOnGroupedSheet);
            CheckedListAdder.addToList(a, this.showDraftOnDetailedSheet);
            CheckedListAdder.addToList(a, this.defaultNoAllegenSymbol);
            CheckedListAdder.addToList(a, this.defaultNotApprovedText);
            CheckedListAdder.addToList(a, this.allergenCodeDescriptionPrintCount);
            CheckedListAdder.addToList(a, this.useProductAllergenDeclaration);
            CheckedListAdder.addToList(a, this.showAllergenTraces);
            return a;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.allergenDisclaimer.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsFlightCatalogConfig.this.node.commitThis(SystemSettingsComplete.class);
                SystemSettingsComplete s = (SystemSettingsComplete)SettingsFlightCatalogConfig.this.node.getValue(SystemSettingsComplete.class);
                s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSystemSettings(s).getValue();
                SettingsFlightCatalogConfig.this.node.removeExistingValues();
                SettingsFlightCatalogConfig.this.node.setValue((Object)s, 0L);
                SettingsFlightCatalogConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsFlightCatalogConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsFlightCatalogConfig.this.changeLoadingState("Load 1/3 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategoriesCached();
                SettingsFlightCatalogConfig.this.changeLoadingState("Load 2/3 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                SettingsFlightCatalogConfig.this.changeLoadingState("Load 3/3 Modules");
                return ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsFlightCatalogConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<?> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        SystemSettingsComplete s = (SystemSettingsComplete)node.getValue();
        if (s.getFlightCatalogSettings() == null) {
            AllergenInfoSheetSettingsComplete fcs = new AllergenInfoSheetSettingsComplete();
            fcs.setClientOId(Long.valueOf(ADTO.getNextId()));
            fcs.setDisclaimer("");
            fcs.setShowImages(Boolean.valueOf(true));
            s.setFlightCatalogSettings(fcs);
            node.updateNode();
        }
        this.allergenDisclaimer.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.disclaimer}));
        this.showProductsInFlightCatalog.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.showImages}));
        this.defaultNoAllegenSymbol.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.defaultNoAllergenSymbol}));
        this.defaultNotApprovedText.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.defaultNotApprovedArticleText}));
        this.showDraftOnDetailedSheet.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.showDraftOnDetailedSheet}));
        this.showDraftOnGroupedSheet.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.showDraftOnGroupedSheet}));
        this.allergenCodeDescriptionPrintCount.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.allergenCodeDescriptionPrintCount}));
        this.useProductAllergenDeclaration.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.useProductAllergenDeclaration}));
        this.showAllergenTraces.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.flightCatalogSettings, AllergenInfoSheetSettingsComplete_.showAllergenTraces}));
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        this.node.commitThis(SystemSettingsComplete.class);
        SystemSettingsComplete s = (SystemSettingsComplete)this.node.getValue(SystemSettingsComplete.class);
        return a;
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsFlightCatalogConfig.this.layoutAnimation(parent);
            if (SettingsFlightCatalogConfig.this.isInserted) {
                SettingsFlightCatalogConfig.this.scrollPane.setLocation(1, 1);
                SettingsFlightCatalogConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsFlightCatalogConfig.this.isInserted) {
                h += border;
                h += 200;
                h += border;
                h = (int)((double)h + SettingsFlightCatalogConfig.this.showProductsInFlightCatalog.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightCatalogConfig.this.useProductAllergenDeclaration.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsFlightCatalogConfig.this.showAllergenTraces.getPreferredSize().getHeight());
                h += border;
                h += 200;
                h += border;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            int w = parent.getWidth() - 2 * border;
            if (SettingsFlightCatalogConfig.this.isInserted) {
                SettingsFlightCatalogConfig.this.allergenDisclaimer.setLocation(border, border);
                SettingsFlightCatalogConfig.this.allergenDisclaimer.setSize(w, 200);
                SettingsFlightCatalogConfig.this.showProductsInFlightCatalog.setLocation(border, SettingsFlightCatalogConfig.this.allergenDisclaimer.getY() + SettingsFlightCatalogConfig.this.allergenDisclaimer.getHeight() + border);
                SettingsFlightCatalogConfig.this.showProductsInFlightCatalog.setSize(SettingsFlightCatalogConfig.this.showProductsInFlightCatalog.getPreferredSize());
                SettingsFlightCatalogConfig.this.showDraftOnGroupedSheet.setLocation(border, SettingsFlightCatalogConfig.this.showProductsInFlightCatalog.getY() + SettingsFlightCatalogConfig.this.showProductsInFlightCatalog.getHeight() + border);
                SettingsFlightCatalogConfig.this.showDraftOnGroupedSheet.setSize(SettingsFlightCatalogConfig.this.showDraftOnGroupedSheet.getPreferredSize());
                SettingsFlightCatalogConfig.this.showDraftOnDetailedSheet.setLocation(border, SettingsFlightCatalogConfig.this.showDraftOnGroupedSheet.getY() + SettingsFlightCatalogConfig.this.showDraftOnGroupedSheet.getHeight() + border);
                SettingsFlightCatalogConfig.this.showDraftOnDetailedSheet.setSize(SettingsFlightCatalogConfig.this.showDraftOnDetailedSheet.getPreferredSize());
                SettingsFlightCatalogConfig.this.useProductAllergenDeclaration.setLocation(border, SettingsFlightCatalogConfig.this.showDraftOnDetailedSheet.getY() + SettingsFlightCatalogConfig.this.showDraftOnDetailedSheet.getHeight() + border);
                SettingsFlightCatalogConfig.this.useProductAllergenDeclaration.setSize(w, (int)SettingsFlightCatalogConfig.this.useProductAllergenDeclaration.getPreferredSize().getHeight());
                SettingsFlightCatalogConfig.this.showAllergenTraces.setLocation(border, SettingsFlightCatalogConfig.this.useProductAllergenDeclaration.getY() + SettingsFlightCatalogConfig.this.useProductAllergenDeclaration.getHeight() + border);
                SettingsFlightCatalogConfig.this.showAllergenTraces.setSize(w, (int)SettingsFlightCatalogConfig.this.showAllergenTraces.getPreferredSize().getHeight());
                SettingsFlightCatalogConfig.this.defaultNoAllegenSymbol.setLocation(border, SettingsFlightCatalogConfig.this.showAllergenTraces.getY() + SettingsFlightCatalogConfig.this.showAllergenTraces.getHeight() + border);
                SettingsFlightCatalogConfig.this.defaultNoAllegenSymbol.setSize(200, (int)SettingsFlightCatalogConfig.this.defaultNoAllegenSymbol.getPreferredSize().getHeight());
                SettingsFlightCatalogConfig.this.defaultNotApprovedText.setLocation(border, SettingsFlightCatalogConfig.this.defaultNoAllegenSymbol.getY() + SettingsFlightCatalogConfig.this.defaultNoAllegenSymbol.getHeight() + border);
                SettingsFlightCatalogConfig.this.defaultNotApprovedText.setSize(200, (int)SettingsFlightCatalogConfig.this.defaultNotApprovedText.getPreferredSize().getHeight());
                SettingsFlightCatalogConfig.this.defaultNotApprovedInfo.setLocation(SettingsFlightCatalogConfig.this.defaultNotApprovedText.getX() + SettingsFlightCatalogConfig.this.defaultNotApprovedText.getWidth() + border / 2, (int)((double)(SettingsFlightCatalogConfig.this.defaultNotApprovedText.getY() + SettingsFlightCatalogConfig.this.defaultNotApprovedText.getHeight()) - (((TextField)SettingsFlightCatalogConfig.this.defaultNotApprovedText.getElement()).getPreferredSize().getHeight() - 2.0)));
                SettingsFlightCatalogConfig.this.defaultNotApprovedInfo.setSize(SettingsFlightCatalogConfig.this.defaultNotApprovedInfo.getPreferredSize());
                SettingsFlightCatalogConfig.this.allergenCodeDescriptionPrintCount.setLocation(border, SettingsFlightCatalogConfig.this.defaultNotApprovedInfo.getY() + SettingsFlightCatalogConfig.this.defaultNotApprovedInfo.getHeight() + border / 2);
                SettingsFlightCatalogConfig.this.allergenCodeDescriptionPrintCount.setSize(SettingsFlightCatalogConfig.this.allergenCodeDescriptionPrintCount.getPreferredSize());
                SettingsFlightCatalogConfig.this.articleCategoriesTable.setLocation(border, SettingsFlightCatalogConfig.this.allergenCodeDescriptionPrintCount.getY() + SettingsFlightCatalogConfig.this.allergenCodeDescriptionPrintCount.getHeight() + border);
                SettingsFlightCatalogConfig.this.articleCategoriesTable.setSize((w - border * 3) / 2, (int)SettingsFlightCatalogConfig.this.articleCategoriesTable.getPreferredSize().getHeight());
            }
        }
    }
}

