/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.TaxRate2Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.TaxRateVariantTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateVariantComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsRetailConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private Node<SystemSettingsComplete> node;
    private ScrollableBackground scrollPane;
    private TitledItem<CheckBox> useSameStowingListTemplateForAllCustomers;
    private TitledItem<SearchTextField2> stowingListTemplate;
    private TitledItem<CheckBox> retailAutoName;
    private TitledItem<TextField> defaultRetailName;
    private TitledItem<CheckBox> retailAutoCloseInvoice;
    private TitledItem<CheckBox> retailAutoSendInvoice;
    private TitledItem<CheckBox> retailAutoSendCreditNote;
    private TitledItem<CheckBox> retailAutoTax;
    private TitledItem<CheckBox> retailUseCustomerInvoiceNo;
    private TitledItem<TextField> retailAutoSendInvoiceReceiveAddress;
    private TitledItem<ComboBox> retailDefaultMilkTaxRate;
    private TaxRateVariantTable defaultRetailTax;
    private TitledItem<CheckBox> productCommissionActive;

    public SettingsRetailConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.useSameStowingListTemplateForAllCustomers = new TitledItem<CheckBox>(new CheckBox(), Words.USE_SAME_STOWING_LIST_FOR_ALL_CUSTOMERS, TitledItem.TitledItemOrientation.EAST);
        this.stowingListTemplate = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, null), Words.STOWING_LIST_TEMPLATE, TitledItem.TitledItemOrientation.NORTH);
        this.retailAutoName = new TitledItem<CheckBox>(new CheckBox(), Words.AUTO_NAME_MANUALLY, TitledItem.TitledItemOrientation.EAST);
        this.retailAutoName.getElement().addButtonListener(this);
        this.defaultRetailName = new TitledItem<TextField>(new TextField(), Words.AUTO_RETAIL_NAME_PREFIX, TitledItem.TitledItemOrientation.NORTH);
        this.retailAutoCloseInvoice = new TitledItem<CheckBox>(new CheckBox(), Words.AUTO_CLOSE_INVOICE, TitledItem.TitledItemOrientation.EAST);
        this.retailAutoSendInvoice = new TitledItem<CheckBox>(new CheckBox(), Words.AUTO_SEND_INVOICE, TitledItem.TitledItemOrientation.EAST);
        this.retailAutoSendCreditNote = new TitledItem<CheckBox>(new CheckBox(), Words.AUTO_SEND_CREDIT_NOTE, TitledItem.TitledItemOrientation.EAST);
        this.retailAutoTax = new TitledItem<CheckBox>(new CheckBox(), Words.AUTO_TAX, TitledItem.TitledItemOrientation.EAST);
        this.retailAutoSendInvoiceReceiveAddress = new TitledItem<TextField>(new TextField(null, TextFieldType.NORMAL), Words.INVOICE_RECEIVER, TitledItem.TitledItemOrientation.NORTH);
        this.retailUseCustomerInvoiceNo = new TitledItem<CheckBox>(new CheckBox(), Words.USE_CUSTOMER_INVOICE_NO, TitledItem.TitledItemOrientation.EAST);
        this.defaultRetailTax = new TaxRateVariantTable();
        this.productCommissionActive = new TitledItem<CheckBox>(new CheckBox(), Words.PRODUCT_COMMISSION_ACTIVE, TitledItem.TitledItemOrientation.EAST);
        this.retailDefaultMilkTaxRate = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(TaxRate2Converter.class)), Words.MILK_TAX, TitledItem.TitledItemOrientation.NORTH);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.useSameStowingListTemplateForAllCustomers);
        this.scrollPane.getViewPort().add(this.stowingListTemplate);
        this.scrollPane.getViewPort().add(this.retailAutoName);
        this.scrollPane.getViewPort().add(this.defaultRetailName);
        this.scrollPane.getViewPort().add(this.retailAutoCloseInvoice);
        this.scrollPane.getViewPort().add(this.retailAutoSendInvoice);
        this.scrollPane.getViewPort().add(this.retailAutoTax);
        this.scrollPane.getViewPort().add(this.retailAutoSendInvoiceReceiveAddress);
        this.scrollPane.getViewPort().add(this.defaultRetailTax);
        this.scrollPane.getViewPort().add(this.retailAutoSendCreditNote);
        this.scrollPane.getViewPort().add(this.productCommissionActive);
        this.scrollPane.getViewPort().add(this.retailUseCustomerInvoiceNo);
        this.scrollPane.getViewPort().add(this.retailDefaultMilkTaxRate);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return Words.SETTINGS;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.useSameStowingListTemplateForAllCustomers.kill();
            this.stowingListTemplate.kill();
            this.retailAutoName.kill();
            this.defaultRetailName.kill();
            this.retailAutoCloseInvoice.kill();
            this.retailAutoSendInvoice.kill();
            this.retailAutoTax.kill();
            this.retailAutoSendInvoiceReceiveAddress.kill();
            this.defaultRetailTax.kill();
            this.retailAutoSendCreditNote.kill();
            this.productCommissionActive.kill();
            this.retailUseCustomerInvoiceNo.kill();
            this.retailDefaultMilkTaxRate.kill();
        }
        this.useSameStowingListTemplateForAllCustomers = null;
        this.stowingListTemplate = null;
        this.retailAutoName = null;
        this.defaultRetailName = null;
        this.retailAutoCloseInvoice = null;
        this.retailAutoSendInvoice = null;
        this.retailAutoTax = null;
        this.retailAutoSendInvoiceReceiveAddress = null;
        this.defaultRetailTax = null;
        this.retailAutoSendCreditNote = null;
        this.productCommissionActive = null;
        this.retailUseCustomerInvoiceNo = null;
        this.retailDefaultMilkTaxRate = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useSameStowingListTemplateForAllCustomers.setEnabled(isEnabled);
            this.stowingListTemplate.setEnabled(isEnabled);
            this.retailAutoName.setEnabled(isEnabled);
            this.defaultRetailName.setEnabled(isEnabled && this.retailAutoName.getElement().isChecked());
            this.retailAutoCloseInvoice.setEnabled(isEnabled);
            this.retailAutoSendInvoice.setEnabled(isEnabled);
            this.retailAutoTax.setEnabled(isEnabled);
            this.retailAutoSendInvoiceReceiveAddress.setEnabled(isEnabled);
            this.defaultRetailTax.setEnabled(isEnabled);
            this.retailAutoSendCreditNote.setEnabled(isEnabled);
            this.productCommissionActive.setEnabled(isEnabled);
            this.retailUseCustomerInvoiceNo.setEnabled(isEnabled);
            this.retailDefaultMilkTaxRate.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.stowingListTemplate);
            CheckedListAdder.addToList(focusList, this.useSameStowingListTemplateForAllCustomers);
            CheckedListAdder.addToList(focusList, this.retailAutoName);
            CheckedListAdder.addToList(focusList, this.defaultRetailName);
            CheckedListAdder.addToList(focusList, this.retailAutoCloseInvoice);
            CheckedListAdder.addToList(focusList, this.retailAutoSendInvoice);
            CheckedListAdder.addToList(focusList, this.retailAutoSendCreditNote);
            CheckedListAdder.addToList(focusList, this.retailAutoTax);
            CheckedListAdder.addToList(focusList, this.productCommissionActive);
            CheckedListAdder.addToList(focusList, this.retailUseCustomerInvoiceNo);
            CheckedListAdder.addToList(focusList, this.retailAutoSendInvoiceReceiveAddress);
            CheckedListAdder.addToList(focusList, this.retailDefaultMilkTaxRate);
            CheckedListAdder.addToList(focusList, this.defaultRetailTax);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.useSameStowingListTemplateForAllCustomers.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsRetailConfig.this.node.commitThis(SystemSettingsComplete.class);
                SystemSettingsComplete s = (SystemSettingsComplete)SettingsRetailConfig.this.node.getValue(SystemSettingsComplete.class);
                s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSystemSettings(s).getValue();
                SettingsRetailConfig.this.node.removeExistingValues();
                SettingsRetailConfig.this.node.setValue((Object)s, 0L);
                SettingsRetailConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsRetailConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsRetailConfig.this.changeLoadingState("Load 1/1 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
                return ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsRetailConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<?> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.useSameStowingListTemplateForAllCustomers.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.useSameStowingListTemplateForRetail));
        this.stowingListTemplate.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.stowingListTemplateForRetail));
        this.retailAutoName.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.retailAutoName));
        this.defaultRetailName.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.defaultRetailName));
        this.retailAutoCloseInvoice.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.retailAutoCloseInvoice));
        this.retailAutoSendInvoice.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.retailAutoSendInvoice));
        this.retailAutoTax.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.retailAutoTax));
        this.retailAutoSendInvoiceReceiveAddress.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.retailAutoSendInvoiceReceiveAddress));
        this.retailAutoSendCreditNote.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.retailAutoSendCreditNote));
        this.defaultRetailTax.setNode((Node<List<TaxRateVariantComplete>>)node.getChildNamed(SystemSettingsComplete_.retailDefaultTaxRateList));
        this.productCommissionActive.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.productCommissionActive));
        this.retailDefaultMilkTaxRate.getElement().refreshPossibleValues(NodeToolkit.getAffixList(TaxRateComplete.class));
        this.retailDefaultMilkTaxRate.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.retailDefaultMilkTaxRate));
        this.retailUseCustomerInvoiceNo.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.useTrackingNoForInvoice));
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsRetailConfig.this.layoutAnimation(parent);
            if (SettingsRetailConfig.this.isInserted) {
                SettingsRetailConfig.this.scrollPane.setLocation(1, 1);
                SettingsRetailConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsRetailConfig.this.isInserted) {
                h = (int)((double)h + SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.stowingListTemplate.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailAutoName.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.defaultRetailName.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailAutoCloseInvoice.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailAutoSendInvoice.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailAutoSendCreditNote.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailAutoTax.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.productCommissionActive.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailUseCustomerInvoiceNo.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailAutoSendInvoiceReceiveAddress.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsRetailConfig.this.retailDefaultMilkTaxRate.getPreferredSize().getHeight());
                h += border;
                h += 350;
                h += border;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int border = 10;
            w /= 2;
            if (SettingsRetailConfig.this.isInserted) {
                SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.setLocation(border, border * 2);
                SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.setSize(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getPreferredSize());
                SettingsRetailConfig.this.stowingListTemplate.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getY() + SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getHeight() + border);
                SettingsRetailConfig.this.stowingListTemplate.setSize(SettingsRetailConfig.this.stowingListTemplate.getPreferredSize());
                SettingsRetailConfig.this.retailAutoName.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.stowingListTemplate.getY() + SettingsRetailConfig.this.stowingListTemplate.getHeight() + border);
                SettingsRetailConfig.this.retailAutoName.setSize(SettingsRetailConfig.this.retailAutoName.getPreferredSize());
                SettingsRetailConfig.this.defaultRetailName.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.retailAutoName.getY() + SettingsRetailConfig.this.retailAutoName.getHeight() + border);
                SettingsRetailConfig.this.defaultRetailName.setSize(SettingsRetailConfig.this.defaultRetailName.getPreferredSize());
                SettingsRetailConfig.this.retailAutoCloseInvoice.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.defaultRetailName.getY() + SettingsRetailConfig.this.defaultRetailName.getHeight() + border);
                SettingsRetailConfig.this.retailAutoCloseInvoice.setSize(SettingsRetailConfig.this.retailAutoCloseInvoice.getPreferredSize());
                SettingsRetailConfig.this.retailAutoSendInvoice.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.retailAutoCloseInvoice.getY() + SettingsRetailConfig.this.retailAutoCloseInvoice.getHeight() + border);
                SettingsRetailConfig.this.retailAutoSendInvoice.setSize(SettingsRetailConfig.this.retailAutoSendInvoice.getPreferredSize());
                SettingsRetailConfig.this.retailAutoSendCreditNote.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.retailAutoSendInvoice.getY() + SettingsRetailConfig.this.retailAutoSendInvoice.getHeight() + border);
                SettingsRetailConfig.this.retailAutoSendCreditNote.setSize(SettingsRetailConfig.this.retailAutoSendCreditNote.getPreferredSize());
                SettingsRetailConfig.this.retailAutoTax.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.retailAutoSendCreditNote.getY() + SettingsRetailConfig.this.retailAutoSendCreditNote.getHeight() + border);
                SettingsRetailConfig.this.retailAutoTax.setSize(SettingsRetailConfig.this.retailAutoTax.getPreferredSize());
                SettingsRetailConfig.this.productCommissionActive.setLocation(SettingsRetailConfig.this.defaultRetailTax.getX(), SettingsRetailConfig.this.retailAutoTax.getY() + SettingsRetailConfig.this.retailAutoTax.getHeight() + border);
                SettingsRetailConfig.this.productCommissionActive.setSize(SettingsRetailConfig.this.productCommissionActive.getPreferredSize());
                SettingsRetailConfig.this.retailUseCustomerInvoiceNo.setLocation(SettingsRetailConfig.this.defaultRetailTax.getX(), SettingsRetailConfig.this.productCommissionActive.getY() + SettingsRetailConfig.this.productCommissionActive.getHeight() + border);
                SettingsRetailConfig.this.retailUseCustomerInvoiceNo.setSize(SettingsRetailConfig.this.retailUseCustomerInvoiceNo.getPreferredSize());
                SettingsRetailConfig.this.retailAutoSendInvoiceReceiveAddress.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.retailUseCustomerInvoiceNo.getY() + SettingsRetailConfig.this.retailUseCustomerInvoiceNo.getHeight() + border);
                SettingsRetailConfig.this.retailAutoSendInvoiceReceiveAddress.setSize(350, (int)SettingsRetailConfig.this.retailAutoSendInvoiceReceiveAddress.getPreferredSize().getHeight());
                SettingsRetailConfig.this.retailDefaultMilkTaxRate.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.retailAutoSendInvoiceReceiveAddress.getY() + SettingsRetailConfig.this.retailAutoSendInvoiceReceiveAddress.getHeight() + border);
                SettingsRetailConfig.this.retailDefaultMilkTaxRate.setSize(350, (int)SettingsRetailConfig.this.retailDefaultMilkTaxRate.getPreferredSize().getHeight());
                SettingsRetailConfig.this.defaultRetailTax.setLocation(SettingsRetailConfig.this.useSameStowingListTemplateForAllCustomers.getX(), SettingsRetailConfig.this.retailDefaultMilkTaxRate.getY() + SettingsRetailConfig.this.retailDefaultMilkTaxRate.getHeight() + border);
                SettingsRetailConfig.this.defaultRetailTax.setSize(600, 350);
            }
        }
    }
}

