/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.SoBAccessLevelComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SoBAccessLevelComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SoBAccessLevelConfig
extends MasterDataInsert<SoBAccessLevelComplete> {
    private static final long serialVersionUID = 1L;

    public SoBAccessLevelConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new CreditCardConfigPanel();
    }

    @Override
    public SoBAccessLevelComplete getNewObject() {
        SoBAccessLevelComplete a = new SoBAccessLevelComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        a.setAccessLevel(Integer.valueOf(0));
        a.setAccessLevelName("");
        return a;
    }

    @Override
    public Class<SoBAccessLevelComplete> getMasterDataClass() {
        return SoBAccessLevelComplete.class;
    }

    @Override
    public String getInsertName() {
        return "SoB Access Level";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        HashSet<Integer> level = new HashSet<Integer>();
        boolean codeSet = true;
        boolean levelSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(SoBAccessLevelComplete_.accessLevelName).getValue() == null) {
                codeSet = false;
            } else if (codes.contains(n.getChildNamed(SoBAccessLevelComplete_.accessLevelName).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Access Name " + n.getChildNamed(SoBAccessLevelComplete_.accessLevelName).getValue() + " is not unique."));
            } else {
                codes.add((String)n.getChildNamed(SoBAccessLevelComplete_.accessLevelName).getValue());
            }
            if (n.getChildNamed(SoBAccessLevelComplete_.accessLevel).getValue() == null) {
                levelSet = false;
                continue;
            }
            if (level.contains(n.getChildNamed(SoBAccessLevelComplete_.accessLevel).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Access Level " + n.getChildNamed(SoBAccessLevelComplete_.accessLevel).getValue() + " is not unique."));
                continue;
            }
            level.add((Integer)n.getChildNamed(SoBAccessLevelComplete_.accessLevel).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Access Level Name are set"));
        }
        if (!levelSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Access Level are set"));
        }
        return a;
    }

    private class CreditCardConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> accessLevelName;
        private TitledItem<TextField> accessLevel;

        public CreditCardConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.accessLevelName = new TitledItem<TextField>(new TextField(null), "Access Level Name", TitledItem.TitledItemOrientation.NORTH);
            this.accessLevel = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.INT), "Access Level", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.accessLevel);
            this.add(this.accessLevelName);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.accessLevel.getFocusComponents();
            CheckedListAdder.addToList(a, this.accessLevelName);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.accessLevelName.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.accessLevelName.setVisibleContainer(pane);
            this.accessLevel.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.accessLevelName.kill();
            this.accessLevelName = null;
            this.accessLevel.kill();
            this.accessLevel = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.accessLevelName.setEnabled(b);
            this.accessLevel.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.accessLevelName.getElement().setNode(node.getChildNamed(SoBAccessLevelComplete_.accessLevelName));
            this.accessLevel.getElement().setNode(node.getChildNamed(SoBAccessLevelComplete_.accessLevel));
            this.setEnabled(true);
            SoBAccessLevelConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return SoBAccessLevelComplete_.accessLevelName;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                CreditCardConfigPanel.this.accessLevel.setLocation(SoBAccessLevelConfig.this.masterDataTable.getCellPadding(), SoBAccessLevelConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.accessLevel.setSize(200, (int)CreditCardConfigPanel.this.accessLevel.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.accessLevelName.setLocation(SoBAccessLevelConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.accessLevel.getY() + CreditCardConfigPanel.this.accessLevel.getHeight() + SoBAccessLevelConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.accessLevelName.setSize(200, (int)CreditCardConfigPanel.this.accessLevelName.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

