/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StowagePositionConfig
extends MasterDataInsert<StowagePositionTypeComplete> {
    private static final long serialVersionUID = 1L;

    public StowagePositionConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public void insertElements() {
    }

    @Override
    public DetailsPanel getDetails() {
        return new StowagePositionConfigPanel();
    }

    @Override
    public StowagePositionTypeComplete getNewObject() {
        StowagePositionTypeComplete a = new StowagePositionTypeComplete();
        Dimension3dComplete d = new Dimension3dComplete(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0));
        a.setSize(d);
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends StowagePositionTypeComplete> getMasterDataClass() {
        return StowagePositionTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Stowage Position Types";
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(StowagePositionTypeComplete.class, true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return StowagePositionConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean dimensionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(new DtoField[]{StowagePositionTypeComplete_.size, Dimension3dComplete_.width}).getValue() == null) {
                dimensionSet = false;
            }
            if (n.getChildNamed(new DtoField[]{StowagePositionTypeComplete_.size, Dimension3dComplete_.height}).getValue() == null) {
                dimensionSet = false;
            }
            if (n.getChildNamed(new DtoField[]{StowagePositionTypeComplete_.size, Dimension3dComplete_.depth}).getValue() == null) {
                dimensionSet = false;
            }
            if (n.getChildNamed(StowagePositionTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(StowagePositionTypeComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(StowagePositionTypeComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(StowagePositionTypeComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!dimensionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Dimensions are set"));
        }
        return a;
    }

    private class StowagePositionConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;
        private TitledItem<TextField> d1;
        private TitledItem<TextField> d2;
        private TitledItem<TextField> d3;

        public StowagePositionConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.d1 = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.DOUBLE), Words.WIDTH, TitledItem.TitledItemOrientation.NORTH);
            this.d2 = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.DOUBLE), Words.HEIGHT, TitledItem.TitledItemOrientation.NORTH);
            this.d3 = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.DOUBLE), Words.DEPTH, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.name);
            this.add(this.d2);
            this.add(this.d1);
            this.add(this.d3);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.name.getFocusComponents());
            a.addAll(this.d1.getFocusComponents());
            a.addAll(this.d2.getFocusComponents());
            a.addAll(this.d3.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
            this.d1.setVisibleContainer(pane);
            this.d2.setVisibleContainer(pane);
            this.d3.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.name.kill();
            this.d1.kill();
            this.d2.kill();
            this.d3.kill();
            this.d1 = null;
            this.d2 = null;
            this.d3 = null;
            this.code = null;
            this.name = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.name.setEnabled(b);
            this.d1.setEnabled(b);
            this.d2.setEnabled(b);
            this.d3.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(StowagePositionTypeComplete_.code));
            this.name.getElement().setNode(node.getChildNamed(StowagePositionTypeComplete_.name));
            this.d1.getElement().setNode(node.getChildNamed(new DtoField[]{StowagePositionTypeComplete_.size, Dimension3dComplete_.width}));
            this.d2.getElement().setNode(node.getChildNamed(new DtoField[]{StowagePositionTypeComplete_.size, Dimension3dComplete_.height}));
            this.d3.getElement().setNode(node.getChildNamed(new DtoField[]{StowagePositionTypeComplete_.size, Dimension3dComplete_.depth}));
            this.setEnabled(true);
            StowagePositionConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return StowagePositionTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                StowagePositionConfigPanel.this.code.setLocation(StowagePositionConfig.this.masterDataTable.getCellPadding(), StowagePositionConfig.this.masterDataTable.getCellPadding());
                StowagePositionConfigPanel.this.code.setSize(200, (int)StowagePositionConfigPanel.this.code.getPreferredSize().getHeight());
                StowagePositionConfigPanel.this.name.setLocation(StowagePositionConfig.this.masterDataTable.getCellPadding(), StowagePositionConfigPanel.this.code.getY() + StowagePositionConfigPanel.this.code.getHeight() + StowagePositionConfig.this.masterDataTable.getCellPadding());
                StowagePositionConfigPanel.this.name.setSize(200, (int)StowagePositionConfigPanel.this.name.getPreferredSize().getHeight());
                StowagePositionConfigPanel.this.d1.setLocation(StowagePositionConfigPanel.this.name.getX(), StowagePositionConfigPanel.this.name.getY() + StowagePositionConfigPanel.this.name.getHeight() + StowagePositionConfig.this.masterDataTable.getCellPadding());
                StowagePositionConfigPanel.this.d1.setSize(100, (int)StowagePositionConfigPanel.this.d1.getPreferredSize().getHeight());
                StowagePositionConfigPanel.this.d2.setLocation(StowagePositionConfigPanel.this.d1.getX() + StowagePositionConfigPanel.this.d1.getWidth() + StowagePositionConfig.this.masterDataTable.getCellPadding(), StowagePositionConfigPanel.this.d1.getY());
                StowagePositionConfigPanel.this.d2.setSize(100, (int)StowagePositionConfigPanel.this.d2.getPreferredSize().getHeight());
                StowagePositionConfigPanel.this.d3.setLocation(StowagePositionConfigPanel.this.d2.getX() + StowagePositionConfigPanel.this.d2.getWidth() + StowagePositionConfig.this.masterDataTable.getCellPadding(), StowagePositionConfigPanel.this.d2.getY());
                StowagePositionConfigPanel.this.d3.setSize(100, (int)StowagePositionConfigPanel.this.d3.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

