/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.TaxRateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TaxRateConfig
extends MasterDataInsert<TaxRateComplete> {
    private static final long serialVersionUID = 1L;

    public TaxRateConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public TaxRateComplete getNewObject() {
        TaxRateComplete z = new TaxRateComplete();
        z.setClientOId(Long.valueOf(ADTO.getNextId()));
        return z;
    }

    @Override
    public Class<? extends TaxRateComplete> getMasterDataClass() {
        return TaxRateComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Taxes";
    }

    @Override
    public DetailsPanel getDetails() {
        return new TaxRateConfigPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        HashSet<Integer> sequenceNumbers = new HashSet<Integer>();
        boolean codeSet = true;
        boolean nameSet = true;
        boolean descriptionSet = true;
        boolean rateSet = true;
        boolean numbersSet = true;
        while (it.hasNext()) {
            TaxRateComplete vatTax;
            Node n = (Node)it.next();
            if (n.getChildNamed(TaxRateComplete_.name).getValue() == null) {
                nameSet = false;
            }
            if (n.getChildNamed(TaxRateComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(TaxRateComplete_.rate).getValue() == null) {
                rateSet = false;
            }
            if (n.getChildNamed(TaxRateComplete_.code).getValue() == null) {
                codeSet = false;
            } else if (codes.contains(n.getChildNamed(TaxRateComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(TaxRateComplete_.code).getValue() + " is not unique."));
            } else {
                codes.add((String)n.getChildNamed(TaxRateComplete_.code).getValue());
            }
            if (n.getChildNamed(TaxRateComplete_.sequenceNumber).getValue() == null) {
                numbersSet = false;
            } else if (sequenceNumbers.contains(n.getChildNamed(TaxRateComplete_.sequenceNumber).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Sequencenumber " + n.getChildNamed(TaxRateComplete_.sequenceNumber).getValue() + " is not unique."));
            } else {
                sequenceNumbers.add((Integer)n.getChildNamed(TaxRateComplete_.sequenceNumber).getValue());
            }
            if (n.getChildNamed(TaxRateComplete_.defaultTaxVAT).getValue() == null || !(vatTax = (TaxRateComplete)n.getChildNamed(TaxRateComplete_.defaultTaxVAT).getValue()).equals(n.getValue())) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Default Tax is equals to current Tax!"));
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!nameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Names are set"));
        }
        if (!descriptionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descriptions are set"));
        }
        if (!rateSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Rates are set"));
        }
        if (!numbersSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Numbers are set"));
        }
        return a;
    }

    class TaxRateConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> description;
        private TitledItem<TextField> name;
        private TitledItem<TextField> rate;
        private TitledItem<TextField> code;
        private TitledItem<TextField> sequenceNumber;
        private TitledItem<CheckBox> isVat;
        private TitledItem<CheckBox> isAirportFee;
        private TitledItem<ComboBox> defaultVatTax;

        public TaxRateConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.description = new TitledItem<TextField>(new TextField(), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.rate = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.RATE_PERCENT, TitledItem.TitledItemOrientation.NORTH);
            this.code = new TitledItem<TextField>(new TextField(), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.isVat = new TitledItem<CheckBox>(new CheckBox(), Words.IS_VAT, TitledItem.TitledItemOrientation.EAST);
            this.isAirportFee = new TitledItem<CheckBox>(new CheckBox(), Words.IS_AIRPORT_FEE, TitledItem.TitledItemOrientation.EAST);
            this.name = new TitledItem<TextField>(new TextField(), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.sequenceNumber = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.SEQUENCE_NUMBER, TitledItem.TitledItemOrientation.NORTH);
            this.defaultVatTax = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(TaxRateConverter.class), true), "Vat Rate", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.description);
            this.add(this.name);
            this.add(this.rate);
            this.add(this.code);
            this.add(this.isVat);
            this.add(this.sequenceNumber);
            this.add(this.defaultVatTax);
            this.add(this.isAirportFee);
        }

        @Override
        public DtoField getAttributeName() {
            return TaxRateComplete_.name;
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.description.getElement().setNode(n.getChildNamed(TaxRateComplete_.description));
            this.name.getElement().setNode(n.getChildNamed(TaxRateComplete_.name));
            this.rate.getElement().setNode(n.getChildNamed(TaxRateComplete_.rate));
            this.code.getElement().setNode(n.getChildNamed(TaxRateComplete_.code));
            this.isVat.getElement().setNode(n.getChildNamed(TaxRateComplete_.isVATTaxRate));
            this.isAirportFee.getElement().setNode(n.getChildNamed(TaxRateComplete_.isAirportFee));
            this.sequenceNumber.getElement().setNode(n.getChildNamed(TaxRateComplete_.sequenceNumber));
            this.defaultVatTax.getElement().setPossibleValues(NodeToolkit.getAffixList(TaxRateComplete.class));
            this.defaultVatTax.getElement().setNode(n.getChildNamed(TaxRateComplete_.defaultTaxVAT));
            this.setEnabled(true);
            TaxRateConfig.this.setEnabled(true);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.description);
            CheckedListAdder.addToList(a, this.rate);
            CheckedListAdder.addToList(a, this.code);
            CheckedListAdder.addToList(a, this.isVat);
            CheckedListAdder.addToList(a, this.isAirportFee);
            CheckedListAdder.addToList(a, this.sequenceNumber);
            CheckedListAdder.addToList(a, this.defaultVatTax);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.description.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
            this.rate.setVisibleContainer(pane);
            this.code.setVisibleContainer(pane);
            this.isVat.setVisibleContainer(pane);
            this.isAirportFee.setVisibleContainer(pane);
            this.sequenceNumber.setVisibleContainer(pane);
            this.defaultVatTax.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.description.kill();
            this.name.kill();
            this.rate.kill();
            this.code.kill();
            this.isVat.kill();
            this.sequenceNumber.kill();
            this.defaultVatTax.kill();
            this.isAirportFee.kill();
            this.description = null;
            this.name = null;
            this.rate = null;
            this.code = null;
            this.isVat = null;
            this.sequenceNumber = null;
            this.defaultVatTax = null;
            this.isAirportFee = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.description.setEnabled(b);
            this.name.setEnabled(b);
            this.rate.setEnabled(b);
            this.code.setEnabled(b);
            this.isVat.setEnabled(b);
            this.sequenceNumber.setEnabled(b);
            this.defaultVatTax.setEnabled(b);
            this.isAirportFee.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                TaxRateConfigPanel.this.name.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.name.setSize(200, (int)TaxRateConfigPanel.this.name.getPreferredSize().getHeight());
                TaxRateConfigPanel.this.description.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfigPanel.this.name.getY() + TaxRateConfigPanel.this.name.getHeight() + TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.description.setSize(200, (int)TaxRateConfigPanel.this.description.getPreferredSize().getHeight());
                TaxRateConfigPanel.this.sequenceNumber.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfigPanel.this.description.getY() + TaxRateConfigPanel.this.description.getHeight() + TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.sequenceNumber.setSize(120, (int)TaxRateConfigPanel.this.sequenceNumber.getPreferredSize().getHeight());
                TaxRateConfigPanel.this.rate.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfigPanel.this.sequenceNumber.getY() + TaxRateConfigPanel.this.sequenceNumber.getHeight() + TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.rate.setSize(100, (int)TaxRateConfigPanel.this.rate.getPreferredSize().getHeight());
                TaxRateConfigPanel.this.code.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfigPanel.this.rate.getY() + TaxRateConfigPanel.this.rate.getHeight() + TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.code.setSize(100, (int)TaxRateConfigPanel.this.code.getPreferredSize().getHeight());
                TaxRateConfigPanel.this.isVat.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfigPanel.this.code.getY() + TaxRateConfigPanel.this.code.getHeight() + TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.isVat.setSize(parent.getWidth() - 2 * TaxRateConfig.this.masterDataTable.getCellPadding(), (int)TaxRateConfigPanel.this.isVat.getPreferredSize().getHeight());
                TaxRateConfigPanel.this.isAirportFee.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfigPanel.this.isVat.getY() + TaxRateConfigPanel.this.isVat.getHeight() + TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.isAirportFee.setSize(parent.getWidth() - 2 * TaxRateConfig.this.masterDataTable.getCellPadding(), (int)TaxRateConfigPanel.this.isVat.getPreferredSize().getHeight());
                TaxRateConfigPanel.this.defaultVatTax.setLocation(TaxRateConfig.this.masterDataTable.getCellPadding(), TaxRateConfigPanel.this.isAirportFee.getY() + TaxRateConfigPanel.this.isAirportFee.getHeight() + TaxRateConfig.this.masterDataTable.getCellPadding());
                TaxRateConfigPanel.this.defaultVatTax.setSize(100, (int)TaxRateConfigPanel.this.defaultVatTax.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

