/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DTODataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class UnitSystemConfig
extends DTODataInsert<UnitSystemComplete> {
    private static final long serialVersionUID = 1L;

    public UnitSystemConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public void insertElements() {
    }

    @Override
    public DetailsPanel getDetails() {
        return new UnitSystemConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Unit System";
    }

    @Override
    public UnitSystemComplete getNewObject() {
        UnitSystemComplete a = new UnitSystemComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends UnitSystemComplete> getMasterDataClass() {
        return UnitSystemComplete.class;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(UnitSystemComplete.class);
            }

            @Override
            public RemoteLoader getInvoker() {
                return UnitSystemConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<Exception> errors = new ArrayList<Exception>();
                Iterator it = UnitSystemConfig.this.masterDataTable.getModel().getNode().getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    UnitSystemComplete us = null;
                    Node unitList = n.getChildNamed(new String[]{"unitList"});
                    if (unitList != null) {
                        UnitComplete lastUnit = null;
                        UnitComplete baseUnit = null;
                        UnitComplete maxUnit = null;
                        Iterator it2 = unitList.getChilds();
                        while (it2.hasNext()) {
                            Node un = (Node)it2.next();
                            Node uNode = un;
                            if (uNode instanceof ProxyNode) {
                                uNode = ((ProxyNode)uNode).getRefNode();
                            }
                            uNode.commitThis(UnitComplete.class);
                            UnitComplete u = (UnitComplete)uNode.getValue();
                            if (uNode.getChildNamed(new String[]{"hasSameUnitSystem"}) != null && ((Boolean)uNode.getChildNamed(new String[]{"hasSameUnitSystem"}).getValue()).booleanValue()) {
                                baseUnit = u;
                            }
                            if (lastUnit != null) {
                                lastUnit.setSubUnit(u);
                                u.setSuperUnit(lastUnit);
                            } else {
                                maxUnit = u;
                            }
                            lastUnit = u;
                        }
                        Node node = n;
                        if (n instanceof ProxyNode) {
                            node = ((ProxyNode)n).getRefNode();
                        }
                        node.commitThis(UnitSystemComplete.class);
                        us = (UnitSystemComplete)node.getValue();
                        us.setName((String)n.getChildNamed(new String[]{"name"}).getValue());
                        us.setBaseUnit((UnitComplete)n.getChildNamed(new String[]{"baseUnit"}).getValue());
                        us.setMaxUnit(maxUnit);
                        us.setBaseUnit(baseUnit);
                    } else {
                        n.commitThis(UnitSystemComplete.class);
                        us = (UnitSystemComplete)n.getValue(UnitSystemComplete.class);
                    }
                    if (us.getBaseUnit() == null) {
                        us.setBaseUnit(us.getMaxUnit());
                    }
                    UnitSystemComplete a = null;
                    try {
                        if (n.getChildNamed(new String[]{"id"}).getValue() == null) {
                            a = (UnitSystemComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).create((AMasterDataComplete)us).getValue();
                            a.getBaseUnit().setUnitSystem(a);
                            a.getMaxUnit().setUnitSystem(a);
                            a = (UnitSystemComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).update((AMasterDataComplete)a).getValue();
                            continue;
                        }
                        if (us.getIsDeleted().booleanValue() && us.getDeleteTime() == null) {
                            a = (UnitSystemComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)us).getValue();
                            continue;
                        }
                        if (!us.getIsDeleted().booleanValue() && us.getDeleteTime() != null) {
                            a = (UnitSystemComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)us).getValue();
                            continue;
                        }
                        a = (UnitSystemComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).update((AMasterDataComplete)us).getValue();
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                }
                if (!errors.isEmpty()) {
                    throw new ClientExceptionCollection("", errors);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return UnitSystemConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(new String[]{"name"}).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(new String[]{"name"}).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(new String[]{"name"}).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(new String[]{"name"}).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Names are set"));
        }
        return a;
    }

    private class UnitSystemConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private Table2 table;
        private Node currentNode;

        public UnitSystemConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), "Name", TitledItem.TitledItemOrientation.NORTH);
            this.table = new Table2(true, "Add Unit", false, false);
            this.table.setButtonHandler(new Table2ButtonHandler(){

                @Override
                public void childRemoved() {
                    UnitSystemConfig.this.revalidate();
                }

                @Override
                public void addButtonPressed(int x, int y, Button source) {
                    UnitComplete u = new UnitComplete();
                    u.setClientOId(Long.valueOf(ADTO.getNextId()));
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, false);
                    UnitSystemConfigPanel.this.table.getModel().getNode().addChild(n, 0L);
                    UnitSystemConfig.this.revalidate();
                }
            });
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo("NAME", null, null, null, "", 120, 120, 120));
            columns.add(new TableColumnInfo("CODE", null, null, null, "", 80, 80, 80));
            columns.add(new TableColumnInfo("FACTOR", null, null, null, "", 120, 120, 120));
            int tw = 2 * this.table.getCellPadding() + RadioButton.getPreferredWidth();
            columns.add(new TableColumnInfo("SHOW UNIT", null, null, null, "", tw, tw, tw));
            columns.add(new TableColumnInfo("BASE UNIT", null, null, null, "", tw, tw, tw));
            columns.add(new TableColumnInfo("RECIPE YIELD UNIT", null, null, null, "", tw, tw, tw));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            this.table.setModel(new Table2Model(columns, model -> {
                UnitComplete s = (UnitComplete)this.currentNode.getChildNamed(new String[]{"baseUnit"}).getValue();
                UnitComplete u = (UnitComplete)model.getNode().getValue();
                boolean f = false;
                if (s != null && u != null && s.equals((Object)u)) {
                    f = true;
                }
                TableRowImpl p = new TableRowImpl(model, f);
                return p;
            }));
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.table);
        }

        private Node createNode(Node node) {
            Node n = node.getChildNamed(new String[]{"unitList"});
            if (n == null) {
                n = new ViewNode("");
                n.setName("unitList");
                node.addChild(n, 0L);
            }
            for (Node unit = node.getChildNamed(new String[]{"maxUnit"}); unit != null && unit.getValue() != null; unit = unit.getChildNamed(new String[]{"subUnit"})) {
                n.addChild(unit, 0L);
            }
            return n;
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.table.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.name = null;
            this.table.kill();
            this.table = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.table.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.currentNode = node;
            this.name.getElement().setNode(node.getChildNamed(new String[]{"name"}));
            this.table.getModel().setNode(this.createNode(node));
            this.setEnabled(true);
            UnitSystemConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return UnitSystemComplete_.name;
        }

        private class TableRowImpl
        extends Table2RowPanel
        implements ButtonListener {
            private static final long serialVersionUID = 1L;
            private TextField name;
            private TextField code;
            private TextField factor;
            private RadioButton baseUnit;
            private CheckBox display;
            private CheckBox yieldUnit;

            public TableRowImpl(Table2RowModel m, boolean isBaseUnit) {
                super(m);
                this.name = new TextField(m.getNode().getChildNamed(new String[]{"name"}));
                this.code = new TextField(m.getNode().getChildNamed(new String[]{"shortName"}));
                this.factor = new NumberTextField(m.getNode().getChildNamed(new String[]{"conversionFactor"}), TextFieldType.INT);
                this.baseUnit = new RadioButton();
                this.baseUnit.addButtonListener(this);
                this.display = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new String[]{"display"}));
                this.yieldUnit = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new String[]{"recipeYieldUnit"}));
                Node n = m.getNode().getChildNamed(new String[]{"hasSameUnitSystem"});
                if (n == null) {
                    n = new Node();
                    n.setName("hasSameUnitSystem");
                    m.getNode().addChild(n, 0L);
                }
                n.setValue((Object)isBaseUnit, 0L);
                this.baseUnit.setChecked(isBaseUnit);
                this.setLayout(new Layout());
                this.add(this.name);
                this.add(this.code);
                this.add(this.factor);
                this.add(this.baseUnit);
                this.add(this.display);
                this.add(this.yieldUnit);
            }

            @Override
            public List<Component> getFocusComponents() {
                List<Component> a = this.name.getFocusComponents();
                a.addAll(this.code.getFocusComponents());
                a.addAll(this.factor.getFocusComponents());
                a.addAll(this.display.getFocusComponents());
                a.addAll(this.baseUnit.getFocusComponents());
                a.addAll(this.yieldUnit.getFocusComponents());
                return a;
            }

            private void writeBaseUnit(boolean b) {
                this.model.getNode().getChildNamed(new String[]{"hasSameUnitSystem"}).setValue((Object)b, 0L);
            }

            @Override
            public Object getObject4Column(int column) {
                switch (column) {
                    case 0: {
                        return this.model.getNode().getChildNamed(new String[]{"name"}).getValue();
                    }
                    case 1: {
                        return this.model.getNode().getChildNamed(new String[]{"code"}).getValue();
                    }
                    case 2: {
                        return this.model.getNode().getChildNamed(new String[]{"factor"}).getValue();
                    }
                }
                return null;
            }

            @Override
            public void setEnabled(boolean isEnabled) {
                boolean b = isEnabled;
                b = UnitSystemConfigPanel.this.isNodeSet() ? isEnabled : false;
                super.setEnabled(b);
                this.name.setEnabled(b);
                this.code.setEnabled(b);
                this.factor.setEnabled(b);
                this.baseUnit.setEnabled(b);
                this.display.setEnabled(b);
                this.yieldUnit.setEnabled(b);
            }

            @Override
            public void kill() {
                if (this.isKilled()) {
                    return;
                }
                super.kill();
                this.name.kill();
                this.code.kill();
                this.factor.kill();
                this.baseUnit.kill();
                this.display.kill();
                this.yieldUnit.kill();
                this.name = null;
                this.code = null;
                this.factor = null;
                this.baseUnit = null;
                this.display = null;
                this.yieldUnit = null;
            }

            @Override
            public void buttonPressed(Button source, int x, int y) {
                for (Table2RowPanel p : UnitSystemConfigPanel.this.table.getRows()) {
                    TableRowImpl pp = (TableRowImpl)p;
                    if (pp.equals(this)) {
                        pp.writeBaseUnit(true);
                        continue;
                    }
                    pp.writeBaseUnit(false);
                }
            }

            private class Layout
            extends DefaultLayout {
                private Layout() {
                }

                @Override
                public void layoutContainer(Container parent) {
                    int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                    int currentX = 0;
                    TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    TableRowImpl.this.code.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.code.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.code.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.code.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.factor.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.factor.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.factor.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.factor.getPreferredSize().getHeight()) / 2.0));
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.display.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.display.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.display.setSize(TableRowImpl.this.display.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    TableRowImpl.this.baseUnit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.baseUnit.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.baseUnit.setSize(TableRowImpl.this.baseUnit.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                    TableRowImpl.this.yieldUnit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.yieldUnit.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.yieldUnit.setSize(TableRowImpl.this.yieldUnit.getPreferredSize());
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
                }
            }
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                UnitSystemConfigPanel.this.name.setLocation(UnitSystemConfig.this.masterDataTable.getCellPadding(), UnitSystemConfig.this.masterDataTable.getCellPadding());
                UnitSystemConfigPanel.this.name.setSize(200, (int)UnitSystemConfigPanel.this.name.getPreferredSize().getHeight());
                UnitSystemConfigPanel.this.table.setLocation(0, UnitSystemConfigPanel.this.name.getY() + UnitSystemConfigPanel.this.name.getHeight() + 10);
                UnitSystemConfigPanel.this.table.setSize(parent.getWidth(), parent.getHeight() - UnitSystemConfigPanel.this.table.getY());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

