/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispocalculation;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.DispositionServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MatDispoCalculationStateE;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationLight;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;

public class MatDispoCalculationModuleDataHandler
extends DefaultDataHandler<MaterialDispositionCalculationReference, MaterialDispositionCalculationComplete> {
    public MatDispoCalculationModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<MaterialDispositionCalculationReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MaterialDispositionCalculationComplete d = (MaterialDispositionCalculationComplete)node.getValue(MaterialDispositionCalculationComplete.class);
                MaterialDispositionCalculationComplete dto = (MaterialDispositionCalculationComplete)((DispositionServiceManager)ServiceManagerRegistry.getService(DispositionServiceManager.class)).updateMatDispo(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<MaterialDispositionCalculationComplete> createEmptyNode() {
        MaterialDispositionCalculationComplete d = new MaterialDispositionCalculationComplete();
        d.setProductDueDate(new Date(System.currentTimeMillis()));
        d.setPeriod(new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())));
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        d.setMatDispoState(MatDispoCalculationStateE.DRAFT);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<MaterialDispositionCalculationComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MaterialDispositionCalculationComplete d = (MaterialDispositionCalculationComplete)node.getValue(MaterialDispositionCalculationComplete.class);
                MaterialDispositionCalculationComplete dto = (MaterialDispositionCalculationComplete)((DispositionServiceManager)ServiceManagerRegistry.getService(DispositionServiceManager.class)).createMatDispo(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MatDispoCalculationModuleDataHandler.this.setCurrentLoadMaximum(2);
                MatDispoCalculationModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                MatDispoCalculationModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return MatDispoCalculationModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MaterialDispositionCalculationLight air = (MaterialDispositionCalculationLight)node.getValue(MaterialDispositionCalculationLight.class);
                MaterialDispositionCalculationComplete nair = (MaterialDispositionCalculationComplete)((DispositionServiceManager)ServiceManagerRegistry.getService(DispositionServiceManager.class)).getMatDispo(new MaterialDispositionCalculationReference(air.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)nair, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<MaterialDispositionCalculationComplete> resetData(Node<MaterialDispositionCalculationComplete> node) {
        MaterialDispositionCalculationComplete n = new MaterialDispositionCalculationComplete();
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<MaterialDispositionCalculationComplete> getCommittingClass() {
        return MaterialDispositionCalculationComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<MaterialDispositionCalculationReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

