/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispocalculation.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationLight;
import ch.icit.pegasus.server.core.dtos.matdispo.ProductForMatDispoCountComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.ProductForMatDispoCountComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ProductDetailsPanel
extends TableDetailsPanel<MaterialDispositionCalculationLight> {
    public ProductDetailsPanel(RowEditor<MaterialDispositionCalculationLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.PRODUCTS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 0, Integer.MAX_VALUE, 80));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 90, 90, 90));
        int tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setTitleText(Words.PRODUCTS);
        table.setUseWriteAccessRight(true);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ProductForMatDispoCountComplete product = new ProductForMatDispoCountComplete();
        product.setClientOId(Long.valueOf(ADTO.getNextId()));
        product.setAmount(Integer.valueOf(0));
        Node dto = INodeCreator.getDefaultImpl().getNode4DTO((Object)product, true, false);
        this.getTable().getModel().getNode().addChild(dto, 0L);
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.productForMatDispoCount));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<ProductComplete> productSearch;
        private TextField count;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.productSearch = SearchTextField2Factory.getProductSearchField(false, m.getNode().getChildNamed(ProductForMatDispoCountComplete_.product));
            this.count = new TextField(m.getNode().getChildNamed(ProductForMatDispoCountComplete_.amount), TextFieldType.INT);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.productSearch);
            this.add(this.count);
            this.add(this.delete);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.productSearch.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.productSearch.kill();
            this.count.kill();
            this.delete.kill();
            this.productSearch = null;
            this.count = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.productSearch);
            CheckedListAdder.addToList(focusList, this.count);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{ProductForMatDispoCountComplete_.product, ProductComplete_.number}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.productSearch.setEnabled(isEnabled);
            this.count.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                ProductDetailsPanel.this.table.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.productSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

