/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispocalculation.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiHaulTypeComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<MaterialDispositionCalculationLight> {
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledItem<RDSearchTextField2<CustomerLight>> customer;
    private TitledDateTimePeriodChooser period;
    private RDCheckBox useHaulType;
    private TitledItem<RDMultiHaulTypeComboBox> haulType;
    private TitledItem<RDCheckBox> excludeCancelled;
    private boolean canEditHaulType = false;

    public SpecificationDetailsPanel(RowEditor<MaterialDispositionCalculationLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.canEditHaulType = provider.isWritable(MaterialDispositionCalculationComplete_.haulTypes);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.customer = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER, true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.period = new TitledDateTimePeriodChooser();
        this.useHaulType = new RDCheckBox(provider);
        this.useHaulType.addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.haulType = new TitledItem<RDMultiHaulTypeComboBox>(new RDMultiHaulTypeComboBox(provider), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.excludeCancelled = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.EXCLUDE_CANCELED_FLIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.setCustomLayouter(new Layout());
        this.addToView(this.useHaulType);
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.customer);
        this.addToView(this.period);
        this.addToView(this.haulType);
        this.addToView(this.excludeCancelled);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.customer.setEnabled(isEnabled);
        this.period.setEnabled(isEnabled);
        this.haulType.setEnabled(isEnabled && this.useHaulType.isChecked());
        this.excludeCancelled.setEnabled(isEnabled);
        this.useHaulType.setEnabled(isEnabled && this.canEditHaulType);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.number.getElement().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.number));
        this.name.getElement().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.name));
        this.customer.getElement().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.customer));
        this.period.setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.period));
        this.haulType.getElement().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.haulTypes));
        this.excludeCancelled.getElement().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.excludeCanceledFlights));
        this.useHaulType.setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.useHaulType));
    }

    @Override
    public void kill() {
        if (!this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.name.kill();
        this.customer.kill();
        this.period.kill();
        this.haulType.kill();
        this.excludeCancelled.kill();
        this.useHaulType.kill();
        this.number = null;
        this.name = null;
        this.customer = null;
        this.period = null;
        this.haulType = null;
        this.excludeCancelled = null;
        this.useHaulType = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.useHaulType);
        CheckedListAdder.addToList(focusList, this.haulType);
        CheckedListAdder.addToList(focusList, this.excludeCancelled);
        return focusList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.haulType.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.excludeCancelled.getPreferredSize().getHeight());
            return new Dimension(105, h += SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int w4tl = (w - (2 * SpecificationDetailsPanel.this.horizontalBorder + 3 * (SpecificationDetailsPanel.this.horizontalBorder * 2))) / 4;
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(w4tl, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(w - (2 * SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.inner_horizontalBorder + w4tl), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.period.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.period.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.period.getY() + SpecificationDetailsPanel.this.period.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.haulType.setLocation((int)((double)SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.useHaulType.getPreferredSize().getWidth()), SpecificationDetailsPanel.this.customer.getY() + SpecificationDetailsPanel.this.customer.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.haulType.setSize((int)((double)parent.getWidth() - ((double)(2 * SpecificationDetailsPanel.this.horizontalBorder) + SpecificationDetailsPanel.this.useHaulType.getPreferredSize().getWidth())), (int)SpecificationDetailsPanel.this.haulType.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.useHaulType.setLocation(SpecificationDetailsPanel.this.horizontalBorder, (int)((double)(SpecificationDetailsPanel.this.haulType.getY() + SpecificationDetailsPanel.this.haulType.getHeight()) - (SpecificationDetailsPanel.this.useHaulType.getPreferredSize().getHeight() + 3.0)));
            SpecificationDetailsPanel.this.useHaulType.setSize(SpecificationDetailsPanel.this.useHaulType.getPreferredSize());
            SpecificationDetailsPanel.this.excludeCancelled.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.haulType.getY() + SpecificationDetailsPanel.this.haulType.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.excludeCancelled.setSize(SpecificationDetailsPanel.this.excludeCancelled.getPreferredSize());
        }
    }
}

