/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product;

import ch.icit.pegasus.client.gui.modules.product.ProductModule;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AircraftTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AllergenCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxMealTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductCommissionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductGroupTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SeasonComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LabelTagComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.solar.SolarCompanySettingsComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.utils.ProductStateToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ProductModuleDataHandler
extends DefaultDataHandler<ProductReference, ProductComplete> {
    private static Map<ProductVariantComplete, ModificationStateE> stateMap = new HashMap<ProductVariantComplete, ModificationStateE>();

    public ProductModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataAfterClosing(final Node<?> node, final RemoteLoader listener, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductComplete f = (ProductComplete)node.getValue();
                ProductModule pm = (ProductModule)ProductModuleDataHandler.this.tableView;
                ProductSearchConfiguration configuration = (ProductSearchConfiguration)pm.getSearchParameters(null, null, false, false, null);
                Node productNode = node;
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)configuration);
                for (ProductComplete fl : r.getResults()) {
                    if (fl.getId() == null || f.getId() == null) continue;
                    if (fl.getId().equals(f.getId())) {
                        productNode.removeExistingValues();
                        productNode.setValue((Object)fl, 0L);
                        productNode.updateNode();
                        return node;
                    }
                    if (f.getClientOId() == null || fl.getClientOId() == null || !f.getClientOId().equals(fl.getClientOId())) continue;
                    productNode.removeExistingValues();
                    productNode.setValue((Object)fl, 0L);
                    productNode.updateNode();
                }
                if (r.getResults().size() == 1) {
                    productNode.removeExistingValues();
                    productNode.setValue(r.getSingleResult(), 0L);
                    productNode.updateNode();
                }
                return productNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return super.reloadDataAfterClosing(node, listener, progressListener);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, "Refresh Product");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductModule pm = (ProductModule)ProductModuleDataHandler.this.tableView;
                ProductSearchConfiguration configuration = (ProductSearchConfiguration)pm.getSearchParameters(null, null, false, false, null);
                ProductComplete pc = (ProductComplete)node.getValue(ProductComplete.class);
                ProductComplete npc = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProduct(new ProductReference(pc.getId()), configuration).getValue();
                node.removeExistingValues();
                node.setValue((Object)npc, 0L);
                node.updateNode();
                List l = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariants(new ListWrapper(npc.getVariants()), configuration).getList();
                ProductVariantComplete pvc = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariant((ProductVariantReference)npc.getCurrentVariant(), configuration).getValue();
                pvc.setProduct(npc);
                if (stateMap.get(pvc) != null) {
                    stateMap.remove(pvc);
                }
                stateMap.put(pvc, pvc.getState());
                node.disableEvents();
                node.getChildNamed(ProductComplete_.currentVariant).disableEvents();
                node.getChildNamed(ProductComplete_.currentVariant).removeExistingValues();
                node.getChildNamed(ProductComplete_.currentVariant).removeChildsPermanent();
                node.getChildNamed(ProductComplete_.currentVariant).setValue((Object)pvc, 0L);
                node.getChildNamed(ProductComplete_.currentVariant).updateNode();
                node.getChildNamed(ProductComplete_.currentVariant).enableEvents();
                node.getChildNamed(ProductComplete_.variants).disableEvents();
                node.getChildNamed(ProductComplete_.variants).removeExistingValues();
                node.getChildNamed(ProductComplete_.variants).setValue((Object)l, 0L);
                node.getChildNamed(ProductComplete_.variants).updateNode();
                node.getChildNamed(ProductComplete_.variants).enableEvents();
                node.enableEvents();
                Node n = node;
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public boolean createGroup(final Node<ProductVariantReference> aNode, final RemoteLoader listener, final ProgressListener pListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductModuleDataHandler.this.showMessage(pListener, Words.LOAD_DATA);
                Node newNode = aNode;
                ProductVariantReference pr = (ProductVariantReference)aNode.getValue(ProductVariantReference.class);
                if (pr.getId() != null) {
                    ProductVariantComplete pc = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(new ProductVariantReference(pr.getId())).getValue();
                    stateMap.remove(pc);
                    stateMap.put(pc, pc.getState());
                    aNode.removeExistingValues();
                    aNode.setValue((Object)pc, 0L);
                    Node g = ProductModuleDataHandler.this.createGroupView(aNode);
                    return g;
                }
                return aNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    private Node createGroupView(Node node) throws ClientServerCallException {
        ViewNode nn = new ViewNode("");
        Node n = node;
        if (n.getValue(ProductVariantComplete.class) == null) {
            ProductVariantReference r = (ProductVariantReference)n.getValue();
            ProductVariantComplete nv = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(new ProductVariantReference(r.getId())).getValue();
            n.setValue((Object)nv, 0L);
        }
        if (n.getValue(ComplexProductVariantComplete.class) != null) {
            Iterator it2 = n.getChildNamed(ComplexProductVariantComplete_.productComponentGroups).getChilds();
            while (it2.hasNext()) {
                Node nnn = (Node)it2.next();
                nn.addChild(nnn, 0L);
            }
        }
        return nn;
    }

    public boolean reloadVariant(final Node<ProductVariantReference> aNode, final RemoteLoader listener, final ProgressListener pListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductModuleDataHandler.this.showMessage(pListener, Words.LOAD_DATA);
                Node newNode = aNode;
                ProductVariantReference pr = (ProductVariantReference)aNode.getValue(ProductVariantReference.class);
                if (pr.getId() != null) {
                    ProductVariantComplete pc = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(new ProductVariantReference(pr.getId())).getValue();
                    stateMap.remove(pc);
                    stateMap.put(pc, pc.getState());
                    aNode.removeExistingValues();
                    aNode.setValue((Object)pc, 0L);
                }
                return aNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public void reloadDataNow(final Node<ADTO> node, final RemoteLoader listener) {
        if (!(node.getValue() instanceof BasicArticleComplete) && node.getValue() instanceof BasicArticleLight) {
            new BasicArticleLoader((BasicArticleReference)node.getValue(BasicArticleLight.class), listener, node, this);
        } else if (!(node.getValue() instanceof RecipeComplete) && node.getValue() instanceof RecipeVariantLight) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    RecipeVariantComplete rc = (RecipeVariantComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant((RecipeVariantReference)((RecipeVariantLight)node.getValue())).getValue();
                    if (rc.getRecipe() == null && rc.getRecipeId() != null) {
                        RecipeComplete base = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipe(new RecipeReference(rc.getRecipeId())).getValue();
                        rc.setRecipe(base);
                    }
                    node.setValue((Object)rc, 0L);
                    node.updateNode();
                    return node;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return listener;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            listener.remoteObjectLoaded(node);
        }
    }

    private void ensureComponents(ProductVariantComplete product, RecipeVariantAccessor accessor) throws Exception {
        if (product instanceof ComplexProductVariantComplete) {
            ComplexProductVariantComplete p = (ComplexProductVariantComplete)product;
            if (p.getProductComponentGroups() == null) {
                return;
            }
            for (SimpleProductComponentGroupComplete group : p.getProductComponentGroups()) {
                if (group.getUseImage().booleanValue()) {
                    if (group.getImage() != null) {
                        if (group.getImage().getId() == null) {
                            group.getImage().setCategory(FileCategoryE.PICTURE);
                            try {
                                PegasusFileComplete r = FileTransferUtil.upload((PegasusFileComplete)group.getImage(), (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                                    public void statusChanged(File file, FileTransferState state) {
                                    }

                                    public void exceptionOccurred(Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }});
                                group.setImage(r);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        group.setUseImage(Boolean.valueOf(false));
                    }
                } else {
                    group.setImage(null);
                }
                boolean wasRemoving = false;
                Iterator it2 = group.getComponents().iterator();
                while (it2.hasNext()) {
                    ProductComponentComplete pcc = (ProductComponentComplete)it2.next();
                    if (pcc instanceof SimpleComponentComplete) {
                        SimpleComponentComplete scc = (SimpleComponentComplete)pcc;
                        if (scc.getArticle() == null) {
                            it2.remove();
                            wasRemoving = true;
                            continue;
                        }
                        if (scc.getNettoQuantity() == null && scc.getQuantity() != null) {
                            scc.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation((QuantityInterpolationComplete)scc.getQuantity()));
                        }
                        if (scc.getQuantity() != null || scc.getNettoQuantity() == null) continue;
                        scc.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation((QuantityInterpolationComplete)scc.getNettoQuantity()));
                        continue;
                    }
                    if (!(pcc instanceof CompoundComponentComplete)) continue;
                    if (((CompoundComponentComplete)pcc).getUnderlyingRecipe() == null) {
                        it2.remove();
                        wasRemoving = true;
                        continue;
                    }
                    if (pcc.getNettoQuantity() == null && pcc.getQuantity() != null) {
                        pcc.setNettoQuantity(CopyTemplateToolkit.copyQuantityInterpolation((QuantityInterpolationComplete)pcc.getQuantity()));
                    }
                    if (pcc.getQuantity() != null || pcc.getNettoQuantity() == null) continue;
                    pcc.setQuantity(CopyTemplateToolkit.copyQuantityInterpolation((QuantityInterpolationComplete)pcc.getNettoQuantity()));
                }
                if (!wasRemoving) continue;
                it2 = group.getComponents().iterator();
                int count = 1;
                while (it2.hasNext()) {
                    ProductComponentComplete pcc = (ProductComponentComplete)it2.next();
                    pcc.setNumber(Integer.valueOf(count));
                    ++count;
                }
            }
        } else {
            SimpleProductVariantComplete p = (SimpleProductVariantComplete)product;
            p.getComponent().setQuantity(CopyTemplateToolkit.copyQuantityInterpolation((QuantityInterpolationComplete)p.getComponent().getNettoQuantity()));
        }
    }

    @Override
    public void updateData(final Node<ProductReference> node, final RemoteLoader model, final ProgressListener list) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductModuleDataHandler.this.showMessage(list, Words.SAVE_DATA);
                ProductComplete dto = (ProductComplete)node.getValue(ProductComplete.class);
                Node newNode = node;
                ArrayList<ProductVariantComplete> cl = new ArrayList<ProductVariantComplete>();
                ArrayList<ProductVariantLight> ll = new ArrayList<ProductVariantLight>();
                ArrayList<Object> allVariants = new ArrayList<Object>();
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Iterator it = node.getChildNamed(ProductComplete_.variants).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue(ProductVariantComplete.class) != null) {
                        n.getChildNamed(ProductVariantComplete_.product).setValue((Object)dto, 0L);
                        ProductVariantComplete vc = (ProductVariantComplete)n.getValue(ProductVariantComplete.class);
                        n.removeExistingValues();
                        n.setValue((Object)vc, 0L);
                        if (n.getValue(ProductVariantComplete.class) instanceof ComplexProductVariantComplete) {
                            n.commitThis(ComplexProductVariantComplete.class);
                        } else {
                            n.commitThis(SimpleProductVariantComplete.class);
                        }
                        ProductVariantComplete c = (ProductVariantComplete)n.getValue(ProductVariantComplete.class);
                        if (c.getImageReference() != null && c.getImageReference().getUri() == null) {
                            c.setImageReference(null);
                        }
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        if (c.getSalesPrice() == null) {
                            c.setSalesPrice(new PriceComplete(s.getCurrency(), Double.valueOf(0.0)));
                        }
                        if (c.getMaterialPrice().getCurrency() == null) {
                            c.getMaterialPrice().setCurrency(s.getCurrency());
                        }
                        c.setProduct(dto);
                        cl.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    if (n.getValue(ProductVariantLight.class) != null) {
                        n.getChildNamed(ProductVariantLight_.product).setValue((Object)dto, 0L);
                        ProductVariantLight c = (ProductVariantLight)n.getValue(ProductVariantLight.class);
                        n.removeExistingValues();
                        n.setValue((Object)c, 0L);
                        n.commitThis(ProductVariantLight.class);
                        c = (ProductVariantLight)n.getValue(ProductVariantLight.class);
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        if (c.getSalesPrice() == null) {
                            c.setSalesPrice(new PriceComplete(s.getCurrency(), Double.valueOf(0.0)));
                        }
                        c.setProduct(dto);
                        ll.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    allVariants.add((ProductVariantReference)n.getValue());
                }
                Hashtable<Class, Class> t = new Hashtable<Class, Class>();
                t.put(ProductVariantLight.class, ProductVariantComplete.class);
                t.put(ProductVariantReference.class, ProductVariantLight.class);
                node.commit(ProductComplete.class, t);
                ProductComplete l = dto = (ProductComplete)node.getValue(ProductComplete.class);
                l.setVariants(allVariants);
                for (ProductVariantReference r : l.getVariants()) {
                    Node vn = INodeCreator.getDefaultImpl().getNode4DTO((Object)r, true, false);
                    ProductVariantComplete vv = (ProductVariantComplete)vn.getValue(ProductVariantComplete.class);
                    if (vv == null) continue;
                    ModificationStateE oldState = (ModificationStateE)stateMap.get(vv);
                    if (oldState == null) {
                        oldState = vv.getState();
                    }
                    RecipeVariantAccessorImpl accessor = new RecipeVariantAccessorImpl();
                    for (ProductVariantComplete c : cl) {
                        Timestamp ts = new Timestamp(c.getValidityPeriod().getStartDate().getTime());
                        if (!c.equals((Object)vv)) continue;
                        if (c != null && oldState != c.getState()) {
                            ProductStateToolkit.updateProductState((ProductVariantComplete)c, (ModificationStateE)c.getState(), (ModificationStateE)vv.getState(), (Timestamp)ts, (RecipeVariantAccessor)accessor);
                        }
                        ProductModuleDataHandler.this.ensureComponents(c, accessor);
                    }
                }
                if (!cl.isEmpty()) {
                    dto.setCurrentVariant((ProductVariantLight)cl.get(0));
                } else if (!ll.isEmpty()) {
                    dto.setCurrentVariant((ProductVariantLight)ll.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                ProductModule pm = (ProductModule)ProductModuleDataHandler.this.tableView;
                ProductSearchConfiguration configuration = (ProductSearchConfiguration)pm.getSearchParameters(null, null, false, false, null);
                ProductComplete newDTO = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateProductWithConfig(dto, configuration).getValue();
                if (newDTO == null) {
                    newDTO = dto;
                    Iterator it2 = newDTO.getVariants().iterator();
                    while (it2.hasNext()) {
                        ProductVariantReference r = (ProductVariantReference)it2.next();
                        if (r.getId() != null) continue;
                        it2.remove();
                    }
                }
                if (newDTO.getCurrentVariant() == null && newDTO.getVariants() != null && newDTO.getVariants().size() > 0) {
                    newDTO.setCurrentVariant((ProductVariantLight)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference((ProductVariantReference)newDTO.getVariants().get(0)).getValue());
                }
                if (newDTO != null) {
                    newNode.getChildNamed(ProductComplete_.variants).removeAllChilds();
                    newNode.removeExistingValues();
                    newNode.setValue((Object)newDTO, 0L);
                    newNode.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<ProductComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductComplete dto = (ProductComplete)node.getValue(ProductComplete.class);
                Node nn = node;
                ArrayList<ProductVariantComplete> cl = new ArrayList<ProductVariantComplete>();
                ArrayList<ProductVariantLight> ll = new ArrayList<ProductVariantLight>();
                RecipeVariantAccessorImpl accessor = new RecipeVariantAccessorImpl();
                Iterator it = node.getChildNamed(ProductComplete_.variants).getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue(ProductVariantComplete.class) != null) {
                        ProductVariantComplete c = (ProductVariantComplete)n.getValue(ProductVariantComplete.class);
                        Timestamp ts = new Timestamp(c.getValidityPeriod().getStartDate().getTime());
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        ProductModuleDataHandler.this.ensureComponents(c, accessor);
                        ProductStateToolkit.updateProductState((ProductVariantComplete)c, (ModificationStateE)c.getState(), (ModificationStateE)ModificationStateE.DRAFT, (Timestamp)ts, (RecipeVariantAccessor)accessor);
                        c.setProduct(dto);
                        cl.add(c);
                        continue;
                    }
                    if (n.getValue(ProductVariantLight.class) == null) continue;
                    ProductVariantLight l = (ProductVariantLight)n.getValue(ProductVariantLight.class);
                    if (l.getState() == null) {
                        l.setState(ModificationStateE.DRAFT);
                    }
                    l.setProduct(dto);
                    ll.add(l);
                }
                Hashtable<Class<ProductVariantLight>, Class<ProductVariantComplete>> t = new Hashtable<Class<ProductVariantLight>, Class<ProductVariantComplete>>();
                t.put(ProductVariantLight.class, ProductVariantComplete.class);
                node.commit(ProductComplete.class, t);
                PeriodComplete pTime = dto.getPeriod();
                ProductModuleDataHandler.this.ensurePeriodMatching(pTime, cl, ll, true);
                if (!ll.isEmpty()) {
                    dto.setCurrentVariant((ProductVariantLight)ll.get(0));
                } else if (!cl.isEmpty()) {
                    dto.setCurrentVariant((ProductVariantLight)cl.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                dto = (ProductComplete)node.getValue();
                for (ProductVariantReference r : dto.getVariants()) {
                    if (!(r instanceof ProductVariantLight)) continue;
                    ((ProductVariantLight)r).setProduct(dto);
                }
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                ProductComplete newDTO = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createProduct(dto).getValue();
                Iterator it2 = newDTO.getVariants().iterator();
                while (it2.hasNext()) {
                    ProductVariantReference r = (ProductVariantReference)it2.next();
                    if (r.getId() != null) continue;
                    it2.remove();
                }
                if (newDTO.getCurrentVariant() == null) {
                    newDTO.setCurrentVariant((ProductVariantLight)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference((ProductVariantReference)newDTO.getVariants().get(0)).getValue());
                }
                if (newDTO != null) {
                    Node n = node;
                    node.getChildNamed(ProductComplete_.variants).removeAllChilds();
                    node.removeExistingValues();
                    node.setValue((Object)newDTO, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensurePeriodMatching(PeriodComplete pTime, List<ProductVariantComplete> cl, List<ProductVariantLight> ll, boolean b) {
        ArrayList<ProductVariantLight> tenders = new ArrayList<ProductVariantLight>();
        ArrayList<ProductVariantLight> productives = new ArrayList<ProductVariantLight>();
        for (ProductVariantComplete variantComplete : cl) {
            if (Boolean.TRUE.equals(variantComplete.getTenderVariant())) {
                tenders.add((ProductVariantLight)variantComplete);
                continue;
            }
            productives.add((ProductVariantLight)variantComplete);
        }
        for (ProductVariantLight variantLight : ll) {
            if (Boolean.TRUE.equals(variantLight.getTenderVariant())) {
                tenders.add(variantLight);
                continue;
            }
            productives.add(variantLight);
        }
        this.sortProductList(pTime, tenders);
        this.sortProductList(pTime, productives);
    }

    private void sortProductList(PeriodComplete pTime, List<ProductVariantLight> l) {
        if (l.size() == 1) {
            ProductVariantLight productVariantLight = l.get(0);
            productVariantLight.getValidityPeriod().setStartDate(new Date(pTime.getStartDate().getTime()));
            productVariantLight.getValidityPeriod().setEndDate(new Date(pTime.getEndDate().getTime()));
        }
    }

    @Override
    public Node<ProductComplete> createEmptyNode() {
        ProductComplete p = new ProductComplete();
        p.setShowOnKitchenSheet(Boolean.valueOf(true));
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setPeriod(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        ComplexProductVariantComplete aProduct = new ComplexProductVariantComplete();
        aProduct.setClientOId(Long.valueOf(ADTO.getNextId()));
        aProduct.setAdditional(Boolean.valueOf(true));
        aProduct.setFixedPrice(Boolean.valueOf(true));
        aProduct.setTakeKonterProbe(Boolean.valueOf(true));
        aProduct.setValidityPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), CalendarUtil.getInfinityDate()));
        aProduct.setState(ModificationStateE.DRAFT);
        aProduct.setProduct(p);
        boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        if (isSolarCompany) {
            SolarCompanySettingsComplete solarSettings = (SolarCompanySettingsComplete)NodeToolkit.getAffixClass(SolarCompanySettingsComplete.class).getValue();
            p.setCustomer(solarSettings.getSolarCustomer());
            SimpleProductComponentGroupComplete group = new SimpleProductComponentGroupComplete();
            group.setClientOId(Long.valueOf(ADTO.getNextId()));
            aProduct.getProductComponentGroups().add(group);
        }
        PriceComplete pr = new PriceComplete();
        pr.setPrice(Double.valueOf(0.0));
        aProduct.setSalesPrice(pr);
        PriceComplete mp = new PriceComplete();
        pr.setPrice(Double.valueOf(0.0));
        aProduct.setMaterialPrice(mp);
        p.getVariants().add(aProduct);
        p.setCurrentVariant((ProductVariantLight)aProduct);
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        if (settings != null && settings.getValue() != null) {
            pr.setCurrency(((SystemSettingsComplete)settings.getValue()).getCurrency());
            mp.setCurrency(pr.getCurrency());
            aProduct.setCategory((ProductCategoryLight)((SystemSettingsComplete)settings.getValue()).getDefaultProductCategory());
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        n.getChildNamed(ProductComplete_.variants);
        return n;
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener listener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public long getID() {
                return id;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductModuleDataHandler.this.model;
            }

            @Override
            public Node<?> loadData() throws Exception {
                ProductModuleDataHandler.this.setCurrentLoadMaximum(31);
                boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
                if (isSolarCompany) {
                    SolarCompanySettingsComplete value = (SolarCompanySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSolarCompanySettings().getValue();
                    Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
                    node4DTO.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(value.getClass()));
                    NodeToolkit.addAffix((Node)node4DTO);
                }
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ProductModuleDataHandler.this.showNextMessage(listener);
                UnitToolkit.loadUnits();
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CateringServiceTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SeasonComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AircraftTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategoriesCached();
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SalesPriceFactorComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(GalleyEquipmentInsertTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                StaticEnumServiceManager.getAllModificationStates();
                ProductModuleDataHandler.this.showNextMessage(listener);
                StaticEnumServiceManager.getAllReturnCountTypes();
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AllergenCharacteristicComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                ProductModuleDataHandler.this.showNextMessage(listener);
                UnitToolkit.loadUnits();
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(MealTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AlaCarteMenuTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(DiscountTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ProductTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PaxMealTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxZoneComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(MealTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ProductCommissionComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionSettingsCached();
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ProductCategoryComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ProductGroupTypeComplete.class);
                ProductModuleDataHandler.this.showNextMessage(listener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(LabelTagComplete.class);
                return new Node();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ProductComplete> resetData(Node<ProductComplete> node) {
        ProductComplete p = new ProductComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setPeriod(new PeriodComplete());
        Date d = new Date(System.currentTimeMillis());
        Date d2 = new Date(System.currentTimeMillis());
        p.getPeriod().setStartDate(d);
        p.getPeriod().setEndDate(d2);
        ComplexProductVariantComplete aProduct = new ComplexProductVariantComplete();
        aProduct.setFixedPrice(Boolean.valueOf(false));
        aProduct.setAdditional(Boolean.valueOf(true));
        PriceComplete pr = new PriceComplete();
        pr.setPrice(Double.valueOf(0.0));
        aProduct.setSalesPrice(pr);
        PriceComplete mp = new PriceComplete();
        pr.setPrice(Double.valueOf(0.0));
        aProduct.setMaterialPrice(mp);
        p.getVariants().add(aProduct);
        p.setCurrentVariant((ProductVariantLight)aProduct);
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        if (settings != null && settings.getValue() != null) {
            pr.setCurrency(((SystemSettingsComplete)settings.getValue()).getCurrency());
            mp.setCurrency(pr.getCurrency());
            aProduct.setCategory((ProductCategoryLight)((SystemSettingsComplete)settings.getValue()).getDefaultProductCategory());
        }
        node.setValue((Object)p, System.currentTimeMillis());
        node.updateNode();
        return node;
    }

    @Override
    public Class<ProductComplete> getCommittingClass() {
        return ProductComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ProductReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

