/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.HandlingCostTable;
import ch.icit.pegasus.client.gui.modules.product.details.utils.GroupedLoader;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TotalHandlingCostConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.HandlingCostToolkit;
import ch.icit.pegasus.client.util.toolkits.PriceToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HandlingCostsDetailsPanel
extends StateDependantDetailsPanel<ProductComplete> {
    private static final long serialVersionUID = 1L;
    private HandlingCostTable table;
    private BackgroundFadeSkin bSkin;
    private ReloadablePriceView totalHandlingCosts;
    private RecipeVariantAccessor accessor = new RecipeVariantAccessorImpl();
    private CurrencyVariantAccessor currencyAccessor = new CurrencyVariantAccessorImpl();

    public HandlingCostsDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider, GroupedLoader loader) {
        super(editor, provider);
        this.setTitleText(Words.HANDLING_COSTS);
        this.table = new HandlingCostTable(provider, false, true, HandlingCostTypeE.PRODUCT){

            public Node getCustomerNode() {
                return this.node.getChildNamed(new DtoField[]{ProductVariantLight_.product, ProductComplete_.customer});
            }

            @Override
            public DtoField[] getAttributeName() {
                return new DtoField[]{ProductVariantComplete_.handlingCosts};
            }
        };
        this.setCustomLayouter(new Layout());
        this.totalHandlingCosts = new ReloadablePriceView((LoadingGroup)loader, TotalHandlingCostConverter.class);
        this.bSkin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.totalHandlingCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        this.setHandlingCostAlgorithm();
        loader.setHandlingCostPriceView(this.totalHandlingCosts);
        this.addToView(this.totalHandlingCosts);
        this.addToView(this.table);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantLight_.state;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.setNode(node);
        this.totalHandlingCosts.load(true);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.totalHandlingCosts.kill();
        this.totalHandlingCosts = null;
        this.bSkin = null;
        this.table.kill();
        this.table = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        this.bSkin.paint((Graphics2D)g, 0, this.getHeight() - this.bSkin.getImage(0).getHeight(), this.getWidth(), 11);
        this.paintOverBackgroundUnderComponents(g2);
        this.paintChildren(g2);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        this.totalHandlingCosts.setEnabled(enabled);
        if (isEnabled) {
            if (isDraft) {
                this.table.setEnabled(isEnabled);
            } else {
                this.table.setEnabled(isEnabled);
                this.table.getTable().setEditable(isDraft);
            }
        } else {
            this.table.setEnabled(isEnabled);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getTable().getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        List<ScreenValidationObject> a = this.table.validateTable(true);
        if (!a.isEmpty()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_HANDLING_COST_JUST_ADDED_ONCE));
        }
        validationObjects.addAll(a);
        return validationObjects;
    }

    private void setHandlingCostAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                if (NodeToolkit.getAffixClass(SystemSettingsComplete.class) != null && HandlingCostsDetailsPanel.this.node != null && HandlingCostsDetailsPanel.this.isEnabled()) {
                    SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    PriceComplete price = new PriceComplete();
                    price.setCurrency(s.getCurrency());
                    price.setPrice(Double.valueOf(0.0));
                    try {
                        Node pn;
                        ProductVariantComplete variant = (ProductVariantComplete)HandlingCostsDetailsPanel.this.node.getValue(ProductVariantComplete.class);
                        if (variant == null) {
                            return;
                        }
                        Map<HandlingCostComplete, PriceComplete> list = HandlingCostToolkit.getHandlingCosts(variant, 1, new Timestamp(variant.getValidityPeriod().getStartDate().getTime()), HandlingCostsDetailsPanel.this.accessor, s, HandlingCostsDetailsPanel.this.currencyAccessor);
                        Node n = HandlingCostsDetailsPanel.this.node;
                        if (list != null && n.getValue() instanceof HandlingCostVariantComplete) {
                            for (PriceComplete p : list.values()) {
                                CurrencyVariantComplete c = (CurrencyVariantComplete)HandlingCostsDetailsPanel.this.currencyAccessor.loadData((Object)p.getCurrency(), new Timestamp(((HandlingCostVariantComplete)n.getValue()).getValidityPeriod().getStartDate().getTime()));
                                price.setPrice(Double.valueOf(price.getPrice() + p.getPrice() * c.getExchangeRate()));
                            }
                        }
                        if ((pn = HandlingCostsDetailsPanel.this.totalHandlingCosts.getNode()) == null) {
                            pn = new EmbeddedDTONode();
                            HandlingCostsDetailsPanel.this.totalHandlingCosts.setNode(pn);
                        }
                        price.setPrice(PriceToolkit.ensureDoubleFinite(price.getPrice()));
                        pn.setValue((Object)price, 0L);
                        pn.updateNode();
                        HandlingCostsDetailsPanel.this.totalHandlingCosts.updateString();
                    }
                    catch (ClientRemoteException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public boolean isAlive() {
                if (HandlingCostsDetailsPanel.this.totalHandlingCosts == null) {
                    return false;
                }
                return !HandlingCostsDetailsPanel.this.totalHandlingCosts.isKilled();
            }
        };
        this.totalHandlingCosts.setRunnable(run);
    }

    public PriceComplete getCosts() {
        if (this.totalHandlingCosts != null && this.totalHandlingCosts.getNode() != null) {
            return (PriceComplete)this.totalHandlingCosts.getNode().getValue();
        }
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            HandlingCostsDetailsPanel.this.table.setLocation(0, 0);
            HandlingCostsDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight() - HandlingCostsDetailsPanel.this.bSkin.getImage(0).getHeight());
            HandlingCostsDetailsPanel.this.totalHandlingCosts.setLocation(HandlingCostsDetailsPanel.this.table.getTable().getCellPadding(), (int)((double)(HandlingCostsDetailsPanel.this.table.getY() + HandlingCostsDetailsPanel.this.table.getHeight()) + ((double)HandlingCostsDetailsPanel.this.bSkin.getImage(0).getHeight() - HandlingCostsDetailsPanel.this.totalHandlingCosts.getPreferredSize().getHeight()) / 2.0));
            HandlingCostsDetailsPanel.this.totalHandlingCosts.setSize(parent.getWidth() - 2 * HandlingCostsDetailsPanel.this.totalHandlingCosts.getX(), (int)HandlingCostsDetailsPanel.this.totalHandlingCosts.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return HandlingCostsDetailsPanel.this.table.getPreferredSize();
        }
    }
}

