/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.ProductTypeDetailsPanel;
import ch.icit.pegasus.client.gui.modules.product.details.utils.GroupedLoader;
import ch.icit.pegasus.client.gui.modules.product.details.utils.InternalExternalCateringCostTable;
import ch.icit.pegasus.client.gui.modules.product.details.utils.MaterialCostConverter;
import ch.icit.pegasus.client.gui.modules.product.details.utils.ProcessCostConverter;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TotalCostConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.FadebleShape;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.HorizontalTextureSkin;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.PriceToolkit;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.DepartmentManHoursCostComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ProcessCostsDetailsPanel
extends StateDependantDetailsPanel<ProductComplete>
implements LafListener {
    private static final long serialVersionUID = 1L;
    private InternalExternalCateringCostTable costTable;
    private final GroupedLoader loader;
    private ReloadablePriceView processCost;
    private final TextLabel materialCost;
    private final ReloadablePriceView productionCost;
    private final HorizontalTextureSkin skin2;
    private boolean isCalculation;
    private ProductTypeDetailsPanel typePanel;
    private final boolean isDeletable;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<TextField> numberOfProducts;

    public ProcessCostsDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider, GroupedLoader loader) {
        super(editor, provider);
        this.isDeletable = provider.isDeletable(ProductVariantComplete_.cateringPointCosts);
        this.skin2 = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.loader = loader;
        this.processCost = new ReloadablePriceView((LoadingGroup)loader, ProcessCostConverter.class);
        this.processCost.setNode((Node)new EmbeddedDTONode());
        this.materialCost = new TextLabel(null, ConverterRegistry.getConverter(MaterialCostConverter.class));
        this.productionCost = new ReloadablePriceView((LoadingGroup)loader, TotalCostConverter.class);
        this.productionCost.setNode((Node)new EmbeddedDTONode());
        loader.setProcessPriceView(this.processCost);
        loader.setProductionPriceView(this.productionCost);
        this.setTitleText(Words.PROCESS_COSTS);
        Node nop = INodeCreator.getDefaultImpl().getNode4DTO((Object)1, false, false);
        this.numberOfProducts = new TitledItem<TextField>(new TextField(nop, TextFieldType.INT_NULLABLE), Words.NUMBER_OF_PRODUCTS, TitledItem.TitledItemOrientation.NORTH);
        this.numberOfProducts.getElement().addTextFieldListener(field -> loader.updateMe(this.processCost));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(n), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.setIgnorePrefWidth(true);
        this.dueDate.getElement().addDateChooserListener((source, selectedDate) -> loader.updateMe(this.productionCost));
        this.costTable = new InternalExternalCateringCostTable(editor, provider, this.isDeletable, loader, ComboBoxFactory.DepartmentType.PRODUCT_UNIT, true){
            private static final long serialVersionUID = 1L;

            @Override
            public void load(boolean b) {
                ProcessCostsDetailsPanel.this.processCost.load(b);
            }

            @Override
            public void removeProcessCost(ReloadablePriceView costs) {
                ProcessCostsDetailsPanel.this.loader.removeProcessCost(costs);
            }

            @Override
            public void addProcessCost(ReloadablePriceView costs) {
                ProcessCostsDetailsPanel.this.loader.addProcessCost(costs);
            }
        };
        this.shape = new FadebleShape(true);
        this.shape.setFillColor(new Color(75, 75, 75));
        this.setCustomLayouter(new Layout());
        this.processCost.setProgress(1.0f);
        this.materialCost.setProgress(1.0f);
        this.productionCost.setProgress(1.0f);
        this.lafAttributeChanged("All attribues changed");
        this.addToView(this.costTable);
        this.addToView(this.processCost);
        this.addToView(this.materialCost);
        this.addToView(this.productionCost);
        this.addToView(this.dueDate);
        this.addToView(this.numberOfProducts);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantComplete_.state;
    }

    public void setTypePanel(ProductTypeDetailsPanel panel) {
        this.typePanel = panel;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.setProcessCostAlgorithm();
        this.setProductionCostAlgorithm();
        this.materialCost.setNode(node.getChildNamed(ProductVariantComplete_.materialPrice));
        this.costTable.setCustomerNode((Node<CustomerLight>)this.editor.getModel().getNode().getChildNamed(ProductComplete_.customer));
        this.costTable.setNode(node);
        this.processCost.load(true);
        this.processCost.updateString();
    }

    public boolean isCalculation() {
        return this.isCalculation;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        int currentY = this.getHeight() - (3 * this.skin2.getImage(11).getHeight() + 2);
        this.skin2.paint(g2, 0, currentY, this.getWidth(), 11);
        currentY = this.getHeight() - (2 * this.skin2.getImage(11).getHeight() + 1);
        this.skin2.paint(g2, 0, currentY, this.getWidth(), 11);
        currentY = this.getHeight() - this.skin2.getImage(11).getHeight();
        this.skin2.paint(g2, 0, currentY, this.getWidth(), 11);
        this.paintChildren(g2);
    }

    public void setCalculation(boolean isCalculation) {
        this.isCalculation = isCalculation;
    }

    public PriceComplete getProcessCosts(Date date) {
        if (this.processCost != null) {
            PriceComplete price = (PriceComplete)this.processCost.getNode().getValue();
            if (price == null) {
                price = new PriceComplete();
            }
            if (price.getCurrency() == null) {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                price.setCurrency(settings.getCurrency());
            }
            if (price.getPrice() == null) {
                price.setPrice(Double.valueOf(0.0));
            }
            return price;
        }
        return null;
    }

    private void ensureCustomerComplete() throws ClientServerCallException {
        Node customerNode = this.editor.getModel().getNode().getChildNamed(ProductComplete_.customer);
        if (customerNode.getValue(CustomerComplete.class) == null && customerNode.getValue(CustomerReference.class) != null) {
            CustomerReference customerReference = (CustomerReference)customerNode.getValue(CustomerReference.class);
            CustomerComplete customerComplete = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getCustomer(new CustomerReference(customerReference.getId())).getValue();
            customerNode.setValue((Object)customerComplete, 0L);
        }
    }

    public Date getDueDate() {
        if (this.dueDate == null) {
            return new Date(System.currentTimeMillis());
        }
        return (Date)this.dueDate.getElement().getNode().getValue();
    }

    public Integer getProductCount() {
        Integer value = (Integer)this.numberOfProducts.getElement().getNode().getValue();
        return value;
    }

    private PriceComplete calculateProcessCosts(Node<List<CateringPointCostComplete>> list, PriceComplete price) {
        if (list != null) {
            try {
                this.ensureCustomerComplete();
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
            Iterator it = list.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Node points = n.getChildNamed(CateringPointCostComplete_.points);
                Node loadF = n.getChildNamed(CateringPointCostComplete_.loadFactor);
                Node from = n.getChildNamed(CateringPointCostComplete_.fromAmount);
                Node to = n.getChildNamed(CateringPointCostComplete_.toAmount);
                Integer targetCount = this.getProductCount();
                if (targetCount == null) {
                    targetCount = 0;
                }
                boolean use = false;
                if ((Integer)from.getValue() == 0 && (Integer)to.getValue() == 0) {
                    use = true;
                }
                if (targetCount >= (Integer)from.getValue() && (targetCount <= (Integer)to.getValue() || (Integer)to.getValue() == 0)) {
                    use = true;
                }
                if (!use) continue;
                InternalCostCenterComplete usedCostCenter = (InternalCostCenterComplete)n.getChildNamed(CateringPointCostComplete_.costCenter).getValue();
                Date validityDate = this.getDueDate();
                boolean tender = Boolean.TRUE.equals(this.node.getChildNamed(ProductVariantComplete_.tenderVariant).getValue());
                CustomerComplete customer = (CustomerComplete)this.editor.getModel().getNode().getChildNamed(ProductComplete_.customer).getValue(CustomerComplete.class);
                PriceComplete np = null;
                if (tender && customer != null) {
                    for (DepartmentManHoursCostComplete dpc : customer.getManHourCosts()) {
                        if (!dpc.getDepartment().equals((Object)usedCostCenter) || !dpc.getValidity().within(validityDate).booleanValue()) continue;
                        np = dpc.getManHourCost();
                    }
                }
                if (np == null) {
                    np = usedCostCenter.resolveBestPrice(validityDate);
                }
                Node pricePerManHour = INodeCreator.getDefaultImpl().getNode4DTO((Object)np, false, false);
                double multiplier = 0.0;
                if (points.getValue() instanceof Integer) {
                    multiplier = ((Integer)points.getValue()).intValue();
                } else if (points.getValue() instanceof Double) {
                    multiplier = (Double)points.getValue();
                }
                double d = multiplier /= 3600.0;
                d = pricePerManHour.getValue() != null && ((PriceComplete)pricePerManHour.getValue()).getPrice() != null ? (d *= ((PriceComplete)pricePerManHour.getValue()).getPrice().doubleValue()) : 0.0;
                if (loadF != null && loadF.getValue() != null && loadF.getValue() instanceof Double) {
                    d *= ((Double)loadF.getValue()).doubleValue();
                }
                if (price.getCurrency() == null) {
                    if (pricePerManHour.getValue() == null) {
                        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        price.setCurrency(settings.getCurrency());
                    } else {
                        price.setCurrency(((PriceComplete)pricePerManHour.getValue()).getCurrency());
                    }
                }
                if (price.getPrice() == null) {
                    price.setPrice(Double.valueOf(0.0));
                }
                price.setPrice(Double.valueOf(price.getPrice() + d));
            }
        }
        return price;
    }

    private void setProcessCostAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(32L);
                    if (ProcessCostsDetailsPanel.this.processCost != null && ProcessCostsDetailsPanel.this.isEnabled()) {
                        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        PriceComplete price = new PriceComplete();
                        price = ProcessCostsDetailsPanel.this.calculateCateringPoints(settings, price);
                        Node pn = ProcessCostsDetailsPanel.this.processCost.getNode();
                        if (pn == null) {
                            pn = new EmbeddedDTONode();
                            ProcessCostsDetailsPanel.this.processCost.setNode(pn);
                        }
                        if (price != null) {
                            price.setPrice(PriceToolkit.ensureDoubleFinite(price.getPrice()));
                            pn.setValue((Object)price, 0L);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean isAlive() {
                if (ProcessCostsDetailsPanel.this.processCost != null) {
                    return !ProcessCostsDetailsPanel.this.processCost.isKilled();
                }
                return false;
            }
        };
        this.processCost.setRunnable(run);
    }

    private PriceComplete calculateCateringPoints(SystemSettingsComplete settings, PriceComplete price) {
        price.setPrice(Double.valueOf(0.0));
        price.setCurrency(settings.getCurrency());
        Node list = this.node.getChildNamed(ProductVariantComplete_.cateringPointCosts);
        price = this.calculateProcessCosts((Node<List<CateringPointCostComplete>>)list, price);
        PriceComplete innerPrice = (PriceComplete)this.node.getChildNamed(ProductVariantComplete_.innerProcessCosts).getValue();
        if (price != null && price.getCurrency() == null) {
            price.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
        }
        if (price != null) {
            if (innerPrice != null) {
                price.setPrice(Double.valueOf(price.getPrice() + innerPrice.getPrice()));
            }
        } else if (innerPrice != null) {
            price = new PriceComplete(innerPrice);
        }
        return price;
    }

    private void setProductionCostAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                CurrencyComplete currency;
                if (!ProcessCostsDetailsPanel.this.isEnabled()) {
                    return;
                }
                Node n = ProcessCostsDetailsPanel.this.node;
                ProductVariantLight v = (ProductVariantLight)n.getValue();
                PriceComplete materialCosts = null;
                if (v.getId() == null || ProcessCostsDetailsPanel.this.getEditor().getModel().isLoading()) {
                    materialCosts = new PriceComplete();
                } else {
                    try {
                        materialCosts = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getMaterialCosts(new ProductVariantReference(v.getId()), new DateWrapper(ProcessCostsDetailsPanel.this.getDueDate()));
                    }
                    catch (ClientServerCallException e) {
                        e.printStackTrace();
                    }
                }
                PriceComplete p1 = materialCosts;
                PriceComplete p2 = null;
                if (ProcessCostsDetailsPanel.this.getDueDate() != null) {
                    p2 = ProcessCostsDetailsPanel.this.getProcessCosts(ProcessCostsDetailsPanel.this.getDueDate());
                }
                if (p2 == null) {
                    p2 = new PriceComplete(null, Double.valueOf(0.0));
                }
                if (p1 == null) {
                    p1 = new PriceComplete();
                }
                if (p1.getPrice() == null) {
                    p1.setPrice(Double.valueOf(0.0));
                }
                if (p2.getPrice() == null) {
                    p2.setPrice(Double.valueOf(0.0));
                }
                if (p1.getCurrency() != null) {
                    currency = p1.getCurrency();
                } else if (p2.getCurrency() != null) {
                    currency = p2.getCurrency();
                } else {
                    SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    currency = s.getCurrency();
                }
                ProcessCostsDetailsPanel.this.materialCost.setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)p1, false, false));
                PriceComplete price = new PriceComplete();
                price.setCurrency(currency);
                price.setPrice(Double.valueOf(0.0));
                price.setPrice(Double.valueOf(p1.getPrice() + p2.getPrice()));
                Node pn = ProcessCostsDetailsPanel.this.productionCost.getNode();
                if (pn == null) {
                    pn = new EmbeddedDTONode();
                    ProcessCostsDetailsPanel.this.productionCost.setNode(pn);
                }
                price.setPrice(PriceToolkit.ensureDoubleFinite(price.getPrice()));
                pn.setValue((Object)price, 0L);
                pn.updateNode();
            }

            @Override
            public boolean isAlive() {
                return !ProcessCostsDetailsPanel.this.productionCost.isKilled();
            }
        };
        this.productionCost.setRunnable(run);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.costTable.kill();
        this.processCost.kill();
        this.loader.setProcessPriceView(null);
        this.loader.setProductionPriceView(null);
        this.dueDate.kill();
        this.numberOfProducts.kill();
        this.costTable = null;
        this.shape = null;
        this.processCost = null;
        this.dueDate = null;
        this.numberOfProducts = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        this.costTable.setEnabled(enabled);
        this.shape.setEnabled(enabled);
        this.processCost.setEnabled(enabled);
        this.materialCost.setEnabled(enabled);
        this.productionCost.setEnabled(enabled);
        this.dueDate.setEnabled(enabled);
        this.numberOfProducts.setEnabled(enabled);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        if (this.processCost != null) {
            this.processCost.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
        if (this.materialCost != null) {
            this.materialCost.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
        if (this.productionCost != null) {
            this.productionCost.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.dueDate);
        CheckedListAdder.addToList(focusList, this.numberOfProducts);
        CheckedListAdder.addToList(focusList, this.costTable);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    public PriceComplete getProductionCost() {
        return (PriceComplete)this.productionCost.getNode().getValue();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        this.node.getChildNamed(ProductVariantComplete_.cateringPointCosts).commitThis();
        List data = (List)this.node.getChildNamed(ProductVariantComplete_.cateringPointCosts).getValue();
        Collections.sort(data);
        boolean error = false;
        HashMap<Tuple, ArrayList<CateringPointCostComplete>> index = new HashMap<Tuple, ArrayList<CateringPointCostComplete>>();
        for (CateringPointCostComplete cateringPointCostComplete : data) {
            Tuple key = new Tuple((Object)cateringPointCostComplete.getCostCenter(), (Object)cateringPointCostComplete.getCabinClass());
            ArrayList<CateringPointCostComplete> list = (ArrayList<CateringPointCostComplete>)index.get(key);
            if (list == null) {
                list = new ArrayList<CateringPointCostComplete>();
                index.put(key, list);
            }
            list.add(cateringPointCostComplete);
        }
        for (Map.Entry entry : index.entrySet()) {
            List list = (List)entry.getValue();
            Collections.sort(list);
            Iterator it = list.iterator();
            Integer latestTo = null;
            while (it.hasNext()) {
                CateringPointCostComplete c = (CateringPointCostComplete)it.next();
                if (latestTo == null) {
                    latestTo = c.getToAmount();
                    continue;
                }
                if (c.getToAmount() == 0) {
                    if (it.hasNext()) {
                        error = true;
                        continue;
                    }
                    if (c.getFromAmount() == latestTo + 1) {
                        latestTo = c.getToAmount();
                        continue;
                    }
                    error = true;
                    latestTo = c.getToAmount();
                    continue;
                }
                if (c.getFromAmount() == latestTo + 1) {
                    latestTo = c.getToAmount();
                    continue;
                }
                error = true;
                latestTo = c.getToAmount();
            }
        }
        if (error) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.PLEASE_REVIEW_PROCESS_COSTS));
        }
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonSpace = 3 * ProcessCostsDetailsPanel.this.skin2.getImage(11).getHeight() + 2;
            int skinHeight = ProcessCostsDetailsPanel.this.skin2.getImage(11).getHeight();
            int cy = 0;
            boolean ch = false;
            ProcessCostsDetailsPanel.this.dueDate.setLocation(ProcessCostsDetailsPanel.this.horizontalBorder, ProcessCostsDetailsPanel.this.verticalBorder);
            ProcessCostsDetailsPanel.this.dueDate.setSize(ProcessCostsDetailsPanel.this.dueDate.getPreferredSize());
            ProcessCostsDetailsPanel.this.numberOfProducts.setLocation(ProcessCostsDetailsPanel.this.dueDate.getX() + ProcessCostsDetailsPanel.this.dueDate.getWidth() + ProcessCostsDetailsPanel.this.horizontalBorder, ProcessCostsDetailsPanel.this.dueDate.getY());
            ProcessCostsDetailsPanel.this.numberOfProducts.setSize(ProcessCostsDetailsPanel.this.numberOfProducts.getPreferredSize());
            cy = ProcessCostsDetailsPanel.this.numberOfProducts.getY() + ProcessCostsDetailsPanel.this.numberOfProducts.getHeight() + ProcessCostsDetailsPanel.this.verticalBorder;
            ProcessCostsDetailsPanel.this.costTable.setLocation(0, cy);
            ProcessCostsDetailsPanel.this.costTable.setSize(parent.getWidth(), parent.getHeight() - (buttonSpace + cy));
            ProcessCostsDetailsPanel.this.processCost.setLocation(ProcessCostsDetailsPanel.this.horizontalBorder, (int)((double)(parent.getHeight() - buttonSpace) + ((double)skinHeight - ProcessCostsDetailsPanel.this.processCost.getPreferredSize().getHeight()) / 2.0));
            ProcessCostsDetailsPanel.this.processCost.setSize(parent.getWidth() - 2 * ProcessCostsDetailsPanel.this.horizontalBorder, (int)ProcessCostsDetailsPanel.this.processCost.getPreferredSize().getHeight());
            ProcessCostsDetailsPanel.this.materialCost.setLocation(ProcessCostsDetailsPanel.this.horizontalBorder, (int)((double)(parent.getHeight() - buttonSpace + skinHeight) + ((double)skinHeight - ProcessCostsDetailsPanel.this.materialCost.getPreferredSize().getHeight()) / 2.0));
            ProcessCostsDetailsPanel.this.materialCost.setSize(parent.getWidth() - 2 * ProcessCostsDetailsPanel.this.horizontalBorder, (int)ProcessCostsDetailsPanel.this.materialCost.getPreferredSize().getHeight());
            ProcessCostsDetailsPanel.this.productionCost.setLocation(ProcessCostsDetailsPanel.this.horizontalBorder, (int)((double)(parent.getHeight() - buttonSpace + 2 * skinHeight) + ((double)skinHeight - ProcessCostsDetailsPanel.this.productionCost.getPreferredSize().getHeight()) / 2.0));
            ProcessCostsDetailsPanel.this.productionCost.setSize(parent.getWidth() - 2 * ProcessCostsDetailsPanel.this.horizontalBorder, (int)ProcessCostsDetailsPanel.this.productionCost.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            InternalExternalCateringCostTable costTable2 = ProcessCostsDetailsPanel.this.costTable;
            int h = (int)((double)ProcessCostsDetailsPanel.this.verticalBorder + ProcessCostsDetailsPanel.this.numberOfProducts.getPreferredSize().getHeight() + (double)ProcessCostsDetailsPanel.this.verticalBorder);
            h = (int)((double)h + Math.max(60.0, costTable2.getPreferredSize().getHeight()));
            int buttonSpace = 3 * ProcessCostsDetailsPanel.this.skin2.getImage(11).getHeight() + 2;
            return new Dimension(0, h += buttonSpace);
        }
    }
}

