/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.SoBProductConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.product.SoBProductConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class SalesOnBoardDetailsPanel
extends StateDependantDetailsPanel<ProductComplete>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDInputComboBox> sobPrice;
    private TitledItem<RDInputComboBox> crewPrice;
    private TitledItem<RDInputComboBox> free4crewPrice;
    private TitledItem<RDTextField> conversionField;
    private TitledItem<TextLabel> sobUnit;
    private TitledItem<RDCheckBox> isNormal;
    private TitledItem<RDCheckBox> complimentary;
    private TitledItem<RDCheckBox> crew;
    private TitledItem<RDCheckBox> free4crew;
    private TitledItem<RDCheckBox> stockCheck;
    private TitledItem<RDCheckBox> uplift;
    private TitledItem<RDCheckBox> receiptRequired;

    public SalesOnBoardDetailsPanel(RowEditor rowEditor, RDProvider provider) {
        super(rowEditor, provider, true, true, true);
        this.setTitleText(Words.SALES_ON_BOARD_CONFIGURATION);
        this.sobPrice = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE), Words.UNITPRICE, TitledItem.TitledItemOrientation.NORTH);
        this.crewPrice = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE), Words.CREWPRICE, TitledItem.TitledItemOrientation.NORTH);
        this.conversionField = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT), Words.CONVERSION, TitledItem.TitledItemOrientation.NORTH);
        this.sobUnit = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UnitConverter.class)), Words.SOB_UNIT, TitledItem.TitledItemOrientation.NORTH);
        this.isNormal = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.NORMAL, TitledItem.TitledItemOrientation.EAST);
        this.complimentary = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.COMPLEMENTARY, TitledItem.TitledItemOrientation.EAST);
        this.crew = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.CREW, TitledItem.TitledItemOrientation.EAST);
        this.stockCheck = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.STOCK_CHECK, TitledItem.TitledItemOrientation.EAST);
        this.uplift = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.UPLIFTABLE, TitledItem.TitledItemOrientation.EAST);
        this.receiptRequired = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.RECEIPT_REQUIRED, TitledItem.TitledItemOrientation.EAST);
        this.crew.getElement().addButtonListener(this);
        this.free4crewPrice = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE), Words.FREE_FOR_CREW_PRICE, TitledItem.TitledItemOrientation.NORTH);
        this.free4crew = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.FREE_FOR_CREW, TitledItem.TitledItemOrientation.EAST);
        this.free4crew.getElement().addButtonListener(this);
        this.sobPrice.getFader().setPermanent(true);
        this.free4crewPrice.getFader().setPermanent(true);
        this.crewPrice.getFader().setPermanent(true);
        this.conversionField.getFader().setPermanent(true);
        this.sobUnit.getFader().setPermanent(true);
        this.isNormal.getFader().setPermanent(true);
        this.free4crew.getFader().setPermanent(true);
        this.complimentary.getFader().setPermanent(true);
        this.crew.getFader().setPermanent(true);
        this.stockCheck.getFader().setPermanent(true);
        this.uplift.getFader().setPermanent(true);
        this.receiptRequired.getFader().setPermanent(true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.sobPrice);
        this.addToView(this.crewPrice);
        this.addToView(this.free4crewPrice);
        this.addToView(this.sobUnit);
        this.addToView(this.conversionField);
        this.addToView(this.isNormal);
        this.addToView(this.free4crew);
        this.addToView(this.complimentary);
        this.addToView(this.crew);
        this.addToView(this.stockCheck);
        this.addToView(this.uplift);
        this.addToView(this.receiptRequired);
        this.setEnabled(true);
    }

    @Override
    public boolean hasExpandableContent() {
        return Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(ProductComplete_.salesOnBoard).getValue());
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantLight_.state;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.crew.getElement().getEditor()) {
            this.setEnabled(this.isEnabled());
        }
        if (source == this.free4crew.getElement().getEditor()) {
            this.setEnabled(this.isEnabled());
        }
    }

    public void reloadNode() {
        Object o = null;
        if (this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.product, ProductComplete_.salesOnBoard}) != null) {
            this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.product, ProductComplete_.salesOnBoard}).removeNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.product, ProductComplete_.salesOnBoard}).addNodeListener((NodeListener)this);
            o = this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.product, ProductComplete_.salesOnBoard}).getValue();
        }
        if (this.editor.getLoadingState() == IDataHandler.DATAHANDLER_STATE.RELOAD) {
            return;
        }
        if (Boolean.TRUE.equals(o)) {
            Node conf = this.node.getChildNamed(ProductVariantComplete_.sobConfiguration);
            if (conf == null || conf.getValue() == null) {
                ProductVariantComplete productVariant = (ProductVariantComplete)this.node.getValue(ProductVariantComplete.class);
                Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
                SoBProductConfigurationComplete sobConfig = (SoBProductConfigurationComplete)this.node.getChildNamed(ProductVariantComplete_.sobConfiguration).getValue();
                sobConfig = settings != null && settings.getValue() != null ? new SoBProductConfigurationComplete(productVariant, ((SystemSettingsComplete)settings.getValue()).getPieceUnit()) : new SoBProductConfigurationComplete(productVariant);
                if (sobConfig.getSobPrice() == null) {
                    sobConfig.setSobPrice(new PriceComplete());
                }
                if (sobConfig.getSobPrice().getPrice() == null) {
                    sobConfig.getSobPrice().setPrice(Double.valueOf(0.0));
                }
                if (sobConfig.getSobPrice().getCurrency() == null) {
                    sobConfig.getSobPrice().setCurrency(((SystemSettingsComplete)settings.getValue()).getCurrency());
                }
                if (sobConfig.getFree4crewPrice() == null) {
                    sobConfig.setFree4crewPrice(new PriceComplete());
                }
                if (sobConfig.getFree4crewPrice().getPrice() == null) {
                    sobConfig.getFree4crewPrice().setPrice(Double.valueOf(0.0));
                }
                if (sobConfig.getFree4crewPrice().getCurrency() == null) {
                    sobConfig.getFree4crewPrice().setCurrency(((SystemSettingsComplete)settings.getValue()).getCurrency());
                }
                if (productVariant.getCrewPrice() == null) {
                    productVariant.setCrewPrice(new PriceComplete());
                }
                if (productVariant.getCrewPrice().getPrice() == null) {
                    productVariant.getCrewPrice().setPrice(Double.valueOf(0.0));
                }
                if (productVariant.getCrewPrice().getCurrency() == null) {
                    productVariant.getCrewPrice().setCurrency(((SystemSettingsComplete)settings.getValue()).getCurrency());
                }
                Node n = this.node;
                n.getChildNamed(ProductVariantComplete_.sobConfiguration).setValue((Object)sobConfig, 0L);
                conf = this.node.getChildNamed(ProductVariantComplete_.sobConfiguration);
            }
            if (conf.getChildNamed(SoBProductConfigurationComplete_.sobPrice) != null && conf.getChildNamed(SoBProductConfigurationComplete_.sobPrice).getValue() == null) {
                conf.getChildNamed(SoBProductConfigurationComplete_.sobPrice).setValue((Object)new PriceComplete(), 0L);
            }
            this.sobPrice.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.sobPrice));
            this.crewPrice.getElement().setNode(this.node.getChildNamed(ProductVariantComplete_.crewPrice));
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (!settings.getPieceUnit().equals(conf.getChildNamed(SoBProductConfigurationComplete_.sobUnit).getValue())) {
                conf.getChildNamed(SoBProductConfigurationComplete_.sobUnit).setValue((Object)settings.getPieceUnit(), 0L);
            }
            this.sobUnit.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.sobUnit));
            this.conversionField.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.conversionFactor));
            this.isNormal.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.normal));
            this.complimentary.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.complimentary));
            this.crew.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.crew));
            this.stockCheck.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.stockCheck));
            this.uplift.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.upliftable));
            this.receiptRequired.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.receiptRequired));
            this.free4crew.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.free4crew));
            this.free4crewPrice.getElement().setNode(conf.getChildNamed(SoBProductConfigurationComplete_.free4crewPrice));
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.reloadNode();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null && this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.product, ProductComplete_.salesOnBoard}) != null) {
            this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.product, ProductComplete_.salesOnBoard}).removeNodeListener((NodeListener)this);
        }
        this.sobPrice.kill();
        this.sobPrice = null;
        this.conversionField.kill();
        this.conversionField = null;
        this.sobUnit.kill();
        this.sobUnit = null;
        this.isNormal.kill();
        this.isNormal = null;
        this.complimentary.kill();
        this.complimentary = null;
        this.crew.kill();
        this.crew = null;
        this.stockCheck.kill();
        this.stockCheck = null;
        this.uplift.kill();
        this.uplift = null;
        this.receiptRequired.kill();
        this.receiptRequired = null;
        this.crewPrice.kill();
        this.crewPrice = null;
        this.free4crew.kill();
        this.free4crew = null;
        this.free4crewPrice.kill();
        this.free4crewPrice = null;
    }

    @Override
    public void setEnabled(boolean d) {
        super.setEnabled(d);
        try {
            if (Boolean.FALSE.equals(this.editor.getModel().getNode().getChildNamed(ProductComplete_.salesOnBoard).getValue())) {
                d = false;
            }
        }
        catch (Exception e) {
            d = false;
        }
        boolean isDraft = this.isStateDraft();
        d = d && isDraft;
        this.sobPrice.setEnabled(d);
        this.sobUnit.setEnabled(d);
        this.conversionField.setEnabled(d);
        this.crewPrice.setEnabled(d && this.crew.getElement().isChecked());
        this.free4crewPrice.setEnabled(d && this.free4crew.getElement().isChecked());
        this.isNormal.setEnabled(d);
        this.complimentary.setEnabled(d);
        this.crew.setEnabled(d);
        this.stockCheck.setEnabled(d);
        this.uplift.setEnabled(d);
        this.receiptRequired.setEnabled(d);
        this.free4crew.setEnabled(d);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.reloadNode();
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SalesOnBoardDetailsPanel.this.conversionField.setLocation(10, SalesOnBoardDetailsPanel.this.inner_verticalBorder);
            SalesOnBoardDetailsPanel.this.conversionField.setSize(80, (int)SalesOnBoardDetailsPanel.this.conversionField.getPreferredSize().getHeight());
            SalesOnBoardDetailsPanel.this.sobUnit.setLocation(SalesOnBoardDetailsPanel.this.conversionField.getX() + SalesOnBoardDetailsPanel.this.conversionField.getWidth() + SalesOnBoardDetailsPanel.this.inner_horizontalBorder, SalesOnBoardDetailsPanel.this.conversionField.getY());
            SalesOnBoardDetailsPanel.this.sobUnit.setSize(75, (int)SalesOnBoardDetailsPanel.this.sobUnit.getPreferredSize().getHeight());
            SalesOnBoardDetailsPanel.this.sobPrice.setLocation(SalesOnBoardDetailsPanel.this.sobUnit.getX() + SalesOnBoardDetailsPanel.this.sobUnit.getWidth() + SalesOnBoardDetailsPanel.this.inner_horizontalBorder, SalesOnBoardDetailsPanel.this.conversionField.getY());
            SalesOnBoardDetailsPanel.this.sobPrice.setSize(SalesOnBoardDetailsPanel.this.sobPrice.getPreferredSize());
            SalesOnBoardDetailsPanel.this.isNormal.setLocation(SalesOnBoardDetailsPanel.this.conversionField.getX(), SalesOnBoardDetailsPanel.this.conversionField.getY() + SalesOnBoardDetailsPanel.this.conversionField.getHeight() + SalesOnBoardDetailsPanel.this.verticalBorder);
            SalesOnBoardDetailsPanel.this.isNormal.setSize(SalesOnBoardDetailsPanel.this.isNormal.getPreferredSize());
            SalesOnBoardDetailsPanel.this.complimentary.setLocation(SalesOnBoardDetailsPanel.this.conversionField.getX(), SalesOnBoardDetailsPanel.this.isNormal.getY() + SalesOnBoardDetailsPanel.this.isNormal.getHeight() + SalesOnBoardDetailsPanel.this.inner_verticalBorder);
            SalesOnBoardDetailsPanel.this.complimentary.setSize(SalesOnBoardDetailsPanel.this.complimentary.getPreferredSize());
            SalesOnBoardDetailsPanel.this.crew.setLocation(SalesOnBoardDetailsPanel.this.conversionField.getX(), SalesOnBoardDetailsPanel.this.complimentary.getY() + SalesOnBoardDetailsPanel.this.complimentary.getHeight() + SalesOnBoardDetailsPanel.this.inner_verticalBorder);
            SalesOnBoardDetailsPanel.this.crew.setSize(SalesOnBoardDetailsPanel.this.crew.getPreferredSize());
            SalesOnBoardDetailsPanel.this.crewPrice.setLocation(SalesOnBoardDetailsPanel.this.crew.getX(), SalesOnBoardDetailsPanel.this.crew.getY() + SalesOnBoardDetailsPanel.this.crew.getHeight() + SalesOnBoardDetailsPanel.this.inner_verticalBorder);
            SalesOnBoardDetailsPanel.this.crewPrice.setSize(SalesOnBoardDetailsPanel.this.crewPrice.getPreferredSize());
            SalesOnBoardDetailsPanel.this.stockCheck.setLocation(SalesOnBoardDetailsPanel.this.complimentary.getX() + SalesOnBoardDetailsPanel.this.complimentary.getWidth() + SalesOnBoardDetailsPanel.this.horizontalBorder, SalesOnBoardDetailsPanel.this.isNormal.getY());
            SalesOnBoardDetailsPanel.this.stockCheck.setSize(SalesOnBoardDetailsPanel.this.stockCheck.getPreferredSize());
            SalesOnBoardDetailsPanel.this.uplift.setLocation(SalesOnBoardDetailsPanel.this.stockCheck.getX(), SalesOnBoardDetailsPanel.this.stockCheck.getY() + SalesOnBoardDetailsPanel.this.stockCheck.getHeight() + SalesOnBoardDetailsPanel.this.inner_verticalBorder);
            SalesOnBoardDetailsPanel.this.uplift.setSize(SalesOnBoardDetailsPanel.this.uplift.getPreferredSize());
            SalesOnBoardDetailsPanel.this.receiptRequired.setLocation(SalesOnBoardDetailsPanel.this.stockCheck.getX(), SalesOnBoardDetailsPanel.this.uplift.getY() + SalesOnBoardDetailsPanel.this.uplift.getHeight() + SalesOnBoardDetailsPanel.this.inner_verticalBorder);
            SalesOnBoardDetailsPanel.this.receiptRequired.setSize(SalesOnBoardDetailsPanel.this.receiptRequired.getPreferredSize());
            SalesOnBoardDetailsPanel.this.free4crew.setLocation(SalesOnBoardDetailsPanel.this.crewPrice.getX(), SalesOnBoardDetailsPanel.this.crewPrice.getY() + SalesOnBoardDetailsPanel.this.crewPrice.getHeight() + SalesOnBoardDetailsPanel.this.verticalBorder);
            SalesOnBoardDetailsPanel.this.free4crew.setSize(SalesOnBoardDetailsPanel.this.free4crew.getPreferredSize());
            SalesOnBoardDetailsPanel.this.free4crewPrice.setLocation(SalesOnBoardDetailsPanel.this.free4crew.getX(), SalesOnBoardDetailsPanel.this.free4crew.getY() + SalesOnBoardDetailsPanel.this.free4crew.getHeight() + SalesOnBoardDetailsPanel.this.inner_verticalBorder);
            SalesOnBoardDetailsPanel.this.free4crewPrice.setSize(SalesOnBoardDetailsPanel.this.free4crewPrice.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SalesOnBoardDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SalesOnBoardDetailsPanel.this.conversionField.getPreferredSize().getHeight());
            h += SalesOnBoardDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SalesOnBoardDetailsPanel.this.isNormal.getPreferredSize().getHeight());
            h += SalesOnBoardDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SalesOnBoardDetailsPanel.this.complimentary.getPreferredSize().getHeight());
            h += SalesOnBoardDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SalesOnBoardDetailsPanel.this.crew.getPreferredSize().getHeight());
            h += SalesOnBoardDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SalesOnBoardDetailsPanel.this.crewPrice.getPreferredSize().getHeight());
            h += SalesOnBoardDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SalesOnBoardDetailsPanel.this.free4crew.getPreferredSize().getHeight());
            h += SalesOnBoardDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SalesOnBoardDetailsPanel.this.free4crewPrice.getPreferredSize().getHeight());
            return new Dimension(0, h += SalesOnBoardDetailsPanel.this.verticalBorder);
        }
    }
}

