/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tables.ArticleQuantityTable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;

public class SolarArticlesDetailsPanel
extends StateDependantDetailsPanel<ProductComplete> {
    private static final long serialVersionUID = 1L;
    private ArticleQuantityTable table;

    public SolarArticlesDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ARTICLES);
        this.table = new ArticleQuantityTable();
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantLight_.state;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        Node firstGroup = (Node)node.getChildNamed(ComplexProductVariantComplete_.productComponentGroups).getFailSafeChildIterator().next();
        this.table.getModel().setNode(firstGroup.getChildNamed(SimpleProductComponentGroupComplete_.components));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        this.paintOverBackgroundUnderComponents(g2);
        this.paintChildren(g2);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        if (isEnabled) {
            if (isDraft) {
                this.table.setEnabled(isEnabled);
            } else {
                this.table.setEnabled(isEnabled);
                this.table.setEditable(isDraft);
            }
        } else {
            this.table.setEnabled(isEnabled);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SolarArticlesDetailsPanel.this.table.setLocation(0, 0);
            SolarArticlesDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return SolarArticlesDetailsPanel.this.table.getPreferredSize();
        }
    }
}

