/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.TaxRateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TaxAmountConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.VariantBasedStateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SolarTaxesDetailsPanel
extends VariantBasedStateDependantTableDetailsPanel<ProductVariantComplete, ProductComplete> {
    private static final long serialVersionUID = 1L;
    private boolean isDeletable;
    private boolean isWritable;

    public SolarTaxesDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider) {
        super(editor, provider, true);
        this.setTitleText(Words.TAXES);
        this.isDeletable = provider.isDeletable(ProductVariantComplete_.taxRates);
        this.isWritable = provider.isWritable(ProductVariantComplete_.taxRates);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TAX_TYPE, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.VALUE, null, null, null, "", 30, 30, 30));
        int dw = this.table.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setOverrideName(ProductVariantComplete_.taxRates);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        TaxRateComplete p = this.getFreeTaxRate();
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, true);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.table.enableAddButton(this.hasFreeTaxRates());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return HandlingCostVariantComplete_.state;
    }

    private boolean hasFreeTaxRates() {
        Node n = NodeToolkit.getAffixList(TaxRateComplete.class);
        return n.getChildCount() != this.table.getRowCount();
    }

    private TaxRateComplete getFreeTaxRate() {
        Node n = NodeToolkit.getAffixList(TaxRateComplete.class);
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            Iterator<Table2RowPanel> it2 = this.table.getRows().iterator();
            boolean found = false;
            while (it2.hasNext() && !found) {
                Node nnn = it2.next().getModel().getNode();
                if (!((TaxRateComplete)nn.getValue()).equals(nnn.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (TaxRateComplete)nn.getValue();
        }
        return null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.variantNode = node;
        this.table.getModel().setNode(node.getChildNamed(ProductVariantComplete_.taxRates));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private ComboBox taxType;
        private TextLabel value;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.taxType = new ComboBox(m.getNode(), NodeToolkit.getAffixList(TaxRateComplete.class), ConverterRegistry.getConverter(TaxRateConverter.class));
            this.value = new TextLabel(m.getNode().getChildNamed(TaxRateComplete_.rate), ConverterRegistry.getConverter(TaxAmountConverter.class));
            m.getNode().addNodeListener((NodeListener)this);
            if (SolarTaxesDetailsPanel.this.isDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.deleteButton.setProgress(1.0f);
                this.add(this.deleteButton);
            }
            this.taxType.setProgress(1.0f);
            this.value.setProgress(1.0f);
            this.add(this.taxType);
            this.add(this.value);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.taxType.getStringValue();
                }
                case 1: {
                    return this.value.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.taxType.setEnabled(isEnabled && SolarTaxesDetailsPanel.this.isWritable);
            this.value.setEnabled(isEnabled);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.taxType.getFocusComponents());
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.taxType.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().removeNodeListener((NodeListener)this);
            this.taxType.kill();
            this.taxType = null;
            this.value.kill();
            this.value = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
            if (this.value != null) {
                this.value.setNode(this.model.getNode().getChildNamed(new String[]{"rate"}));
            }
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.taxType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.taxType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.value.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.value.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.value.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.value.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.deleteButton != null) {
                    TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

