/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.ProductVariantTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.CopyProductVariantPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantDetailsPanelTabbed;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.table.renderer.CellViewModificationStateERenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete_;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.ProductPriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VariantDetailsPanel
extends AVariantDetailsPanelTabbed<ProductComplete> {
    private static final long serialVersionUID = 1L;

    public VariantDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider) {
        super((RowEditor)editor, provider);
    }

    @Override
    public Class getCommittingClass(Node<?> node) {
        if (node.getValue(ComplexProductVariantComplete.class) != null) {
            return ComplexProductVariantComplete.class;
        }
        if (node.getValue(SimpleProductVariantComplete.class) != null) {
            return SimpleProductVariantComplete.class;
        }
        throw new RuntimeException(Words.CURRENT_PRODUCT_VARIANT_TYPE_IS_NOT_SUPPORTED + node.getValue());
    }

    @Override
    public boolean isVariantParent(Node<?> node) {
        return node.getValue() instanceof ProductComplete;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        Iterator it = this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            ProductVariantLight pvl = (ProductVariantLight)n.getValue(ProductVariantLight.class);
            Node img = n.getChildNamed(ProductVariantComplete_.imageReference);
            if (img == null) continue;
            PegasusFileComplete r = (PegasusFileComplete)img.getValue();
            if (r != null && r.getId() == null) {
                FileCommitter c = new FileCommitter(r.getLocalFile());
                c.setWriteBackAlgorithm(reference -> {
                    img.setValue((Object)reference, 0L);
                    pvl.setImageReference(reference);
                });
                a.add(c);
            }
            if (!(pvl instanceof ComplexProductVariantComplete)) continue;
            Iterator it2 = n.getChildNamed(new String[]{"productComponentGroups"}).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node nn = (Node)it2.next();
                SimpleProductComponentGroupComplete pg = (SimpleProductComponentGroupComplete)nn.getValue(SimpleProductComponentGroupComplete.class);
                Node gImg = nn.getChildNamed(SimpleProductComponentGroupComplete_.image);
                PegasusFileComplete gr = (PegasusFileComplete)gImg.getValue(PegasusFileComplete.class);
                if (gr == null || gr.getId() != null) continue;
                FileCommitter c = new FileCommitter(gr.getLocalFile());
                c.setWriteBackAlgorithm(reference -> {
                    gImg.setValue((Object)reference, 0L);
                    pg.setImage(reference);
                });
                a.add(c);
            }
        }
        return a;
    }

    @Override
    public List<TableColumnInfo> getColumns(Table2 table) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = 2 * table.getCellPadding() + DateChooser.getPreferredWidth(this, false);
        int tw2 = 2 * table.getCellPadding() + DateChooser.getPreferredWidth(this, true);
        int stateWidth = 2 * table.getCellPadding() + TableColumnInfo.state2;
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", stateWidth, stateWidth, stateWidth));
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductVariantComment())) {
            columns.add(new TableColumnInfo(Words.INTERNAL_COMMENT, null, null, null, "", 100, 100, 100));
        }
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 80, 80, 80));
        tw = 3 * table.getCellPadding() + ArrowButton.getPreferredWidth() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductVariantComment())) {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        Date t = new PeriodComplete((Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ProductComplete_.period, PeriodComplete_.startDate}).getValue(), null).getStartDate();
        long toDay = new PeriodComplete(null, new Date(System.currentTimeMillis())).getEndDate().getTime();
        long lastDateProductive = t.getTime();
        this.validateVariants("Productive:", true, o, toDay, --lastDateProductive, this.getProductivePanel());
        lastDateProductive = t.getTime();
        this.validateVariants("Tender:", false, o, toDay, --lastDateProductive, this.getTenderPanel());
        return o;
    }

    private void validateVariants(String type, boolean atLeastOneVariant, List<ScreenValidationObject> o, long toDay, long lastDateProductive, Table2 productivPanel) {
        productivPanel.updateOrder();
        ArrayList<Table2RowPanel> list = new ArrayList<Table2RowPanel>();
        list.addAll(productivPanel.getRows());
        Collections.sort(list, (o1, o2) -> {
            ProductVariantLight v1 = (ProductVariantLight)o1.getModel().getNode().getValue(ProductVariantLight.class);
            ProductVariantLight v2 = (ProductVariantLight)o2.getModel().getNode().getValue(ProductVariantLight.class);
            return v1.compareTo(v2);
        });
        boolean b = false;
        for (Table2RowPanel p : list) {
            PeriodComplete price;
            Date date;
            o.addAll(((TableRowImpl)p).validateRow());
            ProductVariantLight v = (ProductVariantLight)p.getModel().getNode().getValue(ProductVariantLight.class);
            Date s = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{ProductVariantLight_.validityPeriod, PeriodComplete_.startDate}).getValue();
            Date e = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{ProductVariantLight_.validityPeriod, PeriodComplete_.endDate}).getValue();
            if (v.getValidityPeriod().getEndDate().getTime() > toDay && e.getTime() < toDay && p.getModel().getNode().getChildNamed(RecipeVariantLight_.state).getValue() == ModificationStateE.ACCEPTED && !this.provider.isWritable(ProductAccess.EDIT_OLD_VARIANT)) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, type + " " + Words.THE_END_DATE_ACCEPTED_VARIANT_MUST_BE_AFTER_TODAY));
            }
            if (lastDateProductive + 1L != (date = (price = new PeriodComplete(s, e)).getStartDate()).getTime()) {
                b = true;
            }
            date = price.getEndDate();
            lastDateProductive = date.getTime();
        }
        Date d = (Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ProductComplete_.period, PeriodComplete_.endDate}).getValue();
        long endDate = new PeriodComplete(null, d).getEndDate().getTime();
        if (lastDateProductive != endDate) {
            b = true;
        }
        if (productivPanel.getRowCount() == 0) {
            if (atLeastOneVariant) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, type + " " + Words.EVERY_PRODUCT_NEEDS_AT_LEAST_ONE_VARIANT));
            }
        } else if (b) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, type + " " + Words.ENSURE_THE_GIVEN_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
        }
    }

    @Override
    public Table2RowPanel getTableRow(Table2RowModel model, boolean productive) {
        return new TableRowImpl(model);
    }

    @Override
    public void reloadVariant(final Node n, final Table2RowPanel panel) {
        this.editor.showCommittingAnimation(Words.RELOAD_VARIANT);
        this.editor.setEnabled(false);
        ProductVariantComplete c = (ProductVariantComplete)n.getValue(ProductVariantComplete.class);
        if (c == null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    Node node = n;
                    SystemSettingsComplete s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached().getValue();
                    ProductVariantComplete cc = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference((ProductVariantReference)((ProductVariantLight)n.getValue(ProductVariantLight.class))).getValue();
                    try {
                        PriceComplete p = ProductPriceCalculationToolkit.getProductMaterialPrice((ProductVariantComplete)cc, (int)1, (ModificationStateE)cc.getState(), (SystemSettingsComplete)s, (Timestamp)new Timestamp(cc.getValidityPeriod().getStartDate().getTime()), (RecipeVariantAccessor)new RecipeVariantAccessorImpl(), (CurrencyVariantAccessor)new CurrencyVariantAccessorImpl());
                        cc.setMaterialPrice(p);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n.removeExistingValues();
                    n.setValue((Object)cc, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            VariantDetailsPanel.this.updatePanels(node, panel);
                            VariantDetailsPanel.this.editor.createFocusCycle();
                        }

                        public void errorOccurred(ClientException exception) {
                            VariantDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            TableRowImpl r;
            ProductVariantComplete variant = (ProductVariantComplete)n.getValue(ProductVariantComplete.class);
            n.removeExistingValues();
            n.setValue((Object)variant, 0L);
            n.updateNode();
            this.updatePanels(n, panel);
            for (Table2RowPanel row : this.productiveVariants.getRows()) {
                r = (TableRowImpl)row;
                r.updateRowFields();
            }
            for (Table2RowPanel row : this.tenderVariants.getRows()) {
                r = (TableRowImpl)row;
                r.updateRowFields();
            }
            this.editor.createFocusCycle();
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private TextLabel price;
        private CellViewModificationStateERenderer stateRenderer;
        private AddButton cloneButton;
        private DeleteButton delete;
        private TextLabel variantType;
        private RDTextField internalComment;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            boolean isTender = Boolean.TRUE.equals(m.getNode().getChildNamed(ProductVariantComplete_.tenderVariant).getValue());
            boolean isAccepted = m.getNode().getChildNamed(ProductVariantLight_.state).getValue() == ModificationStateE.ACCEPTED;
            boolean isDeletable = VariantDetailsPanel.this.provider.isWritable(ProductAccess.REMOVE_VARIANT) && m.getNode().getChildNamed(ProductVariantLight_.state).getValue() != ModificationStateE.ACCEPTED;
            boolean isAddable = VariantDetailsPanel.this.provider.isWritable(ProductAccess.ADD_VARIANT);
            if (isTender) {
                Color background = Color.RED;
                this.setBackground(background);
            }
            this.startDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.startDate.setOverrideName(ProductAccess.EDIT_VARIANT);
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{ProductVariantLight_.validityPeriod, PeriodComplete_.startDate}));
            this.endDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.endDate.setOverrideName(ProductAccess.EDIT_VARIANT);
            this.endDate.setCheckBoxEnabled();
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{ProductVariantLight_.validityPeriod, PeriodComplete_.endDate}));
            this.price = new TextLabel(m.getNode().getChildNamed(ProductVariantLight_.salesPrice), ConverterRegistry.getConverter(PriceConverter3.class));
            this.stateRenderer = new CellViewModificationStateERenderer((ModificationStateE)m.getNode().getChildNamed(ProductVariantLight_.state).getValue());
            this.variantType = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ProductVariantTypeConverter.class));
            this.delete = new DeleteButton();
            if (isAddable && m.getNode().getChildNamed(ProductVariantLight_.id).getValue() != null) {
                this.cloneButton = new AddButton();
            }
            if (this.delete != null) {
                this.delete.addButtonListener(this);
            }
            if (this.cloneButton != null) {
                this.cloneButton.addButtonListener(this);
            }
            if (Boolean.TRUE.equals(VariantDetailsPanel.this.viewSettings.getShowProductVariantComment())) {
                this.internalComment = new RDTextField(VariantDetailsPanel.this.provider, TextFieldType.NORMAL);
                this.internalComment.setNode(m.getNode().getChildNamed(ProductVariantLight_.internalVariantComment));
            }
            this.setLayout(new Layout());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.price);
            this.add(this.stateRenderer);
            if (this.internalComment != null) {
                this.add(this.internalComment);
            }
            this.add(this.variantType);
            if (this.cloneButton != null) {
                this.add(this.cloneButton);
            }
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        @Override
        public Color getRowColor(Table2RowPanel p) {
            boolean isNew = false;
            if (this.model != null) {
                if (this.model.getNode() != null && this.model.getNode().getChildNamed(DtoFieldConstants.NEW_ONE) != null) {
                    isNew = true;
                }
                if (isNew) {
                    return new Color(100, 100, 100);
                }
                return this.model.getParentModel().getTable().getColor4Index(this.colorIndex);
            }
            return new Color(100, 100, 100);
        }

        @Override
        public void updateRow(Node<?> node) {
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.price.kill();
            this.stateRenderer.kill();
            this.variantType.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            if (this.cloneButton != null) {
                this.cloneButton.kill();
            }
            if (this.internalComment != null) {
                this.internalComment.kill();
            }
            this.startDate = null;
            this.endDate = null;
            this.price = null;
            this.stateRenderer = null;
            this.delete = null;
            this.cloneButton = null;
            this.variantType = null;
            this.internalComment = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.startDate);
            CheckedListAdder.addToList(focusList, this.endDate);
            CheckedListAdder.addToList(focusList, this.internalComment);
            CheckedListAdder.addToList(focusList, this.cloneButton);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.startDate.getNode().getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean accepted = false;
            if (isEnabled) {
                try {
                    accepted = this.model.getNode().getChildNamed(ProductVariantLight_.state).getValue() == ModificationStateE.ACCEPTED;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.startDate.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.stateRenderer.setEnabled(isEnabled);
            this.variantType.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled && !accepted);
            }
            if (this.cloneButton != null) {
                this.cloneButton.setEnabled(isEnabled);
            }
            if (this.internalComment != null) {
                this.internalComment.setEnabled(isEnabled && !accepted);
            }
        }

        protected List<ScreenValidationObject> validateRow() {
            return ValidationUtil.validatePeriod((Node<Date>)this.getModel().getNode().getChildNamed(new String[]{"validityPeriod-startDate"}), (Node<Date>)this.getModel().getNode().getChildNamed(new String[]{"validityPeriod-endDate"}), this.startDate, this.endDate);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.cloneButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.cloneButton, true, true, Words.COPY_VARIANT);
                popUp.setView(new CopyProductVariantPopup(this.model.getNode(), this.model.getParentModel().getTable() == VariantDetailsPanel.this.getProductivePanel()));
                popUp.showPopUp(x, y, -1, -1, (source1, xargs) -> {
                    if (xargs == null) {
                        return;
                    }
                    Node nNode = (Node)xargs[0];
                    ProductVariantComplete variant = (ProductVariantComplete)nNode.getValue();
                    Table2 selectedTable = Boolean.TRUE.equals(variant.getTenderVariant()) ? VariantDetailsPanel.this.getTenderPanel() : VariantDetailsPanel.this.getProductivePanel();
                    selectedTable.getModel().getNode().addChild(nNode, 0L);
                    for (Table2RowPanel p : selectedTable.getRows()) {
                        TableRowImpl i = (TableRowImpl)p;
                        i.enableVariantEdit();
                    }
                }, this.cloneButton);
            }
        }

        protected void enableVariantEdit() {
            this.startDate.showEditorAnyWay();
            this.endDate.showEditorAnyWay();
        }

        public void updateRowFields() {
            if (this.internalComment != null) {
                this.internalComment.setNode(this.model.getNode().getChildNamed(ProductVariantLight_.internalVariantComment));
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.stateRenderer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stateRenderer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stateRenderer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stateRenderer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                int nextIndex = 5;
                if (TableRowImpl.this.internalComment != null) {
                    TableRowImpl.this.internalComment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.internalComment.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.internalComment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.internalComment.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                    nextIndex = 6;
                }
                TableRowImpl.this.variantType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.variantType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.variantType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.variantType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(nextIndex);
                TableRowImpl.this.setControlsX(currentX);
                int ax = currentX + TableRowImpl.this.getCellPadding();
                if (TableRowImpl.this.cloneButton != null) {
                    TableRowImpl.this.cloneButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cloneButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cloneButton.setSize(TableRowImpl.this.cloneButton.getPreferredSize());
                    ax = TableRowImpl.this.cloneButton.getX() + TableRowImpl.this.cloneButton.getWidth() + TableRowImpl.this.getCellPadding();
                }
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(ax, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

