/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.PrintPopupInsert;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Date;
import java.util.List;

public class CopyProductVariantPopup
extends PrintPopupInsert {
    private static final long serialVersionUID = 1L;
    public Node variant;
    private final boolean defaultProductive;
    public Node retNode;
    private TitledItem<RadioButtonBox> variantTypes;
    private TitledItem<RadioButton> productive;
    private TitledItem<RadioButton> tender;

    public CopyProductVariantPopup(Node currentVariant, boolean defaultProductive) {
        super(true);
        this.variant = currentVariant;
        this.defaultProductive = defaultProductive;
        this.variantTypes = new TitledItem<RadioButtonBox>(new RadioButtonBox(), Words.INSERT_NEW_VARIANT_OF_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.variantTypes.setInnerGap(10);
        this.variantTypes.getElement().setBorder(0);
        this.productive = new TitledItem<RadioButton>(new RadioButton(), Words.PRODUCTIVE, TitledItem.TitledItemOrientation.EAST);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getUseProductTenderScenario())) {
            this.tender = new TitledItem<RadioButton>(new RadioButton(), Words.TENDER, TitledItem.TitledItemOrientation.EAST);
        }
        this.variantTypes.getElement().addBox(this.productive, this.productive.getElement());
        if (this.tender != null) {
            this.variantTypes.getElement().addBox(this.tender, this.tender.getElement());
        }
        if (defaultProductive) {
            this.productive.getElement().setChecked(true);
        } else if (this.tender != null) {
            this.tender.getElement().setChecked(true);
        }
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.variantTypes);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
    }

    @Override
    public void removeInheritedComponents() {
        this.variantTypes.setVisible(false);
    }

    @Override
    protected String getProgressText() {
        return "Copy Variant";
    }

    @Override
    protected String getFinishedText() {
        return "Variant successfully copied";
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.variantTypes.kill();
        this.variantTypes = null;
        this.tender = null;
        this.productive = null;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.retNode};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductVariantComplete copy;
                ProductVariantComplete org = (ProductVariantComplete)CopyProductVariantPopup.this.variant.getValue(ProductVariantComplete.class);
                if (org == null) {
                    ProductVariantReference l = (ProductVariantReference)CopyProductVariantPopup.this.variant.getValue(ProductVariantReference.class);
                    org = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(l).getValue();
                }
                if ((copy = CopyTemplateToolkit.copyProductVariant(org, false)).getSalesPrice() == null) {
                    copy.setSalesPrice(new PriceComplete(org.getMaterialPrice().getCurrency(), Double.valueOf(0.0)));
                }
                if (((RadioButton)CopyProductVariantPopup.this.productive.getElement()).isChecked()) {
                    copy.setTenderVariant(Boolean.valueOf(false));
                } else {
                    copy.setTenderVariant(Boolean.valueOf(true));
                }
                boolean useDefaultInsert = false;
                if (CopyProductVariantPopup.this.defaultProductive && ((RadioButton)CopyProductVariantPopup.this.productive.getElement()).isChecked()) {
                    useDefaultInsert = true;
                }
                if (!CopyProductVariantPopup.this.defaultProductive && CopyProductVariantPopup.this.tender != null && ((RadioButton)CopyProductVariantPopup.this.tender.getElement()).isChecked()) {
                    useDefaultInsert = true;
                }
                if (useDefaultInsert) {
                    long day = 86400000L;
                    if (org.getValidityPeriod().getStartDate().before(new Date(System.currentTimeMillis()))) {
                        if (org.getValidityPeriod().getEndDate().after(new Date(System.currentTimeMillis()))) {
                            copy.getValidityPeriod().setStartDate(new Date(System.currentTimeMillis()));
                            copy.getValidityPeriod().setEndDate(new Date(org.getValidityPeriod().getEndDate().getTime()));
                            org.getValidityPeriod().setEndDate(new Date(System.currentTimeMillis() - day));
                        } else {
                            copy.getValidityPeriod().setStartDate(new Date(org.getValidityPeriod().getStartDate().getTime() + day));
                            copy.getValidityPeriod().setEndDate(new Date(org.getValidityPeriod().getEndDate().getTime()));
                            org.getValidityPeriod().setEndDate(new Date(org.getValidityPeriod().getStartDate().getTime() + day));
                        }
                    } else {
                        copy.getValidityPeriod().setStartDate(new Date(org.getValidityPeriod().getStartDate().getTime() + day));
                        copy.getValidityPeriod().setEndDate(new Date(org.getValidityPeriod().getEndDate().getTime()));
                        org.getValidityPeriod().setEndDate(new Date(org.getValidityPeriod().getStartDate().getTime() + day));
                    }
                }
                CopyProductVariantPopup.this.variant.removeExistingValues();
                CopyProductVariantPopup.this.variant.setValue((Object)org, 0L);
                CopyProductVariantPopup.this.variant.updateNode();
                CopyProductVariantPopup.this.retNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)copy, true, false);
                Node newOne = CopyProductVariantPopup.this.retNode.getChildNamed(new String[]{"newOne"});
                if (newOne == null) {
                    newOne = new Node();
                    newOne.setName("newOne");
                    CopyProductVariantPopup.this.retNode.addChild(newOne, 0L);
                }
                if (org.getImageReference() != null) {
                    File f = null;
                    if (org.getImageReference().getId() != null) {
                        f = FileTransferUtil.download((PegasusFileComplete)org.getImageReference(), (FileTransferListener[])new FileTransferListener[0]);
                    } else if (org.getImageReference().getLocalFile() != null) {
                        f = org.getImageReference().getLocalFile();
                    }
                    if (f != null) {
                        PegasusFileComplete fr = new PegasusFileComplete();
                        fr.setClientOId(Long.valueOf(ADTO.getNextId()));
                        fr.setLocalFile(f);
                        CopyProductVariantPopup.this.retNode.getChildNamed(new String[]{"imageReference"}).setValue((Object)fr, 0L);
                    }
                }
                return CopyProductVariantPopup.this.retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return CopyProductVariantPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)((double)CopyProductVariantPopup.this.border + CopyProductVariantPopup.this.variantTypes.getPreferredSize().getHeight() + (double)CopyProductVariantPopup.this.border));
        }

        @Override
        public void layoutContainer(Container parent) {
            CopyProductVariantPopup.this.variantTypes.setLocation(CopyProductVariantPopup.this.border, CopyProductVariantPopup.this.border);
            CopyProductVariantPopup.this.variantTypes.setSize(CopyProductVariantPopup.this.variantTypes.getPreferredSize());
        }
    }
}

