/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.productcatalog.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.ProductCatalogTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SettingsDetailsPanel
extends StateDependantDetailsPanel<ProductCatalogLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> title;
    private TitledItem<RDSearchTextField2> customerSearch;
    private TitledItem<TextLabel> number;
    private TitledItem<RDImageChooser> imageChooser;
    private TitledPeriodEditor validPeriod;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDComboBox> catalogType;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDCheckBox> releaseForPrinting;

    public SettingsDetailsPanel(RowEditor<ProductCatalogLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CATALOG_SETTINGS);
        this.number = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerConverter.class)), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.INTERNAL_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.title = new TitledItem<RDTextField>(new RDTextField(provider), Words.TITLE, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearch = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.imageChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.TITLE_IMAGE, TitledItem.TitledItemOrientation.NORTH);
        this.validPeriod = new TitledPeriodEditor(null, null, true, provider);
        this.catalogType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ProductCatalogTypeConverter.class)), WordsToolkit.toCapitalLetter((String)Words.TYPE), TitledItem.TitledItemOrientation.NORTH);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ModificationStateEConverter.class)), WordsToolkit.toCapitalLetter((String)Words.STATE), TitledItem.TitledItemOrientation.NORTH);
        this.releaseForPrinting = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.RELEASE_FOR_PRINTING, TitledItem.TitledItemOrientation.EAST);
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.customerSearch);
        this.addToView(this.imageChooser);
        this.addToView(this.validPeriod);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.catalogType);
        this.addToView(this.state);
        this.addToView(this.releaseForPrinting);
        this.addToView(this.title);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductCatalogLight_.state;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            ProductCatalogLight dto = (ProductCatalogLight)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.name.getElement().setNode(node.getChildNamed(ProductCatalogLight_.internalName));
        this.title.getElement().setNode(node.getChildNamed(ProductCatalogLight_.title));
        this.customerSearch.getElement().setNode(node.getChildNamed(ProductCatalogLight_.customer));
        this.imageChooser.getElement().setNode(node.getChildNamed(ProductCatalogComplete_.titleImage));
        this.validPeriod.setStartDateNode(node.getChildNamed(ProductCatalogLight_.startDate));
        this.validPeriod.setEndDateNode(node.getChildNamed(ProductCatalogLight_.endDate));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(ProductCatalogComplete_.eligibleLocations));
        }
        this.catalogType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ProductCatalogTypeE.class));
        this.catalogType.getElement().setNode(node.getChildNamed(ProductCatalogLight_.catalogType));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        this.state.getElement().setNode(node.getChildNamed(ProductCatalogLight_.state));
        this.number.getElement().setNode(node.getChildNamed(ProductCatalogLight_.number));
        this.releaseForPrinting.getElement().setNode(node.getChildNamed(ProductCatalogLight_.releasedForPrinting));
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return this.imageChooser.getElement().commitImage();
    }

    public CustomerLight getCustomer() {
        return (CustomerLight)this.customerSearch.getElement().getNode().getValue();
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    public boolean validateUpdateInfo() {
        boolean isValid = true;
        if (this.getCustomer() == null) {
            this.customerSearch.getElement().setInvalid();
            isValid = false;
        }
        if (this.validPeriod.getStartDate() == null || this.validPeriod.getEndDate() == null) {
            this.validPeriod.setInvalid();
            isValid = false;
        }
        return isValid;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.title);
        CheckedListAdder.addToList(focusList, this.customerSearch);
        CheckedListAdder.addToList(focusList, this.imageChooser);
        CheckedListAdder.addToList(focusList, this.validPeriod);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.catalogType);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.releaseForPrinting);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.number = null;
        this.title.kill();
        this.title = null;
        this.name.kill();
        this.customerSearch.kill();
        this.name = null;
        this.customerSearch = null;
        this.imageChooser.kill();
        this.imageChooser = null;
        this.validPeriod.kill();
        this.validPeriod = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
        this.catalogType.kill();
        this.catalogType = null;
        this.state.kill();
        this.state = null;
        this.releaseForPrinting.kill();
        this.releaseForPrinting = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isDraft = this.isStateDraft();
        boolean eb = isDraft && isEnabled;
        this.name.setEnabled(eb);
        this.customerSearch.setEnabled(eb);
        this.imageChooser.setEnabled(eb);
        this.validPeriod.setEnabled(eb);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(eb);
        }
        this.catalogType.setEnabled(eb);
        this.number.setEnabled(eb);
        this.title.setEnabled(eb);
        if (!isDraft) {
            boolean changeAnyway = this.provider.isWritable(ProductCatalogAccess.REDRAFT_ACCEPTED);
            eb = changeAnyway && isEnabled;
        }
        this.state.setEnabled(eb);
        this.releaseForPrinting.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        PeriodComplete period = this.validPeriod.getPeriod();
        validationObjects.addAll(ValidationUtil.validatePeriod(period.getStartDate(), period.getEndDate(), this.validPeriod));
        if (this.name.getElement().isWritable() && (!this.name.getElement().isFieldValid() || this.name.getElement().getNode().getValue() == null || ((String)this.name.getElement().getNode().getValue()).equals(""))) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.customerSearch.getElement().isWritable() && this.customerSearch.getElement().getNode().getValue() == null) {
            this.customerSearch.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.CUSTOMER_NOT_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.AT_LEAST_ONE_LOCATION_MUST_BE_SET));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.imageChooser.getElement().addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.title.requestFocusInWindowNow();
    }

    public Date getStartDate() {
        return this.validPeriod.getStartDate();
    }

    public Date getEndDate() {
        return this.validPeriod.getEndDate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsDetailsPanel.this.number.setLocation(SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.number.setSize(75, (int)SettingsDetailsPanel.this.number.getPreferredSize().getHeight());
            SettingsDetailsPanel.this.title.setLocation(2 * SettingsDetailsPanel.this.horizontalBorder + 75, SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.title.setSize(parent.getWidth() - (3 * SettingsDetailsPanel.this.horizontalBorder + 75), (int)SettingsDetailsPanel.this.title.getPreferredSize().getHeight());
            SettingsDetailsPanel.this.name.setLocation(SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.title.getY() + SettingsDetailsPanel.this.title.getHeight() + SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.name.setSize(parent.getWidth() - 2 * SettingsDetailsPanel.this.horizontalBorder, (int)SettingsDetailsPanel.this.name.getPreferredSize().getHeight());
            SettingsDetailsPanel.this.customerSearch.setLocation(SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.name.getY() + SettingsDetailsPanel.this.name.getHeight() + SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.customerSearch.setSize(parent.getWidth() - 2 * SettingsDetailsPanel.this.horizontalBorder, (int)SettingsDetailsPanel.this.customerSearch.getPreferredSize().getHeight());
            SettingsDetailsPanel.this.imageChooser.setLocation(SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.customerSearch.getY() + SettingsDetailsPanel.this.customerSearch.getHeight() + SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.imageChooser.setSize(parent.getWidth() - 2 * SettingsDetailsPanel.this.horizontalBorder, (int)SettingsDetailsPanel.this.imageChooser.getPreferredSize().getHeight());
            SettingsDetailsPanel.this.validPeriod.setLocation(SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.imageChooser.getY() + SettingsDetailsPanel.this.imageChooser.getHeight() + SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.validPeriod.setSize((int)SettingsDetailsPanel.this.validPeriod.getPreferredSize().getWidth(), (int)SettingsDetailsPanel.this.validPeriod.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(SettingsDetailsPanel.this.viewSettings.getShowLocation())) {
                SettingsDetailsPanel.this.locations.setLocation(SettingsDetailsPanel.this.validPeriod.getX() + SettingsDetailsPanel.this.validPeriod.getWidth() + SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.validPeriod.getY());
                SettingsDetailsPanel.this.locations.setSize(parent.getWidth() - (SettingsDetailsPanel.this.locations.getX() + SettingsDetailsPanel.this.horizontalBorder), (int)SettingsDetailsPanel.this.locations.getPreferredSize().getHeight());
            }
            SettingsDetailsPanel.this.catalogType.setLocation(SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.validPeriod.getY() + SettingsDetailsPanel.this.validPeriod.getHeight() + SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.catalogType.setSize(120, (int)SettingsDetailsPanel.this.catalogType.getPreferredSize().getHeight());
            SettingsDetailsPanel.this.state.setLocation(SettingsDetailsPanel.this.catalogType.getX() + SettingsDetailsPanel.this.catalogType.getWidth() + SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.catalogType.getY());
            SettingsDetailsPanel.this.state.setSize(120, (int)SettingsDetailsPanel.this.state.getPreferredSize().getHeight());
            SettingsDetailsPanel.this.releaseForPrinting.setLocation(SettingsDetailsPanel.this.horizontalBorder, SettingsDetailsPanel.this.state.getY() + SettingsDetailsPanel.this.state.getHeight() + SettingsDetailsPanel.this.verticalBorder);
            SettingsDetailsPanel.this.releaseForPrinting.setSize(SettingsDetailsPanel.this.releaseForPrinting.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SettingsDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SettingsDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel.this.title.getPreferredSize().getHeight());
            h += SettingsDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel.this.customerSearch.getPreferredSize().getHeight());
            h += SettingsDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel.this.imageChooser.getPreferredSize().getHeight());
            h += SettingsDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel.this.validPeriod.getPreferredSize().getHeight());
            h += SettingsDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel.this.catalogType.getPreferredSize().getHeight());
            h += SettingsDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel.this.releaseForPrinting.getPreferredSize().getHeight());
            return new Dimension(200, h += SettingsDetailsPanel.this.verticalBorder);
        }
    }
}

