/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.productcatalog.details;

import ch.icit.pegasus.client.gui.modules.productcatalog.details.SettingsDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogTypeE;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsDetailsPanel2
extends StateDependantDetailsPanel<ProductCatalogLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextArea> comment;
    private TitledItem<RDSearchTextField2<MealPlanLight>> mealPlan;
    private TitledItem<RDCheckBox> autoGenerated;
    private SettingsDetailsPanel panel;

    public SettingsDetailsPanel2(RowEditor<ProductCatalogLight> editor, RDProvider provider, SettingsDetailsPanel panel) {
        super(editor, provider);
        this.panel = panel;
        this.setTitleText(Words.CATALOG_ATTRIBUTE);
        this.comment = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
        this.comment.setIgnorePrefHeight(true);
        this.mealPlan = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.MEALPLAN, true), Words.MEAL_PLAN, TitledItem.TitledItemOrientation.NORTH);
        this.autoGenerated = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.AUTO_GENERATED_FROM_MEALPLAN, TitledItem.TitledItemOrientation.EAST);
        if (editor.getModel().isAddRow()) {
            this.setNode(editor.getModel().getNode());
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.mealPlan);
        this.addToView(this.autoGenerated);
        this.addToView(this.comment);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductCatalogLight_.state;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.comment.getElement().setNode(node.getChildNamed(ProductCatalogComplete_.comment));
        this.mealPlan.getElement().setNode(node.getChildNamed(ProductCatalogComplete_.mealPlan));
        this.autoGenerated.getElement().setNode(node.getChildNamed(ProductCatalogComplete_.autoGenerated));
        Object[] o = new Object[]{node.getChildNamed(ProductCatalogLight_.customer)};
        this.mealPlan.getElement().setAdditionalSearchField(o);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.autoGenerated.getElement().isWritable() && this.mealPlan.getElement().isWritable() && this.autoGenerated.getElement().isChecked() && !this.mealPlan.getElement().isItemSelected()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_MEAL_PLAN_IS_DEFINED_FOR_AUTO_GENERATED_CATALOG));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.comment);
        CheckedListAdder.addToList(focusList, this.mealPlan);
        CheckedListAdder.addToList(focusList, this.autoGenerated);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.comment.kill();
        this.comment = null;
        this.mealPlan.kill();
        this.mealPlan = null;
        this.autoGenerated.kill();
        this.autoGenerated = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        this.comment.setEnabled(enabled);
        this.mealPlan.setEnabled(enabled);
        this.autoGenerated.setEnabled(enabled);
    }

    public ProductSearchConfiguration getSearchConf() {
        ProductSearchConfiguration p = new ProductSearchConfiguration();
        p.setPeriod(new PeriodComplete(this.panel.getStartDate(), this.panel.getEndDate()));
        p.setCatalogType((ProductCatalogTypeE)this.editor.getModel().getNode().getChildNamed(ProductCatalogComplete_.catalogType).getValue());
        return p;
    }

    public boolean getAutoGenerateMealPlan() {
        return this.autoGenerated.getElement().isChecked();
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int wh = (parent.getWidth() - (2 * SettingsDetailsPanel2.this.horizontalBorder + SettingsDetailsPanel2.this.inner_horizontalBorder)) / 2;
            SettingsDetailsPanel2.this.comment.setLocation(SettingsDetailsPanel2.this.horizontalBorder, SettingsDetailsPanel2.this.verticalBorder);
            SettingsDetailsPanel2.this.comment.setSize(wh, 150);
            SettingsDetailsPanel2.this.mealPlan.setLocation(SettingsDetailsPanel2.this.horizontalBorder, SettingsDetailsPanel2.this.comment.getY() + SettingsDetailsPanel2.this.comment.getHeight() + SettingsDetailsPanel2.this.inner_verticalBorder);
            SettingsDetailsPanel2.this.mealPlan.setSize(parent.getWidth() - 2 * SettingsDetailsPanel2.this.horizontalBorder, (int)SettingsDetailsPanel2.this.mealPlan.getPreferredSize().getHeight());
            SettingsDetailsPanel2.this.autoGenerated.setLocation(SettingsDetailsPanel2.this.horizontalBorder, SettingsDetailsPanel2.this.mealPlan.getY() + SettingsDetailsPanel2.this.mealPlan.getHeight() + SettingsDetailsPanel2.this.inner_verticalBorder);
            SettingsDetailsPanel2.this.autoGenerated.setSize(SettingsDetailsPanel2.this.autoGenerated.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SettingsDetailsPanel2.this.verticalBorder;
            h += SettingsDetailsPanel2.this.verticalBorder;
            h += 150;
            h += SettingsDetailsPanel2.this.inner_verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel2.this.mealPlan.getPreferredSize().getHeight());
            h += SettingsDetailsPanel2.this.inner_verticalBorder;
            h = (int)((double)h + SettingsDetailsPanel2.this.autoGenerated.getPreferredSize().getHeight());
            return new Dimension(200, h += SettingsDetailsPanel2.this.verticalBorder);
        }
    }
}

