/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow;

import ch.icit.pegasus.client.actions.impl.PrintPurchaseOrderForReceiving;
import ch.icit.pegasus.client.actions.impl.PrintPurchaseOrderSheet;
import ch.icit.pegasus.client.actions.impl.SendPurchaseOrderAction;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.DeliveryTermConverter;
import ch.icit.pegasus.client.converter.OrderDeliveryWindowConverter;
import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.ArticleOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.DeliveryTimeConverter;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.TableRowImpl;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.utils.IConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapterRegistry;
import ch.icit.pegasus.client.gui.utils.combobox.activators.SupplierActivationAdapter;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.SupplierScreenToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DeliveryTermComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.APurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierDeliveryCostTypeE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.util.PrinterToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<PurchaseOrderLight>
implements InnerPopUpListener2,
SearchTextField2Listener,
NodeListener,
IConfigurationDetailsPanel {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2<SupplierLight>> suppliers;
    private InfoButton supplierInfo;
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<ComboBox> deliveryWindow;
    private TitledItem<ComboBox> deliveryTerms;
    private TitledItem<DateChooser> orderDate;
    private TitledItem<CheckBox> sendOrderAfterCreation;
    private TitledItem<CheckBox> printReceiveSheet;
    private TitledItem<CheckBox> printOrderSheet;
    private ArticleOrderDetailsPanel articlePanel;
    private TitledItem<ComboBox> internalCostCenter;
    private TitledItem<ComboBox> customer;
    private TitledItem<ComboBox> deliveryAddress;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<CheckBox> reorder;
    private TitledItem<CheckBox> useTaxZone;
    private TitledItem<ComboBox> taxZone;
    private TitledItem<ComboBox> customerOwnedOnly;
    private TitledItem<ComboBox> halalOnly;
    private final boolean canSend;
    private final boolean canPrint;
    private boolean disablePopup = false;
    private boolean onlyAddFromTemplate;
    private boolean isNoPro = false;

    public ConfigurationDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONFIGURATION);
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        Node supplierNode = editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier);
        if (this.isNoPro) {
            NoProExchangeSettingsComplete noProSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue();
            supplierNode.setValue((Object)noProSettings.getNoProAsSupplier(), 0L);
        }
        this.suppliers = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(false, supplierNode), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.suppliers.getElement().addSearchTextFieldListener(this);
        this.suppliers.getElement().setDefaultActivationAdapter(ActivationAdapterRegistry.getAdapter(SupplierActivationAdapter.class));
        this.onlyAddFromTemplate = !provider.isWritable(APurchaseOrderAccess.CAN_ORDER_WITHOUT_TEMPLATE);
        this.canSend = provider.isWritable(APurchaseOrderAccess.SEND);
        this.canPrint = provider.isWritable(APurchaseOrderAccess.PRINT);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
            this.locations.getElement().setNode(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.eligibleLocations));
        }
        this.internalCostCenter = new TitledItem<ComboBox>(new ComboBox(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.costCenter), ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), null, ComboBoxFactory.DepartmentType.PURCHASE_ORDER), ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.internalCostCenter.getElement().refreshPossibleValues(ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), null, ComboBoxFactory.DepartmentType.PURCHASE_ORDER));
        this.customer = new TitledItem<ComboBox>(new ComboBox(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.customer), NodeToolkit.getAffixList(ExternalCostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        boolean mixedOrdersAllowed = Boolean.TRUE.equals(this.settings.getAllowMixedOrdersWithCustomerOwnedArticles());
        this.customerOwnedOnly = new TitledItem<ComboBox>(ComboBoxFactory.getCustomerOwned(mixedOrdersAllowed), Words.CUSTOMER_OWNED_ONLY, TitledItem.TitledItemOrientation.NORTH);
        if (mixedOrdersAllowed) {
            this.customerOwnedOnly.getElement().setSelectedItem(Words.ALL);
        } else {
            this.customerOwnedOnly.getElement().setSelectedItem(Words.CUSTOMER_OWNED_ONLY);
        }
        this.customerOwnedOnly.getElement().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if (e.getItem().equals(Words.ALL)) {
                    editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).setValue(null, 0L);
                } else if (e.getItem().equals(Words.CUSTOMER_OWNED)) {
                    editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).setValue((Object)true, 0L);
                } else if (e.getItem().equals(Words.NOT_CUSTOMER_OWNED)) {
                    editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).setValue((Object)false, 0L);
                }
            }
        });
        boolean withAll = Boolean.TRUE.equals(this.viewSettings.getUseHalalOnlyOrders());
        this.halalOnly = new TitledItem<ComboBox>(ComboBoxFactory.getHalal(!withAll), Words.HALAL_ORDER, TitledItem.TitledItemOrientation.NORTH);
        if (!withAll) {
            this.halalOnly.getElement().setSelectedItem(Words.ALL);
            editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.halalOrder).setValue(null, 0L);
        } else {
            this.halalOnly.getElement().setSelectedItem(Words.NOT_HALAL_ONLY);
            editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.halalOrder).setValue((Object)false, 0L);
        }
        this.halalOnly.getElement().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if (e.getItem().equals(Words.ALL)) {
                    editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).setValue(null, 0L);
                } else if (e.getItem().equals(Words.HALAL_ONLY)) {
                    editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).setValue((Object)true, 0L);
                } else if (e.getItem().equals(Words.NOT_HALAL_ONLY)) {
                    editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).setValue((Object)false, 0L);
                }
            }
        });
        Node n1 = editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryDate);
        if (n1.getValue() == null) {
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(System.currentTimeMillis());
            c.add(6, 1);
            n1.setValue((Object)new Date(c.getTimeInMillis()), 0L);
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryAddress).getValue() == null) {
            editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryAddress).setValue((Object)settings.getDefaultDeliveryAddress(), 0L);
        }
        this.deliveryAddress = new TitledItem<ComboBox>(new ComboBox(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryAddress), NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(SystemSettingsComplete_.deliveryAddresses), ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
        this.supplierInfo = new InfoButton();
        Node n2 = editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDeliveryWindow);
        if (n2.getValue() == null) {
            n2.setValue((Object)settings.getDefaultReceiveWindow(), 0L);
        }
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(n1), Words.SCHEDULED_DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryWindow = new TitledItem<ComboBox>(new ComboBox(n2, NodeToolkit.getAffixList(OrderDeliveryWindowComplete.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class), ConverterRegistry.getConverter(OrderDeliveryWindowConverter.class)), Words.DELIVERY_TIME_WINDOW, TitledItem.TitledItemOrientation.NORTH);
        Node n3 = editor.getModel().getNode().getChildNamed(new String[]{"orderDate"});
        if (n3.getValue() == null) {
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(System.currentTimeMillis());
            n3.setValue((Object)new Date(c.getTimeInMillis()), 0L);
        }
        this.orderDate = new TitledItem<DateChooser>(new DateChooser(n3), Words.ORDER_DATE, TitledItem.TitledItemOrientation.NORTH);
        if (editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryTerm).getValue() == null) {
            editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryTerm).setValue((Object)settings.getDefaultDeliveryTerm(), 0L);
        }
        this.deliveryTerms = new TitledItem<ComboBox>(new ComboBox(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryTerm), NodeToolkit.getAffixList(DeliveryTermComplete.class), ConverterRegistry.getConverter(DeliveryTermConverter.class)), Words.INCO_TERMS, TitledItem.TitledItemOrientation.NORTH);
        this.sendOrderAfterCreation = new TitledItem<CheckBox>(new CheckBox(), Words.SEND_PURCHASE_ORDER, TitledItem.TitledItemOrientation.EAST);
        this.sendOrderAfterCreation.getElement().setChecked(settings.getSendPurchaseOrderAfterCreation());
        this.printReceiveSheet = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_RECEIVE_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.printReceiveSheet.getElement().setChecked(settings.getSendOrderToReceiver());
        this.printOrderSheet = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_ORDER_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.printOrderSheet.getElement().setChecked(false);
        this.reorder = new TitledItem<CheckBox>(new CheckBox(), Words.REORDER, TitledItem.TitledItemOrientation.EAST);
        this.reorder.getElement().setChecked(false);
        if (this.canChooseTaxZone()) {
            this.useTaxZone = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.useTaxZone)), Words.USE_TAX_ZONE, TitledItem.TitledItemOrientation.EAST);
            this.taxZone = new TitledItem<ComboBox>(new ComboBox(editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone), NodeToolkit.getAffixList(TaxZoneComplete.class), ConverterRegistry.getConverter(TaxZoneConverter.class), true), Words.TAX_ZONE, TitledItem.TitledItemOrientation.NORTH);
            this.useTaxZone.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        }
        this.setCustomLayouter(new Layout());
        ((DeliveryTimeConverter)ConverterRegistry.getConverter(DeliveryTimeConverter.class)).setCurrentSupplier((SupplierReference)supplierNode.getValue());
        supplierNode.addNodeListener((NodeListener)this);
        if (this.isNoPro) {
            this.popUpClosed(null, this);
        }
        this.addToView(this.suppliers);
        this.addToView(this.internalCostCenter);
        this.addToView(this.customer);
        this.addToView(this.deliveryDate);
        this.addToView(this.deliveryWindow);
        this.addToView(this.deliveryAddress);
        this.addToView(this.deliveryTerms);
        this.addToView(this.sendOrderAfterCreation);
        this.addToView(this.printReceiveSheet);
        this.addToView(this.printOrderSheet);
        this.addToView(this.supplierInfo);
        this.addToView(this.orderDate);
        this.addToView(this.reorder);
        this.addToView(this.customerOwnedOnly);
        this.addToView(this.halalOnly);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        if (this.canChooseTaxZone()) {
            this.addToView(this.useTaxZone);
            this.addToView(this.taxZone);
        }
        this.setEnabled(this.isEnabled());
    }

    private boolean canChooseTaxZone() {
        return Boolean.TRUE.equals(this.settings.getAllowTaxZoneRelatedSupplierCondition());
    }

    @Override
    public boolean isSupplierChoosen() {
        return this.suppliers.getElement().isItemSelected();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        boolean mixedOrdersAllowed;
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.canSend && this.sendOrderAfterCreation.getElement().isChecked()) {
            if (!this.editor.getModel().hasActionType(SendPurchaseOrderAction.class)) {
                this.editor.getModel().addClientAction(new SendPurchaseOrderAction());
            }
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            SupplierComplete supplier = (SupplierComplete)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierComplete.class);
            if (user.getContact().getEmail() == null || user.getContact().getEmail().isEmpty()) {
                this.sendOrderAfterCreation.getElement().setInvalid();
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Your EMail Address is not set. Unable to send Order EMail"));
            }
            if (supplier == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Supplier selected."));
            } else if ((supplier.getOrderContactNumber() == null || supplier.getOrderContactNumber().isEmpty()) && (supplier.getOrderContact().getEmail() == null || supplier.getOrderContact().getEmail().isEmpty())) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "EMail of Supplier's Order Contact not set. Unable to send Order EMail"));
            }
        }
        if (this.canPrint && this.printReceiveSheet.getElement().isChecked()) {
            if (!this.editor.getModel().hasActionType(PrintPurchaseOrderForReceiving.class)) {
                this.editor.getModel().addClientAction(new PrintPurchaseOrderForReceiving());
            }
            if (PrinterToolkit.getDefaultPrinter() == null) {
                this.printReceiveSheet.getElement().setInvalid();
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "No default Printer defined. Unable to print Purchase Receive Order Sheet"));
            }
        }
        if (this.canPrint && this.printOrderSheet.getElement().isChecked()) {
            if (!this.editor.getModel().hasActionType(PrintPurchaseOrderSheet.class)) {
                this.editor.getModel().addClientAction(new PrintPurchaseOrderSheet());
            }
            if (PrinterToolkit.getDefaultPrinter() == null) {
                this.printOrderSheet.getElement().setInvalid();
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "No default Printer defined. Unable to print Purchase Order Sheet"));
            }
        }
        if (this.suppliers.getElement().getNode().getValue() == null) {
            this.suppliers.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Supplier must be set"));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            if (this.locations.getElement().getNode().getChildCount() == 0) {
                this.locations.getElement().setInvalid();
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Location is set"));
            } else if (this.locations.getElement().getNode().getChildCount() > 1) {
                this.locations.getElement().setInvalid();
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure only one Location is set"));
            }
        }
        if (this.deliveryDate.getElement().getNode().getValue() == null) {
            this.deliveryDate.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Delivery Date is set"));
        }
        if (this.orderDate.getElement().getNode().getValue() == null) {
            this.orderDate.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Order Date is set"));
        }
        if (!(mixedOrdersAllowed = Boolean.TRUE.equals(this.settings.getAllowMixedOrdersWithCustomerOwnedArticles()))) {
            String articlesToRemove;
            Boolean customerOwnedOnly = (Boolean)this.editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).getValue();
            Boolean halalOrder = (Boolean)this.editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).getValue();
            boolean foundOwnedArticle = false;
            boolean foundNotOwnedArticle = false;
            boolean foundHalalArticle = false;
            boolean foundNotHalalArticle = false;
            HashSet<BasicArticleLight> ownedArticles = new HashSet<BasicArticleLight>();
            HashSet<BasicArticleLight> notOwnedArticles = new HashSet<BasicArticleLight>();
            HashSet<BasicArticleLight> halalArticles = new HashSet<BasicArticleLight>();
            HashSet<BasicArticleLight> notHalalArticles = new HashSet<BasicArticleLight>();
            Iterator it = this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderPositions).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node position = (Node)it.next();
                BasicArticleLight article = (BasicArticleLight)position.getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleLight.class);
                if (Boolean.TRUE.equals(article.getCustomerIsOwner())) {
                    foundOwnedArticle = true;
                    ownedArticles.add(article);
                } else {
                    foundNotOwnedArticle = true;
                    notOwnedArticles.add(article);
                }
                if (Boolean.TRUE.equals(article.getHalal())) {
                    foundHalalArticle = true;
                    halalArticles.add(article);
                    continue;
                }
                foundNotHalalArticle = true;
                notHalalArticles.add(article);
            }
            if (Boolean.TRUE.equals(halalOrder) && foundNotHalalArticle) {
                articlesToRemove = "";
                for (BasicArticleLight article : notHalalArticles) {
                    articlesToRemove = articlesToRemove + article.getNumber() + ",";
                }
                articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "This order can only contains 'halal' articles, please remove article " + articlesToRemove));
            } else if (Boolean.FALSE.equals(halalOrder) && foundHalalArticle) {
                articlesToRemove = "";
                for (BasicArticleLight article : halalArticles) {
                    articlesToRemove = articlesToRemove + article.getNumber() + ",";
                }
                articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "This order can only contains 'not halal' articles, please remove article " + articlesToRemove));
            }
            if (Boolean.TRUE.equals(customerOwnedOnly) && foundNotOwnedArticle) {
                articlesToRemove = "";
                for (BasicArticleLight article : notOwnedArticles) {
                    articlesToRemove = articlesToRemove + article.getNumber() + ",";
                }
                articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "This order can only contains 'customer owned' articles, please remove article " + articlesToRemove));
            } else if (Boolean.FALSE.equals(customerOwnedOnly) && foundOwnedArticle) {
                articlesToRemove = "";
                for (BasicArticleLight article : ownedArticles) {
                    articlesToRemove = articlesToRemove + article.getNumber() + ",";
                }
                articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "This order can only contains 'not customer owned' articles, please remove article " + articlesToRemove));
            }
        }
        return o;
    }

    public void setArticlePanel(ArticleOrderDetailsPanel panel) {
        this.articlePanel = panel;
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.suppliers);
        CheckedListAdder.addToList(focusList, this.internalCostCenter);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.orderDate);
        CheckedListAdder.addToList(focusList, this.deliveryWindow);
        CheckedListAdder.addToList(focusList, this.deliveryAddress);
        CheckedListAdder.addToList(focusList, this.deliveryTerms);
        CheckedListAdder.addToList(focusList, this.customerOwnedOnly);
        CheckedListAdder.addToList(focusList, this.halalOnly);
        CheckedListAdder.addToList(focusList, this.sendOrderAfterCreation);
        CheckedListAdder.addToList(focusList, this.printReceiveSheet);
        CheckedListAdder.addToList(focusList, this.printOrderSheet);
        CheckedListAdder.addToList(focusList, this.reorder);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.useTaxZone);
        CheckedListAdder.addToList(focusList, this.taxZone);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.suppliers.kill();
        this.suppliers = null;
        this.supplierInfo.kill();
        this.supplierInfo = null;
        this.internalCostCenter.kill();
        this.internalCostCenter = null;
        this.customer.kill();
        this.customer = null;
        this.deliveryWindow.kill();
        this.deliveryWindow = null;
        this.deliveryDate.kill();
        this.deliveryDate = null;
        this.deliveryAddress.kill();
        this.deliveryAddress = null;
        this.deliveryTerms.kill();
        this.deliveryTerms = null;
        this.sendOrderAfterCreation.kill();
        this.sendOrderAfterCreation = null;
        this.printReceiveSheet.kill();
        this.printReceiveSheet = null;
        this.printOrderSheet.kill();
        this.printOrderSheet = null;
        this.orderDate.kill();
        this.orderDate = null;
        this.customerOwnedOnly.kill();
        this.customerOwnedOnly = null;
        this.halalOnly.kill();
        this.halalOnly = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
        this.reorder.kill();
        this.reorder = null;
        if (this.canChooseTaxZone()) {
            this.taxZone.kill();
            this.taxZone = null;
            this.useTaxZone.kill();
            this.useTaxZone = null;
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isNoPro) {
            this.suppliers.setEnabled(false);
        } else {
            this.suppliers.setEnabled(isEnabled && !this.onlyAddFromTemplate);
        }
        this.supplierInfo.setEnabled(isEnabled);
        this.internalCostCenter.setEnabled(isEnabled && !this.onlyAddFromTemplate);
        this.customer.setEnabled(isEnabled && !this.onlyAddFromTemplate);
        this.deliveryWindow.setEnabled(isEnabled);
        this.deliveryDate.setEnabled(isEnabled);
        this.orderDate.setEnabled(isEnabled);
        this.deliveryAddress.setEnabled(isEnabled);
        this.deliveryTerms.setEnabled(isEnabled);
        this.sendOrderAfterCreation.setEnabled(isEnabled && this.canSend);
        this.printReceiveSheet.setEnabled(isEnabled && this.canPrint);
        this.printOrderSheet.setEnabled(isEnabled && this.canPrint);
        this.customerOwnedOnly.setEnabled(isEnabled);
        this.halalOnly.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
        this.reorder.setEnabled(isEnabled);
        if (this.canChooseTaxZone()) {
            this.useTaxZone.setEnabled(isEnabled);
            this.taxZone.setEnabled(isEnabled && this.useTaxZone.getElement().isChecked());
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            this.fireFocusCycleChanged(this);
        } else {
            if (this.suppliers.getElement().getNode().getValue(SupplierComplete.class) != null) {
                this.remoteObjectLoaded(this.suppliers.getElement().getNode());
            } else {
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        SupplierLight s = (SupplierLight)((SearchTextField2)ConfigurationDetailsPanel.this.suppliers.getElement()).getNode().getValue();
                        SupplierComplete ss = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier((SupplierReference)s).getValue();
                        if (ss == null) {
                            throw new ClientServerCallException("Error while load Supplier. Please restart CATIT");
                        }
                        if (ss.getCostType() == null) {
                            ss.setCostType(SupplierDeliveryCostTypeE.NONE);
                        }
                        ((SearchTextField2)ConfigurationDetailsPanel.this.suppliers.getElement()).getNode().setValue((Object)ss, 0L);
                        return ((SearchTextField2)ConfigurationDetailsPanel.this.suppliers.getElement()).getNode();
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return ConfigurationDetailsPanel.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
            if (!this.disablePopup) {
                this.articlePanel.clearRows();
            }
        }
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        SupplierLight supplier = (SupplierLight)n.getValue();
        if (supplier != null) {
            this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDeliveryWindow).setValue((Object)supplier.getDefaultDeliveryWindow(), 0L);
            if (!StringUtil.isBlank((String)supplier.getDefaultOrderRemark())) {
                this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.remark).setValue((Object)supplier.getDefaultOrderRemark(), 0L);
            }
        }
        if (this.articlePanel != null && this.articlePanel.getTable() != null && this.articlePanel.getTable().getRowCount() != 0 && !this.disablePopup) {
            InnerPopupFactory.showMessageDialog("Supplier changed, all existing Order Positions will be removed.", "Attention", (source1, xargs) -> {
                Iterator it = this.editor.getModel().getNode().getChildNamed(new String[]{"orderPositions"}).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node m = (Node)it.next();
                    this.editor.getModel().getNode().getChildNamed(new String[]{"orderPositions"}).removeChild(m, 0L);
                }
            }, (Component)source);
        } else {
            this.popUpClosed(null, "");
        }
        this.disablePopup = false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        SupplierComplete sup = (SupplierComplete)node.getValue(SupplierComplete.class);
        ((DeliveryTimeConverter)ConverterRegistry.getConverter(DeliveryTimeConverter.class)).setCurrentSupplier((SupplierReference)sup);
        this.articlePanel.setSupplierSet();
        this.supplierInfo.installStringViewer(SupplierScreenToolkit.getSupplierConditionString(sup));
        this.fireFocusCycleChanged(this);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.suppliers.requestFocusInWindowNow();
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    @Override
    public Date getDeliveryDate() {
        return (Date)this.deliveryDate.getElement().getNode().getValue();
    }

    public void valueChanged(Node<?> node) {
        this.disablePopup = true;
        this.updatePositions();
    }

    private void updatePositions() {
        for (Table2RowPanel row : this.articlePanel.getTable().getRows()) {
            TableRowImpl rowImpl = (TableRowImpl)row;
            rowImpl.updatePosition(this, false);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigurationDetailsPanel.this.suppliers.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.suppliers.setSize(200, (int)ConfigurationDetailsPanel.this.suppliers.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.supplierInfo.setLocation(ConfigurationDetailsPanel.this.suppliers.getX() + ConfigurationDetailsPanel.this.suppliers.getWidth() + ConfigurationDetailsPanel.this.inner_horizontalBorder, (int)((double)(ConfigurationDetailsPanel.this.suppliers.getY() + ConfigurationDetailsPanel.this.suppliers.getHeight()) - (ConfigurationDetailsPanel.this.supplierInfo.getPreferredSize().getHeight() + 3.0)));
            ConfigurationDetailsPanel.this.supplierInfo.setSize(ConfigurationDetailsPanel.this.supplierInfo.getPreferredSize());
            ConfigurationDetailsPanel.this.internalCostCenter.setLocation(ConfigurationDetailsPanel.this.supplierInfo.getX() + ConfigurationDetailsPanel.this.supplierInfo.getWidth() + ConfigurationDetailsPanel.this.inner_horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.internalCostCenter.setSize(250, (int)ConfigurationDetailsPanel.this.internalCostCenter.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.customer.setLocation(ConfigurationDetailsPanel.this.supplierInfo.getX() + ConfigurationDetailsPanel.this.supplierInfo.getWidth() + ConfigurationDetailsPanel.this.inner_horizontalBorder, ConfigurationDetailsPanel.this.internalCostCenter.getY() + ConfigurationDetailsPanel.this.internalCostCenter.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.customer.setSize(250, (int)ConfigurationDetailsPanel.this.customer.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.deliveryDate.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.customer.getY() + ConfigurationDetailsPanel.this.customer.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.deliveryDate.setSize(ConfigurationDetailsPanel.this.deliveryDate.getPreferredSize());
            ConfigurationDetailsPanel.this.deliveryWindow.setLocation(ConfigurationDetailsPanel.this.internalCostCenter.getX(), ConfigurationDetailsPanel.this.customer.getY() + ConfigurationDetailsPanel.this.customer.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.deliveryWindow.setSize(250, (int)ConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.deliveryAddress.setLocation(ConfigurationDetailsPanel.this.internalCostCenter.getX(), ConfigurationDetailsPanel.this.deliveryWindow.getY() + ConfigurationDetailsPanel.this.deliveryWindow.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.deliveryAddress.setSize(250, (int)ConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.orderDate.setLocation(ConfigurationDetailsPanel.this.deliveryDate.getX(), ConfigurationDetailsPanel.this.deliveryAddress.getY());
            ConfigurationDetailsPanel.this.orderDate.setSize(ConfigurationDetailsPanel.this.orderDate.getPreferredSize());
            ConfigurationDetailsPanel.this.deliveryTerms.setLocation(ConfigurationDetailsPanel.this.deliveryAddress.getX(), ConfigurationDetailsPanel.this.deliveryAddress.getY() + ConfigurationDetailsPanel.this.deliveryAddress.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.deliveryTerms.setSize(250, (int)ConfigurationDetailsPanel.this.deliveryTerms.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.customerOwnedOnly.setLocation(ConfigurationDetailsPanel.this.deliveryTerms.getX(), ConfigurationDetailsPanel.this.deliveryTerms.getY() + ConfigurationDetailsPanel.this.deliveryTerms.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.customerOwnedOnly.setSize(250, (int)ConfigurationDetailsPanel.this.customerOwnedOnly.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.halalOnly.setLocation(ConfigurationDetailsPanel.this.deliveryTerms.getX(), ConfigurationDetailsPanel.this.customerOwnedOnly.getY() + ConfigurationDetailsPanel.this.customerOwnedOnly.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.halalOnly.setSize(250, (int)ConfigurationDetailsPanel.this.halalOnly.getPreferredSize().getHeight());
            int cy = ConfigurationDetailsPanel.this.halalOnly.getY() + ConfigurationDetailsPanel.this.halalOnly.getHeight();
            if (Boolean.TRUE.equals(ConfigurationDetailsPanel.this.viewSettings.getShowLocation())) {
                ConfigurationDetailsPanel.this.locations.setLocation(ConfigurationDetailsPanel.this.deliveryDate.getX(), ConfigurationDetailsPanel.this.halalOnly.getY() + ConfigurationDetailsPanel.this.halalOnly.getHeight());
                ConfigurationDetailsPanel.this.locations.setSize(ConfigurationDetailsPanel.this.locations.getPreferredSize());
                cy = ConfigurationDetailsPanel.this.locations.getY() + ConfigurationDetailsPanel.this.locations.getHeight();
            }
            if (ConfigurationDetailsPanel.this.canChooseTaxZone()) {
                ConfigurationDetailsPanel.this.useTaxZone.setLocation(ConfigurationDetailsPanel.this.deliveryDate.getX(), cy + ConfigurationDetailsPanel.this.verticalBorder * 2);
                ConfigurationDetailsPanel.this.useTaxZone.setSize(ConfigurationDetailsPanel.this.useTaxZone.getPreferredSize());
                ConfigurationDetailsPanel.this.taxZone.setLocation(ConfigurationDetailsPanel.this.deliveryDate.getX(), ConfigurationDetailsPanel.this.useTaxZone.getY() + ConfigurationDetailsPanel.this.useTaxZone.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
                ConfigurationDetailsPanel.this.taxZone.setSize(75, (int)ConfigurationDetailsPanel.this.taxZone.getPreferredSize().getHeight());
            }
            ConfigurationDetailsPanel.this.sendOrderAfterCreation.setLocation(ConfigurationDetailsPanel.this.halalOnly.getX(), ConfigurationDetailsPanel.this.halalOnly.getY() + ConfigurationDetailsPanel.this.halalOnly.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.sendOrderAfterCreation.setSize(250, (int)ConfigurationDetailsPanel.this.sendOrderAfterCreation.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.printReceiveSheet.setLocation(ConfigurationDetailsPanel.this.sendOrderAfterCreation.getX(), ConfigurationDetailsPanel.this.sendOrderAfterCreation.getY() + ConfigurationDetailsPanel.this.sendOrderAfterCreation.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.printReceiveSheet.setSize(250, (int)ConfigurationDetailsPanel.this.printReceiveSheet.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.printOrderSheet.setLocation(ConfigurationDetailsPanel.this.printReceiveSheet.getX(), ConfigurationDetailsPanel.this.printReceiveSheet.getY() + ConfigurationDetailsPanel.this.printReceiveSheet.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.printOrderSheet.setSize(250, (int)ConfigurationDetailsPanel.this.printOrderSheet.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.reorder.setLocation(ConfigurationDetailsPanel.this.printReceiveSheet.getX(), ConfigurationDetailsPanel.this.printOrderSheet.getY() + ConfigurationDetailsPanel.this.printOrderSheet.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.reorder.setSize(250, (int)ConfigurationDetailsPanel.this.reorder.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.suppliers.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.deliveryTerms.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.customerOwnedOnly.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.halalOnly.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.sendOrderAfterCreation.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.printReceiveSheet.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.printOrderSheet.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.reorder.getPreferredSize().getHeight());
            return new Dimension(0, h += ConfigurationDetailsPanel.this.verticalBorder);
        }
    }
}

