/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.ArticleOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.SequenceNumberSorter;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.PurchaseOrderTemplateSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplatePositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplatePositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateReference;
import ch.icit.pegasus.server.core.dtos.ordering.template.PurchaseOrderTemplateComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.PurchaseOrderTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.search.PurchaseOrderTemplateSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TemplateDetailsPanel<T extends ADTO>
extends DefaultDetailsPanel<T>
implements Table2RowSelectionListener,
ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    protected SearchTextField searchField;
    protected SearchComboBox supplier;
    protected ComboBox costCenter;
    protected PageableTable2 table;
    private TextButton load;
    protected String fc1;
    protected SupplierLight fc2;
    protected CostCenterComplete fc3;
    protected boolean withSupplier;
    private ArticleOrderDetailsPanel panel;
    private boolean onlyAddFromTemplate;

    public TemplateDetailsPanel(RowEditor<T> editor, RDProvider provider, ArticleOrderDetailsPanel panel, boolean withSupplier) {
        super(editor, provider, true, true, true);
        this.panel = panel;
        this.withSupplier = withSupplier;
        this.onlyAddFromTemplate = !provider.isWritable(PurchaseOrderAccess.CAN_ORDER_WITHOUT_TEMPLATE);
        this.setTitleText(Words.TEMPLATE);
        this.table = new PageableTable2(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return TemplateDetailsPanel.this.getCurrentSearcher();
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                return TemplateDetailsPanel.this.filterChainValueChanged(id, value);
            }

            @Override
            public void fillFilterChain() {
                this.filterChain.setDefault_comboBoxWidth(250);
                TemplateDetailsPanel.this.searchField = this.filterChain.addSeachField("namesearch", "NAME");
                if (TemplateDetailsPanel.this.withSupplier) {
                    TemplateDetailsPanel.this.supplier = this.filterChain.addSupplierSearch("suppliersearch", "SUPPLIER");
                }
                TemplateDetailsPanel.this.costCenter = this.filterChain.addSelectionCombo("costcentersearch", TemplateDetailsPanel.this.getCostCenterTitleName(), new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class), true));
            }
        };
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 200, 200, 200));
        columns.add(new TableColumnInfo(Words.DEPARTMENT, null, null, null, "", 200, 200, 200));
        if (this.withSupplier) {
            columns.add(new TableColumnInfo(Words.SUPPLIER, null, null, null, "", 200, 200, 200));
        }
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        if (this.withSupplier) {
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        }
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)){

            @Override
            public boolean checkIfIsToAdd(Node node) {
                if (TemplateDetailsPanel.this.onlyAddFromTemplate) {
                    UserComplete currentUser1 = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                    Node users = node.getChildNamed(OrderTemplateComplete_.templateUsers);
                    if (((List)users.getValue()).isEmpty()) {
                        return true;
                    }
                    Iterator it = users.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node u = (Node)it.next();
                        if (!u.getValue().equals(currentUser1)) continue;
                        return true;
                    }
                    return false;
                }
                return super.checkIfIsToAdd(node);
            }
        });
        this.table.getModel().addTableSelectionListener(this);
        this.table.getModel().setNode((Node)new ListNode());
        this.load = new TextButton(Words.LOAD_TEMPLATE);
        this.load.setEnabled(false);
        this.load.addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
        this.addToView(this.load);
    }

    public SearchAlgorithm getCurrentSearcher() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(PurchaseOrderTemplateSearchAlgorithm.class);
    }

    public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterChainValueChanged(String id, Object value) {
        if (id != null) {
            if (id.equals(this.searchField.getID())) {
                this.fc1 = (String)value;
            } else if (this.withSupplier && id.equals(this.supplier.getID())) {
                this.fc2 = value instanceof SupplierLight ? (SupplierLight)value : (value instanceof Node ? (SupplierLight)((Node)value).getValue() : null);
            } else if (id.equals(this.costCenter.getID())) {
                this.fc3 = value instanceof CostCenterComplete ? (CostCenterComplete)value : (value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : null);
            }
        }
        PurchaseOrderTemplateSearchConfiguration c = new PurchaseOrderTemplateSearchConfiguration();
        c.setName(this.fc1);
        c.setSupplier(this.fc2);
        c.setCostCenter(this.fc3);
        c.setSortDirection(SortDirection.ASCENDING);
        c.setSortColumn((Enum)PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN.NAME);
        c.setPageNumber(this.table.getPagination().getCurrentPage() - 1);
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.load.setEnabled(isEnabled && this.table.getModel().getSelectedNode() != null);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.load.kill();
        this.table = null;
        this.load = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        CheckedListAdder.addToList(focusList, this.load);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.costCenter.refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.table.invokeDefaultSearch();
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        this.load.setEnabled(true);
    }

    public Node<?> convertTemplatePositionToOrderPosition(OrderTemplatePositionComplete position, SupplierReference supplier) throws ClientServerCallException {
        PurchaseOrderPositionComplete pos = new PurchaseOrderPositionComplete();
        pos.setClientOId(Long.valueOf(ADTO.getNextId()));
        pos.setDeliveryDate(new Date(System.currentTimeMillis()));
        pos.setArticle(position.getArticle());
        pos.setReviewState(OrderReviewStateE.UNCHECKED);
        Boolean useTaxZone = (Boolean)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
        TaxZoneComplete taxZone = (TaxZoneComplete)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
        pos.setSequenceNumber(position.getSequence());
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos, true, false);
        if (n.getChildNamed(OrderTemplatePositionComplete_.article).getValue(BasicArticleComplete.class) == null) {
            BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(pos.getArticle().getId())).getValue();
            n.getChildNamed(OrderTemplatePositionComplete_.article).setValue((Object)artC, 0L);
        }
        return ArticleOrderDetailsPanel.initArticle(n, supplier, this, useTaxZone, taxZone, new Timestamp(System.currentTimeMillis()));
    }

    public Node<?> getPositionNode() {
        return this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderPositions);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.load) {
            Node<?> positions = this.getPositionNode();
            if (positions.getChildCount() > 0) {
                InnerPopupFactory.showDesicionPopup(Words.USE_TEMPLATE, Words.YOU_TRY_TO_LOAD_TEMPLATE, source, this, 250, -1, PopupType.FATAL);
            } else {
                this.popUpClosed(null, positions);
            }
        }
    }

    public DtoField<CostCenterComplete> getCostCenterFieldName() {
        return PurchaseOrderComplete_.costCenter;
    }

    public String getCostCenterTitleName() {
        return "Department";
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            return;
        }
        this.editor.showCommittingAnimation(Words.LOAD_TEMPLATE);
        this.editor.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node<?> positions = TemplateDetailsPanel.this.getPositionNode();
                Iterator it = positions.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    positions.removeChild(n, System.currentTimeMillis());
                }
                Node selectedNode = TemplateDetailsPanel.this.table.getModel().getSelectedNode();
                if (TemplateDetailsPanel.this.supplier != null) {
                    TemplateDetailsPanel.this.editor.getModel().getNode().getChildNamed(new String[]{"supplier"}).setValue(selectedNode.getChildNamed(PurchaseOrderTemplateComplete_.supplier).getValue(), System.currentTimeMillis());
                }
                TemplateDetailsPanel.this.editor.getModel().getNode().getChildNamed(TemplateDetailsPanel.this.getCostCenterFieldName()).setValue(selectedNode.getChildNamed(PurchaseOrderTemplateComplete_.costCenter).getValue(), System.currentTimeMillis());
                ScreenValidationList warnings = new ScreenValidationList();
                try {
                    OrderTemplateReference temp = (OrderTemplateReference)selectedNode.getValue();
                    PurchaseOrderTemplateComplete comp = (PurchaseOrderTemplateComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderTemplate(temp).getValue();
                    for (OrderTemplatePositionComplete p : comp.getPositions()) {
                        Node<?> np = TemplateDetailsPanel.this.convertTemplatePositionToOrderPosition(p, (SupplierReference)selectedNode.getChildNamed(PurchaseOrderTemplateComplete_.supplier).getValue());
                        if (np != null) {
                            Node con = np.getChildNamed(DtoFieldConstants.CONVERTED);
                            if (con == null) {
                                con = new DTONode();
                                con.setName(DtoFieldConstants.CONVERTED);
                                np.addChild(con, 0L);
                            }
                            positions.addChild(np, System.currentTimeMillis());
                            continue;
                        }
                        BasicArticleLight artL = p.getArticle();
                        Converter c = ConverterRegistry.getConverter(BasicArticleConverter.class);
                        Converter c2 = ConverterRegistry.getConverter(SupplierConverter.class);
                        ScreenValidationObject o = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ARTICLE_NO_LONGER_ORDERABLE, (Object[])new Object[]{c.convert((Object)artL, null, new Object[0]), c2.convert(selectedNode.getChildNamed(PurchaseOrderTemplateComplete_.supplier).getValue(), null, new Object[0])}));
                        warnings.add((Object)o);
                    }
                }
                catch (ClientGetFromServerException e) {
                    warnings.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                }
                positions.sortChilds((Comparator)new SequenceNumberSorter());
                int c = 0;
                it = positions.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.getChildNamed(new String[]{"sequenceNumber"}).setValue((Object)c, 0L);
                    ++c;
                }
                if (ScreenValidationObject.isError((List)warnings)) {
                    throw new ClientExceptionCollection(Words.UNABLE_TO_CONVERT_TEMPLATE, warnings);
                }
                ViewNode vn = new ViewNode("");
                vn.setValue((Object)warnings, 0L);
                return vn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        TemplateDetailsPanel.this.editor.hideCommittingAnimation();
                        if (TemplateDetailsPanel.this.panel != null) {
                            TemplateDetailsPanel.this.panel.allLoaded();
                        }
                        TemplateDetailsPanel.this.editor.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        TemplateDetailsPanel.this.errorOccurred(exception);
                        TemplateDetailsPanel.this.editor.hideCommittingAnimation();
                        if (TemplateDetailsPanel.this.panel != null) {
                            TemplateDetailsPanel.this.panel.allLoaded();
                        }
                        TemplateDetailsPanel.this.editor.setEnabled(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private TextLabel costCenter;
        private TextLabel supplier;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.name = new TextLabel(m.getNode().getChildNamed(PurchaseOrderTemplateComplete_.name));
            this.costCenter = new TextLabel(m.getNode().getChildNamed(PurchaseOrderTemplateComplete_.costCenter), ConverterRegistry.getConverter(CostCenterConverter.class));
            if (TemplateDetailsPanel.this.withSupplier) {
                this.supplier = new TextLabel(m.getNode().getChildNamed(PurchaseOrderTemplateComplete_.supplier), ConverterRegistry.getConverter(SupplierConverter.class));
            }
            this.setLayout(new InnerLayout());
            this.add(this.name);
            this.add(this.costCenter);
            if (TemplateDetailsPanel.this.withSupplier) {
                this.add(this.supplier);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.costCenter.kill();
            if (this.supplier != null) {
                this.supplier.kill();
            }
            this.name = null;
            this.costCenter = null;
            this.supplier = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
                case 1: {
                    return this.costCenter.getText();
                }
                case 2: {
                    if (this.supplier != null) {
                        return this.supplier.getText();
                    }
                    return "";
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            this.costCenter.setEnabled(isEnabled);
            if (this.supplier != null) {
                this.supplier.setEnabled(isEnabled);
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.costCenter.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.costCenter.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.costCenter.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.costCenter.getPreferredSize().getHeight());
                if (TableRowImpl.this.supplier != null) {
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.supplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.supplier.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.supplier.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.supplier.getPreferredSize().getHeight());
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 250);
        }

        @Override
        public void layoutContainer(Container parent) {
            TemplateDetailsPanel.this.table.setLocation(0, 0);
            TemplateDetailsPanel.this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - (TemplateDetailsPanel.this.load.getPreferredSize().getHeight() + 20.0)));
            TemplateDetailsPanel.this.load.setLocation(TemplateDetailsPanel.this.horizontalBorder, TemplateDetailsPanel.this.table.getY() + TemplateDetailsPanel.this.table.getHeight() + 10);
            TemplateDetailsPanel.this.load.setSize(TemplateDetailsPanel.this.load.getPreferredSize());
        }
    }
}

