/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;

public class DeliveryTimeConverter
implements Converter<Object, String> {
    private SupplierReference currentSupplier;

    public void setCurrentSupplier(SupplierReference c) {
        this.currentSupplier = c;
    }

    public String convert(Object o, Node<Object> currentNode, Object ... param) {
        Object oc = currentNode.getValue(BasicArticleComplete.class);
        if (oc != null) {
            SupplierConditionComplete c;
            BasicArticleComplete a = (BasicArticleComplete)oc;
            if (this.currentSupplier != null && (c = this.getCondition(a)) != null) {
                int days = c.getDeliveryTime();
                return "" + days + " " + Words.DAYS;
            }
        }
        return NULL_RETURN;
    }

    private SupplierConditionComplete getCondition(BasicArticleComplete a) {
        Timestamp validity = new Timestamp(System.currentTimeMillis());
        SupplierConditionBaseComplete base = a.getSupplier(this.currentSupplier);
        for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
            for (SupplierConditionComplete condition : category.getConditions()) {
                if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                return condition;
            }
        }
        return null;
    }

    public Class<?> getParameterClass() {
        return null;
    }
}

