/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Component;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;

public class GroupLoader
implements LoadingGroup,
RemoteLoader {
    private boolean isRunning = false;
    private PriorityBlockingQueue<ReloadablePriceView> loadingQueue;
    private static final int TYPE_COMPONENT = 3;
    private static final int TYPE_TOTAL = 5;
    private ReloadablePriceView totalView;
    private Component c;

    public GroupLoader(Component c) {
        this.c = c;
        this.loadingQueue = new PriorityBlockingQueue<ReloadablePriceView>(10, new ReloadablePriceComparator());
    }

    public void setTotalView(ReloadablePriceView view) {
        this.totalView = view;
    }

    public void addComponent(ReloadablePriceView rpv) {
        this.loadingQueue.add(rpv);
    }

    public void removeComponent(ReloadablePriceView rpv) {
        this.loadingQueue.remove(rpv);
    }

    @Override
    public void updateMe(ReloadablePriceView rpv) {
        int t = this.getType(rpv);
        if (t == 3) {
            this.initStratOne(rpv);
        } else {
            this.initStratTwo();
        }
        this.runMe();
    }

    private void initStratOne(ReloadablePriceView rpv) {
        this.loadingQueue.add(rpv);
        this.initStratTwo();
    }

    private void initStratTwo() {
        this.loadingQueue.add(this.totalView);
    }

    private void runMe() {
        if (this.isRunning) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                while (!GroupLoader.this.loadingQueue.isEmpty()) {
                    ReloadablePriceView r = (ReloadablePriceView)GroupLoader.this.loadingQueue.poll();
                    CalculationRunnable runing = r.getCurrentRunnable();
                    if (runing == null || !runing.isAlive()) continue;
                    runing.run();
                    r.loaded();
                }
                GroupLoader.this.isRunning = false;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return GroupLoader.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        this.isRunning = true;
        ThreadSafeLoader.run(run);
    }

    private int getType(ReloadablePriceView rpv) {
        if (rpv == this.totalView) {
            return 5;
        }
        return 3;
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, this.c);
    }

    private class ReloadablePriceComparator
    implements Comparator<ReloadablePriceView> {
        private ReloadablePriceComparator() {
        }

        @Override
        public int compare(ReloadablePriceView o1, ReloadablePriceView o2) {
            Integer t1 = GroupLoader.this.getType(o1);
            Integer t2 = GroupLoader.this.getType(o2);
            return t1.compareTo(t2);
        }
    }
}

