/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.EstimatedPositionPriceConverter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter3Decimals;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.SupplierConditionDeliveryTimeConverter;
import ch.icit.pegasus.client.converter.SupplierConditionOrderIntervallConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.ArticleOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.GroupLoader;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CursorController;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.OrderToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableRowImpl
extends SortableTable2RowPanel
implements SearchTextField2Listener,
RemoteLoader,
ButtonListener,
NodeListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private final boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
    private TextLabel label;
    private SearchTextField2 article;
    private InputComboBox2 amount;
    private InfoButton infoButton;
    private TextLabel deliveryTime;
    private ReloadablePriceView estimatedCost;
    private SupplierLight injectedSupplier;
    private StockTransactionRemarkButton comment;
    private final ArticleOrderDetailsPanel artPanel;
    private TextLabel orderIntervall;
    private TextLabel warning;
    private TextLabel department;
    private EditButton packingTable;
    private EditButton editTargetStoreAndDepartment;
    private boolean deliveryDateCheckDone = false;
    private volatile boolean isLoading;
    private boolean newArticleSelected = false;
    private SupplierConditionComplete specifiedSupplierCondition;
    private boolean supplierConditionIsSpecified = false;
    private UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
    private StoreLight backupPos;
    private InternalCostCenterComplete backupDepartment;

    public TableRowImpl(Table2RowModel m, LoadingGroup loader, ArticleOrderDetailsPanel articlePanel, SupplierLight injectedSupplier) {
        super(m);
        this.artPanel = articlePanel;
        if (m.getNode().getChildNamed(new String[]{"hasQuantityChange"}) == null) {
            Node qc = new Node();
            qc.setName("hasQuantityChange");
            m.getNode().addChild(qc, 0L);
        }
        this.setSortAttributeName("sequenceNumber");
        this.setStartEndOffset(0, 1);
        this.label = new TextLabel(m.getNode().getChildNamed(new String[]{"sequenceNumber"}), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
        this.label.setProgress(1.0f);
        this.article = SearchTextField2Factory.getBasicArticleSearchField(false, m.getNode().getChildNamed(new String[]{"article"}), true);
        this.article.addSearchTextFieldListener(this);
        this.editTargetStoreAndDepartment = new EditButton();
        this.editTargetStoreAndDepartment.setProgress(1.0f);
        this.infoButton = new InfoButton();
        this.infoButton.setProgress(1.0f);
        DTONode sup = new DTONode();
        sup.setName("supplier");
        this.amount = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        this.amount.getEnterField().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableRowImpl.this.model.getParentModel().getTable().getAddButton().requestFocusInWindowNow();
            }
        });
        this.deliveryTime = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition), ConverterRegistry.getConverter(SupplierConditionDeliveryTimeConverter.class));
        this.deliveryTime.setProgress(1.0f);
        this.orderIntervall = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition), ConverterRegistry.getConverter(SupplierConditionOrderIntervallConverter.class));
        this.orderIntervall.setProgress(1.0f);
        if (!this.isNoPro) {
            this.warning = new TextLabel();
            this.warning.setProgress(1.0f);
        } else {
            this.department = new TextLabel();
        }
        Object[] paras = new Object[]{FormattedDoubleConverter3Decimals.class};
        this.estimatedCost = new ReloadablePriceView(loader, EstimatedPositionPriceConverter.class);
        this.estimatedCost.setProgress(1.0f);
        this.estimatedCost.setConverterParametes(paras);
        this.estimatedCost.setPermanent(true);
        this.comment = new StockTransactionRemarkButton(false, null);
        this.comment.setProgress(1.0f);
        this.comment.addButtonListener(this);
        ((GroupLoader)loader).addComponent(this.estimatedCost);
        if (this.canChangeSupplierCondition()) {
            this.packingTable = new EditButton();
            this.packingTable.addButtonListener((source, x, y) -> this.showPackingTable(x, y));
            this.packingTable.setEnabled(false);
            this.packingTable.setProgress(1.0f);
        }
        this.editTargetStoreAndDepartment.addButtonListener((source, x, y) -> this.showTargetStoreAndDepartmentPopup(source, x, y));
        this.amount.setEnabled(false);
        this.deliveryTime.setEnabled(false);
        this.estimatedCost.setEnabled(false);
        this.comment.setEnabled(false);
        this.label.setEnabled(true);
        this.orderIntervall.setEnabled(true);
        if (this.warning != null) {
            this.warning.setEnabled(true);
        }
        this.editTargetStoreAndDepartment.setEnabled(false);
        this.article.setProgress(1.0f);
        this.amount.setProgress(1.0f);
        this.setLayout(new Layout());
        m.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).addNodeListener((NodeListener)this);
        this.getOrderDateNode().addNodeListener((NodeListener)this);
        this.getDeliveryDateNode().addNodeListener((NodeListener)this);
        this.getUsedTaxZoneNode().addNodeListener((NodeListener)this);
        this.getTaxZoneNode().addNodeListener((NodeListener)this);
        this.setCalculationAlgorithm();
        articlePanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).addNodeListener((NodeListener)this);
        articlePanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).addNodeListener((NodeListener)this);
        this.add(this.label);
        this.add(this.article);
        this.add(this.amount);
        this.add(this.infoButton);
        this.add(this.deliveryTime);
        if (!this.isNoPro) {
            this.add(this.estimatedCost);
        } else {
            this.add(this.department);
        }
        this.add(this.comment);
        this.add(this.orderIntervall);
        if (this.warning != null) {
            this.add(this.warning);
        }
        this.add(this.editTargetStoreAndDepartment);
        if (this.canChangeSupplierCondition()) {
            this.add(this.packingTable);
        }
        this.injectSupplier(injectedSupplier);
        if (this.model.getNode().getChildNamed(new String[]{"article"}).getValue() != null) {
            this.newValueSelected(this.article, this.model.getNode());
        }
    }

    private void showTargetStoreAndDepartmentPopup(Button source, int x, int y) {
        this.backupPos = (StoreLight)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore).getValue();
        this.backupDepartment = (InternalCostCenterComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department).getValue();
        boolean restrictions = Boolean.TRUE.equals(this.settings.getUseStoreEntryTypeRestrictionForManualTransactions()) && !this.artPanel.getProvider().isWritable(PurchaseOrderAccess.CHECKIN_TO_ANY_STORE);
        InnerPopupFactory.showStoreChangePopup(x, y, (Node<StoreLight>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore), (Node<InternalCostCenterComplete>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department), (Node<Boolean>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.useCommentAsName), (Node<String>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment), this.editTargetStoreAndDepartment, (source1, xargs) -> {
            if (xargs == null) {
                if (this.model.getNode() != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore) != null) {
                    this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore).setValue((Object)this.backupPos, System.currentTimeMillis());
                }
                if (this.model.getNode() != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department) != null) {
                    this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department).setValue((Object)this.backupDepartment, System.currentTimeMillis());
                }
            }
        });
    }

    private boolean canChangeSupplierCondition() {
        return Boolean.TRUE.equals(this.settings.getAllowTaxZoneRelatedSupplierCondition());
    }

    private void showPackingTable(int x, int y) {
        SupplierLight supplier = (SupplierLight)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue();
        Date date = (Date)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
        InnerPopupFactory.showPackingTableWithSupplierCondition(x, y, this, (source, xargs) -> this.conditionPopupClosed(xargs), supplier, date, (Node<PurchaseOrderPositionComplete>)this.model.getNode(), this.artPanel.getProvider(), false);
    }

    private void conditionPopupClosed(Object[] xargs) {
        if (xargs != null) {
            boolean isPlaced = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue() == OrderStateE.PLACED;
            BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            if (isPlaced) {
                SupplierConditionComplete condition = (SupplierConditionComplete)xargs[0];
                boolean shouldUpdateDeliveryTime = false;
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).setValue((Object)condition, 0L);
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).updateNode();
                this.updateInfoPopupAndSelectableUnits(condition);
                try {
                    this.updateSupplierPrice(artC);
                }
                catch (ClientServerCallException e) {
                    e.printStackTrace();
                }
                this.updateEstimatedCosts(artC);
                this.ensurePositionState();
                this.supplierConditionIsSpecified = true;
                this.specifiedSupplierCondition = condition;
                if (shouldUpdateDeliveryTime || !this.deliveryDateCheckDone) {
                    this.deliveryDateCheckDone = true;
                    try {
                        this.artPanel.updateDeliveryTime();
                    }
                    catch (ClientServerCallException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public SupplierConditionComplete updateSupplierCondition(BasicArticleComplete article) {
        boolean shouldUpdateDeliveryTime;
        SupplierConditionBaseComplete base = article.getSupplier((SupplierReference)this.injectedSupplier);
        Date date = this.getOrderDate();
        Boolean useTaxZone = (Boolean)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
        TaxZoneComplete taxZone = (TaxZoneComplete)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
        Object selectedCategory = null;
        for (Object category : base.getSupplierConditionCategory()) {
            if (Boolean.TRUE.equals(useTaxZone)) {
                if (category.getTaxZone() == null) {
                    if (taxZone != null) continue;
                    selectedCategory = category;
                    continue;
                }
                if (!category.getTaxZone().equals((Object)taxZone)) continue;
                selectedCategory = category;
                continue;
            }
            if (category.getTaxZone() != null || taxZone != null) continue;
            selectedCategory = category;
        }
        ArrayList matchedConditions = new ArrayList();
        if (selectedCategory != null) {
            matchedConditions.addAll(selectedCategory.getConditions());
        } else {
            for (Object category : base.getSupplierConditionCategory()) {
                matchedConditions.addAll(category.getConditions());
            }
        }
        Collections.sort(matchedConditions);
        SupplierConditionComplete condition = null;
        for (SupplierConditionComplete newCondition : matchedConditions) {
            if (newCondition.getValidity().getStartDate().getTime() > date.getTime() || newCondition.getValidity().getEndDate().getTime() < date.getTime()) continue;
            if (condition != null) {
                PriceComplete p1 = this.getSupplierConditionPrice(condition);
                PriceComplete p2 = this.getSupplierConditionPrice(newCondition);
                if (p1 == null) {
                    condition = newCondition;
                    continue;
                }
                if (p2 == null || !(p1.getPrice() > p2.getPrice())) continue;
                condition = newCondition;
                continue;
            }
            condition = newCondition;
        }
        SupplierConditionComplete copiedCondition = null;
        if (condition != null) {
            copiedCondition = CopyTemplateToolkit.copySupplierCondition(condition);
            this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).setValue((Object)copiedCondition, 0L);
            this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).updateNode();
        }
        if ((shouldUpdateDeliveryTime = false) || !this.deliveryDateCheckDone) {
            this.deliveryDateCheckDone = true;
            try {
                this.artPanel.updateDeliveryTime();
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
        }
        return copiedCondition;
    }

    private PriceComplete getSupplierConditionPrice(SupplierConditionComplete cond) {
        if (!cond.getStepPrice().getSteps().isEmpty()) {
            return ((StepPriceFunctionComplete)cond.getStepPrice().getSteps().get(0)).getPrice();
        }
        return null;
    }

    public void updateSupplierPrice(BasicArticleComplete article) throws ClientServerCallException {
        PriceAndUnitComplete a = null;
        Node priceNode = this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.supplierPrice, PriceComplete_.price});
        Node currencyNode = this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.supplierPrice, PriceComplete_.currency});
        Node priceUnit = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.priceUnit);
        Node contractEntry = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.contractEntry);
        Boolean useTaxZone = Boolean.TRUE.equals(this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue());
        TaxZoneComplete taxZone = (TaxZoneComplete)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
        SupplierConditionComplete supplierCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue(SupplierConditionComplete.class);
        try {
            if (priceNode.getValue() != null && currencyNode.getValue() != null && priceUnit.getValue() != null) {
                a = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice((BasicArticleReference)article, (SupplierReference)this.injectedSupplier, new DateWrapper(this.getOrderDate()), new QuantityComplete(this.getAmount(), this.getUnit()), useTaxZone, taxZone, supplierCondition);
            }
        }
        catch (Exception e) {
            contractEntry.setValue(null, 0L);
            return;
        }
        if (a == null) {
            contractEntry.setValue(null, 0L);
            return;
        }
        priceNode.setValue((Object)a.getPrice().getPrice(), 0L);
        currencyNode.setValue((Object)a.getPrice().getCurrency(), 0L);
        priceUnit.setValue((Object)a.getUnit(), 0L);
        contractEntry.setValue(contractEntry.getValue(), 0L);
    }

    public void updateEstimatedCosts(BasicArticleComplete article) {
        try {
            Double amount = this.getAmount();
            UnitComplete sourceUnit = this.getUnit();
            UnitComplete destinationUnit = this.getPriceUnit();
            Double sp = this.getSupplierPricePrice();
            CurrencyComplete spc = this.getSupplierPriceCurrency();
            SupplierConditionComplete supplierCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
            List packingQuantities = supplierCondition.getPackingQuantities();
            double amountInPriceUnit = supplierCondition != null && Boolean.TRUE.equals(supplierCondition.getUsePackingQuantity()) && !packingQuantities.isEmpty() ? UnitConversionToolkit.convertUnit((UnitComplete)sourceUnit, (UnitComplete)destinationUnit, (double)amount, (BasicArticleLight)article, (List)packingQuantities) : UnitConversionToolkit.convertUnit((UnitComplete)sourceUnit, (UnitComplete)destinationUnit, (double)amount, (BasicArticleLight)article, (Timestamp)new Timestamp(this.getOrderDate().getTime()));
            double orderPosValue = amountInPriceUnit * sp;
            PriceComplete p = new PriceComplete(spc, Double.valueOf(orderPosValue));
            if (p != null) {
                Node pn = this.estimatedCost.getNode();
                if (pn == null) {
                    pn = new EmbeddedDTONode();
                    this.estimatedCost.setNode(pn);
                }
                pn.setValue((Object)p, 0L);
                pn.updateNode();
                this.estimatedCost.updateString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Double getAmount() {
        Node node = this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount});
        if (node.getValue() instanceof Double) {
            return (Double)node.getValue();
        }
        if (node.getValue() instanceof Integer) {
            return ((Integer)node.getValue()).doubleValue();
        }
        if (node.getValue() instanceof Long) {
            return ((Long)node.getValue()).doubleValue();
        }
        return 0.0;
    }

    public UnitComplete getUnit() {
        return (UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue();
    }

    public UnitComplete getPriceUnit() {
        return (UnitComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.priceUnit).getValue();
    }

    public CurrencyComplete getSupplierPriceCurrency() {
        return (CurrencyComplete)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.supplierPrice, PriceComplete_.currency}).getValue();
    }

    public Double getSupplierPricePrice() {
        return (Double)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.supplierPrice, PriceComplete_.price}).getValue();
    }

    public Date getOrderDate() {
        return (Date)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
    }

    public Node<Date> getDeliveryDateNode() {
        return this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryDate);
    }

    public Node<Date> getOrderDateNode() {
        return this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate);
    }

    public Node<TaxZoneComplete> getTaxZoneNode() {
        return this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone);
    }

    public Node<TaxZoneComplete> getUsedTaxZoneNode() {
        return this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone);
    }

    public void ensurePositionState() {
        if (this.warning != null) {
            String text;
            Color okColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.ok.color"));
            Color fatalColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.fatal.color"));
            Color warningsColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.warning.color"));
            BasicArticleComplete article = (BasicArticleComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            Boolean useTaxZone = (Boolean)this.model.getNode().getParent().getParent().getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
            TaxZoneComplete taxZone = (TaxZoneComplete)this.model.getNode().getParent().getParent().getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
            Color selectedColor = okColor;
            if (!this.isContractStateValid(article)) {
                text = "No Contract found";
                selectedColor = fatalColor;
            } else {
                text = "";
                if (!this.isIntervalValid(article)) {
                    text = text + "Min Order/Interval amount violation, ";
                    selectedColor = warningsColor;
                }
                if (!this.isDeliveryTimeValid(article)) {
                    text = text + "Delivery Time violation, ";
                    selectedColor = warningsColor;
                }
                if (!this.isCheapestSupplier(article, useTaxZone, taxZone)) {
                    text = text + "Not cheapest Supplier, ";
                    selectedColor = warningsColor;
                }
                if (article.getState() == ArticleModificationStateE.DRAFT) {
                    text = text + "DRAFT Article, ";
                    selectedColor = warningsColor;
                }
                if (article.getState() == ArticleModificationStateE.DUMMY) {
                    text = text + "DUMMY Article, ";
                    selectedColor = warningsColor;
                }
                if (!this.isCurrencyValid()) {
                    text = text + "Currency mismatch with Supplier, ";
                    selectedColor = fatalColor;
                }
                if (!this.isTaxZoneCorrect(useTaxZone, taxZone)) {
                    text = text + "No Supplier Condition for Tax Zone " + (taxZone != null ? taxZone.getCode() : "none") + " found, ";
                    selectedColor = fatalColor;
                }
                text = text.isEmpty() ? "ok" : text.substring(0, text.length() - 2);
            }
            this.warning.setText(text);
            this.warning.setForeground(selectedColor);
        }
    }

    private boolean isTaxZoneCorrect(Boolean useTaxZone, TaxZoneComplete taxZone) {
        SupplierConditionComplete condition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        if (Boolean.TRUE.equals(useTaxZone)) {
            return taxZone == null ? condition.getCategoryTaxZone() == null : taxZone.equals((Object)condition.getCategoryTaxZone());
        }
        return true;
    }

    private boolean isIntervalValid(BasicArticleComplete article) {
        SupplierConditionComplete condition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        QuantityComplete orderedAmount = new QuantityComplete();
        orderedAmount.setQuantity(this.getAmount());
        orderedAmount.setUnit(this.getUnit());
        UnitComplete unit = condition.getMinOrderAmountUnit() != null ? condition.getMinOrderAmountUnit() : condition.getOrderUnit();
        double ca = UnitConversionToolkit.convertUnit((UnitComplete)orderedAmount.getUnit(), (UnitComplete)unit, (double)orderedAmount.getQuantity(), (BasicArticleLight)article, (Timestamp)new Timestamp(this.getOrderDate().getTime()));
        return ca % condition.getMinOrderAmount() == 0.0;
    }

    public boolean isCurrencyValid() {
        Node currency = this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.supplierPrice, PriceComplete_.currency});
        return this.injectedSupplier.getPaymentCurrency().equals(currency.getValue());
    }

    private boolean isDeliveryTimeValid(BasicArticleComplete article) {
        SupplierConditionComplete condition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        Date deliveryDate = (Date)this.getDeliveryDateNode().getValue();
        Date toDay = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())).getStartDate();
        long difInMillis = deliveryDate.getTime() - toDay.getTime();
        long aDay = 86400000L;
        long maxDif = (long)condition.getDeliveryTime().intValue() * aDay;
        return maxDif <= difInMillis;
    }

    private boolean isContractStateValid(BasicArticleComplete article) {
        if (Boolean.TRUE.equals(article.getMarkedAsContracted())) {
            Node contractEntry = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.contractEntry);
            if (contractEntry == null) {
                return false;
            }
            if (contractEntry.getValue() == null) {
                return false;
            }
        }
        return true;
    }

    private boolean isCheapestSupplier(BasicArticleComplete article, Boolean useTaxZone, TaxZoneComplete taxZone) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        SupplierConditionComplete sc = ArticleToolkit.getCheapestSupplier(article, (Node<UnitComplete>)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}), (Node<Object>)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}), useTaxZone, taxZone, settings, this, this.artPanel.getAccessor(), new Timestamp(this.getOrderDate().getTime()));
        SupplierConditionComplete currentCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        if (sc == null) {
            return false;
        }
        return currentCondition.getSupplier().equals((Object)sc.getSupplier());
    }

    public boolean hasAmount() {
        Object o = this.amount.getValueNode().getValue();
        if (o instanceof Long) {
            return (Long)o != 0L;
        }
        if (o instanceof Double) {
            return (Double)o != 0.0;
        }
        if (o instanceof Integer) {
            return (Integer)o != 0;
        }
        return false;
    }

    public List<ScreenValidationObject> validateRow(Date deliveryDate, Boolean useTaxZone, TaxZoneComplete taxZone) {
        SupplierLight supplier;
        BasicArticleComplete artC;
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        if (this.isLoading) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Wait until all articles/data are loaded!"));
        }
        Timestamp validity = new Timestamp(deliveryDate.getTime());
        Date d = OrderToolkit.getMinDeliveryDate((BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class), (SupplierReference)this.injectedSupplier, useTaxZone, taxZone, validity);
        Date d2 = OrderToolkit.shiftDeliveryDate2MidNight(deliveryDate);
        if (d2.getTime() < d.getTime()) {
            this.deliveryTime.setInvalid();
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Delivery time for Article " + ((BasicArticleConverter)ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((BasicArticleLight)((BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class)), null, new Object[0]) + " is bigger than selected delivery date."));
        }
        if ((artC = (BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class)) == null) {
            BasicArticleLight artL = (BasicArticleLight)this.article.getNode().getValue(BasicArticleLight.class);
            if (artL != null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article isn't loaded correctly, please recheck the Order Position"));
            } else {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "One Article isn't loaded correctly, please recheck the Order Positions"));
            }
            return rets;
        }
        if (!this.isNoPro && artC.getState() != ArticleModificationStateE.ACCEPTED) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Article is not accepted"));
        }
        SupplierConditionComplete supplierCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        Boolean intervalMandatory = supplierCondition.getMinOrderAmountIsMandatory();
        double minOAmount = supplierCondition.getMinOrderAmount();
        if (minOAmount >= 0.0 && this.amount.getValueNode() != null) {
            UnitComplete unit;
            long a = TransactionToolkit.getLongValue(this.amount.getValueNode());
            UnitComplete u = (UnitComplete)this.amount.getUnitNode().getValue();
            long dd = (long)UnitConversionToolkit.convertUnit((UnitComplete)u, (UnitComplete)(unit = supplierCondition.getMinOrderAmountUnit() != null ? supplierCondition.getMinOrderAmountUnit() : supplierCondition.getOrderUnit()), (double)a, (BasicArticleLight)artC, (Timestamp)new Timestamp(this.getOrderDate().getTime()));
            if (dd == 0L) {
                this.amount.setInvalid();
            } else if ((double)dd % minOAmount != 0.0) {
                this.amount.setInvalid();
                ScreenValidationObject.ValidationStateE errorType = Boolean.TRUE.equals(intervalMandatory) ? ScreenValidationObject.ValidationStateE.FATAL : ScreenValidationObject.ValidationStateE.WARNING;
                rets.add(new ScreenValidationObject(errorType, "Quantity of Article " + ((BasicArticleConverter)ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((BasicArticleLight)((BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class)), null, new Object[0]) + " is not in the Order Interval given by Supplier."));
            }
        }
        if (this.article.getNode().getValue(BasicArticleComplete.class) == null) {
            this.article.setInValid();
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article must be defined"));
        }
        SupplierConditionComplete usedSupplierCondition = null;
        usedSupplierCondition = this.supplierConditionIsSpecified ? this.specifiedSupplierCondition : (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
        int i = Boolean.TRUE.equals(usedSupplierCondition.getUsePackingQuantity()) ? UnitConversionToolkit.isUnitContaining((UnitComplete)this.amount.getSelectUnit(), (UnitComplete)artC.getMainStoreUnit(), (BasicArticleLight)artC, (List)this.specifiedSupplierCondition.getPackingQuantities()) : UnitConversionToolkit.isUnitContaining((UnitComplete)this.amount.getSelectUnit(), (UnitComplete)artC.getMainStoreUnit(), (BasicArticleLight)artC, (Timestamp)new Timestamp(this.getOrderDate().getTime()));
        switch (i) {
            case 3: 
            case 5: {
                break;
            }
            case 11: {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Selected Unit (" + this.amount.getSelectUnit().getShortName() + ") is not convertible within Article's Packaging Table (" + artC.getNumber() + " - " + artC.getName() + "). Please delete current Article and readd it."));
            }
        }
        boolean taxZoneError = false;
        if (Boolean.TRUE.equals(useTaxZone)) {
            if (taxZone == null) {
                if (usedSupplierCondition.getCategoryTaxZone() != null) {
                    taxZoneError = true;
                }
            } else if (!taxZone.equals((Object)usedSupplierCondition.getCategoryTaxZone())) {
                taxZoneError = true;
            }
        }
        if (taxZoneError) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + artC.getNumber() + " - " + artC.getName() + ": No Supplier Condition for Tax Zone " + (taxZone != null ? taxZone.getCode() : "none") + " found"));
        }
        boolean foundSupplier = false;
        SupplierConditionBaseComplete base = artC.getSupplier((SupplierReference)this.injectedSupplier);
        if (base == null) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + artC.getNumber() + " - " + artC.getName() + " can't be ordered from Supplier " + this.injectedSupplier.getName() + " (Supplier not found)"));
            return rets;
        }
        Object selectedCategory = null;
        for (Object category : base.getSupplierConditionCategory()) {
            if (!Boolean.TRUE.equals(useTaxZone)) continue;
            if (category.getTaxZone() == null) {
                if (taxZone != null) continue;
                selectedCategory = category;
                continue;
            }
            if (!category.getTaxZone().equals((Object)taxZone)) continue;
            selectedCategory = category;
        }
        ArrayList conditions = new ArrayList();
        if (selectedCategory == null) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                conditions.addAll(category.getConditions());
            }
        } else {
            conditions.addAll(selectedCategory.getConditions());
        }
        for (SupplierConditionComplete condition : conditions) {
            if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime() || !condition.getCanBeOrdered().booleanValue()) continue;
            foundSupplier = true;
        }
        if (!foundSupplier) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Chosen Supplier (" + this.injectedSupplier.getName() + ") doesn't deliver " + artC.getNumber() + " - " + artC.getName() + ". Please delete current Article and readd it."));
        } else if (!this.isNoPro && Boolean.TRUE.equals(this.settings.getAllowPurchaseOrderSupplierBondedRestriction()) && (supplier = supplierCondition.getSupplier()).getBondedState() != null) {
            switch (supplier.getBondedState()) {
                case ALL: {
                    break;
                }
                case NOT_BONDED: {
                    if (!Boolean.TRUE.equals(artC.getBonded())) break;
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + artC.getNumber() + " - " + artC.getName() + " is bonded but Supplier " + this.injectedSupplier.getName() + " can only deliver not bonded articles"));
                    break;
                }
                case ONLY_BONDED: {
                    if (!Boolean.FALSE.equals(artC.getBonded())) break;
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + artC.getNumber() + " - " + artC.getName() + " is not bonded but Supplier " + this.injectedSupplier.getName() + " can only deliver bonded articles"));
                }
            }
        }
        return rets;
    }

    public PriceComplete getPrice() {
        if (this.estimatedCost.getNode() != null && this.estimatedCost.getNode().getValue() != null) {
            return (PriceComplete)this.estimatedCost.getNode().getValue();
        }
        return null;
    }

    private void setCalculationAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                BasicArticleComplete art = (BasicArticleComplete)TableRowImpl.this.article.getNode().getValue(BasicArticleComplete.class);
            }

            @Override
            public boolean isAlive() {
                if (TableRowImpl.this.estimatedCost != null) {
                    return !TableRowImpl.this.estimatedCost.isKilled();
                }
                return false;
            }
        };
        this.estimatedCost.setRunnable(run);
    }

    public void injectSupplier(SupplierLight supplier) {
        if (supplier != null) {
            this.injectedSupplier = supplier;
        }
        Object[] o = new Object[8];
        o[0] = this.injectedSupplier;
        o[1] = this.readCustomerState();
        o[7] = this.readHalalState();
        Boolean canMoveAny = false;
        for (ModuleAccessRightComplete module : this.currentUser.getModules()) {
            if (!module.getModule().getInvokingName().equals(PurchaseOrderAccess.MODULE_PURCHASE.getIdentifier())) continue;
            for (DataFieldAccessRightComplete fieldAccessRight : module.getFieldAccessRights()) {
                if (!fieldAccessRight.getField().getName().equals(PurchaseOrderAccess.MOVE_ANY_ARTICLE.getName())) continue;
                canMoveAny = null;
            }
        }
        o[6] = this.isNoPro ? null : (canMoveAny == null ? null : Boolean.valueOf(true));
        this.article.setAdditionalSearchField(o);
    }

    private Boolean readCustomerState() {
        if (this.isNoPro) {
            return null;
        }
        return (Boolean)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).getValue();
    }

    private Boolean readHalalState() {
        if (this.isNoPro) {
            return null;
        }
        return (Boolean)this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).getValue();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).removeNodeListener((NodeListener)this);
        this.artPanel.getEditor().getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).removeNodeListener((NodeListener)this);
        this.article.kill();
        this.editTargetStoreAndDepartment.kill();
        if (this.amount.getValueNode() != null) {
            this.amount.getValueNode().removeNodeListener((NodeListener)this);
        }
        if (this.amount.getUnitNode() != null) {
            this.amount.getUnitNode().removeNodeListener((NodeListener)this);
        }
        this.amount.kill();
        this.orderIntervall.kill();
        if (this.warning != null) {
            this.warning.kill();
        }
        this.deliveryTime.kill();
        this.estimatedCost.kill();
        this.infoButton.kill();
        this.comment.kill();
        this.label.kill();
        if (this.canChangeSupplierCondition()) {
            this.packingTable.kill();
        }
        this.model.getNode().getChildNamed(new String[]{"article"}).removeNodeListener((NodeListener)this);
        this.getOrderDateNode().removeNodeListener((NodeListener)this);
        this.getDeliveryDateNode().removeNodeListener((NodeListener)this);
        this.getUsedTaxZoneNode().removeNodeListener((NodeListener)this);
        this.getTaxZoneNode().removeNodeListener((NodeListener)this);
        this.article = null;
        this.editTargetStoreAndDepartment = null;
        this.amount = null;
        this.deliveryTime = null;
        this.estimatedCost = null;
        this.infoButton = null;
        this.comment = null;
        this.label = null;
        this.orderIntervall = null;
        this.warning = null;
        this.packingTable = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b = isEnabled;
        if (this.isLoading) {
            b = false;
        }
        if (this.article != null) {
            this.article.setEnabled(b);
        }
        super.setEnabled(b);
        b &= this.isArticleSet();
        if (this.amount != null) {
            this.amount.setEnabled(b);
        }
        if (this.deliveryTime != null) {
            this.deliveryTime.setEnabled(b);
        }
        if (this.estimatedCost != null) {
            this.estimatedCost.setEnabled(b);
        }
        if (this.infoButton != null) {
            this.infoButton.setEnabled(b);
        }
        if (this.comment != null) {
            this.comment.setEnabled(b);
        }
        if (this.warning != null) {
            this.warning.setEnabled(b);
        }
        if (this.orderIntervall != null) {
            this.orderIntervall.setEnabled(b);
        }
        if (this.packingTable != null) {
            this.packingTable.setEnabled(b);
        }
        if (this.editTargetStoreAndDepartment != null) {
            this.editTargetStoreAndDepartment.setEnabled(b);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        focusList.addAll(this.article.getFocusComponents());
        if (this.article.getNode().getValue() != null) {
            focusList.addAll(this.amount.getFocusComponents());
            focusList.addAll(this.editTargetStoreAndDepartment.getFocusComponents());
        }
        if (this.canChangeSupplierCondition()) {
            focusList.addAll(this.packingTable.getFocusComponents());
        }
        focusList.addAll(this.comment.getFocusComponents());
        focusList.addAll(super.getFocusComponents());
        return focusList;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.newArticleSelected = true;
        this.updatePosition(source, true);
    }

    public void updatePosition(Component source, boolean updateDeliveryDate) {
        if (this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue() != null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    if (TableRowImpl.this.model.getNode() != null && TableRowImpl.this.model.getNode().getValue() != null) {
                        TableRowImpl.this.isLoading = true;
                        BasicArticleComplete artC = ArticleOrderDetailsPanel.loadArticleComplete(TableRowImpl.this.model.getNode(), TableRowImpl.this);
                        if (TableRowImpl.this.newArticleSelected) {
                            TableRowImpl.this.newArticleSelected = false;
                            TableRowImpl.this.initComponentWithNodes(artC);
                        }
                        if (!TableRowImpl.this.supplierConditionIsSpecified) {
                            TableRowImpl.this.specifiedSupplierCondition = TableRowImpl.this.updateSupplierCondition(artC);
                        }
                        TableRowImpl.this.updateInfoPopupAndSelectableUnits(TableRowImpl.this.specifiedSupplierCondition);
                        TableRowImpl.this.updateSupplierPrice(artC);
                        TableRowImpl.this.updateEstimatedCosts(artC);
                        TableRowImpl.this.ensurePositionState();
                        TableRowImpl.this.artPanel.loadTotalCosts();
                    }
                    return TableRowImpl.this.model.getNode().getChildNamed(new String[]{"article"});
                }

                @Override
                public RemoteLoader getInvoker() {
                    return TableRowImpl.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.isLoading = false;
        if (node == null || this.article == null) {
            return;
        }
        this.setEnabled(true);
        BasicArticleComplete artC = (BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class);
        if (artC == null) {
            InnerPopupFactory.showErrorDialog("Loading Article Data failed, please re add current Position.", (Component)this);
            this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            return;
        }
        boolean rebuildFocusCycle = false;
        CursorController.showCursor(this, false);
        this.artPanel.checkOrderableState();
        this.amount.getEnterField().requestFocusInWindowNow();
        this.invalidate();
        this.validate();
    }

    public void initComponentWithNodes(BasicArticleComplete artC) {
        Node qn;
        Node n = this.model.getNode().getChildNamed(new String[]{"quantity"});
        if (n.getValue() == null) {
            StoreQuantityComplete q = new StoreQuantityComplete(Long.valueOf(0L), artC.getMainStoreUnit());
            this.model.getNode().getChildNamed(new String[]{"quantity"}).setValue((Object)q, 0L);
            this.model.getNode().getChildNamed(new String[]{"quantity"}).updateNode();
        }
        if (n.getChildNamed(new String[]{"amount"}).getValue() == null) {
            n.getChildNamed(new String[]{"amount"}).setValue((Object)0, 0L);
        }
        n.getChildNamed(new String[]{"unit"}).setValue((Object)artC.getMainStoreUnit(), 0L);
        boolean rebuildFocusCycle = false;
        this.amount.setNode(this.model.getNode().getChildNamed(new String[]{"quantity"}));
        Node a = this.model.getNode().getChildNamed(new String[]{"quantity-amount"});
        if (a != null) {
            a.removeNodeListener((NodeListener)this);
            a.addNodeListener((NodeListener)this);
        }
        if ((qn = this.model.getNode().getChildNamed(new String[]{"quantity-unit"})) != null) {
            qn.removeNodeListener((NodeListener)this);
            qn.addNodeListener((NodeListener)this);
        }
        rebuildFocusCycle = true;
        Node supplierPrice = this.model.getNode().getChildNamed(new String[]{"supplierPrice"});
        supplierPrice.setValue((Object)new PriceComplete(this.injectedSupplier.getPaymentCurrency(), Double.valueOf(0.0)), 0L);
        Object p3 = null;
        if (this.isNoPro) {
            this.department.setText(artC.getDefaultRequisitionDeliverDepartment() != null ? artC.getDefaultRequisitionDeliverDepartment().getCode() : "");
        }
        this.model.getNode().getChildNamed(new String[]{"priceUnit"}).setValue((Object)artC.getMainStoreUnit(), 0L);
        this.deliveryTime.setNode(this.model.getNode().getChildNamed(new String[]{"supplierCondition"}));
        this.orderIntervall.setNode(this.model.getNode().getChildNamed(new String[]{"supplierCondition"}));
    }

    @Override
    public void requestFocusInWindowNow() {
        this.article.requestFocusInWindowNow();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.comment) {
            InnerPopupFactory.showEnterMessagePopup("Enter Comment", this, this.comment, this.model.getNode().getChildNamed(new String[]{"comment"}), x, y);
        }
    }

    public boolean isArticleSet() {
        return this.article != null && this.article.isItemSelected() && this.injectedSupplier != null;
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals("amount")) {
            this.updatePosition(this, false);
        } else if (node.getName().equals("unit")) {
            this.updatePosition(this, false);
        } else if (node.getName().equals(PurchaseOrderPositionComplete_.article.getFieldName())) {
            Date date = (Date)this.model.getNode().getParent().getParent().getChildNamed(PurchaseOrderLight_.deliveryDate).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            try {
                this.infoButton.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class), validity, 138567, true, (SupplierReference)this.injectedSupplier));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!node.getName().equals("price")) {
            if (node.getName().equals(PurchaseOrderLight_.orderDate.getFieldName())) {
                this.updatePosition(this, false);
            } else if (node.getName().equals(PurchaseOrderLight_.deliveryDate.getFieldName())) {
                this.updatePosition(this, false);
            } else if (node.getName().equals(PurchaseOrderComplete_.useTaxZone.getFieldName())) {
                this.updatePosition(this, false);
            } else if (node.getName().equals(PurchaseOrderComplete_.taxZone.getFieldName())) {
                this.updatePosition(this, false);
            } else if (node.getName().equals(PurchaseOrderComplete_.customerOwnedOnly.getFieldName())) {
                this.injectSupplier(this.injectedSupplier);
            } else if (node.getName().equals(PurchaseOrderComplete_.halalOrder.getFieldName())) {
                this.injectSupplier(this.injectedSupplier);
            }
        }
    }

    private void updateInfoPopupAndSelectableUnits(SupplierConditionComplete supplierCondition) {
        if (supplierCondition != null) {
            Date date = this.getOrderDate();
            Timestamp validity = new Timestamp(date.getTime());
            BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            if (Boolean.TRUE.equals(supplierCondition.getUsePackingQuantity()) && !supplierCondition.getPackingQuantities().isEmpty()) {
                this.infoButton.installStringViewer(ArticleToolkit.getArticleInfoPopupString(artC, validity, 138567, true, (SupplierReference)this.injectedSupplier, supplierCondition.getPackingQuantities()));
            } else {
                this.infoButton.installStringViewer(ArticleToolkit.getArticleInfoPopupString(artC, validity, 138567, true, (SupplierReference)this.injectedSupplier));
            }
            if (artC != null) {
                Node sc = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition);
                List units = sc != null && sc.getValue() != null && Boolean.TRUE.equals(sc.getChildNamed(SupplierConditionComplete_.usePackingQuantity).getValue()) ? UnitConversionToolkit.getPossibleUnits((List)((List)sc.getChildNamed(SupplierConditionComplete_.packingQuantities).getValue())) : StoreToolkit.getPossibleUnits((BasicArticleLight)artC, (SupplierConditionComplete)supplierCondition, (Timestamp)validity, (TransactionType)TransactionType.PURCHASE, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
                ViewNode un = new ViewNode("");
                for (UnitComplete u : units) {
                    un.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, true), 0L);
                }
                this.amount.setPossibleUnits((Node)un);
                this.deliveryTime.setNode(sc);
            }
        }
    }

    private void ensureCommentState() {
        if (this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment).getValue() == null || ((String)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment).getValue()).isEmpty()) {
            this.comment.setChoosen(false);
        } else {
            this.comment.setChoosen(true);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.ensureCommentState();
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            int i = 0;
            int w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            if (TableRowImpl.this.label == null) {
                return;
            }
            TableRowImpl.this.label.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.label.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.label.setSize(TableRowImpl.this.label.getPreferredSize());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.article.setSize((int)((double)(w - 2 * TableRowImpl.this.getCellPadding()) - ((double)TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.editTargetStoreAndDepartment.getPreferredSize().getWidth())), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
            TableRowImpl.this.editTargetStoreAndDepartment.setLocation(TableRowImpl.this.article.getX() + TableRowImpl.this.article.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editTargetStoreAndDepartment.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.editTargetStoreAndDepartment.setSize(TableRowImpl.this.editTargetStoreAndDepartment.getPreferredSize());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            if (TableRowImpl.this.isNoPro) {
                TableRowImpl.this.department.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.department.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.department.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.department.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            }
            TableRowImpl.this.deliveryTime.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deliveryTime.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.deliveryTime.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.deliveryTime.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            TableRowImpl.this.orderIntervall.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.orderIntervall.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.orderIntervall.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.orderIntervall.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.amount.setSize((int)TableRowImpl.this.amount.getPreferredSize().getWidth(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
            TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.amount.getX() + TableRowImpl.this.amount.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            if (!TableRowImpl.this.isNoPro) {
                TableRowImpl.this.estimatedCost.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.estimatedCost.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.estimatedCost.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.estimatedCost.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(i++);
            }
            if (TableRowImpl.this.warning != null) {
                TableRowImpl.this.warning.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.warning.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.warning.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.warning.getPreferredSize().getHeight());
                currentX += w;
            }
            TableRowImpl.this.setControlsX(currentX);
            int nx = currentX + TableRowImpl.this.getCellPadding();
            if (TableRowImpl.this.canChangeSupplierCondition()) {
                TableRowImpl.this.packingTable.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.packingTable.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.packingTable.setSize(TableRowImpl.this.packingTable.getPreferredSize());
                nx = TableRowImpl.this.packingTable.getX() + TableRowImpl.this.packingTable.getWidth() + TableRowImpl.this.getInnerCellPadding();
            }
            TableRowImpl.this.comment.setLocation(nx, (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.comment.setSize(TableRowImpl.this.comment.getPreferredSize());
            currentX = TableRowImpl.this.comment.getX() + TableRowImpl.this.comment.getWidth();
            TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight(), true);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
        }
    }
}

