/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.EstimatedPositionPriceConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.SupplierConditionDeliveryTimeConverter;
import ch.icit.pegasus.client.converter.SupplierConditionOrderCostsConverter;
import ch.icit.pegasus.client.converter.SupplierConditionOrderIntervallConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbComponentTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.ArticleDetailsPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.GroupCalculator;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.PositionNameConverter;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.PositionsColumnTitleConverter;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.PurchasePreviewToPurchaseFieldAccessor;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.SupplierChangePopup;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ManualPurchaseOrderCreatorAccess;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderBreadCrumbComponentTable
extends BreadCrumbComponentTable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(OrderBreadCrumbComponentTable.class);
    private ArticleDetailsPanel articlePanel;
    private SystemSettingsComplete settings;
    private UserComplete currentUser;
    private PriceComplete positionCosts;
    private PurchasePreviewToPurchaseFieldAccessor fieldAccessor;
    private final boolean workOnPreviewBase;
    private boolean ordersFixed;

    public OrderBreadCrumbComponentTable(IDataHandler dataHandler, BreadCrumbPanel master, ArticleDetailsPanel ap, boolean workOnPreviewBase, boolean ordersFixed) {
        super(dataHandler, master, new GroupCalculator(ap), "", new RDProvider(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ManualPurchaseOrderCreatorAccess.MODULE_MANUAL_PURCHASE), null);
        this.fieldAccessor = new PurchasePreviewToPurchaseFieldAccessor(workOnPreviewBase);
        this.workOnPreviewBase = workOnPreviewBase;
        this.ordersFixed = ordersFixed;
        this.table.setSortedColumn(0);
        this.articlePanel = ap;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
    }

    @Override
    public Converter getTotalConverter() {
        return ConverterRegistry.getConverter(StringConverter.class);
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
    }

    @Override
    public void setTotalCostAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                try {
                    if (OrderBreadCrumbComponentTable.this.totalCompPrice != null) {
                        PriceComplete price = null;
                        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        for (Table2RowPanel n : (List)((ArrayList)OrderBreadCrumbComponentTable.this.table.getRows()).clone()) {
                            TableRowImpl i = (TableRowImpl)n;
                            PriceComplete c = i.getPositionPrice();
                            if (price == null) {
                                price = new PriceComplete();
                                price.setCurrency(c.getCurrency());
                                price.setPrice(Double.valueOf(0.0));
                            }
                            if (c == null) {
                                c = new PriceComplete();
                                c.setCurrency(c.getCurrency());
                                c.setPrice(Double.valueOf(0.0));
                            }
                            if (price.getCurrency().equals((Object)c.getCurrency())) {
                                price.setPrice(Double.valueOf(price.getPrice() + c.getPrice()));
                                continue;
                            }
                            double p = c.getPrice() * c.getCurrency().getCurrentVariant().getExchangeRate();
                            price.setPrice(Double.valueOf(price.getPrice() + p));
                        }
                        if (price == null) {
                            price = new PriceComplete();
                        }
                        if (price.getCurrency() == null) {
                            price.setCurrency(settings.getCurrency());
                        }
                        if (price.getPrice() == null) {
                            price.setPrice(Double.valueOf(0.0));
                        }
                        OrderBreadCrumbComponentTable.this.positionCosts = price;
                        SupplierComplete supplier = (SupplierComplete)OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierField()).getValue(SupplierComplete.class);
                        if (supplier == null) {
                            SupplierLight supL = (SupplierLight)OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierField()).getValue(SupplierLight.class);
                            if (supL == null) {
                                return;
                            }
                            supplier = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier(new SupplierReference(supL.getId())).getValue();
                            OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierField()).setValue((Object)supplier, 0L);
                            return;
                        }
                        PriceComplete ds = null;
                        if (supplier.getCostType() != null) {
                            switch (supplier.getCostType()) {
                                case FIX: {
                                    ds = new PriceComplete(supplier.getDeliveryCost());
                                    break;
                                }
                                case MINAMOUNT: {
                                    PriceComplete costs = OrderBreadCrumbComponentTable.this.positionCosts;
                                    if (costs == null) {
                                        costs = new PriceComplete(supplier.getPaymentCurrency(), Double.valueOf(0.0));
                                    }
                                    PriceComplete minValue = supplier.getMinOrderValue();
                                    if (!(costs.getPrice() < minValue.getPrice())) break;
                                    ds = new PriceComplete(supplier.getDeliveryCost());
                                    break;
                                }
                                case NONE: {
                                    break;
                                }
                            }
                        }
                        PriceComplete tp = new PriceComplete(supplier.getPaymentCurrency(), Double.valueOf(0.0));
                        tp.setPrice(price.getPrice());
                        String t = "Material Cost: ";
                        t = t + price.getFormattedPrice() + " " + price.getCurrency().getCode();
                        t = t + ", Delivery Costs: ";
                        if (ds != null) {
                            t = t + ds.getFormattedPrice() + " " + ds.getCurrency().getCode();
                            tp.setPrice(Double.valueOf(tp.getPrice() + ds.getPrice()));
                        } else {
                            t = t + "0.00 " + supplier.getPaymentCurrency().getCode();
                        }
                        t = t + " => TOTAL: " + tp.getFormattedPrice() + " " + tp.getCurrency().getCode();
                        if (OrderBreadCrumbComponentTable.this.totalCompPrice != null) {
                            Node pn = OrderBreadCrumbComponentTable.this.totalCompPrice.getNode();
                            if (pn == null) {
                                pn = new Node();
                                OrderBreadCrumbComponentTable.this.totalCompPrice.setNode(pn);
                            }
                            pn.setValue((Object)t, 0L);
                            pn.updateNode();
                            OrderBreadCrumbComponentTable.this.totalCompPrice.updateString();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean isAlive() {
                if (OrderBreadCrumbComponentTable.this.totalCompPrice == null) {
                    return false;
                }
                return !OrderBreadCrumbComponentTable.this.totalCompPrice.isKilled();
            }
        };
        this.totalCompPrice.setRunnable(run);
    }

    private void updateDeliveryTime() throws ClientServerCallException {
        Boolean autoCalc;
        Integer maxDeliveryDays = 0;
        Iterator it = this.table.getModel().getNode().getParent().getChildNamed(this.fieldAccessor.getPositionField()).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node condition;
            Node n = (Node)it.next();
            Node articleNode = n.getChildNamed(this.fieldAccessor.getArticleField());
            if (articleNode == null || articleNode.getValue() == null || (condition = n.getChildNamed(this.fieldAccessor.getSupplierConditionField())) == null || condition.getValue() == null) continue;
            Integer days = ((SupplierConditionComplete)condition.getValue()).getDeliveryTime();
            if (days == null) {
                days = 0;
            }
            if (maxDeliveryDays >= days) continue;
            maxDeliveryDays = days;
        }
        if (maxDeliveryDays != 0 && Boolean.TRUE.equals(autoCalc = (Boolean)this.table.getModel().getNode().getParent().getChildNamed(PurchaseOrderComplete_.autoCalculateDeliveryTime).getValue())) {
            long aDay = 86400000L;
            long offsetTime = aDay * (long)maxDeliveryDays.intValue();
            Date newDeliveryDate = new PeriodComplete(new Date(System.currentTimeMillis() + offsetTime), new Date(System.currentTimeMillis() + offsetTime)).getStartDate();
            Date oldDate = (Date)this.table.getModel().getNode().getParent().getChildNamed(this.fieldAccessor.getDeliveryDateField()).getValue();
            if (newDeliveryDate.getTime() != oldDate.getTime() && newDeliveryDate.getTime() > oldDate.getTime()) {
                this.table.getModel().getNode().getParent().getChildNamed(this.fieldAccessor.getDeliveryDateField()).setValue((Object)newDeliveryDate, 0L);
            }
        }
    }

    @Override
    public Table2RowPanel getComponentTableRow(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void addButtonPressed(int x, int y) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public List<TableColumnInfo> getColumns(Node node) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 40, 40, 40));
        int tw1 = this.getTable().getCellPadding() * 2 + InputComboBox2.getPreferredWidth(this, 11);
        int tw2 = tw1 - 50;
        columns.add(new TableColumnInfo(Words.DEPARTMENT, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.CALC, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.STOCK, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(Words.ORDER_INFO, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.DELIVERY_TIME, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.WARNING, null, null, null, "", 120, 120, 120));
        int tw = this.getTable().getCellPadding() * 2 + ArrowButton.getPreferredWidth();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void kill() {
        super.kill();
    }

    @Override
    public boolean hasAddButton() {
        return false;
    }

    public Converter<Object, String> getTitleConverter() {
        return ConverterRegistry.getConverter(PositionsColumnTitleConverter.class);
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    private Node getSupplierList(Node article, Node currentSupplierCondition) {
        SupplierConditionComplete selectedCondition = currentSupplierCondition != null ? (SupplierConditionComplete)currentSupplierCondition.getValue() : null;
        ViewNode nn = new ViewNode("");
        Timestamp validity = new Timestamp(System.currentTimeMillis());
        Iterator it = article.getChildNamed(BasicArticleComplete_.suppliers).getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            for (SupplierConditionCategoryComplete category : ((SupplierConditionBaseComplete)n.getValue()).getSupplierConditionCategory()) {
                for (SupplierConditionComplete condition : category.getConditions()) {
                    if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    if (selectedCondition != null && condition.equals((Object)selectedCondition.getOriginCondition())) {
                        nn.addChild((Node)new DTOProxyNode((Object)selectedCondition), 0L);
                        continue;
                    }
                    nn.addChild((Node)new DTOProxyNode((Object)condition), 0L);
                }
            }
        }
        return nn;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private InternalCostCenterComplete backupDepartment;
        private StoreLight backupPos;
        private TextLabel article;
        private InfoButton articleInfo;
        private EditButton editStoreAndDepartment;
        private InputComboBox2 quantity;
        private ArrowButton moveSupplier;
        private ReloadablePriceView positionPrice;
        private StockTransactionRemarkButton remark;
        private QuantityRenderer calcQty;
        private QuantityRenderer stockQty;
        private TextLabel orderInfo;
        private TextLabel deliveryTime;
        private TextLabel warning;
        private TextLabel department;
        private boolean deliveryTimeChecked;
        private PriceComplete positionCosts;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.deliveryTimeChecked = false;
            this.article = new TextLabel(this.model.getNode(), ConverterRegistry.getConverter(PositionNameConverter.class));
            this.articleInfo = new InfoButton();
            this.quantity = new InputComboBox2(this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.amount}), this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            this.updateInfoPopupAndSelectableUnits();
            this.editStoreAndDepartment = new EditButton();
            this.editStoreAndDepartment.addButtonListener((source, x, y) -> {
                if (!OrderBreadCrumbComponentTable.this.workOnPreviewBase) {
                    this.backupPos = (StoreLight)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore).getValue();
                    this.backupDepartment = (InternalCostCenterComplete)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.department).getValue();
                    InnerPopupFactory.showStoreChangePopup(x, y, (Node<StoreLight>)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore), (Node<InternalCostCenterComplete>)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.department), (Node<Boolean>)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.useCommentAsName), (Node<String>)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment), this.editStoreAndDepartment, (source1, xargs) -> {
                        if (xargs == null) {
                            if (this.model.getNode() != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore) != null) {
                                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore).setValue((Object)this.backupPos, System.currentTimeMillis());
                            }
                            if (this.model.getNode() != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department) != null) {
                                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department).setValue((Object)this.backupDepartment, System.currentTimeMillis());
                            }
                        }
                        this.article.updateString();
                    });
                }
            });
            this.department = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.department), ConverterRegistry.getConverter(CostCenterConverter.class));
            this.calcQty = new QuantityRenderer((Node<?>)this.model.getNode().getChildNamed(new String[]{"calcQty"}));
            this.stockQty = new QuantityRenderer((Node<?>)this.model.getNode().getChildNamed(new String[]{"stockQty"}));
            this.remark = new StockTransactionRemarkButton(false, null);
            this.remark.addButtonListener(this);
            this.warning = new TextLabel();
            this.orderInfo = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition), ConverterRegistry.getConverter(SupplierConditionOrderIntervallConverter.class));
            this.deliveryTime = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition), ConverterRegistry.getConverter(SupplierConditionDeliveryTimeConverter.class));
            this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.amount}).addNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.unit}).addNodeListener((NodeListener)this);
            OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(PurchaseOrderComplete_.orderDate).addNodeListener((NodeListener)this);
            OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(PurchaseOrderComplete_.deliveryDate).addNodeListener((NodeListener)this);
            this.moveSupplier = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Right);
            this.moveSupplier.addButtonListener(this);
            this.positionPrice = new ReloadablePriceView((LoadingGroup)OrderBreadCrumbComponentTable.this.loader, EstimatedPositionPriceConverter.class);
            this.setCalculationAlgorithm();
            this.setLayout(new Layout());
            this.positionPrice.load(true);
            this.add(this.article);
            this.add(this.articleInfo);
            this.add(this.quantity);
            this.add(this.positionPrice);
            this.add(this.moveSupplier);
            this.add(this.remark);
            this.add(this.calcQty);
            this.add(this.stockQty);
            this.add(this.warning);
            this.add(this.orderInfo);
            this.add(this.deliveryTime);
            this.add(this.editStoreAndDepartment);
            this.add(this.department);
        }

        private SupplierLight getSupplier() {
            return (SupplierLight)this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField(), SupplierConditionComplete_.supplier}).getValue();
        }

        private Date getDeliveryDate() {
            return (Date)OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getDeliveryDateField()).getValue();
        }

        private Date getOrderDate() {
            return (Date)OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getOrderDateField()).getValue();
        }

        private Timestamp getOrderTimestamp() {
            return new Timestamp(((Date)OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getDeliveryDateField()).getValue()).getTime());
        }

        public Double getAmount() {
            Node node = this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.amount});
            if (node.getValue() instanceof Double) {
                return (Double)node.getValue();
            }
            if (node.getValue() instanceof Integer) {
                return ((Integer)node.getValue()).doubleValue();
            }
            if (node.getValue() instanceof Long) {
                return ((Long)node.getValue()).doubleValue();
            }
            return 0.0;
        }

        public UnitComplete getUnit() {
            return (UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.unit}).getValue();
        }

        public UnitComplete getPriceUnit() {
            return (UnitComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionPriceUnitField()).getValue();
        }

        public CurrencyComplete getSupplierPriceCurrency() {
            return (CurrencyComplete)this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierPriceField(), PriceComplete_.currency}).getValue();
        }

        public Double getSupplierPricePrice() {
            return (Double)this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierPriceField(), PriceComplete_.price}).getValue();
        }

        private void updateSupplierCondition() {
            SupplierLight supplier = (SupplierLight)this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField(), SupplierConditionComplete_.supplier}).getValue();
            BasicArticleComplete artN = (BasicArticleComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getArticleField()).getValue(BasicArticleComplete.class);
            if (artN == null || supplier == null) {
                return;
            }
            SupplierConditionBaseComplete scb = artN.getSupplier((SupplierReference)supplier);
            SupplierConditionComplete sc = null;
            Boolean useTaxZone = (Boolean)this.model.getNode().getParent().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getUseTaxZoneField()).getValue();
            TaxZoneComplete taxZone = (TaxZoneComplete)this.model.getNode().getParent().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getTaxZoneField()).getValue();
            Timestamp validity = this.getOrderTimestamp();
            ArrayList<SupplierConditionComplete> conditions = new ArrayList<SupplierConditionComplete>();
            for (SupplierConditionCategoryComplete category : scb.getSupplierConditionCategory()) {
                boolean useCondition = false;
                if (Boolean.TRUE.equals(useTaxZone)) {
                    if (category.getTaxZone() == null) {
                        if (taxZone == null) {
                            useCondition = true;
                        }
                    } else if (category.getTaxZone().equals((Object)taxZone)) {
                        useCondition = true;
                    }
                } else {
                    useCondition = true;
                }
                if (!useCondition) continue;
                for (SupplierConditionComplete condition : category.getConditions()) {
                    if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    conditions.add(condition);
                }
            }
            double lowestPrice = 2.147483647E9;
            for (SupplierConditionComplete condition : conditions) {
                PriceComplete price = ((StepPriceFunctionComplete)condition.getStepPrice().getSteps().get(0)).getPrice();
                if (!(price.getPrice() < lowestPrice)) continue;
                lowestPrice = price.getPrice();
                sc = condition;
            }
            if (sc == null && !conditions.isEmpty()) {
                sc = (SupplierConditionComplete)conditions.get(0);
            }
            if (sc == null) {
                throw new IllegalStateException("No Supplier Condition found for Article " + artN.getNumber() + " - " + artN.getName() + " and Supplier " + supplier.getName());
            }
            SupplierConditionComplete nsc = CopyTemplateToolkit.copySupplierCondition(sc);
            SupplierConditionComplete oldCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).getValue();
            boolean revalidateDeliveryDate = false;
            if (oldCondition != null && nsc.getDeliveryTime() != null) {
                if (nsc.getDeliveryTime().equals(oldCondition.getDeliveryTime())) {
                    revalidateDeliveryDate = true;
                }
            } else {
                revalidateDeliveryDate = true;
            }
            this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).setValue((Object)nsc, 0L);
            this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).updateNode();
            this.updateSupplierPrice(nsc);
            this.updateEstimatedCosts(artN);
            this.updatePositionWarnings();
            this.updateArticleInfo(artN);
            if (revalidateDeliveryDate || !this.deliveryTimeChecked) {
                try {
                    this.deliveryTimeChecked = true;
                    OrderBreadCrumbComponentTable.this.updateDeliveryTime();
                }
                catch (ClientServerCallException e) {
                    e.printStackTrace();
                }
            }
        }

        private void updateSupplierPrice(SupplierConditionComplete nsc) {
            PriceAndUnitComplete a = null;
            SupplierConditionComplete sc = (SupplierConditionComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).getValue();
            BasicArticleComplete artN = (BasicArticleComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getArticleField()).getValue(BasicArticleComplete.class);
            Node priceNode = this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierPriceField(), PriceComplete_.price});
            Node currencyNode = this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierPriceField(), PriceComplete_.currency});
            Node priceUnit = this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionPriceUnitField());
            Node contractEntry = this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionContractEntryField());
            try {
                if (priceNode.getValue() != null && currencyNode.getValue() != null && priceUnit.getValue() != null) {
                    a = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice((BasicArticleReference)artN, (SupplierReference)sc.getSupplier(), new DateWrapper(this.getOrderDate()), new QuantityComplete(this.getAmount(), this.getUnit()), this.getUseTaxZone(), this.getTaxZone(), nsc);
                }
            }
            catch (Exception e) {
                contractEntry.setValue(null, 0L);
                return;
            }
            if (a == null) {
                contractEntry.setValue(null, 0L);
                return;
            }
            priceNode.setValue((Object)a.getPrice().getPrice(), 0L);
            currencyNode.setValue((Object)a.getPrice().getCurrency(), 0L);
            priceUnit.setValue((Object)a.getUnit(), 0L);
            contractEntry.setValue((Object)a.getContractEntry(), 0L);
        }

        private TaxZoneComplete getTaxZone() {
            return (TaxZoneComplete)this.model.getNode().getParent().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getTaxZoneField()).getValue();
        }

        private Boolean getUseTaxZone() {
            return (Boolean)this.model.getNode().getParent().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getUseTaxZoneField()).getValue();
        }

        private void updateEstimatedCosts(BasicArticleComplete article) {
            try {
                Double a = this.getAmount();
                UnitComplete u = this.getUnit();
                UnitComplete pu = this.getPriceUnit();
                Double sp = this.getSupplierPricePrice();
                CurrencyComplete spc = this.getSupplierPriceCurrency();
                double amountInPriceUnit = UnitConversionToolkit.convertUnit((UnitComplete)u, (UnitComplete)pu, (double)a, (BasicArticleLight)article, (Timestamp)new Timestamp(this.getOrderDate().getTime()));
                double orderPosValue = amountInPriceUnit * sp;
                PriceComplete p = new PriceComplete(spc, Double.valueOf(orderPosValue));
                if (p != null) {
                    Node pn = this.positionPrice.getNode();
                    if (pn == null) {
                        pn = new EmbeddedDTONode();
                        this.positionPrice.setNode(pn);
                    }
                    pn.setValue((Object)p, 0L);
                    pn.updateNode();
                    this.positionPrice.updateString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void updateArticleInfo(BasicArticleComplete article) {
            List packingQuantities;
            SupplierConditionComplete scc = (SupplierConditionComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).getValue();
            if (Boolean.TRUE.equals(scc.getUsePackingQuantity())) {
                packingQuantities = scc.getPackingQuantities();
            } else {
                PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)article, (Timestamp)this.getOrderTimestamp());
                packingQuantities = packingQuantity.getPackingQuantities();
            }
            this.articleInfo.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)this.model.getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), new Timestamp(System.currentTimeMillis()), 373065, false, packingQuantities));
        }

        private void updatePositionWarnings() {
            String text;
            Color okColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.ok.color"));
            Color fatalColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.fatal.color"));
            Color warningsColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.warning.color"));
            BasicArticleComplete article = null;
            if (this.model != null && this.model.getNode() != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article) != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class) != null) {
                article = (BasicArticleComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            }
            Color selectedColor = okColor;
            if (article == null) {
                text = "Article not loaded, please reinsert";
                selectedColor = fatalColor;
            } else if (!this.isContractStateValid(article)) {
                text = "No Contract found";
                selectedColor = fatalColor;
            } else {
                text = "";
                if (!this.isIntervallValid(article)) {
                    text = text + "Min Order/Interval amount violation, ";
                    selectedColor = warningsColor;
                }
                if (!this.isDeliveryTimeValid(article)) {
                    text = text + "Delivery Time violation, ";
                    selectedColor = warningsColor;
                }
                if (!this.isCheapestSupplier(article)) {
                    text = text + "Not cheapest Supplier, ";
                    selectedColor = warningsColor;
                }
                if (article.getState() == ArticleModificationStateE.DRAFT) {
                    text = text + "DRAFT Article, ";
                    selectedColor = warningsColor;
                }
                if (article.getState() == ArticleModificationStateE.DUMMY) {
                    text = text + "DUMMY Article, ";
                    selectedColor = warningsColor;
                }
                if (!this.isCurrencyValid()) {
                    text = text + "Currency missmatch with Supplier, ";
                    selectedColor = fatalColor;
                }
                text = text.isEmpty() ? "ok" : text.substring(0, text.length() - 2);
            }
            this.warning.setText(text);
            this.warning.setForeground(selectedColor);
        }

        private boolean isIntervallValid(BasicArticleComplete article) {
            SupplierConditionComplete condition = (SupplierConditionComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).getValue();
            QuantityComplete orderedAmount = new QuantityComplete();
            orderedAmount.setQuantity(this.getAmount());
            orderedAmount.setUnit(this.getUnit());
            UnitComplete unit = condition.getMinOrderAmountUnit() != null ? condition.getMinOrderAmountUnit() : condition.getOrderUnit();
            double ca = UnitConversionToolkit.convertUnit((UnitComplete)orderedAmount.getUnit(), (UnitComplete)unit, (double)orderedAmount.getQuantity(), (BasicArticleLight)article, (Timestamp)new Timestamp(this.getOrderDate().getTime()));
            return ca % condition.getMinOrderAmount() == 0.0;
        }

        public boolean isCurrencyValid() {
            Node currency = this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierPriceField(), PriceComplete_.currency});
            return this.getSupplier().getPaymentCurrency().equals(currency.getValue());
        }

        private boolean isDeliveryTimeValid(BasicArticleComplete article) {
            SupplierConditionComplete condition = (SupplierConditionComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).getValue();
            Date deliveryDate = this.getDeliveryDate();
            Date toDay = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())).getStartDate();
            long difInMillis = deliveryDate.getTime() - toDay.getTime();
            long aDay = 86400000L;
            long maxDif = (long)condition.getDeliveryTime().intValue() * aDay;
            return maxDif <= difInMillis;
        }

        private boolean isContractStateValid(BasicArticleComplete article) {
            if (Boolean.TRUE.equals(article.getMarkedAsContracted())) {
                Node contractEntry = this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionContractEntryField());
                if (contractEntry == null) {
                    return false;
                }
                if (contractEntry.getValue() == null) {
                    return false;
                }
            }
            return true;
        }

        private boolean isCheapestSupplier(BasicArticleComplete article) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            SupplierConditionComplete sc = ArticleToolkit.getCheapestSupplier(article, (Node<UnitComplete>)this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.unit}), (Node<Object>)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}), false, null, settings, this, OrderBreadCrumbComponentTable.this.articlePanel.getAccessor(), new Timestamp(this.getOrderDate().getTime()));
            SupplierConditionComplete currentCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).getValue();
            if (sc == null) {
                return false;
            }
            return currentCondition.getSupplier().equals((Object)sc.getSupplier());
        }

        private void setCalculationAlgorithm() {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    try {
                        TableRowImpl.this.updateSupplierCondition();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public boolean isAlive() {
                    if (TableRowImpl.this.positionPrice != null) {
                        return !TableRowImpl.this.positionPrice.isKilled();
                    }
                    return false;
                }
            };
            this.positionPrice.setRunnable(run);
        }

        public PriceComplete getPositionPrice() {
            if (this.positionPrice != null && this.positionPrice.getNode() != null && this.positionPrice.getNode().getValue() != null) {
                return (PriceComplete)this.positionPrice.getNode().getValue();
            }
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.amount}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getPositionQuantityField(), StoreQuantityComplete_.unit}).removeNodeListener((NodeListener)this);
            OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getOrderDateField()).removeNodeListener((NodeListener)this);
            OrderBreadCrumbComponentTable.this.table.getModel().getNode().getParent().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getDeliveryDateField()).removeNodeListener((NodeListener)this);
            this.article.kill();
            this.articleInfo.kill();
            this.quantity.kill();
            this.moveSupplier.kill();
            this.positionPrice.kill();
            this.remark.kill();
            this.orderInfo.kill();
            this.deliveryTime.kill();
            this.warning.kill();
            this.editStoreAndDepartment.kill();
            this.department.kill();
            this.article = null;
            this.articleInfo = null;
            this.quantity = null;
            this.moveSupplier = null;
            this.positionPrice = null;
            this.remark = null;
            this.orderInfo = null;
            this.deliveryTime = null;
            this.warning = null;
            this.editStoreAndDepartment = null;
            this.department = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.quantity.getFocusComponents();
            CheckedListAdder.addToList(a, this.moveSupplier);
            CheckedListAdder.addToList(a, this.remark);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbComponentTable.this.fieldAccessor.getArticleField(), BasicArticleLight_.number}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.editStoreAndDepartment.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.article.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.articleInfo.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.moveSupplier.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.positionPrice.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.remark.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.warning.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.orderInfo.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.deliveryTime.setEnabled(isEnabled && !OrderBreadCrumbComponentTable.this.ordersFixed);
            this.department.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.moveSupplier) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, "Move Positions..");
                popUp.hideCancelButton();
                Node currentCondition = this.model.getNode().getChildNamed(new String[]{"supplier"});
                if (currentCondition == null) {
                    currentCondition = this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField());
                    SupplierConditionComplete data = (SupplierConditionComplete)currentCondition.getValue();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)data, false, true);
                    node.setName("supplier");
                    this.model.getNode().addChild(node, 0L);
                }
                popUp.setView(new SupplierChangePopup((Node<SupplierConditionComplete>)currentCondition, (Node<List<SupplierConditionComplete>>)OrderBreadCrumbComponentTable.this.getSupplierList(this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getArticleField()), currentCondition), (Converter<SupplierConditionComplete, String>)ConverterRegistry.getConverter(SupplierConditionOrderCostsConverter.class)));
                popUp.showPopUp(x, y, 350, -1, this, source);
            } else if (source == this.remark) {
                InnerPopupFactory.showEnterMessagePopup("Enter Comment", this, this.remark, this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getCommentField()), x, y);
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (xargs == null || xargs.length == 0) {
                return;
            }
            if (xargs[0] instanceof SupplierConditionComplete) {
                SupplierConditionComplete oldOne;
                SupplierConditionComplete newOne = (SupplierConditionComplete)xargs[0];
                Node oSupplier = this.model.getNode().getChildNamed(new String[]{"supplier"});
                if (oSupplier == null) {
                    oSupplier = this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField());
                }
                if (!(oldOne = (SupplierConditionComplete)oSupplier.getValue()).equals((Object)newOne)) {
                    OrderBreadCrumbComponentTable.this.articlePanel.block();
                    OrderBreadCrumbComponentTable.this.articlePanel.switchSuppliers(this.model.getNode(), oldOne, newOne, newOne.getCategoryTaxZone() != null, newOne.getCategoryTaxZone());
                    OrderBreadCrumbComponentTable.this.articlePanel.unblock();
                    if (oSupplier != null) {
                        oSupplier.removeExistingValues();
                        oSupplier.setValue((Object)newOne, 0L);
                    }
                }
            } else {
                this.ensureCommentState();
            }
        }

        private void ensureCommentState() {
            if (this.model.getNode().getChildNamed(new String[]{"comment"}).getValue() == null || ((String)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getCommentField()).getValue()).isEmpty()) {
                this.remark.setChoosen(false);
            } else {
                this.remark.setChoosen(true);
            }
        }

        public void valueChanged(Node<?> node) {
            if (this.positionPrice != null) {
                this.positionPrice.load(true);
            }
            this.updateInfoPopupAndSelectableUnits();
        }

        private void updateInfoPopupAndSelectableUnits() {
            SupplierConditionComplete supplierCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getSupplierConditionField()).getValue();
            Date orderDate = this.getOrderDate();
            Timestamp validity = new Timestamp(orderDate.getTime());
            try {
                String articleInfoPopupString = ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getArticleField()).getValue(BasicArticleComplete.class), validity, 373065, false);
                this.articleInfo.installStringViewer(articleInfoPopupString);
            }
            catch (Exception e) {
                log.debug(e.getMessage(), (Throwable)e);
                this.articleInfo.installStringViewer("Error while load Article Information");
            }
            if (supplierCondition != null && Boolean.TRUE.equals(supplierCondition.getUsePackingQuantity())) {
                this.quantity.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(supplierCondition));
            } else {
                BasicArticleComplete ac = (BasicArticleComplete)this.model.getNode().getChildNamed(OrderBreadCrumbComponentTable.this.fieldAccessor.getArticleField()).getValue(BasicArticleComplete.class);
                List<Object> list = null;
                list = ac != null ? StoreToolkit.getPossibleUnits((BasicArticleLight)ac, (SupplierConditionComplete)supplierCondition, (Timestamp)validity, (TransactionType)TransactionType.PURCHASE, (UserComplete)OrderBreadCrumbComponentTable.this.currentUser, null, null, (SystemSettingsComplete)OrderBreadCrumbComponentTable.this.settings) : new ArrayList<UnitComplete>();
                this.quantity.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + 3 * TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.articleInfo.getPreferredSize().getWidth() + TableRowImpl.this.remark.getPreferredSize().getWidth() + TableRowImpl.this.editStoreAndDepartment.getPreferredSize().getWidth())), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                TableRowImpl.this.articleInfo.setLocation(TableRowImpl.this.article.getX() + TableRowImpl.this.article.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.articleInfo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.articleInfo.setSize(TableRowImpl.this.articleInfo.getPreferredSize());
                TableRowImpl.this.remark.setLocation(TableRowImpl.this.articleInfo.getX() + TableRowImpl.this.articleInfo.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remark.setSize(TableRowImpl.this.remark.getPreferredSize());
                TableRowImpl.this.editStoreAndDepartment.setLocation(TableRowImpl.this.remark.getX() + TableRowImpl.this.remark.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editStoreAndDepartment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editStoreAndDepartment.setSize(TableRowImpl.this.editStoreAndDepartment.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.department.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.department.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.department.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.department.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.calcQty.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.calcQty.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.calcQty.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.calcQty.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.stockQty.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stockQty.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stockQty.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stockQty.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.positionPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.positionPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.positionPrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.positionPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.orderInfo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.orderInfo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.orderInfo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.orderInfo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.deliveryTime.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deliveryTime.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deliveryTime.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.deliveryTime.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(8);
                TableRowImpl.this.warning.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.warning.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.warning.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.warning.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(9);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.moveSupplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.moveSupplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.moveSupplier.setSize(TableRowImpl.this.moveSupplier.getPreferredSize());
            }
        }
    }
}

