/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DeliveryTermConverter;
import ch.icit.pegasus.client.converter.OrderDeliveryWindowConverter;
import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.PurchasePreviewToPurchaseFieldAccessor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DeliveryTermComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class OrderConfigPopup
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private final Node<?> node;
    private final boolean isSolarCompany;
    private TitledItem<ComboBox> department;
    private TitledItem<ComboBox> customer;
    private TitledItem<ComboBox> deliveryWindow;
    private TitledItem<ComboBox> deliveryAddress;
    private TitledItem<ComboBox> incoTerms;
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<DateChooser> orderDate;
    private TitledItem<ScrollableTextArea> orderRemark;
    private TitledItem<ScrollableTextArea> orderFooter;
    private TitledItem<MultiLocationComboBox> location;
    private TitledItem<CheckBox> useTaxZone;
    private TitledItem<ComboBox> taxZone;
    private TitledItem<CheckBox> reorder;
    private TitledItem<ComboBox> customerOwnedOnly;
    private TitledItem<ComboBox> halalOrder;
    private PurchasePreviewToPurchaseFieldAccessor fieldAccessor;
    private boolean editable;
    private boolean previewMode;
    private SystemSettingsComplete settings;
    private SystemViewSettingsComplete viewSettings;

    public OrderConfigPopup(Node<?> node, PurchasePreviewToPurchaseFieldAccessor fieldAccessor, boolean editable, boolean previewMode) {
        Date d;
        this.node = node;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.fieldAccessor = fieldAccessor;
        this.editable = editable;
        this.previewMode = previewMode;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        node.getChildNamed(fieldAccessor.getAutoCalculateDeliveryTimeField()).setValue((Object)false, 0L);
        if (node.getChildNamed(fieldAccessor.getCostCenterField()).getValue() == null && !previewMode) {
            node.getChildNamed(fieldAccessor.getCostCenterField()).setValue((Object)settings.getDefaultMPOCCostCenter(), 0L);
        }
        if (node.getChildNamed(fieldAccessor.getOrderDeliveryWindowField()).getValue() == null) {
            node.getChildNamed(fieldAccessor.getOrderDeliveryWindowField()).setValue((Object)settings.getDefaultReceiveWindow(), 0L);
        }
        if (node.getChildNamed(fieldAccessor.getDeliveryAddressField()).getValue() == null) {
            node.getChildNamed(fieldAccessor.getDeliveryAddressField()).setValue((Object)settings.getDefaultDeliveryAddress(), 0L);
        }
        if (!this.isSolarCompany && node.getChildNamed(fieldAccessor.getDeliveryTermField()).getValue() == null) {
            node.getChildNamed(fieldAccessor.getDeliveryTermField()).setValue((Object)settings.getDefaultDeliveryTerm(), 0L);
        }
        if (node.getChildNamed(fieldAccessor.getFooterField()).getValue() == null) {
            node.getChildNamed(fieldAccessor.getFooterField()).setValue((Object)settings.getDefaultOrderFooter(), 0L);
        }
        if (!this.isSolarCompany) {
            Node newValues = ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), (Node<InternalCostCenterComplete>)node.getChildNamed(fieldAccessor.getCostCenterField()), ComboBoxFactory.DepartmentType.PURCHASE_ORDER);
            this.department = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(fieldAccessor.getCostCenterField()), newValues, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
            this.department.getElement().refreshPossibleValues(newValues);
            this.customer = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(fieldAccessor.getCustomerField()), NodeToolkit.getAffixList(ExternalCostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
            this.incoTerms = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(fieldAccessor.getDeliveryTermField()), NodeToolkit.getAffixList(DeliveryTermComplete.class), ConverterRegistry.getConverter(DeliveryTermConverter.class)), Words.INCO_TERMS, TitledItem.TitledItemOrientation.NORTH);
            this.customerOwnedOnly = new TitledItem<ComboBox>(ComboBoxFactory.getCustomerOwned(Boolean.TRUE.equals(settings.getAllowMixedOrdersWithCustomerOwnedArticles())), Words.CUSTOMER_OWNED_ONLY, TitledItem.TitledItemOrientation.NORTH);
            this.customerOwnedOnly.getElement().addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.updateCustomerOwnedSearchState();
                }
            });
            this.selectCustomerOwnedState();
            this.halalOrder = new TitledItem<ComboBox>(ComboBoxFactory.getHalal(true), Words.HALAL_ORDER, TitledItem.TitledItemOrientation.NORTH);
            this.halalOrder.getElement().addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.updateHalalSearchState();
                }
            });
            this.selectHalalState();
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.location = new TitledItem<MultiLocationComboBox>(new MultiLocationComboBox(node.getChildNamed(fieldAccessor.getEligibleLocationField()), true), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
            }
            this.reorder = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(fieldAccessor.getReorderField())), Words.REORDER, TitledItem.TitledItemOrientation.EAST);
        }
        this.deliveryWindow = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(fieldAccessor.getOrderDeliveryWindowField()), NodeToolkit.getAffixList(OrderDeliveryWindowComplete.class), ConverterRegistry.getConverter(OrderDeliveryWindowConverter.class)), Words.DELIVERY_TIME_WINDOW, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAddress = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(fieldAccessor.getDeliveryAddressField()), NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(new String[]{"deliveryAddresses"}), ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
        this.orderRemark = new TitledItem<ScrollableTextArea>(new ScrollableTextArea((Node<String>)node.getChildNamed(fieldAccessor.getRemarkField())), Words.REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.orderFooter = new TitledItem<ScrollableTextArea>(new ScrollableTextArea((Node<String>)node.getChildNamed(fieldAccessor.getFooterField())), Words.FOOTER, TitledItem.TitledItemOrientation.NORTH);
        this.orderRemark.setIgnorePrefHeight(true);
        this.orderFooter.setIgnorePrefHeight(true);
        if (node.getChildNamed(fieldAccessor.getDeliveryDateField()).getValue() == null) {
            d = new Date(System.currentTimeMillis() + 86400000L);
            node.getChildNamed(fieldAccessor.getDeliveryDateField()).setValue((Object)d, 0L);
        }
        if (node.getChildNamed(fieldAccessor.getOrderDateField()).getValue() == null) {
            d = new Date(System.currentTimeMillis());
            node.getChildNamed(fieldAccessor.getOrderDateField()).setValue((Object)d, 0L);
        }
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(node.getChildNamed(fieldAccessor.getDeliveryDateField())), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.orderDate = new TitledItem<DateChooser>(new DateChooser(node.getChildNamed(fieldAccessor.getOrderDateField())), Words.ORDER_DATE, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(settings.getAllowTaxZoneRelatedSupplierCondition())) {
            this.useTaxZone = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(fieldAccessor.getUseTaxZoneField())), Words.USE_TAX_ZONE, TitledItem.TitledItemOrientation.EAST);
            this.taxZone = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(fieldAccessor.getTaxZoneField()), NodeToolkit.getAffixList(TaxZoneComplete.class), ConverterRegistry.getConverter(TaxZoneConverter.class), true), Words.TAX_ZONE, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setLayout(new Layout());
        if (!this.isSolarCompany) {
            this.add(this.department);
            this.add(this.customer);
            this.add(this.incoTerms);
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.add(this.location);
            }
            this.add(this.reorder);
            if (this.useTaxZone != null) {
                this.add(this.useTaxZone);
                this.add(this.taxZone);
            }
            this.add(this.customerOwnedOnly);
            this.add(this.halalOrder);
        }
        this.add(this.deliveryAddress);
        this.add(this.deliveryDate);
        this.add(this.orderDate);
        this.add(this.deliveryWindow);
        this.add(this.orderRemark);
        this.add(this.orderFooter);
        this.setEnabled(true);
    }

    private void updateCustomerOwnedSearchState() {
        if (!this.previewMode) {
            Object[] o = new Object[7];
            Boolean selectedType = null;
            if (this.customerOwnedOnly.getElement().getSelectedItem().equals(Words.ALL)) {
                selectedType = null;
            } else if (this.customerOwnedOnly.getElement().getSelectedItem().equals(Words.CUSTOMER_OWNED)) {
                selectedType = true;
            } else if (this.customerOwnedOnly.getElement().getSelectedItem().equals(Words.NOT_CUSTOMER_OWNED)) {
                selectedType = false;
            }
            this.node.getChildNamed(PurchaseOrderComplete_.customerOwnedOnly).setValue(selectedType, 0L);
        }
    }

    private void updateHalalSearchState() {
        if (!this.previewMode) {
            Object[] o = new Object[7];
            Boolean selectedType = null;
            if (this.halalOrder.getElement().getSelectedItem().equals(Words.ALL)) {
                selectedType = null;
            } else if (this.halalOrder.getElement().getSelectedItem().equals(Words.HALAL_ONLY)) {
                selectedType = true;
            } else if (this.halalOrder.getElement().getSelectedItem().equals(Words.NOT_HALAL_ONLY)) {
                selectedType = false;
            }
            this.node.getChildNamed(PurchaseOrderComplete_.halalOrder).setValue(selectedType, 0L);
        }
    }

    private void selectCustomerOwnedState() {
        if (!this.previewMode) {
            Boolean type = (Boolean)this.node.getChildNamed(PurchaseOrderComplete_.customerOwnedOnly).getValue();
            if (Boolean.TRUE.equals(type)) {
                this.customerOwnedOnly.getElement().setSelectedItem(Words.CUSTOMER_OWNED);
            } else if (Boolean.FALSE.equals(type)) {
                this.customerOwnedOnly.getElement().setSelectedItem(Words.NOT_CUSTOMER_OWNED);
            } else {
                this.customerOwnedOnly.getElement().setSelectedItem(Words.ALL);
            }
        }
    }

    private void selectHalalState() {
        if (!this.previewMode) {
            Boolean type = (Boolean)this.node.getChildNamed(PurchaseOrderComplete_.halalOrder).getValue();
            if (Boolean.TRUE.equals(type)) {
                this.halalOrder.getElement().setSelectedItem(Words.HALAL_ONLY);
            } else if (Boolean.FALSE.equals(type)) {
                this.halalOrder.getElement().setSelectedItem(Words.NOT_HALAL_ONLY);
            } else {
                this.halalOrder.getElement().setSelectedItem(Words.ALL);
            }
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean e = enabled && this.editable;
        this.deliveryAddress.setEnabled(e);
        this.deliveryDate.setEnabled(e);
        this.orderDate.setEnabled(e);
        this.deliveryWindow.setEnabled(e);
        if (!this.isSolarCompany) {
            this.department.setEnabled(e);
            this.customer.setEnabled(e);
            this.incoTerms.setEnabled(e);
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.location.setEnabled(e);
            }
            this.reorder.setEnabled(e);
            if (this.taxZone != null) {
                this.useTaxZone.setEnabled(e);
                this.taxZone.setEnabled(e && this.useTaxZone.getElement().isChecked());
            }
            this.customerOwnedOnly.setEnabled(e);
            this.halalOrder.setEnabled(e);
        }
        this.orderRemark.setEnabled(e);
        this.orderFooter.setEnabled(e);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.deliveryDate.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.orderDate);
        CheckedListAdder.addToList(focusList, this.location);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.deliveryWindow);
        CheckedListAdder.addToList(focusList, this.deliveryAddress);
        CheckedListAdder.addToList(focusList, this.incoTerms);
        CheckedListAdder.addToList(focusList, this.customerOwnedOnly);
        CheckedListAdder.addToList(focusList, this.halalOrder);
        CheckedListAdder.addToList(focusList, this.reorder);
        CheckedListAdder.addToList(focusList, this.orderRemark);
        CheckedListAdder.addToList(focusList, this.orderFooter);
        CheckedListAdder.addToList(focusList, this.useTaxZone);
        CheckedListAdder.addToList(focusList, this.taxZone);
        return focusList;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        Component currentC;
        if (!this.isSolarCompany) {
            if (this.customerOwnedOnly.getElement().getCurrentPopUp() != null) {
                for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.customerOwnedOnly.getElement().getCurrentPopUp())) continue;
                    return true;
                }
            }
            if (this.halalOrder.getElement().getCurrentPopUp() != null) {
                for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.halalOrder.getElement().getCurrentPopUp())) continue;
                    return true;
                }
            }
            if (this.department.getElement().getCurrentPopUp() != null) {
                for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.department.getElement().getCurrentPopUp())) continue;
                    return true;
                }
            }
            if (this.customer.getElement().getCurrentPopUp() != null) {
                for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.customer.getElement().getCurrentPopUp())) continue;
                    return true;
                }
            }
            if (this.incoTerms.getElement().getCurrentPopUp() != null) {
                for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.incoTerms.getElement().getCurrentPopUp())) continue;
                    return true;
                }
            }
            if (this.taxZone != null && this.taxZone.getElement().getCurrentPopUp() != null) {
                for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.taxZone.getElement().getCurrentPopUp())) continue;
                    return true;
                }
            }
        }
        if (this.deliveryWindow.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.deliveryWindow.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        if (this.deliveryAddress.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.deliveryAddress.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deliveryAddress.kill();
        this.deliveryDate.kill();
        this.orderDate.kill();
        this.deliveryWindow.kill();
        if (!this.isSolarCompany) {
            this.department.kill();
            this.customer.kill();
            this.incoTerms.kill();
            this.customerOwnedOnly.kill();
            this.halalOrder.kill();
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.location.kill();
            }
            this.reorder.kill();
            if (this.taxZone != null) {
                this.taxZone.kill();
                this.useTaxZone.kill();
            }
        }
        this.orderRemark.kill();
        this.orderFooter.kill();
        this.deliveryAddress = null;
        this.deliveryDate = null;
        this.orderDate = null;
        this.deliveryWindow = null;
        this.department = null;
        this.customer = null;
        this.incoTerms = null;
        this.orderRemark = null;
        this.orderFooter = null;
        this.location = null;
        this.reorder = null;
        this.taxZone = null;
        this.useTaxZone = null;
        this.customerOwnedOnly = null;
        this.halalOrder = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 10;
            int h = 0;
            int w = 0;
            w += border;
            w = (int)((double)w + OrderConfigPopup.this.deliveryDate.getPreferredSize().getWidth());
            w += border;
            w += 250;
            w += border;
            w += 200;
            w += border;
            if (!OrderConfigPopup.this.isSolarCompany) {
                h += border;
                h = (int)((double)h + OrderConfigPopup.this.department.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + OrderConfigPopup.this.customer.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + OrderConfigPopup.this.incoTerms.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + OrderConfigPopup.this.customerOwnedOnly.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + OrderConfigPopup.this.halalOrder.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + OrderConfigPopup.this.reorder.getPreferredSize().getHeight());
                h += border;
            }
            h = (int)((double)h + OrderConfigPopup.this.deliveryWindow.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + OrderConfigPopup.this.deliveryAddress.getPreferredSize().getHeight());
            h += border;
            h += 200;
            return new Dimension(w, h += border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            OrderConfigPopup.this.deliveryDate.setLocation(border, border);
            OrderConfigPopup.this.deliveryDate.setSize(OrderConfigPopup.this.deliveryDate.getPreferredSize());
            OrderConfigPopup.this.orderDate.setLocation(border, OrderConfigPopup.this.deliveryDate.getY() + OrderConfigPopup.this.deliveryDate.getHeight() + border);
            OrderConfigPopup.this.orderDate.setSize(OrderConfigPopup.this.orderDate.getPreferredSize());
            int cy = OrderConfigPopup.this.orderDate.getY() + OrderConfigPopup.this.orderDate.getHeight();
            int cy2 = 0;
            int cx = OrderConfigPopup.this.deliveryDate.getX() + OrderConfigPopup.this.deliveryDate.getWidth();
            if (!OrderConfigPopup.this.isSolarCompany) {
                if (Boolean.TRUE.equals(OrderConfigPopup.this.viewSettings.getShowLocation())) {
                    OrderConfigPopup.this.location.setLocation(border, OrderConfigPopup.this.orderDate.getY() + OrderConfigPopup.this.orderDate.getHeight() + border);
                    OrderConfigPopup.this.location.setSize(100, (int)OrderConfigPopup.this.location.getPreferredSize().getWidth());
                    cy = OrderConfigPopup.this.location.getY() + OrderConfigPopup.this.location.getHeight();
                }
                if (OrderConfigPopup.this.taxZone != null) {
                    OrderConfigPopup.this.useTaxZone.setLocation(border, cy + border);
                    OrderConfigPopup.this.useTaxZone.setSize(OrderConfigPopup.this.useTaxZone.getPreferredSize());
                    OrderConfigPopup.this.taxZone.setLocation(border, OrderConfigPopup.this.useTaxZone.getY() + OrderConfigPopup.this.useTaxZone.getHeight() + border);
                    OrderConfigPopup.this.taxZone.setSize(100, (int)OrderConfigPopup.this.taxZone.getPreferredSize().getHeight());
                }
                OrderConfigPopup.this.department.setLocation(cx + border, border);
                OrderConfigPopup.this.department.setSize(250, (int)OrderConfigPopup.this.department.getPreferredSize().getHeight());
                OrderConfigPopup.this.customer.setLocation(OrderConfigPopup.this.deliveryDate.getX() + OrderConfigPopup.this.deliveryDate.getWidth() + border, OrderConfigPopup.this.department.getY() + OrderConfigPopup.this.department.getHeight() + border);
                OrderConfigPopup.this.customer.setSize(250, (int)OrderConfigPopup.this.customer.getPreferredSize().getHeight());
                cy2 = OrderConfigPopup.this.customer.getY() + OrderConfigPopup.this.customer.getHeight();
            }
            OrderConfigPopup.this.deliveryWindow.setLocation(cx + border, cy2 + border);
            OrderConfigPopup.this.deliveryWindow.setSize(250, (int)OrderConfigPopup.this.deliveryWindow.getPreferredSize().getHeight());
            OrderConfigPopup.this.deliveryAddress.setLocation(cx + border, OrderConfigPopup.this.deliveryWindow.getY() + OrderConfigPopup.this.deliveryWindow.getHeight() + border);
            OrderConfigPopup.this.deliveryAddress.setSize(250, (int)OrderConfigPopup.this.deliveryAddress.getPreferredSize().getHeight());
            cy2 = OrderConfigPopup.this.deliveryAddress.getY() + OrderConfigPopup.this.deliveryAddress.getHeight();
            if (!OrderConfigPopup.this.isSolarCompany) {
                OrderConfigPopup.this.incoTerms.setLocation(OrderConfigPopup.this.department.getX(), OrderConfigPopup.this.deliveryAddress.getY() + OrderConfigPopup.this.deliveryAddress.getHeight() + border);
                OrderConfigPopup.this.incoTerms.setSize(250, (int)OrderConfigPopup.this.incoTerms.getPreferredSize().getHeight());
                OrderConfigPopup.this.customerOwnedOnly.setLocation(OrderConfigPopup.this.department.getX(), OrderConfigPopup.this.incoTerms.getY() + OrderConfigPopup.this.incoTerms.getHeight() + border);
                OrderConfigPopup.this.customerOwnedOnly.setSize(OrderConfigPopup.this.customerOwnedOnly.getPreferredSize());
                OrderConfigPopup.this.halalOrder.setLocation(OrderConfigPopup.this.department.getX(), OrderConfigPopup.this.customerOwnedOnly.getY() + OrderConfigPopup.this.customerOwnedOnly.getHeight() + border);
                OrderConfigPopup.this.halalOrder.setSize(OrderConfigPopup.this.halalOrder.getPreferredSize());
                OrderConfigPopup.this.reorder.setLocation(OrderConfigPopup.this.department.getX(), OrderConfigPopup.this.halalOrder.getY() + OrderConfigPopup.this.halalOrder.getHeight() + border);
                OrderConfigPopup.this.reorder.setSize(OrderConfigPopup.this.reorder.getPreferredSize());
                cy2 = OrderConfigPopup.this.reorder.getY() + OrderConfigPopup.this.reorder.getHeight();
            }
            OrderConfigPopup.this.orderFooter.setLocation(cx + border, cy2 + border);
            OrderConfigPopup.this.orderFooter.setSize(parent.getWidth() - (OrderConfigPopup.this.orderFooter.getX() + border), 200);
            OrderConfigPopup.this.orderRemark.setLocation(OrderConfigPopup.this.deliveryWindow.getX() + OrderConfigPopup.this.deliveryWindow.getWidth() + border, border);
            OrderConfigPopup.this.orderRemark.setSize(200, OrderConfigPopup.this.orderFooter.getY() - 2 * border);
        }
    }
}

