/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class SupplierChangePopup
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> supplier;

    public SupplierChangePopup(Node<SupplierConditionComplete> changeNode, Node<List<SupplierConditionComplete>> possibles, Converter<SupplierConditionComplete, String> converter) {
        SupplierConditionComplete oldOne = (SupplierConditionComplete)changeNode.getValue();
        this.supplier = new TitledItem<ComboBox>(new ComboBox(changeNode, possibles, converter), "New Supplier", TitledItem.TitledItemOrientation.NORTH);
        this.setLayout(new Layout());
        this.add(this.supplier);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.supplier.kill();
        this.supplier = null;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.supplier.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.supplier.getElement().getNode().getValue()};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.supplier.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.supplier.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)(10.0 + SupplierChangePopup.this.supplier.getPreferredSize().getHeight() + 10.0));
        }

        @Override
        public void layoutContainer(Container parent) {
            SupplierChangePopup.this.supplier.setLocation(10, 10);
            SupplierChangePopup.this.supplier.setSize(parent.getWidth() - 20, parent.getHeight());
        }
    }
}

