/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.preview;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DeliveryTermComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewReference;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.List;

public class PurchaseOrderPreviewModuleDataHandler
extends DefaultDataHandler<ManualPurchaseOrderPreviewLight, ManualPurchaseOrderPreviewComplete> {
    public PurchaseOrderPreviewModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, final ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ManualPurchaseOrderPreviewLight group = (ManualPurchaseOrderPreviewLight)node.getValue(ManualPurchaseOrderPreviewLight.class);
                ManualPurchaseOrderPreviewComplete groupComplete = (ManualPurchaseOrderPreviewComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getManualPurchaseOrderPreview((ManualPurchaseOrderPreviewReference)group).getValue();
                PurchaseOrderPreviewModuleDataHandler.this.showMessage(progressListener, Words.LOAD_ARTICLES);
                for (PurchaseOrderPreviewComplete order : groupComplete.getOrders()) {
                    for (PurchaseOrderPositionPreviewComplete position : order.getPositionPreviews()) {
                        BasicArticleComplete basicArticle = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(position.getArticle().getId())).getValue();
                        INodeCreator.getDefaultImpl().getNode4DTO((Object)basicArticle, false, false);
                    }
                }
                node.removeExistingValues();
                node.setValue((Object)groupComplete, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<ManualPurchaseOrderPreviewLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ManualPurchaseOrderPreviewComplete g = (ManualPurchaseOrderPreviewComplete)node.getValue(ManualPurchaseOrderPreviewComplete.class);
                PurchaseOrderPreviewModuleDataHandler.this.ensureBidirectionalData(g);
                PurchaseOrderPreviewModuleDataHandler.this.ensureSupplierConditionOnPreview(g);
                ManualPurchaseOrderPreviewComplete gn = (ManualPurchaseOrderPreviewComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updateManualPurchaseOrderPreview(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ManualPurchaseOrderPreviewComplete> createEmptyNode() {
        ManualPurchaseOrderPreviewComplete m = new ManualPurchaseOrderPreviewComplete();
        m.setClientOId(Long.valueOf(ADTO.getNextId()));
        m.setCreatedForDate(new Date(System.currentTimeMillis()));
        m.setOrderState(PurchaseOrderPreviewStateE.PLANNED);
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)m, false, false);
    }

    @Override
    public void createNewData(final Node<ManualPurchaseOrderPreviewComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ManualPurchaseOrderPreviewComplete g = (ManualPurchaseOrderPreviewComplete)node.getValue(ManualPurchaseOrderPreviewComplete.class);
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
                if (!Boolean.TRUE.equals(viewSettings.getShowLocation())) {
                    g.setOrderLocation((LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                PurchaseOrderPreviewModuleDataHandler.this.ensureBidirectionalData(g);
                PurchaseOrderPreviewModuleDataHandler.this.ensureSupplierConditionOnPreview(g);
                ManualPurchaseOrderPreviewComplete gn = (ManualPurchaseOrderPreviewComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).createManualPurchaseOrderPreview(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensureSupplierConditionOnPreview(ManualPurchaseOrderPreviewComplete g) throws ClientServerCallException {
        if (g.getOrderState() == PurchaseOrderPreviewStateE.CREATED) {
            return;
        }
        for (PurchaseOrderPreviewComplete order : g.getOrders()) {
            for (PurchaseOrderPositionPreviewComplete preview : order.getPositionPreviews()) {
                if (preview.getSupplierCondition() != null) continue;
                BasicArticleComplete basicArticle = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(preview.getArticle().getId())).getValue();
                SupplierConditionBaseComplete supplier = basicArticle.getSupplier((SupplierReference)order.getSupplier());
                List conditions = ((SupplierConditionCategoryComplete)supplier.getSupplierConditionCategory().get(0)).getConditions();
                SupplierConditionComplete selectedCondition = null;
                for (SupplierConditionComplete condition : conditions) {
                    if (!condition.getValidityPeriod().within(order.getOrderDate()).booleanValue()) continue;
                    selectedCondition = condition;
                    preview.setSupplierCondition(CopyTemplateToolkit.copySupplierCondition(condition));
                }
                if (preview.getSupplierCondition() == null) {
                    selectedCondition = (SupplierConditionComplete)conditions.get(conditions.size() - 1);
                }
                PriceAndUnitComplete articlePrice = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice(new BasicArticleReference(preview.getArticle().getId()), new SupplierReference(order.getSupplier().getId()), new DateWrapper(order.getOrderDate()), new QuantityComplete(Double.valueOf(preview.getQuantity().getAmount().doubleValue()), preview.getQuantity().getUnit()), order.getUseTaxZone(), order.getTaxZone(), selectedCondition);
                preview.setSupplierPrice(articlePrice.getPrice());
                preview.setPriceUnit(articlePrice.getUnit());
            }
        }
    }

    private void ensureBidirectionalData(ManualPurchaseOrderPreviewComplete g) {
        for (PurchaseOrderPreviewComplete order : g.getOrders()) {
            for (PurchaseOrderPositionPreviewComplete positions : order.getPositionPreviews()) {
                if (order.getId() == null) {
                    positions.setId(null);
                }
                positions.setOrder(order);
            }
        }
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderPreviewModuleDataHandler.this.setCurrentLoadMaximum(8);
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ExternalCostCenterComplete.class);
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderDeliveryWindowComplete.class);
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(DeliveryTermComplete.class);
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxZoneComplete.class);
                PurchaseOrderPreviewModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return PurchaseOrderPreviewModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ManualPurchaseOrderPreviewComplete> resetData(Node<ManualPurchaseOrderPreviewComplete> node) {
        ManualPurchaseOrderPreviewComplete n = new ManualPurchaseOrderPreviewComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<ManualPurchaseOrderPreviewComplete> getCommittingClass() {
        return ManualPurchaseOrderPreviewComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ManualPurchaseOrderPreviewLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

