/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.preview.details;

import ch.icit.pegasus.client.gui.modules.purchaseorder.preview.details.utils.ArticlePanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.preview.details.utils.OrderPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class OrdersCreationDetailsPanel
extends DefaultDetailsPanel<ManualPurchaseOrderPreviewLight> {
    private static final long serialVersionUID = 1L;
    private ArticlePanel articlePanel;
    private OrderPanel orderPanel;

    public OrdersCreationDetailsPanel(RowEditor<ManualPurchaseOrderPreviewLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ORDERS);
        this.articlePanel = new ArticlePanel((Container)this, provider, null, null);
        this.articlePanel.setOrdersCreated(editor.getModel().getNode().getChildNamed(ManualPurchaseOrderPreviewLight_.orderState).getValue() == PurchaseOrderPreviewStateE.CREATED);
        this.orderPanel = new OrderPanel(this, null, null, this.articlePanel, editor.getModel().getNode().getChildNamed(ManualPurchaseOrderPreviewLight_.orderState).getValue() == PurchaseOrderPreviewStateE.CREATED);
        this.setCustomLayouter(new Layout());
        this.addToView(this.articlePanel);
        this.addToView(this.orderPanel);
    }

    @Override
    public void setNode(Node<?> node) {
        this.articlePanel.setArticleListNode(node.getChildNamed(ManualPurchaseOrderPreviewComplete_.usedArticles));
        this.articlePanel.setOrderListNode((Node<List<PurchaseOrderPreviewComplete>>)node.getChildNamed(ManualPurchaseOrderPreviewComplete_.orders));
        this.orderPanel.setOrderListNode(node.getChildNamed(ManualPurchaseOrderPreviewComplete_.orders));
    }

    @Override
    public void requestFocusInWindowNow() {
        this.articlePanel.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.articlePanel);
        CheckedListAdder.addToList(a, this.orderPanel);
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.articlePanel.kill();
        this.orderPanel.kill();
        this.articlePanel = null;
        this.orderPanel = null;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (!this.orderPanel.validateSuppliers()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Suppliers are configured proper"));
        }
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.articlePanel.setEnabled(isEnabled);
        this.orderPanel.setEnabled(isEnabled);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            OrdersCreationDetailsPanel.this.articlePanel.setLocation(OrdersCreationDetailsPanel.this.horizontalBorder, OrdersCreationDetailsPanel.this.verticalBorder);
            OrdersCreationDetailsPanel.this.articlePanel.setSize(parent.getWidth() - 2 * OrdersCreationDetailsPanel.this.horizontalBorder, (parent.getHeight() - 3 * OrdersCreationDetailsPanel.this.verticalBorder) / 2);
            OrdersCreationDetailsPanel.this.orderPanel.setLocation(OrdersCreationDetailsPanel.this.horizontalBorder, OrdersCreationDetailsPanel.this.articlePanel.getY() + OrdersCreationDetailsPanel.this.articlePanel.getHeight() + OrdersCreationDetailsPanel.this.verticalBorder);
            OrdersCreationDetailsPanel.this.orderPanel.setSize(OrdersCreationDetailsPanel.this.articlePanel.getWidth(), OrdersCreationDetailsPanel.this.articlePanel.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 700);
        }
    }
}

