/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.preview.details.utils;

import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.ArticleDetailsPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.OrderBreadCrumpPanel;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Container;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Iterator;

public class ArticlePanel
extends ArticleDetailsPanel {
    private static final long serialVersionUID = -4323407091393828669L;
    private boolean ordersCreated = false;

    public ArticlePanel(Container aParent, RDProvider provider, Node orderList, Node articleList) {
        super(aParent, orderList, articleList, provider);
    }

    @Override
    protected boolean isPreview() {
        return true;
    }

    public void setOrdersCreated(boolean ordersCreated) {
        this.ordersCreated = ordersCreated;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled && !this.ordersCreated);
    }

    @Override
    public Node createPositionNode(BasicArticleComplete article, StoreQuantityComplete quantity, SupplierConditionComplete copySupplierCondition, Timestamp validity, boolean active) {
        PurchaseOrderPositionPreviewComplete npos = new PurchaseOrderPositionPreviewComplete();
        npos.setClientOId(Long.valueOf(ADTO.getNextId()));
        npos.setArticle((BasicArticleLight)article);
        npos.setArticleLabelCount(Integer.valueOf(0));
        npos.setQuantity(quantity);
        npos.setPriceUnit(copySupplierCondition.getOrderUnit());
        npos.setSupplierCondition(copySupplierCondition);
        if (copySupplierCondition.getStepPrice().getSteps().size() > 0) {
            npos.setSupplierPrice(((StepPriceFunctionComplete)copySupplierCondition.getStepPrice().getSteps().get(0)).getPrice());
        } else {
            npos.setSupplierPrice(new PriceComplete(copySupplierCondition.getSupplier().getPaymentCurrency(), Double.valueOf(0.0)));
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)npos, true, false);
        return n;
    }

    @Override
    protected Node getOrderNode4Supplier(SupplierConditionComplete supplierCondition, CostCenterComplete costCenterComplete) {
        Iterator it = this.orderList.getChilds();
        while (it.hasNext()) {
            Node e = (Node)it.next();
            if (!((SupplierLight)e.getChildNamed(PurchaseOrderPreviewComplete_.supplier).getValue()).equals((Object)supplierCondition.getSupplier())) continue;
            Boolean orderTaxZone = (Boolean)e.getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
            TaxZoneComplete orderUseTaxZone = (TaxZoneComplete)e.getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
            TaxZoneComplete newTaxZone = supplierCondition.getCategoryTaxZone();
            if (!(Boolean.TRUE.equals(orderTaxZone) ? (orderUseTaxZone == null ? newTaxZone == null : orderUseTaxZone.equals((Object)newTaxZone)) : newTaxZone == null)) continue;
            return e;
        }
        long oneDay = 86400000L;
        Node n = this.createOrderNode(supplierCondition, null, oneDay);
        this.orderList.addChild(n, System.currentTimeMillis());
        return n;
    }

    @Override
    protected Node createOrderNode(SupplierConditionComplete supplierCondition, CostCenterComplete costCenterComplete, long oneDay) {
        PurchaseOrderPreviewComplete o = new PurchaseOrderPreviewComplete();
        if (!StringUtil.isBlank((String)supplierCondition.getSupplier().getDefaultOrderRemark())) {
            o.setRemark(supplierCondition.getSupplier().getDefaultOrderRemark());
        }
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        o.setSupplier(supplierCondition.getSupplier());
        o.setUseTaxZone(Boolean.valueOf(supplierCondition.getCategoryTaxZone() != null));
        o.setTaxZone(supplierCondition.getCategoryTaxZone());
        o.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getDefaultLocation());
        o.setOrderDate(new Date(System.currentTimeMillis()));
        o.setDeliveryDate(new Date(System.currentTimeMillis() + oneDay));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, false, false);
        return n;
    }

    @Override
    public DtoField<?> getPositionField() {
        return PurchaseOrderPreviewComplete_.positionPreviews;
    }

    @Override
    public void createOrders(TextButton button, Node node, OrderBreadCrumpPanel orderBreadCrumpPanel, LoadingAnimation anim, boolean send, boolean printRec, boolean printOrder) {
    }
}

