/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102.details;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter1Decimals;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.RecipeVariantConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchMeasurementComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchMeasurementTypeE;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102EntryComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102EntryComplete_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementComplete_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class MeasurementDetailsPanel2
extends TableDetailsPanel<CCP0102MeasurementLight> {
    public MeasurementDetailsPanel2(RowEditor<CCP0102MeasurementLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.RECIPES);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        boolean editable = this.provider.isWritable(CCP0102MeasurementComplete_.entries);
        columns.add(new TableColumnInfo(Words.RECIPE, null, null, null, "", 40));
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 40));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", InputComboBox2.getPreferredWidth(this, 11)));
        columns.add(new TableColumnInfo(Words.PRODUCED, null, null, null, "", 75));
        columns.add(new TableColumnInfo(Words.BATCHES, null, null, null, "", 60));
        columns.add(new TableColumnInfo(Words.COMPLETE, null, null, null, "", 60));
        columns.add(new TableColumnInfo("Details", null, null, null, "", 60));
        if (editable) {
            columns.add(new TableColumnInfo("", null, null, null, "", DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding()));
        }
        ((TableColumnInfo)columns.get(0)).setxExpand(0.75);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        if (editable) {
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
        table.setOverrideName(CCP0102MeasurementComplete_.entries);
        table.setUseWriteAccessRight(true);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        CCP0102EntryComplete entry = new CCP0102EntryComplete();
        entry.setClientOId(Long.valueOf(ADTO.getNextId()));
        entry.setComplete(Boolean.valueOf(false));
        entry.setProduced(Boolean.valueOf(true));
        entry.setQuantity(new QuantityComplete(Double.valueOf(0.0), this.settings.getDefaultCustomsPenaltyUnit()));
        Node child = INodeCreator.getDefaultImpl().getNode4DTO((Object)entry, true, false);
        this.table.getModel().getNode().addChild(child, 0L);
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(CCP0102MeasurementComplete_.entries));
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        boolean editable = this.provider.isWritable(CCP0102MeasurementComplete_.entries);
        if (editable) {
            CCP0102EntryComplete entry = (CCP0102EntryComplete)model.getNode().getValue(CCP0102EntryComplete.class);
            row.addLayoutComponent(SearchTextField2Factory.getRecipeSearchField(true, model.getNode().getChildNamed(CCP0102EntryComplete_.recipe)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(SearchTextField2Factory.getCustomerSearchField(true, model.getNode().getChildNamed(CCP0102EntryComplete_.customer)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new InputComboBox2(model.getNode().getChildNamed(new DtoField[]{CCP0102EntryComplete_.quantity, QuantityComplete_.quantity}), model.getNode().getChildNamed(new DtoField[]{CCP0102EntryComplete_.quantity, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_DOUBLE), DefaultTable2RowPanelLayout.LayoutType.FIX);
            row.addLayoutComponent(new CheckBox((Node<Boolean>)model.getNode().getChildNamed(CCP0102EntryComplete_.produced)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            int batchCount = 0;
            for (CCP0102BatchComplete batch : entry.getBatches()) {
                if (batch.getMeasurements().isEmpty()) continue;
                ++batchCount;
            }
            row.addLayoutComponent(new TextLabel(batchCount + ""), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new CheckBoxRO((Node<Boolean>)model.getNode().getChildNamed(CCP0102EntryComplete_.complete)), DefaultTable2RowPanelLayout.LayoutType.FIX);
            InfoButton infoButton = new InfoButton();
            infoButton.installStringViewer(this.createHeatingText(entry));
            row.addLayoutComponent(infoButton, DefaultTable2RowPanelLayout.LayoutType.FIX);
            row.addLayoutComponent(new DeleteButton((source, x, y) -> this.table.getModel().getNode().removeChild(model.getNode(), 0L)), DefaultTable2RowPanelLayout.LayoutType.FIX);
        } else {
            CCP0102EntryComplete entry = (CCP0102EntryComplete)model.getNode().getValue(CCP0102EntryComplete.class);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(new DtoField[]{CCP0102EntryComplete_.recipe, RecipeComplete_.currentVariant}), ConverterRegistry.getConverter(RecipeVariantConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(CCP0102EntryComplete_.customer), ConverterRegistry.getConverter(CustomerConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(CCP0102EntryComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(CCP0102EntryComplete_.produced), ConverterRegistry.getConverter(BooleanConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(entry.getBatches().size() + ""), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new CheckBoxRO((Node<Boolean>)model.getNode().getChildNamed(CCP0102EntryComplete_.complete)), DefaultTable2RowPanelLayout.LayoutType.FIX);
            InfoButton infoButton = new InfoButton();
            infoButton.installStringViewer(this.createHeatingText(entry));
            row.addLayoutComponent(infoButton, DefaultTable2RowPanelLayout.LayoutType.FIX);
        }
        return row;
    }

    private Timestamp getMeasureTime(CCP0102BatchMeasurementComplete measurement) {
        if (measurement.getMeasureTimeStart() != null) {
            return measurement.getMeasureTimeStart();
        }
        return measurement.getMeasureTimeEnd();
    }

    private Double getMeasureTemperature(CCP0102BatchMeasurementComplete measurement) {
        if (measurement.getTemperatureStart() != null) {
            return measurement.getTemperatureStart();
        }
        return measurement.getTemperatureEnd();
    }

    private double getMeasurementDuration(CCP0102BatchMeasurementComplete measurement) {
        Timestamp startTime = measurement.getMeasureTimeStart();
        Timestamp endTime = measurement.getMeasureTimeEnd();
        if (startTime != null && endTime != null) {
            return (endTime.getTime() - startTime.getTime()) / 1000L;
        }
        return 0.0;
    }

    private String createHeatingText(CCP0102EntryComplete entry) {
        String text = "<html>";
        text = text + "<b>Heating/Chilling Process</b><br/>";
        UserConverter userConverter = (UserConverter)ConverterRegistry.getConverter(UserConverter.class);
        DateTimeConverter dateConverter = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
        FormattedDoubleConverter1Decimals numberConverter = (FormattedDoubleConverter1Decimals)ConverterRegistry.getConverter(FormattedDoubleConverter1Decimals.class);
        for (CCP0102BatchComplete batch : entry.getBatches()) {
            text = text + "<b>Batch</b><br/>";
            for (CCP0102BatchMeasurementComplete measurement : batch.getMeasurements()) {
                text = text + "<ul>";
                if (measurement.getBatchMeasurementType() == CCP0102BatchMeasurementTypeE.Heating) {
                    text = text + "<li>Heating Time: " + dateConverter.convert((Object)this.getMeasureTime(measurement), null, new Object[0]) + "</li>";
                    text = text + "<li>Heating Duration: " + this.getMeasurementDuration(measurement) + " sec</li>";
                    text = text + "<li>Heating Core Temperature: " + numberConverter.convert((Number)this.getMeasureTemperature(measurement), null, new Object[0]) + " " + Words.DEGREE + "C</li>";
                    text = text + "<li>Heating User: " + userConverter.convert((UserReference)measurement.getUser(), null, new Object[0]) + "</li>";
                    text = text + "<li>Heating Comment: " + this.createString(measurement.getCommentText()) + "</li>";
                } else if (measurement.getBatchMeasurementType() == CCP0102BatchMeasurementTypeE.FastChillBegin) {
                    text = text + "<li>Fast Chill Begin Time: " + dateConverter.convert((Object)this.getMeasureTime(measurement), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill Begin Temperature: " + this.getMeasureTemperature(measurement) + " " + Words.DEGREE + "C</li>";
                    text = text + "<li>Fast Chill User: " + userConverter.convert((UserReference)measurement.getUser(), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill Begin Comment: " + this.createString(measurement.getCommentText()) + "</li>";
                } else if (measurement.getBatchMeasurementType() == CCP0102BatchMeasurementTypeE.FastChillEnd) {
                    text = text + "<li>Fast Chill End Time: " + dateConverter.convert((Object)this.getMeasureTime(measurement), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill End Temperature: " + this.getMeasureTemperature(measurement) + " " + Words.DEGREE + "C</li>";
                    text = text + "<li>Fast Chill End: " + userConverter.convert((UserReference)measurement.getUser(), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill End Comment: " + this.createString(measurement.getCommentText()) + "</li>";
                }
                text = text + "</ul>";
            }
            text = text + "<br/>";
        }
        text = text + "</html>";
        return text;
    }

    private String createString(String t) {
        if (StringUtil.isBlank((String)t)) {
            return "-";
        }
        return t;
    }
}

