/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;

public class RadarFlightStateRenderer
extends DefaultPanel {
    private static final long serialVersionUID = 1L;
    private static BufferedImage out_none;
    private static BufferedImage out_red;
    private static BufferedImage out_blue;
    private static BufferedImage out_orange;
    private static BufferedImage out_green;
    private static BufferedImage in_none;
    private static BufferedImage in_red;
    private static BufferedImage in_blue;
    private static BufferedImage in_orange;
    private static BufferedImage in_green;
    private int innerGap = 1;
    private int outerGap = 3;
    private Node<FlightLight> node;
    private boolean isOutbound;

    public RadarFlightStateRenderer(Node<FlightLight> node, boolean isOutbound) {
        this.node = node;
        this.isOutbound = isOutbound;
        this.init();
    }

    private void init() {
        if (out_none == null) {
            out_none = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_out_none"));
            out_red = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_out_red"));
            out_blue = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_out_blue"));
            out_orange = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_out_orange"));
            out_green = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_out_green"));
            in_none = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_in_none"));
            in_red = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_in_red"));
            in_blue = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_in_blue"));
            in_orange = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_in_orange"));
            in_green = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("flightoverview_state_indicator_7px_in_green"));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int i = 7;
        int w = 6 * i + 2 * this.outerGap + 3 * this.innerGap;
        return new Dimension(w, i);
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.node != null && this.node.getValue() != null) {
            int currentX = 0;
            BufferedImage i = this.getI(0, ((FlightLight)this.node.getValue()).getFlightState());
            g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX, 0.0f), null);
            currentX += i.getWidth() + this.innerGap;
            i = this.getI(1, ((FlightLight)this.node.getValue()).getFlightState());
            g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX, 0.0f), null);
            currentX += i.getWidth() + this.outerGap;
            i = this.getI(2, ((FlightLight)this.node.getValue()).getFlightState());
            g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX, 0.0f), null);
            currentX += i.getWidth() + this.innerGap;
            i = this.getI(3, ((FlightLight)this.node.getValue()).getFlightState());
            g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX, 0.0f), null);
            currentX += i.getWidth() + this.outerGap;
            i = this.getI(4, ((FlightLight)this.node.getValue()).getFlightState());
            g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX, 0.0f), null);
            currentX += i.getWidth() + this.innerGap;
            i = this.getI(5, ((FlightLight)this.node.getValue()).getFlightState());
            g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentX, 0.0f), null);
        }
        this.paintChildren(g2);
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private BufferedImage getI(int position, FlightStateE currentType) {
        if (currentType == FlightStateE.PLANNED && position == 0) {
            if (this.isOutbound) {
                return out_orange;
            }
            return in_orange;
        }
        if (currentType == FlightStateE.OPEN && position == 1) {
            if (this.isOutbound) {
                return out_blue;
            }
            return in_blue;
        }
        if (currentType == FlightStateE.EN_ROUTE && position == 2) {
            if (this.isOutbound) {
                return out_orange;
            }
            return in_orange;
        }
        if (currentType == FlightStateE.DISPATCHED && position == 3) {
            if (this.isOutbound) {
                return out_blue;
            }
            return in_blue;
        }
        if (currentType == FlightStateE.CLOSED && position == 4) {
            if (this.isOutbound) {
                return out_green;
            }
            return in_green;
        }
        if (currentType == FlightStateE.CANCELLED && position == 5) {
            if (this.isOutbound) {
                return out_red;
            }
            return in_red;
        }
        if (this.isOutbound) {
            return out_none;
        }
        return in_none;
    }
}

