/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.RecipeVariantSorter;
import ch.icit.pegasus.client.gui.modules.recipe.RecipeModule;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.loaders.RecipeVariantLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AdditiveCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AllergenCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.OtherCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.RecipeProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.recipe.CompoundIngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.IngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.recipe.SimpleIngredientComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.recipe.RecipeCalculationToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class RecipeModuleDataHandler
extends DefaultDataHandler<RecipeReference, RecipeComplete> {
    public RecipeModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, "Refresh Recipe");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RecipeComplete rl = (RecipeComplete)node.getValue(RecipeComplete.class);
                List l = ((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariants(new ListWrapper(rl.getVariants())).getList();
                RecipeComplete r = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipe(new RecipeReference(rl.getId())).getValue();
                l.forEach(rv -> rv.setRecipe(r));
                node.removeExistingValues();
                node.setValue((Object)r, 0L);
                node.updateNode();
                node.disableEvents();
                node.getChildNamed(new String[]{"variants"}).disableEvents();
                node.getChildNamed(new String[]{"variants"}).removeExistingValues();
                node.getChildNamed(new String[]{"variants"}).setValue((Object)l, 0L);
                node.getChildNamed(new String[]{"variants"}).updateNode();
                node.getChildNamed(new String[]{"variants"}).enableEvents();
                node.enableEvents();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public void reloadDataNow(Node<ADTO> node, RemoteLoader listener) {
        if (node.getValue(BasicArticleLight.class) != null) {
            if (node.getValue(BasicArticleComplete.class) == null) {
                new BasicArticleLoader((BasicArticleReference)node.getValue(BasicArticleLight.class), listener, node, this);
            } else {
                listener.remoteObjectLoaded(node);
            }
        } else if (node.getValue(RecipeVariantLight.class) != null) {
            if (node.getValue(RecipeVariantComplete.class) != null) {
                listener.remoteObjectLoaded(node);
            } else {
                new RecipeVariantLoader((RecipeVariantReference)node.getValue(RecipeVariantLight.class), listener, node, this);
            }
        }
    }

    public static void processIt(Node<IngredientComplete> comps) throws ClientServerCallException {
        if (comps.getValue() instanceof SimpleIngredientComplete) {
            RecipeModuleDataHandler.reloadIt((Node<ADTO>)comps.getChildNamed(new String[]{"article"}));
        } else {
            RecipeModuleDataHandler.reloadIt((Node<ADTO>)comps.getChildNamed(new String[]{"recipe"}));
        }
    }

    public static void reloadIt(Node<ADTO> node) throws ClientServerCallException {
        if (node.getParent().getValue() instanceof SimpleIngredientComplete) {
            if (node.getValue(BasicArticleComplete.class) == null && node.getValue(BasicArticleLight.class) != null) {
                Long cId = System.currentTimeMillis();
                BasicArticleComplete art = null;
                if (node.getValue() != null) {
                    art = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)((BasicArticleLight)node.getValue())).getValue();
                } else if (node instanceof ProxyNode) {
                    art = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)((BasicArticleLight)((ProxyNode)node).getSource())).getValue();
                }
                if (art != null) {
                    // empty if block
                }
                Node nn = node;
                if (node instanceof ProxyNode) {
                    nn = ((ProxyNode)node).getRefNode();
                }
                nn.setValue((Object)art, cId.longValue());
            }
        } else if (node.getParent().getValue() instanceof CompoundIngredientComplete && node.getValue(RecipeComplete.class) == null && node.getValue(RecipeComplete.class) != null) {
            Long cId = System.currentTimeMillis();
            RecipeComplete art = null;
            if (node.getValue() != null) {
                art = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipe((RecipeReference)((RecipeComplete)node.getValue())).getValue();
            } else if (node instanceof ProxyNode) {
                art = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipe((RecipeReference)((RecipeComplete)((ProxyNode)node).getSource())).getValue();
            }
            Node nn = node;
            if (node instanceof ProxyNode) {
                nn = ((ProxyNode)node).getRefNode();
            }
            nn.setValue((Object)art, cId.longValue());
        }
    }

    private void ensureIngredients(RecipeVariantComplete recipe) {
        Iterator it = recipe.getIngredients().iterator();
        boolean removedSomething = false;
        while (it.hasNext()) {
            IngredientComplete ingr = (IngredientComplete)it.next();
            if (ingr instanceof SimpleIngredientComplete) {
                if (((SimpleIngredientComplete)ingr).getArticle() != null) continue;
                it.remove();
                removedSomething = true;
                continue;
            }
            if (!(ingr instanceof CompoundIngredientComplete) || ((CompoundIngredientComplete)ingr).getUnderlyingRecipe() != null) continue;
            it.remove();
            removedSomething = true;
        }
        if (removedSomething) {
            int count = 1;
            for (IngredientComplete ingr : recipe.getIngredients()) {
                ingr.setSequenceNumber(Integer.valueOf(count));
                ++count;
            }
        }
    }

    @Override
    public void updateData(final Node<RecipeReference> node, final RemoteLoader model, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RecipeModuleDataHandler.this.showMessage(l, Words.SAVE_DATA);
                RecipeComplete dto = (RecipeComplete)node.getValue(RecipeComplete.class);
                CurrencyVariantAccessorImpl accessor = new CurrencyVariantAccessorImpl();
                RecipeVariantAccessorImpl recipeAccessor = new RecipeVariantAccessorImpl();
                Node newNode = node;
                ArrayList<RecipeVariantComplete> cl = new ArrayList<RecipeVariantComplete>();
                ArrayList<RecipeVariantLight> ll = new ArrayList<RecipeVariantLight>();
                ArrayList<Object> allVariants = new ArrayList<Object>();
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Iterator it = node.getChildNamed(new String[]{"variants"}).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.getChildNamed(new String[]{"recipe"}).setValue((Object)dto, 0L);
                    if (n.getValue(RecipeVariantComplete.class) != null) {
                        RecipeVariantComplete vc = (RecipeVariantComplete)n.getValue(RecipeVariantComplete.class);
                        n.removeExistingValues();
                        n.setValue((Object)vc, 0L);
                        n.commitThis(RecipeVariantComplete.class);
                        RecipeVariantComplete c = (RecipeVariantComplete)n.getValue(RecipeVariantComplete.class);
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        PriceComplete np = RecipeCalculationToolkit.getPrice((RecipeVariantComplete)vc, (QuantityComplete)new QuantityComplete(Double.valueOf(1.0), vc.getYield().getUnit()), (CurrencyComplete)s.getCurrency(), (CurrencyVariantAccessor)accessor, (RecipeVariantAccessor)recipeAccessor, (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
                        vc.setPrice(np);
                        n.getChildNamed(RecipeVariantLight_.price).setValue((Object)np, 0L);
                        n.getChildNamed(RecipeVariantLight_.price).updateNode();
                        c.setRecipe(dto);
                        cl.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    if (n.getValue(RecipeVariantLight.class) != null) {
                        RecipeVariantLight c = (RecipeVariantLight)n.getValue(RecipeVariantLight.class);
                        n.removeExistingValues();
                        n.setValue((Object)c, 0L);
                        n.commitThis(RecipeVariantLight.class);
                        c = (RecipeVariantLight)n.getValue(RecipeVariantLight.class);
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        c.setRecipe(dto);
                        ll.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    allVariants.add((RecipeVariantReference)n.getValue());
                }
                Hashtable<Class<RecipeVariantReference>, Class> t = new Hashtable<Class<RecipeVariantReference>, Class>();
                t.put(RecipeVariantLight.class, RecipeVariantComplete.class);
                t.put(RecipeVariantReference.class, RecipeVariantComplete.class);
                t.put(RecipeVariantReference.class, RecipeVariantLight.class);
                node.commit(RecipeComplete.class, t);
                RecipeComplete l2 = dto = (RecipeComplete)node.getValue(RecipeComplete.class);
                l2.setVariants(allVariants);
                if (!cl.isEmpty()) {
                    dto.setCurrentVariant((RecipeVariantLight)cl.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                Timestamp validityDate = new Timestamp(System.currentTimeMillis());
                RecipeComplete newDTO = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).updateRecipe(dto, new TimestampWrapper(validityDate)).getValue();
                if (newDTO.getCurrentVariant() == null && newDTO.getVariants() != null && newDTO.getVariants().size() > 0) {
                    newDTO.setCurrentVariant((RecipeVariantLight)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant((RecipeVariantReference)newDTO.getVariants().get(0)).getValue());
                }
                if (newDTO != null) {
                    newNode.getChildNamed(new String[]{"variants"}).removeAllChilds();
                    newNode.removeExistingValues();
                    newNode.setValue((Object)newDTO, 0L);
                    newNode.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return RecipeModuleDataHandler.this.loadingID;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensurePeriodMatching(PeriodComplete pTime, List<RecipeVariantComplete> cl, List<RecipeVariantLight> ll, boolean b) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(cl);
        l.addAll(ll);
        Collections.sort(l, ComparatorRegistry.getComparator(RecipeVariantSorter.class));
        long d = pTime.getEndDate().getTime() - pTime.getStartDate().getTime();
        if (l.size() > 0) {
            d /= (long)l.size();
        }
        long latestTS = -1L;
        for (int i = 0; i < l.size(); ++i) {
            RecipeVariantLight f = (RecipeVariantLight)l.get(i);
            long dd = pTime.getStartDate().getTime() + (long)i * d;
            if (latestTS != -1L) {
                f.getValidityPeriod().setStartDate(new Date(latestTS));
            } else {
                f.getValidityPeriod().setStartDate(new Date(dd));
            }
            if (i == l.size() - 1) {
                f.getValidityPeriod().setEndDate(pTime.getEndDate());
            } else {
                dd = pTime.getStartDate().getTime() + (long)(i + 1) * d;
                f.getValidityPeriod().setEndDate(new Date(--dd));
            }
            latestTS = f.getValidityPeriod().getEndDate().getTime() + 1L;
        }
    }

    @Override
    public void createNewData(final Node<RecipeComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RecipeComplete dto = (RecipeComplete)node.getValue(RecipeComplete.class);
                Node nn = node;
                ArrayList<RecipeVariantComplete> cl = new ArrayList<RecipeVariantComplete>();
                ArrayList<RecipeVariantLight> ll = new ArrayList<RecipeVariantLight>();
                Iterator it = node.getChildNamed(new String[]{"variants"}).getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue(RecipeVariantComplete.class) != null) {
                        RecipeVariantComplete c = (RecipeVariantComplete)n.getValue(RecipeVariantComplete.class);
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        RecipeModuleDataHandler.this.ensureIngredients(c);
                        c.setRecipe(dto);
                        cl.add(c);
                        continue;
                    }
                    if (n.getValue(RecipeVariantLight.class) == null) continue;
                    RecipeVariantLight l = (RecipeVariantLight)n.getValue(RecipeVariantLight.class);
                    if (l.getState() == null) {
                        l.setState(ModificationStateE.DRAFT);
                    }
                    l.setRecipe(dto);
                    ll.add(l);
                }
                Hashtable<Class<RecipeVariantLight>, Class<RecipeVariantComplete>> t = new Hashtable<Class<RecipeVariantLight>, Class<RecipeVariantComplete>>();
                t.put(RecipeVariantLight.class, RecipeVariantComplete.class);
                node.commit(RecipeVariantComplete.class, t);
                PeriodComplete pTime = dto.getPeriod();
                RecipeModuleDataHandler.this.ensurePeriodMatching(pTime, cl, ll, true);
                if (!cl.isEmpty()) {
                    dto.setCurrentVariant((RecipeVariantLight)cl.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                dto = (RecipeComplete)node.getValue();
                for (RecipeVariantReference r : dto.getVariants()) {
                    if (!(r instanceof RecipeVariantLight)) continue;
                    ((RecipeVariantLight)r).setRecipe(dto);
                }
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                RecipeComplete newDTO = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).createRecipe(dto).getValue();
                Iterator it2 = newDTO.getVariants().iterator();
                while (it2.hasNext()) {
                    RecipeVariantReference r = (RecipeVariantReference)it2.next();
                    if (r.getId() != null) continue;
                    it2.remove();
                }
                if (newDTO.getCurrentVariant() == null) {
                    newDTO.setCurrentVariant((RecipeVariantLight)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant((RecipeVariantReference)newDTO.getVariants().get(0)).getValue());
                }
                if (newDTO != null) {
                    Node n = node;
                    node.getChildNamed(new String[]{"variants"}).removeAllChilds();
                    node.removeExistingValues();
                    node.setValue((Object)newDTO, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return RecipeModuleDataHandler.this.loadingID;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public long getID() {
                return id;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RecipeModuleDataHandler.this.model;
            }

            @Override
            public Node<?> loadData() throws Exception {
                RecipeModuleDataHandler.this.setCurrentLoadMaximum(15);
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperRecipeCategoriesCached();
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AllergenCharacteristicComplete.class);
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AdditiveCharacteristicComplete.class);
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OtherCharacteristicComplete.class);
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PreparationGroupComplete.class);
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxZoneComplete.class);
                RecipeModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(RecipeProductGroupComplete.class);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getQualitySettingsCached();
                Node dto = new Node();
                return dto;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<RecipeComplete> resetData(Node<RecipeComplete> node) {
        return this.createEmptyNode();
    }

    private RecipeComplete createNewRecipe() {
        RecipeComplete aProduct = new RecipeComplete();
        aProduct.setCreationDate(new Timestamp(System.currentTimeMillis()));
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        RecipeVariantComplete variant = new RecipeVariantComplete();
        variant.setValidityPeriod(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        variant.setExcludeFromKonterProben(Boolean.valueOf(true));
        QuantityComplete yield = new QuantityComplete();
        yield.setQuantity(Double.valueOf(0.0));
        if (settings != null && settings.getValue() != null) {
            yield.setUnit(((SystemSettingsComplete)settings.getValue()).getDefaultRecipeUnit());
            if (this.tableView instanceof RecipeModule) {
                RecipeModule r = (RecipeModule)this.tableView;
                if (r.isServiceItem()) {
                    yield.setUnit(((SystemSettingsComplete)settings.getValue()).getPieceUnit());
                    aProduct.setServiceItem(Boolean.valueOf(true));
                } else {
                    yield.setUnit(((SystemSettingsComplete)settings.getValue()).getDefaultRecipeUnit());
                    aProduct.setServiceItem(Boolean.valueOf(false));
                }
            }
            variant.setYield(yield);
            variant.setCategory((RecipeCategoryLight)((SystemSettingsComplete)settings.getValue()).getDefaultRecipeCategory());
            variant.setCreationDate(aProduct.getCreationDate());
            variant.setBatchMaxSizeAmount(Double.valueOf(1.0));
            variant.setBatchMaxSizeUnit(((SystemSettingsComplete)settings.getValue()).getDefaultCustomsPenaltyUnit());
        }
        aProduct.getVariants().add(variant);
        aProduct.setCurrentVariant((RecipeVariantLight)variant);
        return aProduct;
    }

    @Override
    public Node<RecipeComplete> createEmptyNode() {
        RecipeComplete recipe = this.createNewRecipe();
        PeriodComplete p = new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate());
        recipe.setPeriod(p);
        recipe.getCurrentVariant().setValidityPeriod(new PeriodComplete(p.getStartDate(), p.getEndDate()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)recipe, false, false);
        return n;
    }

    @Override
    public Class<RecipeComplete> getCommittingClass() {
        return RecipeComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<RecipeReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

