/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CommentDetailsPanel
extends StateDependantDetailsPanel<RecipeComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextArea> comment;
    private TitledItem<RDTextArea> additionalComment;

    public CommentDetailsPanel(RowEditor<RecipeComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.INSTRUCTIONS);
        this.comment = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.INSTRUCTION, TitledItem.TitledItemOrientation.NORTH);
        this.comment.getElement().setMaxStringLength(1000);
        this.comment.setIgnorePrefHeight(true);
        this.additionalComment = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.ADDITIONAL_COMMENT, TitledItem.TitledItemOrientation.NORTH);
        this.additionalComment.getElement().setMaxStringLength(1000);
        this.additionalComment.setIgnorePrefHeight(true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.comment);
        this.addToView(this.additionalComment);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return RecipeVariantLight_.state;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean b = isEnabled && isDraft;
        super.setEnabled(b);
        this.comment.setEnabled(b);
        this.additionalComment.setEnabled(b);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.comment.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.comment));
        this.additionalComment.getElement().setNode(node.getChildNamed(RecipeVariantComplete_.additionalComment));
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.comment);
        CheckedListAdder.addToList(a, this.additionalComment);
        return a;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            CommentDetailsPanel.this.comment.setLocation(CommentDetailsPanel.this.horizontalBorder, CommentDetailsPanel.this.verticalBorder);
            CommentDetailsPanel.this.comment.setSize((parent.getWidth() - 3 * CommentDetailsPanel.this.horizontalBorder) / 2, parent.getHeight() - 2 * CommentDetailsPanel.this.verticalBorder);
            CommentDetailsPanel.this.additionalComment.setLocation(CommentDetailsPanel.this.comment.getX() + CommentDetailsPanel.this.comment.getWidth() + CommentDetailsPanel.this.horizontalBorder, CommentDetailsPanel.this.comment.getY());
            CommentDetailsPanel.this.additionalComment.setSize(CommentDetailsPanel.this.comment.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }
    }
}

