/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class RecipeBasicDataDetailsPanel
extends StateDependantDetailsPanel<RecipeComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledPeriodEditor periodEditor;
    private TitledItem<RDMultiLocationComboBox> locations;

    public RecipeBasicDataDetailsPanel(RowEditor<RecipeComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.periodEditor = new TitledPeriodEditor(null, null, true, provider, "period");
        this.periodEditor.enableInfinity(false, true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.periodEditor);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return RecipeVariantLight_.state;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean b = isEnabled && isDraft;
        super.setEnabled(isEnabled);
        this.number.setEnabled(b);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(b);
        }
        this.periodEditor.setEnabled(isEnabled);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            RecipeComplete dto = (RecipeComplete)this.editor.getModel().getNode().getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.number.getElement().setNode(this.editor.getModel().getNode().getChildNamed(RecipeComplete_.number));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(this.editor.getModel().getNode().getChildNamed(RecipeComplete_.eligibleLocations));
        }
        this.periodEditor.setStartDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{RecipeComplete_.period, PeriodComplete_.startDate}));
        this.periodEditor.setEndDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{RecipeComplete_.period, PeriodComplete_.endDate}));
    }

    @Override
    public void resetParagraph() {
        super.resetParagraph();
        this.number.getElement().setNode(this.editor.getModel().getNode().getChildNamed(RecipeComplete_.number));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.number);
        CheckedListAdder.addToList(a, this.periodEditor);
        CheckedListAdder.addToList(a, this.locations);
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.periodEditor.kill();
        this.number = null;
        this.locations = null;
        this.periodEditor = null;
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "At least one Location must be set"));
        }
        return o;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.requestFocusInWindowNow();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = RecipeBasicDataDetailsPanel.this.verticalBorder;
            RecipeBasicDataDetailsPanel.this.number.setLocation(RecipeBasicDataDetailsPanel.this.horizontalBorder, currentY);
            int numberMinWidth = 100;
            RecipeBasicDataDetailsPanel.this.number.setSize(numberMinWidth, (int)RecipeBasicDataDetailsPanel.this.number.getPreferredSize().getHeight());
            RecipeBasicDataDetailsPanel.this.periodEditor.setLocation(RecipeBasicDataDetailsPanel.this.horizontalBorder, currentY += RecipeBasicDataDetailsPanel.this.number.getHeight() + RecipeBasicDataDetailsPanel.this.verticalBorder);
            RecipeBasicDataDetailsPanel.this.periodEditor.setSize(RecipeBasicDataDetailsPanel.this.periodEditor.getPreferredSize());
            currentY += RecipeBasicDataDetailsPanel.this.periodEditor.getHeight() + RecipeBasicDataDetailsPanel.this.verticalBorder;
            int currentX = RecipeBasicDataDetailsPanel.this.horizontalBorder;
            if (Boolean.TRUE.equals(RecipeBasicDataDetailsPanel.this.viewSettings.getShowLocation())) {
                RecipeBasicDataDetailsPanel.this.locations.setLocation(RecipeBasicDataDetailsPanel.this.horizontalBorder, currentY);
                RecipeBasicDataDetailsPanel.this.locations.setSize(RecipeBasicDataDetailsPanel.this.locations.getPreferredSize());
                currentY = RecipeBasicDataDetailsPanel.this.locations.getY() + RecipeBasicDataDetailsPanel.this.locations.getHeight() - ((RDMultiLocationComboBox)RecipeBasicDataDetailsPanel.this.locations.getElement()).getHeight();
                currentX += RecipeBasicDataDetailsPanel.this.locations.getWidth() + RecipeBasicDataDetailsPanel.this.horizontalBorder;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = RecipeBasicDataDetailsPanel.this.verticalBorder;
            h += (int)RecipeBasicDataDetailsPanel.this.number.getPreferredSize().getHeight();
            h += RecipeBasicDataDetailsPanel.this.verticalBorder;
            h = (int)((double)h + RecipeBasicDataDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            h += RecipeBasicDataDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(RecipeBasicDataDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + RecipeBasicDataDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += RecipeBasicDataDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }
    }
}

