/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.modules.recipe.details.utils.StepComparator;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.recipe.InterpolationStepComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StepQuantityPopUpInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node steps;
    private Node recipeUnits;
    private ViewNode allUnits;
    private DecimalFormat format;
    private boolean isEditable;
    private RDProvider provider;
    private String override;

    public StepQuantityPopUpInsert(Node steps, Node prodUnitList, List<Node> yieldUnit, RDProvider provider, String overrideName) {
        this.isEditable = provider != null ? provider.isWritable(overrideName) : true;
        this.provider = provider;
        this.override = overrideName;
        this.format = FormatterRegistry.getDecimalFormat(Words.EXTENDED_PRICE_PATTERN);
        this.recipeUnits = prodUnitList;
        this.allUnits = new ViewNode("allUnits");
        this.allUnits.addChildren(yieldUnit);
        this.setOpaque(false);
        this.steps = steps;
        this.table = new Table2(true, Words.ADD_STEP);
        this.table.setUseWriteAccessRight(true);
        this.table.setOverrideName(overrideName);
        this.table.setProvider(provider);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                StepQuantityPopUpInsert.this.ensureSequenceNumber();
                StepQuantityPopUpInsert.this.popup.createFocusCycle();
                StepQuantityPopUpInsert.this.table.relayoutRequested();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node lastStep = null;
                if (StepQuantityPopUpInsert.this.steps.getChildCount() > 0) {
                    lastStep = StepQuantityPopUpInsert.this.steps.getChildAt(StepQuantityPopUpInsert.this.steps.getChildCount() - 1);
                }
                InterpolationStepComplete step = new InterpolationStepComplete();
                QuantityComplete upQuant = new QuantityComplete();
                QuantityComplete resQuant = new QuantityComplete();
                if (lastStep != null) {
                    upQuant.setQuantity(Double.valueOf((Double)lastStep.getChildNamed(new String[]{"upperBound-quantity"}).getValue() + 1.0));
                    upQuant.setUnit((UnitComplete)lastStep.getChildNamed(new String[]{"upperBound-unit"}).getValue());
                    resQuant.setQuantity(Double.valueOf((Double)lastStep.getChildNamed(new String[]{"resultingQuantity-quantity"}).getValue() + 1.0));
                    resQuant.setUnit((UnitComplete)lastStep.getChildNamed(new String[]{"resultingQuantity-unit"}).getValue());
                } else {
                    upQuant.setQuantity(Double.valueOf(1.0));
                    upQuant.setUnit((UnitComplete)StepQuantityPopUpInsert.this.allUnits.getChildAt(0).getValue());
                    resQuant.setQuantity(Double.valueOf(0.0));
                    resQuant.setUnit((UnitComplete)StepQuantityPopUpInsert.this.recipeUnits.getChildAt(0).getValue());
                }
                step.setUpperBound(upQuant);
                step.setResultingQuantity(resQuant);
                step.setSequenceNumber(Integer.valueOf(StepQuantityPopUpInsert.this.table.getRowCount()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)step, true, false);
                StepQuantityPopUpInsert.this.steps.addChild(n, System.currentTimeMillis());
                StepQuantityPopUpInsert.this.ensureSequenceNumber();
                StepQuantityPopUpInsert.this.popup.createFocusCycle();
                StepQuantityPopUpInsert.this.table.relayoutRequested();
                Table2RowPanel p = StepQuantityPopUpInsert.this.table.getRowPanel4Node(n);
                if (p != null) {
                    p.requestFocusInWindowNow();
                }
            }
        });
        this.table.setComparator(ComparatorRegistry.getComparator(StepComparator.class));
        int delSpace = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STEP, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", delSpace, delSpace, delSpace));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.24);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.36);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(this.steps);
        this.table.updateOrder();
        this.setLayout(new Layout());
        this.add(this.table);
    }

    private void ensureSequenceNumber() {
        int count = 0;
        long currentId = System.currentTimeMillis();
        for (Table2RowPanel p : this.table.getRows()) {
            p.getModel().getNode().getChildNamed(new String[]{"sequenceNumber"}).setValue((Object)count, currentId);
            ++count;
        }
        this.table.updateOrder();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        if (this.isEditable && this.table.getAddButton() != null) {
            this.table.getAddButton().requestFocusInWindow();
            return true;
        }
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel step;
        private TextLabel from;
        private ArrowConnectorIcon arrow;
        private RDInputComboBox toField;
        private TextLabel equals;
        private RDInputComboBox resultingField;
        private DeleteButton delete;
        private Node IReadableNodekill;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            Converter unit2Pos = ConverterRegistry.getConverter(DefaultObject2ObjectConverter.class);
            Converter viewConverter = ConverterRegistry.getConverter(UnitConverter.class);
            Converter aV = ConverterRegistry.getConverter(IntegerPlusPlusConverter.class);
            this.step = new TextLabel(this.model.getNode().getChildNamed(new String[]{"sequenceNumber"}), aV);
            Converter fromConverter = new Converter(){

                public Object convert(Object o, Node currentNode, Object ... param) {
                    Node seqNr = TableRowImpl.this.model.getNode().getChildNamed(new String[]{"sequenceNumber"});
                    int nIndex = (Integer)seqNr.getValue() - 1;
                    Node quant = TableRowImpl.this.getAmount4Sequence(nIndex);
                    if (quant == null || quant.getValue() == null) {
                        return "0";
                    }
                    String t = "> " + StepQuantityPopUpInsert.this.format.format(quant.getChildNamed(new String[]{"quantity"}).getValue());
                    Node unit = quant.getChildNamed(new String[]{"unit"});
                    if (unit != null && unit.getValue() != null) {
                        Node unS = unit.getChildNamed(new String[]{"shortName"});
                        t = unS != null ? t + " " + (String)unS.getValue() : t + " " + ((UnitComplete)unit.getValue()).getShortName();
                    }
                    return t;
                }

                public Class getParameterClass() {
                    return null;
                }
            };
            this.from = new TextLabel(m.getNode(), fromConverter);
            this.arrow = new ArrowConnectorIcon();
            this.toField = new RDInputComboBox(StepQuantityPopUpInsert.this.provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
            this.toField.setOverrideName(StepQuantityPopUpInsert.this.override);
            this.toField.setNode(m.getNode().getChildNamed(new String[]{"upperBound"}));
            this.toField.setPossibleUnits((Node)StepQuantityPopUpInsert.this.allUnits);
            this.equals = new TextLabel("=");
            this.resultingField = new RDInputComboBox(StepQuantityPopUpInsert.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.resultingField.setOverrideName(StepQuantityPopUpInsert.this.override);
            this.resultingField.setNode(m.getNode().getChildNamed(new String[]{"resultingQuantity"}));
            this.resultingField.setPossibleUnits(StepQuantityPopUpInsert.this.recipeUnits);
            this.setLayout(new TableRowImplLayouter());
            if (StepQuantityPopUpInsert.this.isEditable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.toField.setProgress(1.0f);
            this.resultingField.setProgress(1.0f);
            this.from.setProgress(1.0f);
            this.add(this.step);
            this.add(this.from);
            this.add(this.arrow);
            this.add(this.toField);
            this.add(this.equals);
            this.add(this.resultingField);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        public Node getAmount4Sequence(int nr) {
            Iterator it = this.model.getNode().getParent().getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Node seqNr = n.getChildNamed(new String[]{"sequenceNumber"});
                if ((Integer)seqNr.getValue() != nr) continue;
                Node d = n.getChildNamed(new String[]{"upperBound"});
                d.getChildNamed(new String[]{"quantity"}).removeNodeListener((NodeListener)this);
                d.getChildNamed(new String[]{"unit"}).removeNodeListener((NodeListener)this);
                d.getChildNamed(new String[]{"quantity"}).addNodeListener((NodeListener)this);
                d.getChildNamed(new String[]{"unit"}).addNodeListener((NodeListener)this);
                this.IReadableNodekill = d;
                return d;
            }
            return null;
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return false;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.step.setEnabled(isEnabled);
            this.from.setEnabled(isEnabled);
            this.arrow.setEnabled(isEnabled);
            this.toField.setEnabled(isEnabled);
            this.equals.setEnabled(isEnabled);
            this.resultingField.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.IReadableNodekill != null) {
                this.IReadableNodekill.getChildNamed(new String[]{"quantity"}).removeNodeListener((NodeListener)this);
                this.IReadableNodekill.getChildNamed(new String[]{"unit"}).removeNodeListener((NodeListener)this);
            }
            this.step.kill();
            this.from.kill();
            this.arrow.kill();
            this.toField.kill();
            this.equals.kill();
            this.resultingField.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.step = null;
            this.from = null;
            this.arrow = null;
            this.toField = null;
            this.equals = null;
            this.resultingField = null;
            this.delete = null;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.toField.requestFocusInWindowNow();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.toField);
            CheckedListAdder.addToList(a, this.resultingField);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void valueChanged(Node<?> node) {
            this.from.updateString();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class TableRowImplLayouter
        extends DefaultLayout {
            private TableRowImplLayouter() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.step.setLocation((int)((double)w - TableRowImpl.this.step.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TableRowImpl.this.step.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.step.setSize(TableRowImpl.this.step.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                int aW = 0;
                TableRowImpl.this.from.setLocation(currentX + StepQuantityPopUpInsert.this.table.getCellPadding(), (int)((parent.getPreferredSize().getHeight() - TableRowImpl.this.from.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.from.setSize(w - 2 * StepQuantityPopUpInsert.this.table.getCellPadding(), (int)TableRowImpl.this.from.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.arrow.setLocation(currentX + (int)(((double)w - TableRowImpl.this.arrow.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - TableRowImpl.this.arrow.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.arrow.setSize(TableRowImpl.this.arrow.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                aW = w - 4 * StepQuantityPopUpInsert.this.table.getCellPadding();
                TableRowImpl.this.toField.setLocation(currentX + StepQuantityPopUpInsert.this.table.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.toField.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.toField.setSize(aW, (int)TableRowImpl.this.toField.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.equals.setLocation(currentX + (int)((double)w - TableRowImpl.this.equals.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TableRowImpl.this.equals.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.equals.setSize(TableRowImpl.this.equals.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.resultingField.setLocation(currentX + StepQuantityPopUpInsert.this.table.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.resultingField.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.resultingField.setSize(w - 2 * StepQuantityPopUpInsert.this.table.getCellPadding(), (int)TableRowImpl.this.resultingField.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + (int)((double)w - TableRowImpl.this.delete.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            StepQuantityPopUpInsert.this.table.setLocation(0, 0);
            StepQuantityPopUpInsert.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }
    }
}

