/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reorderlevel;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.reorderlevel.ReorderLevelServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelEntryComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelReference;
import ch.icit.pegasus.server.core.dtos.search.ReorderLevelSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class ReorderLevelModuleDataHandler
extends DefaultDataHandler<ReorderLevelLight, ReorderLevelComplete> {
    public ReorderLevelModuleDataHandler(long id, ScreenTableView<ReorderLevelLight, ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN> tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<ReorderLevelLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReorderLevelComplete d = (ReorderLevelComplete)node.getValue(ReorderLevelComplete.class);
                ReorderLevelComplete dto = (ReorderLevelComplete)((ReorderLevelServiceManager)ServiceManagerRegistry.getService(ReorderLevelServiceManager.class)).updateReorderLevel(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ReorderLevelComplete> createEmptyNode() {
        ReorderLevelComplete d = new ReorderLevelComplete();
        d.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        d.setFlightPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<ReorderLevelComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(ReorderLevelComplete.class);
                ReorderLevelComplete dto = (ReorderLevelComplete)node.getValue(ReorderLevelComplete.class);
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                ReorderLevelComplete nDto = (ReorderLevelComplete)((ReorderLevelServiceManager)ServiceManagerRegistry.getService(ReorderLevelServiceManager.class)).createReorderLevel(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReorderLevelModuleDataHandler.this.setCurrentLoadMaximum(2);
                ReorderLevelModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ReorderLevelModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReorderLevelModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ReorderLevelComplete> resetData(Node<ReorderLevelComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReorderLevelLight acc = (ReorderLevelLight)node.getValue(ReorderLevelLight.class);
                ReorderLevelComplete nacc = (ReorderLevelComplete)((ReorderLevelServiceManager)ServiceManagerRegistry.getService(ReorderLevelServiceManager.class)).getReorderLevel((ReorderLevelReference)acc).getValue();
                for (ReorderLevelEntryComplete article : nacc.getArticles()) {
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(article.getArticle().getId())).getValue();
                    INodeCreator.getDefaultImpl().getNode4DTO((Object)artC, false, false);
                }
                node.removeExistingValues();
                node.setValue((Object)nacc, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<ReorderLevelComplete> getCommittingClass() {
        return ReorderLevelComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ReorderLevelLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

