/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reporting.insert;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.converter.ArticleReportTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.modules.reporting.ReportingModule;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ArticleReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.TopArticlesReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class TopArticleInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextField> topX;
    private TitledItem<ComboBox> type;
    private TitledPeriodEditor period;
    private TablePanelAddSaveButton printButton;
    private Node<TopArticlesReportConfiguration> node;
    private TitledItem<RadioButtonBox> outputFormat;
    private TitledItem<RadioButton> pdfOutput;
    private TitledItem<RadioButton> xlsOutput;
    private TextLabel options;
    private TitledItem<CheckBox> includeAllArticles;
    private TitledItem<CheckBox> includeInuseOnly;
    private ReportingOutputFormatE currentFormat = ReportingOutputFormatE.PDF;
    private ReportingModule module;

    public TopArticleInsert(ReportingModule module) {
        super(module);
        this.module = module;
        TopArticlesReportConfiguration e = new TopArticlesReportConfiguration();
        e.setAllArticles(Boolean.valueOf(true));
        e.setArticleConfig(new BasicArticleSearchConfiguration());
        e.setStoreConfig(new StoreSearchConfiguration());
        e.setPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        this.node = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, false, false);
        this.startAnimation("Load Data");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(ReportTypeE.TOP_ARTICLES);
                if (r != null && !r.getResults().isEmpty()) {
                    TopArticleInsert.this.node.getChildNamed(new String[]{"stylesheet"}).setValue(r.getResults().get(0), 0L);
                }
                StaticEnumServiceManager.getAllArticleReportTypes();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return TopArticleInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void insertElements() {
        this.topX = new TitledItem<NumberTextField>(new NumberTextField(this.node.getChildNamed(new String[]{"topCount"}), TextFieldType.INT), "Top Count", TitledItem.TitledItemOrientation.NORTH);
        this.type = new TitledItem<ComboBox>(new ComboBox(this.node.getChildNamed(new String[]{"type"}), NodeToolkit.getAffixList(ArticleReportTypeE.class), ConverterRegistry.getConverter(ArticleReportTypeConverter.class)), "Export Type", TitledItem.TitledItemOrientation.NORTH);
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)this.node.getChildNamed(new String[]{"period"}), true, null);
        this.outputFormat = new TitledItem<RadioButtonBox>(new RadioButtonBox(), "Output Format", TitledItem.TitledItemOrientation.NORTH);
        this.outputFormat.getElement().setBorder(0);
        this.pdfOutput = new TitledItem<RadioButton>(new RadioButton(), "as PDF", TitledItem.TitledItemOrientation.EAST);
        this.xlsOutput = new TitledItem<RadioButton>(new RadioButton(), "as Excel", TitledItem.TitledItemOrientation.EAST);
        Color fc = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.pdfOutput.setTitleForeground(fc);
        this.xlsOutput.setTitleForeground(fc);
        this.pdfOutput.getElement().setChecked(true);
        this.outputFormat.getElement().addBox(this.pdfOutput, this.pdfOutput.getElement());
        this.outputFormat.getElement().addBox(this.xlsOutput, this.xlsOutput.getElement());
        this.options = new TextLabel("Options");
        this.includeAllArticles = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.node.getChildNamed(new String[]{"allArticles"})), "Include all Articles", TitledItem.TitledItemOrientation.EAST);
        this.includeInuseOnly = new TitledItem<CheckBox>(new CheckBox(), "Active Articles only", TitledItem.TitledItemOrientation.EAST);
        this.printButton = new TablePanelAddSaveButton();
        this.printButton.setText("Start");
        this.printButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.topX);
        this.add(this.type);
        this.add(this.period);
        this.add(this.outputFormat);
        this.add(this.options);
        this.add(this.includeAllArticles);
        this.add(this.includeInuseOnly);
        this.add(this.printButton);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.topX.setEnabled(isEnabled);
            this.type.setEnabled(isEnabled);
            this.period.setEnabled(isEnabled);
            this.outputFormat.setEnabled(isEnabled);
            this.options.setEnabled(isEnabled);
            this.includeAllArticles.setEnabled(isEnabled);
            this.includeInuseOnly.setEnabled(isEnabled);
            this.printButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.topX.kill();
            this.type.kill();
            this.period.kill();
            this.outputFormat.kill();
            this.options.kill();
            this.includeAllArticles.kill();
            this.includeInuseOnly.kill();
            this.printButton.kill();
        }
        this.topX = null;
        this.type = null;
        this.period = null;
        this.printButton = null;
        this.outputFormat = null;
        this.pdfOutput = null;
        this.xlsOutput = null;
        this.includeAllArticles = null;
        this.includeInuseOnly = null;
        this.options = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Top Articles";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        List<ScreenValidationObject> a = this.period.validateContent();
        if (a != null && !a.isEmpty()) {
            InnerPopupFactory.showErrorDialog(a, "Unable to start Analysis", (Component)this);
            return;
        }
        this.node.commit();
        this.module.started();
        this.startAnimation("Create Top Articles");
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TopArticlesReportConfiguration config = (TopArticlesReportConfiguration)TopArticleInsert.this.node.getValue();
                if (((RadioButton)TopArticleInsert.this.pdfOutput.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.PDF);
                    TopArticleInsert.this.currentFormat = ReportingOutputFormatE.PDF;
                } else {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                    TopArticleInsert.this.currentFormat = ReportingOutputFormatE.XLSX;
                }
                config.getArticleConfig().setInUse(Boolean.valueOf(((CheckBox)TopArticleInsert.this.includeInuseOnly.getElement()).isChecked()));
                Node n = new Node();
                try {
                    Timestamp validityDate = new Timestamp(System.currentTimeMillis());
                    PegasusFileComplete ret = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createTopArticleSheet(config, new TimestampWrapper(validityDate)).getValue();
                    if (ret != null) {
                        PegasusFileComplete frc = ret;
                        try {
                            File rfile = FileTransferUtil.download((PegasusFileComplete)frc, (FileTransferListener[])new FileTransferListener[0]);
                            n.setValue((Object)rfile, 0L);
                            return n;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    n.setValue((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()), 0L);
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        TopArticleInsert.this.stopAnimation();
                        File file = (File)node.getValue(File.class);
                        TopArticleInsert.this.showSaveDialog(file);
                    }

                    public void errorOccurred(ClientException exception) {
                        TopArticleInsert.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private File showSaveDialog(final File file) {
        File selectedFile = null;
        try {
            MainFrame.isTempRelease = true;
            File fileName = FileChooserUtil.saveFile(".xlsx");
            if (fileName != null) {
                final File ssF = selectedFile = fileName;
                if (selectedFile.exists()) {
                    InnerPopupFactory.showDesicionPopup("File already exists", "File already exists. Do you want to override it?", this.printButton, new InnerPopUpListener2(){

                        @Override
                        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                            if (xargs != null) {
                                TopArticleInsert.this.saveFileTo(file, ssF);
                            } else {
                                TopArticleInsert.this.module.ended();
                                TopArticleInsert.this.setEnabled(true);
                            }
                        }
                    }, 150, 100);
                } else {
                    this.saveFileTo(file, selectedFile);
                }
            } else {
                this.module.ended();
                this.setEnabled(true);
            }
            MainFrame.isTempRelease = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return selectedFile;
    }

    private void saveFileTo(File file, File path) {
        try {
            String p = path.getPath();
            p = FileChooserUtil.ensureFilePath(p, this.currentFormat);
            if (file != null) {
                file.renameTo(new File(p));
            }
            this.setEnabled(true);
            InnerPopupFactory.showMessageDialog("TopArticles successfully exported!", this);
        }
        catch (Exception e) {
            e.printStackTrace();
            InnerPopupFactory.showErrorDialog("Unable to export TopArticles!", (Component)this);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (TopArticleInsert.this.animation != null) {
                TopArticleInsert.this.animation.setLocation((int)((double)parent.getWidth() - TopArticleInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TopArticleInsert.this.animation.getPreferredSize().getHeight()) / 2);
                TopArticleInsert.this.animation.setSize(TopArticleInsert.this.animation.getPreferredSize());
            }
            if (TopArticleInsert.this.isInserted) {
                TopArticleInsert.this.topX.setLocation(border, border);
                TopArticleInsert.this.topX.setSize(70, (int)TopArticleInsert.this.topX.getPreferredSize().getHeight());
                TopArticleInsert.this.type.setLocation(border, TopArticleInsert.this.topX.getY() + TopArticleInsert.this.topX.getHeight() + border / 2);
                TopArticleInsert.this.type.setSize(250, (int)TopArticleInsert.this.type.getPreferredSize().getHeight());
                TopArticleInsert.this.outputFormat.setLocation(border, TopArticleInsert.this.type.getY() + TopArticleInsert.this.type.getHeight() + border / 2);
                TopArticleInsert.this.outputFormat.setSize(TopArticleInsert.this.outputFormat.getPreferredSize());
                TopArticleInsert.this.period.setLocation(border, TopArticleInsert.this.outputFormat.getY() + TopArticleInsert.this.outputFormat.getHeight() + border);
                TopArticleInsert.this.period.setSize(TopArticleInsert.this.period.getPreferredSize());
                TopArticleInsert.this.options.setLocation(border, TopArticleInsert.this.period.getY() + TopArticleInsert.this.period.getHeight() + border);
                TopArticleInsert.this.options.setSize(TopArticleInsert.this.options.getPreferredSize());
                TopArticleInsert.this.includeAllArticles.setLocation(border, TopArticleInsert.this.options.getY() + TopArticleInsert.this.options.getHeight() + border / 2);
                TopArticleInsert.this.includeAllArticles.setSize(TopArticleInsert.this.includeAllArticles.getPreferredSize());
                TopArticleInsert.this.includeInuseOnly.setLocation(border, TopArticleInsert.this.includeAllArticles.getY() + TopArticleInsert.this.includeAllArticles.getHeight() + border / 2);
                TopArticleInsert.this.includeInuseOnly.setSize(TopArticleInsert.this.includeInuseOnly.getPreferredSize());
                TopArticleInsert.this.printButton.setLocation((int)((double)parent.getWidth() - ((double)border + TopArticleInsert.this.printButton.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ((double)border + TopArticleInsert.this.printButton.getPreferredSize().getHeight())));
                TopArticleInsert.this.printButton.setSize(TopArticleInsert.this.printButton.getPreferredSize());
            }
        }
    }
}

