/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager;

import ch.icit.pegasus.client.actions.ClientAction;
import ch.icit.pegasus.client.actions.impl.PrintRequisitionOrderForDeliver;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionBatchComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderDeliveryGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderDeliveryGroupComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.SupplyOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionMutationRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionReceivingRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionRejectionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import java.util.Iterator;

public class RequisitionOrderModuleDataHandler
extends DefaultDataHandler<SupplyOrderLight, RequisitionOrderComplete> {
    public RequisitionOrderModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<SupplyOrderLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = node.getChildNamed(RequisitionOrderComplete_.deliveryGroups).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    Iterator it2 = next.getChildNamed(RequisitionOrderDeliveryGroupComplete_.customsDocuments).getFailSafeChildIterator();
                    while (it2.hasNext()) {
                        Node next1 = (Node)it2.next();
                        if (!(next1 instanceof DTOProxyNode)) continue;
                        next1 = ((DTOProxyNode)next1).getRefNode();
                        next1.commitThis(CustomsDocumentComplete.class);
                    }
                }
                node.commitThis(RequisitionOrderComplete.class);
                RequisitionOrderComplete oldDTO = (RequisitionOrderComplete)node.getValue(RequisitionOrderComplete.class);
                for (RequisitionOrderDeliveryGroupComplete group : oldDTO.getDeliveryGroups()) {
                    group.setCustomsDocuments(((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).mergeCustomsDocuments(new ListWrapper(group.getCustomsDocuments()), false).getList());
                }
                SupplyOrderLight newDTO = (SupplyOrderLight)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updateRequisitionOrder(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)newDTO, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                if (model == null) {
                    return RequisitionOrderModuleDataHandler.this.model;
                }
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void reloadOrder(final Node<RequisitionOrderComplete> order, final RemoteLoader listener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RequisitionOrderComplete o = (RequisitionOrderComplete)order.getValue();
                RequisitionOrderComplete no = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(o.getId())).getValue();
                order.removeExistingValues();
                order.setValue((Object)no, 0L);
                order.updateNode();
                return order;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        if (node.getValue() instanceof RequisitionOrderLight) {
            this.showMessage(pListener, "Refresh Requisition Order");
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    RequisitionOrderLight order = (RequisitionOrderLight)node.getValue(RequisitionOrderLight.class);
                    RequisitionOrderComplete no = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(order.getId())).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)no, 0L);
                    node.updateNode();
                    Iterator it = node.getChildNamed(RequisitionOrderComplete_.orderPositions).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node artNode = ((Node)it.next()).getChildNamed(RequisitionOrderPositionComplete_.article);
                        RequisitionOrderModuleDataHandler.this.reloadBasicArticle((Node<BasicArticleReference>)artNode);
                    }
                    return node;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return listener;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
            return true;
        }
        if (node.getValue() instanceof RequisitionOrderPositionComplete) {
            this.showMessage(pListener, "Refresh Requisition Order Positions");
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    if (node.getChildNamed(RequisitionOrderPositionComplete_.associatedBatches) == null) {
                        return node;
                    }
                    Iterator it = node.getChildNamed(RequisitionOrderPositionComplete_.associatedBatches).getChilds();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        Node artCharge = n.getChildNamed(OrderPositionBatchComplete_.charge);
                        ArticleChargeLight charge = (ArticleChargeLight)artCharge.getValue();
                        ArticleChargeComplete chargeC = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge((ArticleChargeReference)charge).getValue();
                        artCharge.removeExistingValues();
                        artCharge.setValue((Object)chargeC, 0L);
                        artCharge.updateNode();
                    }
                    return node;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return listener;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
            return true;
        }
        return false;
    }

    @Override
    public void createNewData(final Node<RequisitionOrderComplete> node, final RemoteLoader model, boolean sameNode, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RequisitionOrderComplete order = (RequisitionOrderComplete)node.getValue(RequisitionOrderComplete.class);
                Iterator it = order.getOrderPositions().iterator();
                while (it.hasNext()) {
                    RequisitionOrderPositionComplete p = (RequisitionOrderPositionComplete)it.next();
                    if (p.getArticle() == null || p.getQuantity() == null || p.getQuantity().getAmount() == null || p.getQuantity().getAmount() == 0L || p.getReceivingStore() == null) {
                        it.remove();
                        continue;
                    }
                    p.setOrder(order);
                }
                if (order.getOrderPositions().size() == 0) {
                    return null;
                }
                if (order.getEligibleLocations().isEmpty()) {
                    order.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                RequisitionOrderComplete o = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).createRequisitionOrder(order).getValue();
                if (model instanceof RowModel) {
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    Iterator<ClientAction> it2 = ((RowModel)model).getActions();
                    while (it2.hasNext()) {
                        ClientAction e = it2.next();
                        if (!(e instanceof PrintRequisitionOrderForDeliver)) continue;
                        try {
                            PrintRequisitionOrderForDeliver p = (PrintRequisitionOrderForDeliver)e;
                            p.performAction(RequisitionOrderModuleDataHandler.this.model.getTable(), l, o, settings);
                        }
                        catch (ClientServerCallException ex) {
                            InnerPopupFactory.showMessage("Unable to print Requisition Order", "Deliver Sheet was not printed. Order was created correctly. Problem: " + ex.getMessage(), null, RequisitionOrderModuleDataHandler.this.tableView);
                        }
                    }
                }
                node.removeExistingValues();
                node.setValue((Object)o, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RequisitionOrderModuleDataHandler.this.setCurrentLoadMaximum(10);
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionReceivingRemarkComplete.class);
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionRejectionRemarkComplete.class);
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionMutationRemarkComplete.class);
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ExternalCostCenterComplete.class);
                RequisitionOrderModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return RequisitionOrderModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<RequisitionOrderComplete> resetData(Node<RequisitionOrderComplete> node) {
        return null;
    }

    public void reloadBasicArticle(Node<BasicArticleReference> node) throws ClientServerCallException {
        BasicArticleComplete art = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(((BasicArticleReference)node.getValue()).getId())).getValue();
        node.removeExistingValues();
        node.setValue((Object)art, 0L);
        node.updateNode();
    }

    @Override
    public Node<RequisitionOrderComplete> createEmptyNode() {
        RequisitionOrderComplete order = new RequisitionOrderComplete();
        order.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)order, false, false);
        return n;
    }

    @Override
    public Class<RequisitionOrderComplete> getCommittingClass() {
        return RequisitionOrderComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<SupplyOrderLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

