/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.BarcodeDevice;
import ch.icit.utils.BarcodeType;
import ch.icit.utils.GTINCategory;
import ch.icit.utils.builder.BarcodeBuilder;
import ch.icit.utils.reader.BarcodeHandler;
import ch.icit.utils.reader.BarcodeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class KanbanDetailsPanel
extends DefaultDetailsPanel<RequisitionOrderLight>
implements BarcodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> kanbanOrder;
    private TitledItem<ComboBox> scannerConfig;
    private TitledItem<TextField> scannerField;
    private BarcodeHandler handler = new BarcodeHandler((BarcodeListener)this, this.getCompanyCode(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompanyCode()));

    public KanbanDetailsPanel(RowEditor<RequisitionOrderLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true);
        this.setTitleText(Words.KANBAN);
        this.setCustomLayouter(new Layout());
        this.kanbanOrder = new TitledItem<CheckBox>(new CheckBox(), "Kanban Order", TitledItem.TitledItemOrientation.EAST);
        this.scannerConfig = new TitledItem<ComboBox>(new ComboBox(), "Scanner Type", TitledItem.TitledItemOrientation.NORTH);
        for (BarcodeDevice value : BarcodeDevice.values()) {
            if (!value.isOnWorkstation()) continue;
            this.scannerConfig.getElement().addItem(value);
        }
        this.scannerField = new TitledItem<TextField>(new TextField(), Words.INPUT_FIELD, TitledItem.TitledItemOrientation.NORTH);
        this.scannerConfig.getElement().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.handler.setCurrentDevice((BarcodeDevice)e.getItem());
                this.handler.registerInputListener((JComponent)this.scannerField.getElement().getTextField());
            }
        });
        this.scannerConfig.getElement().setSelectedItem(BarcodeDevice.HONEYWELL_1300G);
        this.handler.setCurrentDevice(BarcodeDevice.HONEYWELL_1300G);
        this.handler.registerInputListener((JComponent)this.scannerField.getElement().getTextField());
        this.addToView(this.scannerField);
        this.addToView(this.kanbanOrder);
        this.addToView(this.scannerConfig);
    }

    private String getCompanyCode(String companyCode) {
        return companyCode.replaceAll("0", "").trim();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.kanbanOrder);
        CheckedListAdder.addToList(focusList, this.scannerConfig);
        CheckedListAdder.addToList(focusList, this.scannerField);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        if (node == null) {
            return;
        }
        this.kanbanOrder.getElement().setNode(node.getChildNamed(RequisitionOrderLight_.kanBanOrder));
        this.scannerField.getElement().setNode((Node)new ViewNode("scanning_test"));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.scannerField.kill();
        this.scannerField = null;
        this.kanbanOrder.kill();
        this.kanbanOrder = null;
        this.scannerConfig.kill();
        this.scannerConfig = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.scannerField.setEnabled(isEnabled);
        this.kanbanOrder.setEnabled(isEnabled);
        this.scannerConfig.setEnabled(isEnabled);
    }

    public void barcodeReady(BarcodeType barcodeType, final String barcode) {
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Integer articleNo = BarcodeBuilder.getBuilder().readContentAsInteger(barcode, settings.getCompanyCode(), GTINCategory.ARTICLE, BarcodeType.EAN_13, false);
                BasicArticleSearchConfiguration configuration = new BasicArticleSearchConfiguration();
                configuration.setSearchType(BasicArticleSearchTypeE.ARTICLE_NUMBER);
                configuration.setNumber(articleNo);
                List articles = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)configuration).getResults();
                BasicArticleLight selectedArticle = !articles.isEmpty() ? (BasicArticleLight)articles.get(0) : null;
                ViewNode retNode = new ViewNode("ret");
                if (selectedArticle != null) {
                    BasicArticleComplete baC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(selectedArticle.getId())).getValue();
                    Node reqNode = KanbanDetailsPanel.this.editor.getModel().getTypeSafeNode();
                    RequisitionOrderPositionComplete positionComplete = new RequisitionOrderPositionComplete();
                    positionComplete.setSequenceNumber(Integer.valueOf(KanbanDetailsPanel.this.editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.orderPositions).getChildCount()));
                    positionComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
                    positionComplete.setArticle((BasicArticleLight)baC);
                    ArticleKanbanConfigurationComplete selectedKanbanConfiguration = null;
                    Date validity = (Date)reqNode.getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
                    for (ArticleKanbanConfigurationComplete kanbanConfiguration : baC.getKanbanConfigurations()) {
                        if (!kanbanConfiguration.getValidity().within(validity).booleanValue()) continue;
                        selectedKanbanConfiguration = kanbanConfiguration;
                    }
                    if (selectedKanbanConfiguration != null) {
                        positionComplete.setReceivingStore(selectedKanbanConfiguration.getStorePosition());
                        positionComplete.setQuantity(new StoreQuantityComplete(selectedKanbanConfiguration.getQuantityPerCard()));
                    }
                    Node positionNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)positionComplete, true, false);
                    reqNode.getChildNamed(RequisitionOrderComplete_.orderPositions).addChild(positionNode, 0L);
                    retNode.setValue((Object)baC, 0L);
                }
                return retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        KanbanDetailsPanel.this.handler.resetBarcode();
                        ((TextField)KanbanDetailsPanel.this.scannerField.getElement()).setText("");
                        if (node.getValue() == null) {
                            InnerPopupFactory.showErrorDialog("No article found", (Component)KanbanDetailsPanel.this);
                        }
                        KanbanDetailsPanel.this.setEnabled(true);
                        if (node.getValue() != null) {
                            KanbanDetailsPanel.this.scannerField.requestFocusInWindowNow();
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        KanbanDetailsPanel.this.setEnabled(true);
                        KanbanDetailsPanel.this.handler.resetBarcode();
                        ((TextField)KanbanDetailsPanel.this.scannerField.getElement()).setText("");
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)KanbanDetailsPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean hasExpandableContent() {
        return false;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.kanbanOrder.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            KanbanDetailsPanel.this.kanbanOrder.setLocation(KanbanDetailsPanel.this.horizontalBorder, KanbanDetailsPanel.this.verticalBorder);
            KanbanDetailsPanel.this.kanbanOrder.setSize(200, (int)KanbanDetailsPanel.this.kanbanOrder.getPreferredSize().getHeight());
            KanbanDetailsPanel.this.scannerConfig.setLocation(KanbanDetailsPanel.this.horizontalBorder, KanbanDetailsPanel.this.kanbanOrder.getY() + KanbanDetailsPanel.this.kanbanOrder.getHeight() + KanbanDetailsPanel.this.inner_verticalBorder);
            KanbanDetailsPanel.this.scannerConfig.setSize(200, (int)KanbanDetailsPanel.this.scannerConfig.getPreferredSize().getHeight());
            KanbanDetailsPanel.this.scannerField.setLocation(KanbanDetailsPanel.this.horizontalBorder, KanbanDetailsPanel.this.scannerConfig.getY() + KanbanDetailsPanel.this.scannerConfig.getHeight() + KanbanDetailsPanel.this.inner_verticalBorder);
            KanbanDetailsPanel.this.scannerField.setSize(300, (int)KanbanDetailsPanel.this.scannerField.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = KanbanDetailsPanel.this.verticalBorder;
            h = (int)((double)h + KanbanDetailsPanel.this.kanbanOrder.getPreferredSize().getHeight());
            h += KanbanDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + KanbanDetailsPanel.this.scannerConfig.getPreferredSize().getHeight());
            h += KanbanDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + KanbanDetailsPanel.this.scannerField.getPreferredSize().getHeight());
            return new Dimension(0, h += KanbanDetailsPanel.this.verticalBorder);
        }
    }
}

