/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow.utils;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow.utils.TotalAvailableConverter;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.CursorController;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.UnitSelectionUtil;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleProductInfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBoxListener;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ARequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.GroupCheckOutCBAccess;
import ch.icit.pegasus.server.core.dtos.store.StoreEntryTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class TableRowImpl
extends SortableTable2RowPanel
implements SearchTextField2Listener,
RemoteLoader,
MutableFocusContainerListener,
NodeListener,
StorePositionSearchBoxListener {
    private static final long serialVersionUID = 1L;
    private TextLabel label;
    private SearchTextField2 article;
    private InputComboBox2 amount;
    private TextLabel available;
    private ArticleProductInfoButton infoButton;
    private StorePositionSearchBox storeField;
    private TextLabel department;
    private SystemSettingsComplete settings;
    private UserComplete currentUser;

    public TableRowImpl(Table2RowModel m, RDProvider provider) {
        super(m);
        this.setSortAttributeName(RequisitionOrderPositionComplete_.sequenceNumber);
        this.setStartEndOffset(0, 1);
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn).addNodeListener((NodeListener)this);
        this.label = new TextLabel(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.sequenceNumber), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
        if (Boolean.TRUE.equals(this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderLight_.kanBanOrder).getValue())) {
            this.article = SearchTextField2Factory.getBasicArticleKanbanSearchField(false, m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article));
            if (Boolean.TRUE.equals(this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderLight_.secondScannerConfig).getValue())) {
                this.article.tryToSelectOne(true);
                this.article.setIgnoreEmptySearch(true);
            }
        } else {
            this.article = SearchTextField2Factory.getBasicArticleSearchField(false, m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article), false);
        }
        this.article.addSearchTextFieldListener(this);
        Object[] o = new Object[8];
        Boolean canMoveAny = false;
        for (ModuleAccessRightComplete module : this.currentUser.getModules()) {
            if (!module.getModule().getInvokingName().equals(GroupCheckOutCBAccess.MODULE_CHECKOUTGROUPCB.getIdentifier())) continue;
            for (DataFieldAccessRightComplete fieldAccessRight : module.getFieldAccessRights()) {
                if (!fieldAccessRight.getField().getName().equals(GroupCheckOutCBAccess.CHECKOUT_ANY_ARTICLE.getName())) continue;
                canMoveAny = null;
            }
        }
        o[6] = canMoveAny == null ? null : Boolean.valueOf(true);
        o[7] = this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.halalOrder).getValue();
        this.article.setAdditionalSearchField(o);
        this.amount = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        this.available = new TextLabel(null, ConverterRegistry.getConverter(TotalAvailableConverter.class));
        this.infoButton = new ArticleInfoButton(null, null, 3003);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(viewSettings.getShowArticleDepartments())) {
            this.department = new TextLabel(m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.article, BasicArticleLight_.defaultRequisitionDeliverDepartment}), ConverterRegistry.getConverter(CostCenterConverter.class));
        }
        this.storeField = new StorePositionSearchBox();
        if (Boolean.TRUE.equals(settings.getUseStoreEntryTypeRestrictionForManualTransactions()) && !provider.isWritable(ARequisitionOrderAccess.MOVE_FROM_TO_ANY_STORE.getName(), true)) {
            this.storeField.setStoreSearchType(StoreEntryTypeE.IN);
        }
        this.storeField.addFocusCycleChangeListener(this);
        this.storeField.setNode((Node<StorePositionLight>)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore));
        this.storeField.setEnabled(false);
        this.storeField.addSearchListener(this);
        this.label.setEnabled(true);
        this.amount.setEnabled(false);
        this.available.setEnabled(false);
        this.article.setProgress(1.0f);
        this.available.setProgress(1.0f);
        this.amount.setProgress(1.0f);
        this.storeField.setProgress(1.0f);
        this.setLayout(new Layout());
        this.add(this.label);
        this.add(this.article);
        this.add(this.amount);
        this.add(this.available);
        this.add(this.infoButton);
        this.add(this.storeField);
        if (this.department != null) {
            this.add(this.department);
        }
        if (m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue() != null) {
            this.newValueSelected(this.article, m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article));
        }
    }

    public List<ScreenValidationObject> validateInputs() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (this.article.getNode().getValue(BasicArticleComplete.class) == null) {
            this.article.setInValid();
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure each Order Position has an Article set"));
        } else {
            Timestamp validity = new Timestamp(((Date)this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue()).getTime());
            BasicArticleComplete artC = (BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class);
            UnitComplete orderUnit = this.amount.getSelectUnit();
            int containsOrderUnit = UnitConversionToolkit.isUnitContaining((UnitComplete)orderUnit, (BasicArticleLight)artC, (Timestamp)validity);
            if (containsOrderUnit == 11) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Selected Unit (" + orderUnit.getShortName() + ") is not convertible within Article's Packaging Table (" + artC.getNumber() + " - " + artC.getName() + "). Please delete current Article and add it again."));
            }
        }
        if (this.storeField.getNode().getValue() == null) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No receiving Store selected."));
            this.storeField.setInValid();
        }
        return a;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.article != null) {
            this.article.requestFocusInWindowNow();
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn).removeNodeListener((NodeListener)this);
        this.label.kill();
        this.article.kill();
        this.amount.kill();
        this.storeField.kill();
        this.available.kill();
        this.infoButton.kill();
        if (this.department != null) {
            this.department.kill();
        }
        this.article = null;
        this.amount = null;
        this.storeField = null;
        this.available = null;
        this.infoButton = null;
        this.label = null;
        this.department = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.article == null) {
            return;
        }
        boolean selected = this.article.isItemSelected();
        this.article.setEnabled(isEnabled);
        this.infoButton.setEnabled(isEnabled && selected);
        this.amount.setEnabled(isEnabled && selected);
        this.storeField.setEnabled(isEnabled && selected);
        this.available.setEnabled(isEnabled && selected);
        this.infoButton.setEnabled(isEnabled);
        if (this.department != null) {
            this.department.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.article.getFocusComponents());
        if (this.article.isItemSelected()) {
            a.addAll(this.amount.getFocusComponents());
            a.addAll(this.storeField.getFocusComponents());
        }
        a.addAll(super.getFocusComponents());
        return a;
    }

    private Timestamp getValidityDate() {
        Date date = (Date)this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
        Timestamp validity = new Timestamp(date.getTime());
        return validity;
    }

    private void loadBasicArticleComplete(Node<?> n, Timestamp validityDate) throws ClientServerCallException {
        BasicArticleLight art = (BasicArticleLight)n.getValue();
        BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(art.getId())).getValue();
        this.article.getNode().setValue((Object)artC, 0L);
    }

    private void loadArticleStock(BasicArticleComplete artC) throws ClientServerCallException {
        StoreQuantityComplete stock = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getMainStockInTargetUnitIfPossible(new BasicArticleReference(artC.getId()), artC.getFloatStoreUnit());
        ViewNode searchResults = new ViewNode("");
        ViewNode nNode = new ViewNode("");
        ViewNode quantNode = new ViewNode("quantNode");
        quantNode.setValue((Object)stock, 0L);
        quantNode.setName("quantity");
        nNode.addChild((Node)quantNode, 0L);
        searchResults.addChild((Node)nNode, 0L);
        searchResults.setName("ArticleStores");
        NodeToolkit.removeAffixNamed((String)"ArticleStores");
        NodeToolkit.addAffix((Node)searchResults);
    }

    @Override
    public void newValueSelected(SearchTextField2 source, final Node<?> n) {
        if (n.getChildNamed(DtoFieldConstants.requisitionConverted) == null) {
            if (n != null && n.getValue() != null) {
                CursorController.showCursor(this, true);
                this.setEnabled(false);
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        TableRowImpl.this.loadBasicArticleComplete(n, TableRowImpl.this.getValidityDate());
                        BasicArticleComplete artC = (BasicArticleComplete)n.getValue(BasicArticleComplete.class);
                        TableRowImpl.this.loadArticleStock(artC);
                        return TableRowImpl.this.article.getNode();
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return TableRowImpl.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
        } else {
            this.model.getNode().removeChild(this.model.getNode().getChildNamed(DtoFieldConstants.requisitionConverted), 0L);
            this.remoteObjectLoaded(n);
        }
    }

    @Override
    public Object getSortableObject() {
        return this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.sequenceNumber).getValue();
    }

    protected boolean isStoreSelected() {
        return this.storeField.getPositionNode() != null && this.storeField.getPositionNode().getValue() != null;
    }

    private void updateSelectableUnits(StoreLight store) {
        BasicArticleComplete artC = (BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class);
        Timestamp validity = this.getValidityDate();
        List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)validity, (TransactionType)TransactionType.REQUISITION, (UserComplete)this.currentUser, null, (StoreLight)store, (SystemSettingsComplete)this.settings);
        ViewNode un = new ViewNode("");
        for (UnitComplete u : units) {
            un.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, true), 0L);
        }
        this.amount.setPossibleUnits((Node)un);
        this.amount.setNode(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.quantity));
        UnitSelectionUtil.selectUnit(units, this.amount, (BasicArticleLight)artC);
        this.available.updateString();
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        Node n;
        StoreQuantityComplete q;
        if (node != null && node.getValue() instanceof ClientServerCallException) {
            InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)this);
            CursorController.showCursor(this, false);
            this.setEnabled(true);
            return;
        }
        BasicArticleComplete artC = (BasicArticleComplete)this.article.getNode().getValue(BasicArticleComplete.class);
        if (artC == null) {
            if (node != null) {
                Node convNode = node.getChildNamed(DtoFieldConstants.requisitionConverted);
                node.removeChild(convNode, 0L);
            }
            this.newValueSelected(this.article, node);
            return;
        }
        boolean kanbanOrder = false;
        ArticleKanbanConfigurationComplete selectedKanbanConfiguration = null;
        if (Boolean.TRUE.equals(this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderLight_.kanBanOrder).getValue())) {
            kanbanOrder = true;
            Date validity = (Date)this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
            for (ArticleKanbanConfigurationComplete kanbanConfiguration : artC.getKanbanConfigurations()) {
                if (!kanbanConfiguration.getValidity().within(validity).booleanValue()) continue;
                selectedKanbanConfiguration = kanbanConfiguration;
            }
        }
        this.infoButton.setNode(this.article.getNode());
        this.infoButton.setValidityNode((Node<Date>)this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn));
        if (this.department != null) {
            this.department.setNode(this.article.getNode().getChildNamed(BasicArticleLight_.defaultRequisitionDeliverDepartment));
        }
        if ((q = (StoreQuantityComplete)(n = this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.quantity)).getValue()) == null) {
            q = kanbanOrder && selectedKanbanConfiguration != null ? new StoreQuantityComplete(selectedKanbanConfiguration.getQuantityPerCard()) : new StoreQuantityComplete(Long.valueOf(0L), artC.getFloatStoreUnit());
        }
        if (n.getValue() == null) {
            n.setValue((Object)q, 0L);
        } else {
            n.setValue((Object)q, 0L);
            n.getChildNamed(StoreQuantityComplete_.unit).setValue((Object)artC.getFloatStoreUnit(), 0L);
        }
        this.updateSelectableUnits(null);
        if (kanbanOrder && selectedKanbanConfiguration != null) {
            this.storeField.getStoreNode().setValue((Object)selectedKanbanConfiguration.getStorePosition().getStore(), 0L);
            this.storeField.getPositionNode().setValue((Object)selectedKanbanConfiguration.getStorePosition(), 0L);
        } else {
            int i = this.model.getParentModel().getTable().getRowIndex(this);
            if (i > 0) {
                boolean done = false;
                while (i >= 0 && !done) {
                    TableRowImpl p = (TableRowImpl)this.model.getParentModel().getTable().getRowAt(i);
                    if (p.isStoreSelected()) {
                        this.storeField.setDontSelectNewOne(true);
                        StoreLight s = (StoreLight)p.storeField.getStoreNode().getValue();
                        this.storeField.getStoreNode().setValue((Object)s, 0L);
                        StorePositionLight l = (StorePositionLight)p.storeField.getPositionNode().getValue();
                        this.storeField.getPositionNode().setValue((Object)l, 0L);
                        done = true;
                        this.storeField.setDontSelectNewOne(false);
                    }
                    --i;
                }
            } else {
                StoreConditionComplete storeCondition = ArticleToolkit.getStoreCondition(artC, StoreConditionTypeE.REQUISITION_CHECKIN);
                if (storeCondition != null) {
                    this.storeField.getStoreNode().setValue((Object)storeCondition.getPosition().getStore(), 0L);
                }
            }
        }
        this.available.setNode(this.article.getNode());
        this.available.updateString();
        CursorController.showCursor(this, false);
        this.getModel().getParentModel().recreateFocusCycle();
        this.setEnabled(true);
        this.invalidate();
        this.validate();
    }

    public void valueChanged(Node<?> node) {
        this.updateSelectableUnits(null);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    @Override
    public void selectionChanged(SearchComboBox store, SearchTextField2 position) {
        StorePositionLight storePosition = (StorePositionLight)position.getNode().getValue();
        if (storePosition != null) {
            this.updateSelectableUnits(storePosition.getStore());
        }
    }

    @Override
    public void focusCycleChanged(MutableFocusContainer container) {
        this.getModel().getParentModel().recreateFocusCycle();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
            TableRowImpl.this.label.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.label.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.label.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.label.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
            TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.article.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
            TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.article.getX() + TableRowImpl.this.article.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
            int index = 3;
            if (TableRowImpl.this.department != null) {
                TableRowImpl.this.department.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.department.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.department.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.department.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
            }
            TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.amount.setSize((int)TableRowImpl.this.amount.getPreferredSize().getWidth(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
            TableRowImpl.this.available.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.available.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.available.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.available.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
            TableRowImpl.this.storeField.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.storeField.getPreferredSize().getHeight()) / 2.0));
            TableRowImpl.this.storeField.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.storeField.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
            TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight(), false);
            TableRowImpl.this.setControlsX(currentX);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
        }
    }
}

