/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retail;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.FlightCustomsDocumentsConverter;
import ch.icit.pegasus.client.converter.FlightTrackingNumberConverter;
import ch.icit.pegasus.client.converter.LogTimeConverter;
import ch.icit.pegasus.client.converter.LogUserConverter;
import ch.icit.pegasus.client.converter.RetailStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.SalesPersonConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.retail.RetailModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.retail.details.NewRetailDetailsPanel;
import ch.icit.pegasus.client.gui.modules.retail.details.OrderNumbersDetailsPanel;
import ch.icit.pegasus.client.gui.modules.retail.details.ProductsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.retail.details.RemarkDetailsPanel;
import ch.icit.pegasus.client.gui.modules.retail.details.SolarHandlingCostsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.retail.details.StateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.retail.details.TimeDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.deliveryinstruction.utils.CategoryConverter;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.InputMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.invoice.RetailInvoiceStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RetailAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchTypeE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class RetailModule
extends ScreenTableView<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_FLIGHT = "flight_number";
    private static final String FILTER_ORDER_NUMBER = "flight_order_number";
    private static final String FILTER_SALES_PERSON = "flight_sales_person";
    private static final String FILTER_STATE = "flight_state";
    private static final String FILTER_PERIOD = "flight_period";
    private static final String FILTER_CARRIER = "flight_carrier";
    private static final String FILTER_FLIGHT_CAT = "category";
    private static final String FILTER_INVOICE_STATE = "invoice_state";
    private String filterCriteria1;
    private String filterCriteriaOrderNumber;
    private FlightStateE filterCriteria2;
    private PeriodComplete filterCriteria3;
    private CustomerLight filterCriteria4;
    private SalesPersonComplete filterCriteriaSalesPerson;
    private FlightSearchConfiguration.STOWAGE_TYPE_COLUMN filterCriteria6 = FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL;
    private Boolean onlyOpenFlights = false;
    private Boolean ignoreCancelledFlights = false;
    private FlightCategoryComplete flightCategoryFilter;
    private FlightSearchTypeE filterCriteria11;
    private TitledPeriodEditor periodEditor;
    private ComboBox stateCombo;
    private ComboBox flightCategories;
    private ComboBox invoiceStateCombo;
    private RetailInvoiceStateE filterCriteriaInvoiceState;

    public RetailModule() {
        super(FlightLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodEditor.kill();
        this.stateCombo.kill();
        if (this.flightCategories != null) {
            this.flightCategories.kill();
        }
        this.invoiceStateCombo.kill();
        this.periodEditor = null;
        this.stateCombo = null;
        this.flightCategories = null;
        this.invoiceStateCombo = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return RetailAccess.MODULE_RETAIL;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected boolean showDeletedComboBox() {
        return false;
    }

    @Override
    protected void createFilterChain(long id) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.filterChain.setDefaultComboWidth(100);
        this.filterChain.overrideDefaultComboBoxWidth(140);
        this.filterChain.overrideDefaultSearchBoxWidth(140);
        this.filterChain.overrideDefaultSearchField2Width(130);
        this.stateCombo = ComboBoxFactory.getRetailStateComboBox(true);
        this.stateCombo.setSelectedItem(Words.ALL);
        this.invoiceStateCombo = ComboBoxFactory.getRetailInvoiceStateComboBox(true);
        this.invoiceStateCombo.setSelectedItem(Words.ALL);
        String searchName = Boolean.TRUE.equals(settings.getRetailAutoName()) ? Words.DELIVERY_NO : Words.DELIVERY_NO_OR_NAME;
        this.filterChain.addSearchField(FILTER_FLIGHT, searchName, "");
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            this.filterChain.addSearchField(FILTER_ORDER_NUMBER, Words.ORDER_NO, "");
        } else {
            this.filterChain.setResetButtonWidth(120);
        }
        this.filterChain.addSelectionComboBox(this.stateCombo, FILTER_STATE, Words.STATE, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "", true);
        this.periodEditor.setCommitOnFocusLost(true);
        this.periodEditor.setComboBoxWidth(100);
        this.filterChain.addCustomerSearchField(FILTER_CARRIER);
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            this.flightCategories = new ComboBox(null, null, ConverterRegistry.getConverter(FlightCategoryConverter.class));
            this.filterChain.addSelectionComboBox(this.flightCategories, FILTER_FLIGHT_CAT, Words.CATEGORY, Words.ALL);
        }
        this.filterChain.addSelectionComboBox(this.invoiceStateCombo, FILTER_INVOICE_STATE, Words.INVOICE_STATE, Words.ALL);
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            this.filterChain.addSalesPersonSearchField(FILTER_SALES_PERSON);
        }
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteriaOrderNumber = null;
            this.filterCriteria2 = null;
            PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
            ((DateChooser)this.periodEditor.getStartDateChooser().getEditor()).setSelectedDate(p.getStartDate());
            ((DateChooser)this.periodEditor.getEndDateChooser().getEditor()).setSelectedDate(p.getEndDate());
            this.filterCriteria3 = p;
            this.filterCriteria4 = null;
            this.filterCriteria6 = FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL;
            this.onlyOpenFlights = false;
            this.ignoreCancelledFlights = false;
            this.flightCategoryFilter = null;
            this.filterCriteria11 = null;
            this.filterCriteriaSalesPerson = null;
            this.filterCriteriaInvoiceState = null;
        } else {
            if (name == FILTER_STATE) {
                if (value instanceof FlightStateE) {
                    this.filterCriteria2 = (FlightStateE)value;
                    this.onlyOpenFlights = false;
                } else if (value instanceof String) {
                    if (value.equals(Words.ALL)) {
                        this.filterCriteria2 = null;
                        this.onlyOpenFlights = false;
                    } else if (value.equals(Words.ALL_EXCEPT_PLANNED)) {
                        this.filterCriteria2 = null;
                        this.onlyOpenFlights = true;
                        this.ignoreCancelledFlights = false;
                    } else if (value.equals(Words.ALL_EXCEPT_PLANNED_AND_CANCELLED)) {
                        this.filterCriteria2 = null;
                        this.onlyOpenFlights = true;
                        this.ignoreCancelledFlights = true;
                    } else {
                        this.filterCriteria2 = null;
                        this.onlyOpenFlights = false;
                    }
                } else {
                    this.filterCriteria2 = null;
                    this.onlyOpenFlights = false;
                }
            }
            if (name == FILTER_FLIGHT) {
                this.filterCriteria1 = (String)value;
            } else if (name == FILTER_ORDER_NUMBER) {
                this.filterCriteriaOrderNumber = (String)value;
            } else if (name == FILTER_PERIOD) {
                TitledPeriodEditor ed = (TitledPeriodEditor)value;
                PeriodComplete per = new PeriodComplete();
                per.setStartDate(ed.getStartDate());
                per.setEndDate(ed.getEndDate());
                this.filterCriteria3 = per;
            } else if (name == FILTER_CARRIER) {
                this.filterCriteria4 = value == Words.ALL ? null : (CustomerLight)value;
            } else if (name == FILTER_FLIGHT_CAT) {
                this.flightCategoryFilter = value instanceof FlightCategoryComplete ? (FlightCategoryComplete)value : (value instanceof Node ? (FlightCategoryComplete)((Node)value).getValue() : null);
            } else if (name == FILTER_SALES_PERSON) {
                this.filterCriteriaSalesPerson = value instanceof SalesPersonComplete ? (SalesPersonComplete)value : (value instanceof Node ? (SalesPersonComplete)((Node)value).getValue() : null);
            } else if (name == FILTER_INVOICE_STATE) {
                if (value instanceof RetailInvoiceStateE) {
                    this.filterCriteriaInvoiceState = (RetailInvoiceStateE)value;
                } else if (value instanceof String) {
                    this.filterCriteriaInvoiceState = null;
                }
            }
        }
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.filterCriteria4);
        c.setFlightNumber(this.filterCriteria1);
        c.setCustomsDocumentId(this.filterCriteriaOrderNumber);
        c.setFlightState(this.filterCriteria2);
        c.setDayPeriod(this.filterCriteria3);
        c.setStowageType(this.filterCriteria6);
        c.setCategory(this.flightCategoryFilter);
        c.setIgnoreCancelledFlights(this.ignoreCancelledFlights);
        c.setOnlyOpenFlights(this.onlyOpenFlights);
        c.setSalesPerson(this.filterCriteriaSalesPerson);
        c.setRetailInvoiceState(this.filterCriteriaInvoiceState);
        c.setFromRetailModule(true);
        String v = this.filterCriteria1;
        if (v != null) {
            c.setFlightNumber(v);
            c.setCustomsDocumentId(v);
        }
        if (this.filterCriteria11 == null) {
            c.setSearchFlightType(FlightSearchTypeE.FLIGHT_CODE);
        } else {
            c.setSearchFlightType(this.filterCriteria11);
        }
        if (this.filterCriteriaOrderNumber != null) {
            c.setSearchFlightType(FlightSearchTypeE.CUSTOMS_DOCUMENT_ID);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_UPDATE_PRE_ORDERS.getIdentifier())) {
            return false;
        }
        return !subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_UPDATE_MAX_PAX.getIdentifier());
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightLight> model) {
        try {
            if (model == null || model.getNode() == null || model.getNode().getValue() == null) {
                return false;
            }
            FlightLight flight = (FlightLight)model.getNode().getValue(FlightLight.class);
            if (flight.getId() == null) {
                return false;
            }
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (screen.getInvokingName().equals(RetailAccess.ACTION_CLOSE_RETAIL_INVOICE.getIdentifier())) {
                if (flight.getIsInvoiceClosed().booleanValue() || flight.getFlightState() == FlightStateE.CANCELLED) {
                    return false;
                }
                if (Boolean.TRUE.equals(settings.getRetailAutoCloseInvoice())) {
                    return false;
                }
            }
            if (screen.getInvokingName().equals(RetailAccess.ACTION_CANCEL_RETAIL_INVOICE.getIdentifier()) && !flight.getIsInvoiceClosed().booleanValue()) {
                return false;
            }
            if (screen.getInvokingName().equals(RetailAccess.PRINT_FLIGHT_DELIVERY_SLIP.getIdentifier())) {
                return false;
            }
            if (screen.getInvokingName().equals(RetailAccess.ACTION_SEND_RETAIL_INVOICE.getIdentifier())) {
                if (!flight.getIsInvoiceClosed().booleanValue()) {
                    return false;
                }
                if (flight.getInvoiceSent().booleanValue()) {
                    return false;
                }
                if (Boolean.TRUE.equals(settings.getRetailAutoSendInvoice())) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.flightCategories != null) {
            this.flightCategories.refreshPossibleValues(NodeToolkit.getAffixList(FlightCategoryComplete.class));
            this.flightCategories.addItem(Words.ALL);
            this.flightCategories.setSelectedItem(Words.ALL);
        }
        super.remoteObjectLoaded(node);
    }

    @Override
    public boolean isDeletable(RowModel<FlightLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<FlightLight> getRowEditorFactory() {
        return model -> {
            InputMessageProvidedRowEditor<FlightLight> rowEditor = new InputMessageProvidedRowEditor<FlightLight>(model, Words.ARE_YOU_SURE_TO_SAVE_FLIGHT);
            RDProvider p = this.createProvider(model.isAddRow());
            if (rowEditor.getModel().isAddRow()) {
                NewRetailDetailsPanel numberAndNamePanel = new NewRetailDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                TimeDetailsPanel timePanel = new TimeDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                OrderNumbersDetailsPanel orderNumberPanel = new OrderNumbersDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                RemarkDetailsPanel remarkPanel = new RemarkDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                ProductsDetailsPanel productsPanel = new ProductsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                SolarHandlingCostsDetailsPanel handlings = new SolarHandlingCostsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                c1.add((Component)numberAndNamePanel, new TableLayoutConstraint(0, 0, 0.0, 1.0));
                c1.add((Component)timePanel, new TableLayoutConstraint(1, 0, 0.0, 1.0));
                c1.add((Component)remarkPanel, new TableLayoutConstraint(2, 0, 1.0, 1.0));
                CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
                c2.add((Component)c1, new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(c2, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                CombinedDetailsParagraph c3 = new CombinedDetailsParagraph();
                c3.add((Component)productsPanel, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                c3.add((Component)handlings, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                rowEditor.add(c3, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                rowEditor.add(orderNumberPanel, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.0));
                rowEditor.addToFocusQueue(numberAndNamePanel);
                rowEditor.addToFocusQueue(timePanel);
                rowEditor.addToFocusQueue(productsPanel);
                rowEditor.addToFocusQueue(handlings);
                rowEditor.addToFocusQueue(orderNumberPanel);
                rowEditor.addToFocusQueue(remarkPanel);
            } else {
                StateDetailsPanel statePanel = new StateDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                TimeDetailsPanel timePanel = new TimeDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                OrderNumbersDetailsPanel ordersPanel = new OrderNumbersDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                RemarkDetailsPanel remarkPanel = new RemarkDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                ProductsDetailsPanel productPanel = new ProductsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                SolarHandlingCostsDetailsPanel handlings = new SolarHandlingCostsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                CombinedDetailsParagraph h1 = new CombinedDetailsParagraph();
                CombinedDetailsParagraph h12 = new CombinedDetailsParagraph();
                CombinedDetailsParagraph h2 = new CombinedDetailsParagraph();
                h12.add((Component)productPanel, new TableLayoutConstraint(0, 0, 0.5, 0.5));
                h12.add((Component)handlings, new TableLayoutConstraint(1, 0, 0.5, 0.5));
                h1.add((Component)statePanel, new TableLayoutConstraint(0, 0, 0.0, 1.0));
                h1.add((Component)timePanel, new TableLayoutConstraint(1, 0, 0.0, 1.0));
                h1.add((Component)remarkPanel, new TableLayoutConstraint(2, 0, 1.0, 1.0));
                h2.add((Component)ordersPanel, new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(h1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(h12, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                rowEditor.add(h2, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.0));
                rowEditor.addToFocusQueue(statePanel);
                rowEditor.addToFocusQueue(timePanel);
                rowEditor.addToFocusQueue(productPanel);
                rowEditor.addToFocusQueue(ordersPanel);
                rowEditor.addToFocusQueue(remarkPanel);
            }
            rowEditor.allInstalled();
            rowEditor.updateEnableStateToDetailsPanel();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new RetailModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        info.add(new TableColumnInfo(Words.STATE, "", (Class)RetailStateEWithWarningConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STATE, "", TableColumnInfo.state3WithExpandWidth, TableColumnInfo.state3WithExpandWidth, TableColumnInfo.state3WithExpandWidth));
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            info.add(new TableColumnInfo(Words.DELIVERY_NO, "", (Class)FlightTrackingNumberConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.TRACKING_NUMBER, FlightLight_.trackingNumber, 100, 100, 100));
            info.add(new TableColumnInfo(Words.ORDER_NO, "", (Class)FlightCustomsDocumentsConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CUSTOMS_ORDER_ID, FlightLight_.customsDocuments, 100, 100, 100));
        } else {
            info.add(new TableColumnInfo(Words.DELIVERY_NO, "", (Class)FlightTrackingNumberConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.TRACKING_NUMBER, FlightLight_.trackingNumber, 200, Integer.MAX_VALUE, 200));
        }
        if (!Boolean.TRUE.equals(settings.getRetailAutoName())) {
            info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 160, 200, 160));
        }
        info.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            info.add(new TableColumnInfo(Words.CATEGORY, "", (Class)CategoryConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CATEGORY, FlightLight_.category, TableColumnInfo.flightCategoryWidth, TableColumnInfo.flightCategoryWidth, TableColumnInfo.flightCategoryWidth));
        }
        info.add(new TableColumnInfo(Words.DELIVERY_DATE, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            info.add(new TableColumnInfo(Words.PICK_N_PAY, "", BooleanConverter.class, null, "#" + FlightComplete_.customer.getFieldName() + "-" + CustomerComplete_.pickNPayCustomer.getFieldName(), TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        }
        info.add(new TableColumnInfo(Words.INVOICE_CLOSED, "", BooleanConverter.class, null, FlightLight_.isInvoiceClosed, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        info.add(new TableColumnInfo(Words.INVOICE_SENT, "", BooleanConverter.class, null, FlightLight_.invoiceSent, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType()) && Boolean.TRUE.equals(settings.getProductCommissionActive())) {
            info.add(new TableColumnInfo(Words.SALES_PERSON, "", (Class)SalesPersonConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.SALES_PERSON, FlightLight_.commissionSalesPerson, 120, 120, 120));
        }
        info.add(new TableColumnInfo(Words.LAST_UPDATE, "", (Class)LogTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.LAST_UPDATE, FlightLight_.log, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.USER, "", (Class)LogUserConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.DISPATCH, FlightLight_.log, 160, 160, 160));
        return info;
    }

    @Override
    public SearchAlgorithm<FlightLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
    }
}

